<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - English Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys

    'dashboard' => 'Dashboard',
    'users' => 'Benutzer',
    'patients' => 'Patienten',
    'settings' => 'Einstellungen',
    'clinic_schedules' => 'Klinikpläne',
    'start_time_invalid' => 'Die Startzeit des Tages ist ungültig',
    'doctor_sessions' => 'Arztpläne',
    'apps' => 'Apps',
    'countries' => 'Länder',
    'states' => 'Staaten',
    'cities' => 'Städte',
    'doctors' => 'Ärzte',
    'service_categories' => 'Dienstleistungskategorien',
    'specializations' => 'Spezialisierungen',
    'services' => 'Dienste',
    'roles' => 'Rollen',
    'staffs' => 'Mitarbeiter',
    'appointments' => 'Termine',
    'doctor_appointments' => 'Arzttermine',
    'currencies' => 'Währungen',
    'login' => 'Anmelden',
    'register' => 'Registrieren',
    'visits' => 'Besuche',
    'front_cms' => 'Front-CMS',
    'sliders' => 'Schieberegler',
    'front_services' => 'Frontdienste',
    'faqs' => 'Häufig gestellte Fragen',
    'front_medical_services' => 'Frontärztlicher Dienst',
    'front_patient_testimonials' => 'Vorderseite Patientenberichte',
    'enquiries' => 'Anfragen',
    'subscribers' => 'Abonnenten',
    'privacy_policy' => 'Datenschutzerklärung',
    'terms_conditions' => 'Allgemeine Geschäftsbedingungen',
    'transactions' => 'Transaktionen',
    'reviews' => 'Bewertungen',
    'live_consultations' => 'Live-Beratungen',
    'email_password_reset_link' => 'Link zum Zurücksetzen des E-Mail-Passworts',
    'resend_email_verification' => 'E-Mail-Bestätigung erneut senden',
    'paytm' => 'Zahlung',
    'payment_detail' => 'Zahlungsdetails',
    'payment_for_booking_appointment_with_doctor' => 'Zahlung für die Buchung eines Arzttermins',
    'mobile_no' => 'Handy-Nr',
    'doctors_scheduled_time_ended_for_today__' => 'Die geplante Zeit des Arztes ist für heute abgelaufen, bitte wählen Sie einen anderen Arzt oder ein anderes Datum aus',
    'valid_number' => 'Gültige Nummer',
    'invalid_number' => 'Ungültige Nummer',
    'invalid_country_code' => 'Ungültiger Ländercode',
    'too_short' => 'Zu kurz',
    'too_long' => 'Zu lang',
    'note' => 'Hinweis: Sie müssen Ihre Zeitzone festlegen, bevor Sie Google Kalender integrieren.',
    'medicine_categories' => 'Medizinkategorien',
    'medicine_brands' => 'Arzneimittelmarken',
    'medicines' => 'Medikamente',

    'no_response' => 'Es wurde keine Antwort zurückgegeben',
    'filter_success' => 'Filtererfolg',
    'live_status_retrieved_successfully.' => 'Live-Status erfolgreich abgerufen.',
    'id' => 'AUSWEIS',

    'holder_name_required' => 'Felder für den Namen des Karteninhabers sind Pflichtfelder.',
    'holder_name_invalid' => 'Der Name des Karteninhabers ist ungültig.',
    'holder_number_invalid' => 'Kartennummernfelder sind Pflichtfelder.',
    'expiration_month_required' => 'Felder für den Ablaufmonat sind erforderlich.',
    'expiration_year_required' => 'Felder für das Ablaufjahr sind erforderlich.',
    'valid_expiration_date' => 'Geben Sie ein gültiges Ablaufdatum ein.',
    'cvv_number_required.' => 'CVV-Nummernfelder sind erforderlich.',
    'cvv_invalid.' => 'CVV ist ungültig.',
    'card_number_invalid..' => 'Kartennummer ist ungültig.',

    'range_constructor_requires_trie_parameter' => 'Der Bereichskonstruktor erfordert einen Trie-Parameter',
    'requires_string_parameter' => 'rangeWithString erfordert einen String-Parameter',
    'invalid_range' => 'Ungültiger Bereich',
    'card_type' => 'Kreditkartentyp',
    'not_supported' => 'nicht unterstützt',

    'image_file_type' => 'Das Bild muss eine Datei des folgenden Typs sein: jpeg, jpg, png.',
    'icon_size' => 'Die Symbolgröße sollte weniger als 2 MB betragen',

    'web' => [
        'enter_your_email' => 'Geben sie ihre E-Mail Adresse ein',
        'emergency_help' => 'Nothilfe',
        'qualified_doctors' => 'Qualifizierte Ärzte',
        'best_professionals' => 'Beste Fachleute',
        'medical_treatment' => 'Medizinische Behandlung',
        'testimonial' => 'Zeugnis',
        'see_what_are_the_patients' => 'Sehen Sie, was die Patienten sind',
        'saying_about_us' => 'Über uns sagen',
        'our_team' => 'Unser Team',
        'our_doctor' => 'Unser Arzt',
        'contact_us' => 'Kontakt',
        'faqs' => 'Häufig gestellte Fragen',
        'location' => 'Lage',
        'quick_links' => 'Schnelllinks',
        'sign_up' => 'Anmeldung',
        'working_process' => 'Arbeitsprozess',
        'how_we_works' => 'Wie wir arbeiten',
        'registration' => 'Anmeldung',
        'view_more' => 'Mehr sehen',
        'email_address' => 'E-Mail-Addresse',
        'make_appointment' => 'Einen Termin machen',
        'take_treatment' => 'Behandlung durchführen',
        'appointment_now' => 'Termin jetzt',
        'all_services' => 'Alle Dienste',
        'satisfied_patient' => 'Zufriedener Patient',
        'Meet_best_doctors' => 'Treffen Sie die besten Ärzte',
        'all_rights_reserved' => 'Alle Rechte vorbehalten',
        'contact_us_for_any_information' => 'Kontaktieren Sie uns für alle Informationen',
        'patient_can_do_registration___' => 'Der Patient kann sich von hier aus mit grundlegenden Informationen registrieren.',
        'patient_can_book_an_appointment___' => 'Der Patient kann über die Landingpage oder über sein Login-Panel einen Termin beim Arzt buchen.',
        'doctors_can_interact___' => 'Ärzte können mit Patienten interagieren und damit verbundene Behandlungen durchführen.',
        'we_cover_a_big___' => 'Wir decken eine große Vielfalt medizinischer Leistungen ab',
        'we_provide_the_special_tips___' => 'Wir geben die speziellen Tipps und Ratschläge der Gesundheitspflege und des höchsten Niveaus.',
        'timings' => 'Zeiten',
        'book_an_appointment' => 'Termin buchen',
        'login' => 'Anmelden',
        'home' => 'Zuhause',
        'about_us' => 'Über uns',
        'services' => 'Dienste',
        'appointment' => 'Termin',
        'doctors' => 'Ärzte',
        'contact' => 'Kontakt',
        'call_us' => 'Rufen Sie uns an',
        'send_an_email' => 'E-Mail senden',
        'subscribe' => 'Abonnieren',
        'medical' => 'Medizinisch',
        'medical_services' => 'Medizinische Dienste',
        'medical_about_us' => 'Medizinisch über uns',
        'medical_appointment' => 'Ärztlicher Termin',
        'medical_doctors' => 'Ärzte',
        'medical_contact' => 'Medizinischer Kontakt',
        'opening_hours' => 'Öffnungszeiten',
        'send_us_an_email' => 'Senden Sie uns eine E-Mail',
        'name' => 'Name',
        'reason' => 'Grund',
        'email' => 'E-Mail',
        'phone' => 'Telefon',
        'subject' => 'Betreff',
        'message' => 'Nachricht',
        'send_message' => 'Nachricht senden',
        'closed' => 'Geschlossen',
        'enquiry_details' => 'Anfragedetails',
        'status' => 'Status',
        'created_at' => 'Erstellt am',
        'total_services' => 'Gesamtdienste',
        'total_doctors' => 'Ärzte insgesamt',
        'total_registered_patient' => 'Gesamt registrierte Patienten',
        'total_specializations' => 'Gesamtspezialisierungen',
        'about_title' => 'Über Titel',
        'about_experience' => 'Über Erfahrung',
        'about_short_description' => 'Über Kurzbeschreibung',
        'patient_registration' => 'Patientenregistrierung',
        'already_have_an_account' => 'Habe bereits ein Konto',
        'sign_in_here' => 'Hier anmelden',
        'i_agree' => 'Ich stimme zu',
        'terms_and_conditions' => 'Allgemeine Geschäftsbedingungen',
        'sign_in' => 'Anmelden',
        'new_here' => 'Neu hier',
        'create_an_account' => 'Konto erstellen',
        'remember_me' => 'Erinnere dich an mich',
        'forgot_password' => 'Passwort vergessen',
        'already_have_patient_account' => 'Habe bereits ein Patientenkonto',
        'confirm_booking' => 'Buchung bestätigen',
        'patient_name' => 'Patientenname',
        'questions_before_booking' => 'Fragen vor der Buchung',
        'no_services_available' => 'Keine Dienste verfügbar',
        'meet_our_team_of_specialists' => 'Treffen Sie unser Team von Spezialisten',
        'enter_your_email_to_subscribe_to_our_newsletter' => 'Geben Sie Ihre E-Mail-Adresse ein, um unseren Newsletter zu abonnieren',
        'we_make_sure_that_your_life_are_in_good_hands' => 'Wir sorgen dafür, dass Ihr Leben in guten Händen ist',
        'dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the' => 'Formulieren Sie fehlerfreie Ergebnisse dynamisch, bevor Sie die Ergebnisse integrieren. Integrierte Ressourcen drastisch inkubieren, ohne kosteneffektiv außerhalb der.',
        'enquiry' => 'Anfrage',
        'book_appointment' => 'Einen Termin verabreden',

    ],

    'admin_dashboard' => [
        'dashboard' => 'Dashboard',
        'name' => 'Name',
        'patient_id' => 'Eindeutige Patienten-ID',
        'registered' => 'Registriert',
        'month' => 'Monat',
        'week' => 'Woche',
        'day' => 'Tag',
        'total_doctor' => 'Ärzte insgesamt',
        'total_patients' => 'Gesamtpatienten',
        'today_appointments' => 'Heute Termine',
        'today_registered_patients' => 'Heute registrierte Patienten',
        'recent_patients_registration' => 'Neue Patientenregistrierung',
        'earnings_from_appointments' => 'Einnahmen aus Terminen',
        'filter_options' => 'Filteroptionen',
    ],
    'common' => [
        'save' => 'Speichern',
        'submit' => 'Senden',
        'cancel' => 'Abbrechen',
        'discard' => 'Verwerfen',
        'country' => 'Land',
        'state' => 'Staat',
        'city' => 'Stadt',
        'please_wait' => 'Bitte warten...',
        'back' => 'Zurück',
        'action' => 'Aktion',
        'add' => 'Hinzufügen',
        'edit' => 'Bearbeiten',
        'name' => 'Name',
        'details' => 'Details',
        'service' => 'Dienst',
        'active' => 'Aktiv',
        'de_active' => 'Deaktivieren',
        'overview' => 'Übersicht',
        'n/a' => 'N/A',
        'filter' => 'Filter',
        'filter_option' => 'Filteroption',
        'apply' => 'Bewerben',
        'reset' => 'Zurücksetzen',
        'no_data_available' => 'Keine Daten verfügbar',
        'no_records_found' => 'Keine Datensätze gefunden.',
        'impersonate' => 'Imitieren',
        'email_verified' => 'Email überprüft',
        'custom' => 'Brauch',
        'from' => 'Aus',
        'to' => 'Zu',
        'select_service' => 'Dienst auswählen',
        'select_category' => 'Kategorie wählen',
        'select_doctor' => 'Arzt auswählen',
        'delete' => 'Löschen',
        'search' => 'Suche',
        'twitter_url' => 'Twitter-URL',
        'linkedin_url' => 'Linkedin-URL',
        'instagram_url' => 'Instagram-URL',
        'show' => 'Zeigen',
        'are_you_sure' => 'Möchten Sie dies wirklich löschen?',
        'cancelled_appointment' => 'Termin abgesagt !',
        'are_you_sure_cancel' => 'Möchten Sie dies wirklich abbrechen?',
        'has_cancel' => ' wurde abgebrochen.',
        'no' => 'Nein, Abbrechen',
        'yes' => 'Ja, löschen!',
        'select_country' => 'Land auswählen',
        'select_state' => 'Staat wählen',
        'select_city' => 'Stadt wählen',
        'no_data_available_in_table' => 'Keine Daten in der Tabelle verfügbar',
        'read' => 'Lesen',
        'unread' => 'Ungelesen',
        'change_image' => 'Изменить изображение',
        'hour' => 'Stunde',
        'minutes' => 'Protokoll',
        'deleted' => '¡Eliminado!',
        'has_been' => 'ha sido eliminado.',
        'yes_update' => '¡Sí, actualización!',
        'error' => 'Error',
        'booked' => 'Gebucht',
        'check in' => 'Check-In',
        'check out' => 'Kasse',
        'cancelled' => 'Abgesagt',
        'view' => 'Aussicht',
        'note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar' => 'Hinweis: Wir verwenden die Zeitzone Ihrer Ärzte, während wir einen Termin im Kalender erstellen. Wenn der Arzt die Zeitzone nicht eingestellt hat, wird die UTC-Standardzeitzone verwendet.',
        'download' => 'Herunterladen',
        'select_brand' => 'Wählen Sie Marke aus',
        'observation_white_space' => 'Das Beobachtungsfeld enthält nicht nur Leerzeichen.',
        'problem_white_space' => 'Das Problemfeld enthält nicht nur Leerzeichen',
        'note_white_space' => 'Das Hinweisfeld enthält nicht nur Leerzeichen',

        'showing' => 'Zeigt',
        'to' => 'Zu',
        'of' => 'von',
        'results' => 'Ergebnisse',
        'google_captcha_required' => 'Das Google-Captcha-Feld ist erforderlich.',
        'processing' => 'Wird bearbeitet..',
        'first_name_required' => 'Das Feld „Vorname“ ist erforderlich. ',
        'last_name_required' => 'Das Feld „Nachname“ ist erforderlich.',
        'email_required' => 'Das E-Mail-Feld ist erforderlich.',
        'doctor_required' => 'Das Feld „Arzt“ ist erforderlich.',
        'service_required' => 'Das Feld „Dienste“ ist erforderlich.',
        'appointment_date_required' => 'Das Feld „Termindatum“ ist erforderlich.',
        'payment_type_required' => 'Das Feld „Zahlungsmethode“ ist erforderlich.',
        'prescription_report' => 'Rezeptbericht',
        'age' => 'Alter',
        'years' => 'Jahre',
        'maximum_55' => 'Maximal 55 Zeichen zulässig.',
        'name_required' => 'Das Namensfeld ist erforderlich',
        'name_already_taken' => 'Der Name ist bereits vergeben',
        'any_one_permission' => 'Bitte wählen Sie eine beliebige Berechtigung aus.',
        'add_credential' => 'Bitte fügen Sie Zoom-Zugangsdaten hinzu',
        'connected_zoom' => 'Erfolgreich mit Zoom verbunden.',
        'contact_number' => 'Kontaktnummer ist',
        'purchase_price' => 'Kaufpreis',
        'email_already_exist' => 'Die E-Mail wurde bereits abonniert.',
        'email_not_register' => 'E-Mail ist nicht registriert.',
        'category_required' => 'Das Kategoriefeld ist erforderlich.',
        'brand_required' => 'Das Markenfeld ist erforderlich.',


        'message_required' => 'Das Nachrichtenfeld ist erforderlich.',
        'subject_required' => 'Das Betrefffeld ist erforderlich.',
        'email_max' => 'Die maximale E-Mail-Größe beträgt 255.',
        'email_regex' => 'Das E-Mail-Feld muss ein gültiges Format haben.',
        'Attempt_read_property_access_token_null' => 'Versuchen Sie, die Eigenschaft „access_token“ auf Null zu lesen',
        'default_language' => 'Standardsprache',

        'not_allow__assess_record' => 'Anscheinend sind Sie nicht berechtigt, auf diesen Datensatz zuzugreifen.',
        'zoom_credentials' => 'Bitte fügen Sie Zoom-Zugangsdaten hinzu.',

        'forgot_your_password' => 'Haben Sie Ihr Passwort vergessen',
        'remember_me' => 'Erinnere dich an mich',
        'Forgot_password_lable'=>'Haben Sie Ihr Passwort vergessen? Kein Problem. Teilen Sie uns einfach Ihre E-Mail-Adresse mit und wir senden Ihnen einen Link zum Zurücksetzen Ihres Passworts, über den Sie ein neues Passwort auswählen können.',
        'reset_password' => 'Passwort zurücksetzen',
        'verify_lable1' => 'Danke für\'s Registrieren! Bevor Sie beginnen, können Sie Ihre E-Mail-Adresse bestätigen, indem Sie auf den Link klicken, den wir Ihnen gerade per E-Mail zugesandt haben. Wenn Sie die E-Mail nicht erhalten haben, senden wir Ihnen gerne eine neue zu.',
        'verify_lable2' => 'Ein neuer Bestätigungslink wurde an die E-Mail-Adresse gesendet, die Sie bei der Registrierung angegeben haben.',
        'resend_verification_email' => 'Bestätigungsmail erneut senden',
        'logout' => 'Ausloggen',
        'confirm' => 'Bestätigen'
    ],

    'user' => [
        'profile_details' => 'Profildetails',
        'edit_profile' => 'Profil bearbeiten',
        'avatar' => 'Avatar',
        'full_name' => 'Vollständiger Name',
        'email' => 'E-Mail',
        'contact_number' => 'Kontaktnummer',
        'save_changes' => 'Änderungen speichern',
        'setting' => 'Einstellung',
        'account_setting' => 'Kontoeinstellungen',
        'change_password' => 'Passwort ändern',
        'current_password' => 'Aktuelles Passwort',
        'new_password' => 'Neues Passwort',
        'confirm_password' => 'Passwort bestätigen',
        'account' => 'Konto',
        'staff_details' => 'Personaldetails',
        'gender' => 'Geschlecht',
        'language' => 'Sprache',
        'sign_out' => 'Abmelden',
        'return_to_admin' => 'Zurück zum Administrator',
        'email_notification' => 'Email Benachrichtigung',
        'time_zone' => 'Zeitzone',
        'change_language' => 'Sprache ändern',
        'select_time_zone' => 'Wähle Zeitzone aus',
    ],

    'setting' => [
        'setting' => 'Einstellung',
        'general' => 'Allgemein',
        'contact_information' => 'Kontaktinformationen',
        'currency_settings' => 'Währungseinstellungen',
        'general_details' => 'Allgemeine Details',
        'clinic_name' => 'Klinikname',
        'specialities' => 'Spezialitäten',
        'currency' => 'Währung',
        'prefix' => 'Präfix',
        'address' => 'Adresse',
        'postal_code' => 'Postleitzahl',
        'logo' => 'Logo',
        'favicon' => 'Favicon',
        'default_country_code' => 'Standard-Ländercode',
        'do_not_allow_to_login_without_email_verification' => 'Anmeldung ohne E-Mail-Verifizierung nicht zulassen',
        'connect_google_calendar' => 'Google Kalender verbinden',
        'connect_your_google_calendar' => 'Verbinden Sie Ihren Google-Kalender',
        'disconnect_your_google_calendar' => 'Verbindung zu Ihrem Google-Kalender trennen',
        'sync_your_google_calendar' => 'Ihren Google-Kalender synchronisieren',
        'select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments' => 'Wählen Sie Ihre Kalender (aus Google Kalender) aus, in denen Sie die Termine erstellen möchten',
        'when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars' => 'Wenn ein Patient einen Termin bei Ihnen bucht, wird in ausgewählten Kalendern ein neuer Termin erstellt',
        'when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars' => 'Wenn Sie einen Termin buchen, wird in ausgewählten Kalendern ein neuer Termin erstellt',
        'when_checkbox_disable' => 'Wenn das Kontrollkästchen deaktiviert ist, funktioniert die E-Mail-Überprüfung nicht für neue Benutzer.',
        'change_app_logo' => 'App-Logo ändern',
        'change_favicon' => 'Favicon ändern',
        'default_language_suggest' => 'Durch die Aktualisierung ändert sich die gesamte App-Sprache beim Arzt- und Patienten-Login sowie auf der Vorderseite.'
    ],

    'patient' => [
        'add' => 'Patienten hinzufügen',
        'edit' => 'Patient bearbeiten',
        'name' => 'Name',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'patient_unique_id' => 'Eindeutige Patienten-ID',
        'email' => 'E-Mail',
        'password' => 'Passwort',
        'confirm_password' => 'Passwort bestätigen',
        'contact_no' => 'Kontakt-Nr',
        'save_changes' => 'Änderungen speichern',
        'profile' => 'Profil',
        'dob' => 'Geburtstag',
        'gender' => 'Geschlecht',
        'blood_group' => 'Blutgruppe',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'address1' => 'Adresse 1',
        'address2' => 'Adresse 2',
        'city' => 'Stadt',
        'state' => 'Staat',
        'country' => 'Land',
        'postal_code' => 'Postleitzahl',
        'address_information' => 'Adressinformationen',
        'registered_on' => 'Registriert am',
        'details' => 'Patientendaten',
        'last_updated' => 'Zuletzt aktualisiert',
        'enter_email' => 'Email eingeben',
        'enter_password' => 'Passwort eingeben',
        'filter' => 'Filter',
        'today' => 'Heute',
        'emailverified' => 'Email überprüft',
    ],

    'country' => [
        'country' => 'Land',
        'add_country' => 'Land hinzufügen',
        'short_code' => 'Kurzcode',
    ],

    'state' => [
        'states' => 'Staaten',
        'add_state' => 'Staat hinzufügen',
        'state' => 'Staat',
        'edit_state' => 'Status bearbeiten',
        'country' => 'Land',
    ],

    'doctor_session' => [
        'doctor_session' => 'Arztplan',
        'my_schedule' => 'Mein Zeitplan',
        'session' => 'Sitzung',
        'add' => 'Arztplan hinzufügen',
        'edit' => 'Arztplan bearbeiten',
        'doctor' => 'Arzt',
        'morning_session' => 'Morgenplan',
        'evening_session' => 'Abendplan',
        'session_time_in_minutes' => 'Besprechungszeit planen',
        'doctor_session_details' => 'Details zum Arzttermin',
        'week_days' => 'Wochentage',
        'all' => 'Alle',
        'monday' => 'Montag',
        'tuesday' => 'Dienstag',
        'wednesday' => 'Mittwoch',
        'thursday' => 'Donnerstag',
        'friday' => 'Freitag',
        'saturday' => 'Samstag',
        'sunday' => 'Sonntag',
        'gap_between_appointment' => 'Lücke zwischen Termin',
        'session_gap' => 'Zeitplanlücke',
        'session_meeting_time' => 'Besprechungszeit planen',
        'unavailable' => 'Nicht verfügbar',
        'copy' => 'Kopieren',
        'select_session_gap' => 'Fahrplanlücke auswählen',
        'select_meeting_time' => 'Besprechungszeit auswählen',
    ],

    'city' => [
        'city' => 'Stadt',
        'add_city' => 'Stadt hinzufügen',
        'edit_city' => 'Stadt bearbeiten',
        'state' => 'Staat',
    ],

    'specialization' => [
        'add_specialization' => 'Spezialisierung hinzufügen',
        'edit_specialization' => 'Spezialisierung bearbeiten',
        'retrieved_successfully' => 'Spezialisierung erfolgreich abgerufen.'
    ],

    'service_category' => [
        'add_category' => 'Dienstkategorie hinzufügen',
        'edit_category' => 'Servicekategorie bearbeiten',
        'service_category' => 'Servicekategorie',
    ],

    'doctor' => [
        'add' => 'Arzt hinzufügen',
        'edit' => 'Ärztin bearbeiten',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'dob' => 'Geburtstag',
        'experience' => 'Erfahrung im Jahr',
        'status' => 'Status',
        'specialization' => 'Spezialisierung',
        'select_gender' => 'Geschlecht auswählen',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'profile' => 'Profil',
        'allowed_img' => 'Erlaubte Dateitypen: png, jpg, jpeg.',
        'address_information' => 'Adressinformationen',
        'address1' => 'Adresse 1',
        'address2' => 'Adresse 2',
        'city' => 'Stadt',
        'state' => 'Staat',
        'country' => 'Land',
        'postal_code' => 'Postleitzahl',
        'add_qualification' => 'Qualifikation hinzufügen',
        'degree' => 'Abschluss',
        'university' => 'Universität',
        'year' => 'Jahr',
        'passout_year' => 'Passionsjahr',
        'sr_no' => 'SR NEIN',
        'collage_university' => 'COLLAGE/UNIVERSITÄT',
        'doctor' => 'Arzt',
        'created_at' => 'Erstellt am',
        'updated_at' => 'Aktualisiert um',
        'qualification_information' => 'Qualifikationsinformationen',
        'doctor_detail' => 'Arztdetails',
        'select_doctors' => 'Ärzte auswählen',
        'qualification' => 'Qualifikation',
        'select_blood_group' => 'Blutgruppe auswählen',
        'select_year' => 'Jahr auswählen',
        'twitter' => 'Twitter',
        'linkedin' => 'Linkedin',
        'instagram' => 'Instagram',
        'select_date' => 'Datum auswählen',

    ],

    'service' => [
        'add_service' => 'Dienst hinzufügen',
        'edit_service' => 'Dienst bearbeiten',
        'category' => 'Kategorie',
        'charges' => 'Gebühren',
        'short_description' => 'Kurze Beschreibung',
    ],

    'role' => [
        'role' => 'Rolle',
        'add_role' => 'Rolle hinzufügen',
        'edit_role' => 'Rolle bearbeiten',
        'permissions' => 'Berechtigungen',
        'role_permissions' => 'Rollenberechtigungen',
        'select_all_permissions' => 'Alle Berechtigungen auswählen',
    ],

    'staff' => [
        'staff' => 'Personal',
        'add_staff' => 'Personal hinzufügen',
        'edit_staff' => 'Personal bearbeiten',
        'staff_details' => 'Personaldetails',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'email' => 'E-Mail',
        'password' => 'Passwort',
        'confirm_password' => 'Passwort bestätigen',
        'contact_no' => 'Kontakt-Nr',
        'gender' => 'Geschlecht',
        'role' => 'Rolle',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'select_role' => 'Rolle auswählen',
    ],

    'appointment' => [
        'appointments' => 'Termine',
        'add_new_appointment' => 'Termin hinzufügen',
        'edit_appointment' => 'Termin bearbeiten',
        'patient' => 'Patient',
        'date' => 'Datum',
        'available_slot' => 'Verfügbare Slots',
        'description' => 'Beschreibung',
        'charge' => 'Laden',
        'extra_fees' => 'Zusätzliche Gebühren',
        'total_payable_amount' => 'Zahlbarer Gesamtbetrag',
        'payable_amount' => 'Zahlbarer Betrag',
        'no_slot_found' => 'Keine Zeitfenster gefunden.',
        'service' => 'Dienst',
        'service_charge' => 'Servicegebühr',
        'time' => 'Zeit',
        'upcoming_meetings' => 'anstehende Treffen',
        'appointments_schedule' => 'Terminplan',
        'patient_id' => 'Patienten-ID',
        'appointment_details' => 'Termindetails',
        'appointment_at' => 'Termin um',
        'appointment_unique_id' => 'Termin-ID',
        'appointment_date' => 'Termintermin',
        'switch_to_calendar' => 'Zum Kalender wechseln',
        'starts' => 'Startet',
        'ends' => 'Ende',
        'calendar' => 'Kalender',
        'status' => 'Status',
        'booked' => 'Gebucht',
        'available' => 'Verfügbar',
        'check_in' => 'Einchecken',
        'check_out' => 'Auschecken',
        'cancelled' => 'Storniert',
        'payment' => 'Zahlung',
        'Select_payment_method' => 'Wählen Sie die Zahlungsmethode',
        'payment_method' => 'Bezahlverfahren',
        'cancel_appointment' => 'Termin stornieren',
        'session_created_successfully' => 'Sitzung erfolgreich erstellt',
        'appointment_status' => 'Terminstatus',
        'payment_status' => 'Zahlungsstatus',
        'authorize_session_created_successfully' => 'Autorisierungssitzung erfolgreich erstellt.',
        'patient_name_retrieved' => 'Patientenname erfolgreich abgerufen',
        'session_id_required' => 'Sitzungs-ID ist erforderlich',

    ],

    'doctor_appointment' => [
        'patient' => 'Patient',
        'service' => 'Dienst',
        'from_time' => 'Aus der Zeit',
        'to_time' => 'Zur Zeit',
        'amount' => 'Betrag',
    ],

    'doctor_dashboard' => [
        'total_appointments' => 'Gesamttermine',
        'recent_appointments' => 'Letzte Termine',
    ],

    'patient_dashboard' => [
        'today_appointments' => 'Heute Termine',
        'completed_appointments' => 'Abgeschlossene Termine',
        'upcoming_appointments' => 'Anstehende Termine',
        'next_appointment' => 'Nächste Termine',
    ],

    'currency' => [
        'add_currency' => 'Währung hinzufügen',
        'edit_currency' => 'Währung bearbeiten',
        'currency_name' => 'Währungsname',
        'currency_icon' => 'Währungssymbol',
        'currency_code' => 'Währungscode',
        'name' => 'Name',
        'add_currency_code_as_per_three_letter_iso_code' => 'Fügen Sie den Währungscode gemäß dem dreistelligen ISO-Code hinzu',
        'you_can_find_out_here' => 'das erfährst du hier',
    ],

    'visit' => [
        'add_visit' => 'Besuch hinzufügen',
        'edit_visit' => 'Besuch bearbeiten',
        'visit_date' => 'Besuchsdatum',
        'visit_details' => 'Besuchsdetails',
        'patient' => 'Patient',
        'doctor' => 'Arzt',
        'description' => 'Beschreibung',
        'title' => 'Titel',
        'problems' => 'Probleme',
        'observations' => 'Beobachtungen',
        'notes' => 'Notizen',
        'visit_detail' => 'Besuchsdetails',
        'prescriptions' => 'Rezepte',
        'enter_problem' => 'Problem eingeben',
        'enter_observation' => 'Beobachtung eingeben',
        'enter_note' => 'Notiz eingeben',

    ],

    'prescription' => [
        'name' => 'Name',
        'frequency' => 'Frequenz',
        'duration' => 'Dauer',
        'prescription' => 'Rezept',
        'prescriptions' => 'Rezepte',
        'prescription_details' => 'Rezeptdetails',
        'new_prescription' => 'Neues Rezept',
        'edit_prescription' => 'Rezept bearbeiten',
        'patient' => 'Geduldig',
        'doctor' => 'Arzt',
        'food_allergies' => 'Essensallergien',
        'tendency_bleed' => 'Tendenz bluten',
        'heart_disease' => 'Herzkrankheit',
        'high_blood_pressure' => 'Bluthochdruck',
        'diabetic' => 'Diabetikerin',
        'surgery' => 'Chirurgie',
        'accident' => 'Unfall',
        'others' => 'Andere',
        'medical_history' => 'Krankengeschichte',
        'current_medication' => 'Derzeitige Medikamente',
        'female_pregnancy' => 'Weibliche Schwangerschaft',
        'breast_feeding' => 'Stillen',
        'health_insurance' => 'Krankenversicherung',
        'low_income' => 'Niedriges Einkommen',
        'reference' => 'Referenz',
        'physical_information' => 'physikalische Informationen',
        'new_medicine' => 'neue Medizin',
        'plus_rate' => 'Impuls Tarif',
        'temperature' => 'Temperatur',
        'problem_description' => 'Problembeschreibung',
        'test' => 'Prüfung',
        'advice' => 'Rat',
        'next_visit' => 'nächster Besuch',
        'time' => 'Zeit',
        'comment' => 'Kommentar',
        'problem' => 'Problem',
        'rx' => 'Empfang',
        'medicine_name' => 'Medizinname',
        'duration' => 'Dauer',
        'dosage' => 'Dosierung',
        'prescription_updated' => 'Rezept erfolgreich aktualisiert.',
        'prescription_saved' => 'Rezept erfolgreich gespeichert.',
        'appointment_slot' => 'Terminslots',
        'ok' => 'OK',
        'connect_with_zoom' => ' Verbinden Sie sich mit Zoomen',
        'not_add_duplicate_medicines' => 'Es können keine doppelten Medikamente hinzugefügt werden.',
        'available_quantity_of' => 'Die verfügbare Menge von ',
        'is' => 'Ist',
        'selectMedicine' => "Wählen Sie ein Medikament aus",
        'total_quantity' => 'Gesamtmenge'

    ],

    'slider' => [
        'add_slider' => 'Schieberegler hinzufügen',
        'edit_slider' => 'Schieberegler bearbeiten',
        'title' => 'Titel',
        'short_description' => 'Kurze Beschreibung',
        'image' => 'Bild',
    ],

    'front_service' => [
        'add_front_service' => 'Frontservice hinzufügen',
        'edit_front_service' => 'Frontservice bearbeiten',
        'title' => 'Titel',
        'short_description' => 'Kurze Beschreibung',
        'icon' => 'Symbol',
    ],

    'faq' => [
        'add_faq' => 'FAQ hinzufügen',
        'edit_faq' => 'FAQ bearbeiten',
        'question' => 'Frage',
        'answer' => 'Antwort',
    ],

    'front_medical_service' => [
        'add_front_medical_service' => 'Frontärztlichen Dienst hinzufügen',
        'edit_front_medical_service' => 'Front Sanitätsdienst bearbeiten',
        'title' => 'Titel',
        'short_description' => 'Kurze Beschreibung',
    ],

    'front_patient_testimonial' => [
        'add_front_patient_testimonial' => 'Vorderseite Patientenbericht hinzufügen',
        'edit_front_patient_testimonial' => 'Vorderseite Patientenbericht bearbeiten',
        'name' => 'Name',
        'profile' => 'Profil',
        'designation' => 'Bezeichnung',
        'short_description' => 'Kurze Beschreibung',
        'patient_testimonials' => 'Patientenberichte',
        'more_patient_feedbacks' => 'Mehr Patienten-Feedbacks...',
    ],

    'cms' => [
        'cms' => 'CMS',
        'terms_conditions' => 'Allgemeine Geschäftsbedingungen',
        'privacy_policy' => 'Datenschutzerklärung',
        'about_image' => 'Über Bild',
        'title_no_white_space' => 'Das Feld „Über den Titel“ enthält nicht nur Leerzeichen',
        'description_no_white_space' => 'Das Feld „Kurzbeschreibung“ enthält nicht nur Leerzeichen',
        'experience_required' => 'Das Feld „Über Erfahrung“ ist erforderlich.',
        'Terms_Conditions_required' => 'Allgemeine Geschäftsbedingungen sind erforderlich',
        'privacy_policy_required.' => 'Die Datenschutzerklärung ist erforderlich.',

    ],

    'transaction' => [
        'transaction_detail' => 'Transaktionsdetails',
        'transaction_id' => 'Transaktions-ID',
        'payment_status' => 'Zahlungsstatus',
        'paid' => 'bezahlt',
        'pending' => 'Ausstehend',
        'payment_accepted_by' => 'Zahlung akzeptiert von',

    ],

    'notification' => [
        'you_don`t_have_any_new_notification' => 'Sie haben keine neue Benachrichtigung',
        'notification' => 'Benachrichtigungen',
        'mark_all_as_read' => 'Alles als gelesen markieren',
    ],

    'review' => [
        'write_a_review' => 'Eine Rezension schreiben',
        'add_review' => 'Bewertung hinzufügen',
        'review' => 'Rezension',
        'edit_review' => 'Bewertung bearbeiten',
        'no_doctors_available_to_give_rating' => 'Keine Ärzte verfügbar, um eine Bewertung abzugeben.',
    ],

    'live_consultation' => [
        'new_live_consultation' => 'Neue Live-Beratung',
        'add_live_consultation' => 'Live-Beratung hinzufügen',
        'consultation_title' => 'Beratungstitel',
        'consultation_date' => 'Beratungstermin',
        'select_consultation_date' => 'Beratungsdatum auswählen',
        'select_doctor_name' => 'Name des Arztes auswählen',
        'select_patient_name' => 'Patientennamen auswählen',
        'consultation_minutes' => 'Beratungsprotokoll',
        'description' => 'Beschreibung',
        'live_consultation_details' => 'Einzelheiten zur Live-Beratung',
        'consultation_duration_minutes' => 'Beratungsdauer Minuten',
        'client_video' => 'Kundenvideo',
        'host_video' => 'Host-Video',
        'enable' => 'Ermöglichen',
        'disabled' => 'Behindert',
        'type' => 'Typ',
        'type_number' => 'Nummer eingeben',
        'created_by' => 'Erstellt von',
        'created_for' => 'Hergestellt für',
        'new_live_meeting' => 'Neues Live-Meeting',
        'staff_list' => 'Mitarbeiterliste',
        'edit_live_consultation' => 'Live-Beratung bearbeiten',
        'duration' => 'Dauer (in Minuten)',
        'start_now' => 'Jetzt anfangen',
        'join_now' => 'Jetzt beitreten',
        'edit_live_meeting' => 'Live-Meeting bearbeiten',
        'add_credential' => 'Anmeldeinformationen hinzufügen',
        'zoom_api_key' => 'Zoom-API-Schlüssel',
        'zoom_api_secret' => 'Zoom-API-Geheimnis',
        'awaited' => 'Erwartet',
        'finished' => 'Fertig',
    ],
    'months' => [
        'jan' => 'Jan',
        'feb' => 'Feb',
        'mar' => 'Beschädigen',
        'apr' => 'Apr',
        'may' => 'Kann',
        'jun' => 'Jun',
        'jul' => 'Juli',
        'aug' => 'Aug',
        'sep' => 'Sep',
        'oct' => 'Okt',
        'nov' => 'Nov',
        'dec' => 'Dec',
    ],

    'weekdays' => [
        'sun' => 'SONNE',
        'mon' => 'MO',
        'tue' => 'DI',
        'wed' => 'HEIRATEN',
        'thu' => 'DO',
        'fri' => 'FR',
        'sat' => 'Sa',
    ],
    'datepicker' => [
        'today' => 'Heute',
        'yesterday' => 'Gestern',
        'last_30_days' => 'Letzte 30 Tage',
        'this_week' => 'In dieser Woche',
        'last_week' => 'Letzte Woche',
        'this_month' => 'Diesen Monat',
        'last_month' => 'Im vergangenen Monat',
    ],

    'filter' => [
        'all' => 'Alle',
        'paid' => 'Bezahlt',
        'pending' => 'Ausstehend',
        'active' => 'Aktiv',
        'deactive' => 'Deaktivieren',
        'awaited' => 'erwartet',
        'finished' => 'Fertig',
        'booked' => 'Gebucht',
        'check in' => 'Check-In',
        'check out' => 'Kasse',
        'cancelled' => 'Abgesagt',
        'read' => 'Lesen',
        'unread' => 'Ungelesen',
    ],

    'flash' => [
        'patients_retrieve' => 'Patienten erfolgreich gefunden.',
        'data_retrieve' => 'Daten erfolgreich abgerufen.',
        'schedule_crete' => 'Zeitplan erfolgreich erstellt.',
        'schedule_update' => 'Zeitplan erfolgreich aktualisiert.',
        'schedule_delete' => 'Zeitplan erfolgreich gelöscht.',
        'schedule_not_found' => 'Zeitplan nicht gefunden.',
        'retrieve' => 'Erfolgreich abgerufen.',
        'doctor_session_not_found' => 'Arztsitzung nicht gefunden.',
        'no_available_slots' => 'Zum angegebenen Datum sind keine Slots verfügbar.',
        'google_calendar_connect' => 'Ihr Google Kalender ist jetzt verbunden.',
        'something_went_wrong' => 'Etwas ist schief gelaufen',
        'calender_added' => 'Kalender erfolgreich hinzugefügt.',
        'google_calendar_disconnect' => 'Google Kalender wurde erfolgreich getrennt.',
        'google_calendar_update' => 'Ihr Google Kalender wurde erfolgreich aktualisiert.',
        'states_retrieve' => 'Zustände erfolgreich abgerufen.',
        'cities_retrieve' => 'Städte erfolgreich abgerufen',
        'session_retrieve' => 'Sitzung erfolgreich abgerufen.',
        'review_add' => 'Hinzufügen erfolgreich überprüft.',
        'review_retrieved' => 'Bewertung erfolgreich abgerufen.',
        'review_edit' => 'Bewertung erfolgreich bearbeitet.',
        'live_consultation_save' => 'Live-Konsultation erfolgreich gespeichert.',
        'live_consultation_retrieved' => 'Live-Konsultation erfolgreich abgerufen.',
        'live_consultation_update' => 'Live-Konsultation erfolgreich aktualisiert.',
        'live_consultation_delete' => 'Live-Konsultation erfolgreich gelöscht.',
        'notification_read' => 'Benachrichtigung erfolgreich gelesen.',
        'all_notification_read' => 'Alle Benachrichtigungen erfolgreich gelesen.',
        'visit_prescription_update' => 'Besuchsrezept erfolgreich aktualisiert.',
        'visit_prescription_added' => 'Besuchsrezept erfolgreich hinzugefügt.',
        'qualification_create' => 'Qualifikation erfolgreich erstellt.',
        'prescription_retrieved' => 'Rezept erfolgreich abgerufen.',
        'prescription_delete' => 'Rezept erfolgreich gelöscht.',
        'problem_added' => 'Problem erfolgreich hinzugefügt.',
        'problem_delete' => 'Problem erfolgreich gelöscht.',
        'observation_added' => 'Beobachtung erfolgreich hinzugefügt.',
        'observation_delete' => 'Beobachtung erfolgreich gelöscht.',
        'note_added' => 'Notiz erfolgreich hinzugefügt.',
        'note_delete' => 'Notiz erfolgreich gelöscht.',
        'visit_create' => 'Besuch erfolgreich erstellt.',
        'visit_update' => 'Besuch erfolgreich aktualisiert.',
        'visit_delete' => 'Löschen erfolgreich besucht.',
        'doctor_create' => 'Arzt erfolgreich erstellt.',
        'doctor_update' => 'Doktor erfolgreich aktualisiert.',
        'doctor_delete' => 'Arzt erfolgreich gelöscht.',
        'doctor_use' => 'Arzt erfolgreich eingesetzt.',
        'user_profile_update' => 'Benutzerprofil erfolgreich aktualisiert.',
        'staff_create' => 'Personal erfolgreich erstellt.',
        'staff_update' => 'Mitarbeiter erfolgreich aktualisiert.',
        'staff_delete' => 'Mitarbeiter erfolgreich gelöscht.',
        'staff_use' => 'Personal erfolgreich eingesetzt.',
        'specialization_create' => 'Spezialisierung erfolgreich erstellt.',
        'specialization_update' => 'Spezialisierung erfolgreich aktualisiert.',
        'specialization_delete' => 'Spezialisierung erfolgreich gelöscht.',
        'specialization_use' => 'Spezialisierung erfolgreich eingesetzt.',
        'service_cat_create' => 'Dienstkategorie erfolgreich erstellt.',
        'service_cat_update' => 'Dienstkategorie erfolgreich aktualisiert.',
        'service_cat_use' => 'Servicekategorie woanders verwendet.',
        'service_cat_delete' => 'Dienstkategorie erfolgreich gelöscht.',
        'cat_retrieve' => 'Kategorie erfolgreich abgerufen.',
        'service_create' => 'Dienst erfolgreich erstellt.',
        'service_update' => 'Dienst erfolgreich aktualisiert.',
        'service_delete' => 'Dienst erfolgreich gelöscht.',
        'service_use' => 'Dienst woanders verwendet.',
        'verified_email' => 'E-Mail erfolgreich bestätigt.',
        'email_notification' => 'E-Mail-Benachrichtigung erfolgreich aktualisiert.',
        'notification_send' => 'E-Mail-Bestätigungsbenachrichtigung erfolgreich gesendet.',
        'theme_change' => 'Design erfolgreich geändert.',
        'reactive_account' => 'Reaktivieren Sie Ihr Konto von Mail.',
        'user_status' => 'Benutzerstatus erfolgreich aktualisiert',
        'user_update' => 'Benutzer erfolgreich aktualisiert.',
        'user_profile' => 'Benutzerprofil erfolgreich aktualisiert.',
        'user_already_verified' => 'Benutzer hat bereits E-Mail bestätigt.',
        'current_invalid' => 'Aktuelles Passwort ist ungültig.',
        'password_update' => 'Passwort erfolgreich aktualisiert.',
        'language_update' => 'Sprache erfolgreich aktualisiert.',
        'language_change' => 'Sprache erfolgreich geändert',
        'order_create' => 'Bestellung erfolgreich erstellt.',
        'plan_update' => 'Plan erfolgreich aktualisiert.',
        'plan_status' => 'Planstatus erfolgreich aktualisiert',
        'plan_default' => 'Standardplan erfolgreich geändert.',
        'patient_create' => 'Patient erfolgreich erstellt.',
        'patient_update' => 'Patient erfolgreich aktualisiert.',
        'patient_used' => 'Patient woanders verwendet.',
        'patient_delete' => 'Patient erfolgreich gelöscht.',
        'patient_not_found' => 'Patient nicht gefunden.',
        'country_create' => 'Land erfolgreich erstellt.',
        'country_update' => 'Land erfolgreich aktualisiert.',
        'country_used' => 'Land woanders verwendet.',
        'country_delete' => 'Land erfolgreich gelöscht.',
        'currency_create' => 'Währung erfolgreich erstellt.',
        'currency_update' => 'Währung erfolgreich aktualisiert.',
        'currency_used' => 'Währung woanders verwendet.',
        'currency_delete' => 'Währung erfolgreich gelöscht.',
        'state_create' => 'Status erfolgreich erstellt.',
        'state_update' => 'Status erfolgreich gelöscht.',
        'state_delete' => 'Status erfolgreich aktualisiert.',
        'state_use' => 'Zustand woanders verwendet.',
        'city_create' => 'Stadt erfolgreich erstellt.',
        'city_retrieved' => 'Stadt erfolgreich abgerufen.',
        'city_update' => 'Stadt erfolgreich aktualisiert.',
        'city_used' => 'Stadt woanders verwendet.',
        'city_delete' => 'Stadt erfolgreich gelöscht.',
        'about_us_create' => 'Über uns erfolgreich gespeichert.',
        'feature_update' => 'Funktion erfolgreich aktualisiert.',
        'clinic_save' => 'Klinikplan erfolgreich gespeichert.',
        'clinic_delete' => 'ClinicSchedule erfolgreich gelöscht.',
        'create_front_testimonial' => 'Testimonial erfolgreich erstellt.',
        'update_front_testimonial' => 'Testimonial erfolgreich aktualisiert.',
        'setting_update' => 'Einstellungen erfolgreich aktualisiert.',
        'cms_update' => 'CMS erfolgreich aktualisiert.',
        'enquire_sent' => 'Anfrage erfolgreich gesendet',
        'messages_sent' => 'Nachricht erfolgreich gesendet',
        'enquire_deleted' => 'Anfrage erfolgreich gelöscht.',
        'create_blog' => 'VCard-Blog erfolgreich erstellt.',
        'update_blog' => 'VCard-Blog erfolgreich aktualisiert.',
        'role_create' => 'Rolle erfolgreich erstellt.',
        'role_update' => 'Rolle erfolgreich aktualisiert.',
        'doctor_appointment' => 'Arztterminkalenderdaten erfolgreich abgerufen.',
        'patient_appointment' => 'Patiententerminkalenderdaten erfolgreich abgerufen.',
        'appointment_create' => 'Termin erfolgreich erstellt.',
        'appointment_not_found' => 'Termin nicht gefunden',
        'appointment_created_payment_complete' => 'Termin erfolgreich erstellt und Zahlung abgeschlossen.',
        'appointment_created_payment_not_complete' => 'Termin erfolgreich erstellt und Zahlung nicht abgeschlossen.',
        'appointment_delete' => 'Termin erfolgreich gelöscht.',
        'appointment_retrieve' => 'Terminkalenderdaten erfolgreich abgerufen.',
        'appointment_cancel' => 'Termin abgesagt.',
        'appointment_booked' => 'Termin erfolgreich gebucht',
        'status_update' => 'Status erfolgreich aktualisiert.',
        'status_change' => 'Status erfolgreich geändert.',
        'payment_status_updated' => 'Zahlungsstatus erfolgreich aktualisiert.',
        'operation_performed_success' => 'Operation erfolgreich durchgeführt',
        'paystack_token_expired' => 'Das Paystack-Token ist abgelaufen. Bitte aktualisieren Sie die Seite und versuchen Sie es erneut.',
        'default_role_not_delete' => 'Standardrolle nicht gelöscht.',
        'user_role_not_delete' => 'Diese Benutzerrolle konnte nicht gelöscht werden, da sie einem Benutzer zugewiesen ist.',
        'role_delete' => 'Rolle erfolgreich gelöscht.',
        'faq_update' => 'FAQ erfolgreich aktualisiert.',
        'faq_use' => 'Diese FAQ wurde woanders verwendet.',
        'faq_delete' => 'FAQ erfolgreich gelöscht.',
        'slider_update' => 'Slider erfolgreich aktualisiert',
        'subscriber_creat' => 'Abonnent erfolgreich erstellt.',
        'subscriber_delete' => 'Abonnent erfolgreich gelöscht.',
        'testimonial_creat' => 'Front Patient Testimonial erfolgreich erstellt.',
        'testimonial_update' => 'Front Patient Testimonial wurde erfolgreich aktualisiert.',
        'testimonial_use' => 'Front Patient Testimonial erfolgreich verwendet.',
        'testimonial_delete' => 'Front Patient Testimonial erfolgreich gelöscht.',
        'there_were' => 'Es gab ein Problem mit der Zahlung. Bitte versuchen Sie es später noch einmal.',
        'your_reg_success' => 'Ihre Registrierung erfolgreich. Bitte bestätigen Sie Ihr Konto per E-Mail.',
        'some_doctors' => 'Einige Ärzte haben ihre Tage in bestimmten ungeprüften Tagen geplant, also sind Sie sicher, dass Sie diese Operation durchführen möchten?',
        'email_send' => 'E-Mail erfolgreich gesendet.',
        'faq_creat' => 'FAQ erfolgreich erstellt.',
        'valid_twitter' => 'Bitte geben Sie eine gültige Twitter-URL ein',
        'valid_linkedin' => 'Bitte geben Sie eine gültige Linkedin-URL ein',
        'valid_instagram' => 'Bitte geben Sie eine gültige Instagram-URL ein',
        'user_8_or' => 'Verwenden Sie 6 oder mehr Zeichen mit einer Mischung aus Buchstaben, Zahlen und Symbolen.',
        'degree_required' => 'Das Studienfach ist erforderlich.',
        'university_required' => 'Die Universität ist erforderlich.',
        'year_required' => 'Das Jahr ist erforderlich.',
        'select_payment' => 'Bitte wählen Sie eine Zahlungsmethode aus',
        'maximum_char' => 'Maximal 60 Zeichen erlaubt.',
        'doctor_not_available' => 'Arzt nicht erreichbar',
        'doctor_holiday' => 'Doctor Holiday erfolgreich erstellt',
        'holiday_already_is_exist' => 'Für dieses Datum existiert bereits ein Feiertag',
        'profile_validation_message' => 'Das Profil muss eine Datei des Typs: jpg, jpeg, png sein.',
        'logo_validation_message' => 'Das Anwendungslogo muss ein Dateityp sein: jpg, jpeg, png.',
        'favicon_validation_message' => 'Das Favicon muss ein Dateityp sein: jpg, jpeg, png.',
        'icon_validation_message' => 'Das Symbol muss ein Dateityp sein: jpg, jpeg, png, svg.',
        'about_image_validation_message' => 'Das About-Bild muss ein Dateityp sein: jpg, jpeg, png.',
        'user_zoom_credential_saved' => 'Benutzer-Zoomen-Anmeldeinformationen erfolgreich gespeichert.',
        'select_calendar.' => 'Bitte wählen Sie einen Kalender aus.'
    ],
    'holiday' => [
        'holiday' => 'Ferien',
        'add_holiday' => 'Urlaub hinzufügen',
        'doctor_holiday' => 'Arzt Urlaub',
        'service_category' => 'Servicekategorie',
        'holiday_date' => 'Feiertagsdatum',
    ],

    'payment_method' => [
        'stripe' => 'Streifen',
        'paystack' => 'Lohn',
        'paypal' => 'Paypal',
        'razorpay' => 'Rasiererzahlung',
        'authorize' => 'Autorisieren',
        'paytm' => 'Paytm',
    ],
    'medicine' => [
        'medicine' => 'Medizin',
        'medicine_category' => 'Kategorie Medizin',
        'medicine_category_details' => 'Details zur Arzneimittelkategorie',
        'medicines' => 'Medikamente',
        'medicine_details' => 'Einzelheiten zu Medikamenten',
        'new_medicine' => 'Neue Medizin',
        'new_medicine_category' => 'Kategorie „Neue Medizin“.',
        'edit_medicine_category' => 'Kategorie „Medizin“ bearbeiten',
        'edit_medicine' => 'Medizin bearbeiten',
        'name' => 'Name',
        'brand' => 'Marke',
        'selling_price' => 'Verkaufspreis',
        'buying_price' => 'Kaufpreis',
        'category' => 'Kategorie',
        'salt_composition' => 'Salzzusammensetzung',
        'side_effects' => 'Nebenwirkungen',
        'description' => 'Beschreibung',
        'category_id' => 'Kategorie ID',
        'brand_name' => 'Markenname',
        'medicine_brands' => 'Arzneimittelmarken',
        'medicine_brands_details' => 'Details zur Arzneimittelmarke',
        'new_brand' => 'Neue Marke',
        'new_medicine_brand' => 'Neue Medizinmarke',
        'edit_medicine_brand' => 'Medizinmarke bearbeiten',
        'medicine_name' => 'Name des Arzneimittels',
        'dosage' => 'Dosierung',
        'duration' => 'Dauer',
        'saved_successfully' => 'Erfolgreich gespeichert',
        'updated_successfully' => 'Erfolgreich geupdated',
        'deleted_successfully' => 'Erfolgreich gelöscht',
        'cant_be_deleted' => 'kann nicht gelöscht werden',
        'status_updated_successfully' => 'Status erfolgreich aktualisiert.',
        'filter_options' => 'Filteroptionen',
        'available_quantity' => 'verfügbare Anzahl',
        'brand' => 'Marke',
        'category' => 'Kategorie',
        'quantity' => 'Menge',
        'medicine_retrieved_successfully' => 'Medizin erfolgreich abgerufen',
        'no_use' => 'Nicht in Gebrauch',
        'category_retrieved_successfully' => 'Medizinkategorie erfolgreich abgerufen.',
        'select_duration' => 'Wählen Sie Dauer aus',
        'dose_interval' => 'Wählen Sie Dosisintervall',

    ],

    'purchase_medicine' => [
        'purchase_number' => 'Kaufnummer',
        'total' => 'Gesamt',
        'discount' => 'Rabatt',
        'tax_amount' => 'Steuerbetrag',
        'net_amount' => 'Netto-Betrag',
        'payment_mode' => 'Zahlungsart',
        'payment_note' => 'Zahlungshinweis',
        'note' => 'Notiz',
        'purchase_medicine' => 'Kaufen Sie Medikamente',
        'purchase_medicines' => 'Kaufen Sie Medikamente',
        'purchase_medicine_details' => 'Details zum Kauf von Arzneimitteln',
        'purchase_medicine_overview' => 'Übersicht über den Kauf von Arzneimitteln',
        'lot_no' => 'Lot-Nr.',
        'tax' => 'Steuer',
        'quantity' => 'Menge',
        'amount' => 'Menge',
        'expiry_date' => 'Verfallsdatum',
        'other_details' => 'Andere Details',
        'dose_duration' => 'Dosisdauer',
        'actions' => 'Aktionen',
        'export_to_excel' => 'Nach Excel exportieren',
        'purchased_medicine_success' => 'Medikament erfolgreich gekauft',
    ],

    'used_medicine' => [
        'used_medicine' => 'Gebrauchte Medizin',
        'used_medicines' => 'Gebrauchte Medikamente',
        'used_quantity' => 'Gebrauchte Menge',
        'used_at' => 'Verwendet bei',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Arzneimittelrechnungen',
        'medicine_bill' => 'Medizingesetz',
        'add_medicine_bill' => 'Arzneimittelrechnung hinzufügen',
        'edit_medicine_bill' => 'Bearbeiten Sie das Arzneimittelgesetz',
        'medicine_bill_details' => 'Einzelheiten zum Arzneimittelgesetz',
        'dose_interval' => 'Dosisintervall',
        'available_quantity' => 'Die verfügbare Menge von',
        'is' => 'Ist',
        'prescription_not_found' => 'Rezept nicht gefunden',
        'medicine_not_selected' => 'Bitte wählen Sie mindestens ein Arzneimittel aus.',
        'duplicate_medicine' => 'Es können keine doppelten Medikamente hinzugefügt werden.',
        'payment_status' => 'Zahlungsstatus',
        'sale_price' => 'Verkaufspreis',
        'select_medicine' => 'Wählen Sie Medizin',
        'update_quantity' => 'Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.',
        'net_amount_not_empty' => 'Der Nettobetrag darf nicht leer sein.',
        'net_amount_not_zero' => 'Der Nettobetrag darf nicht Null sein.',
        'medicine_required' => 'Fachrichtung Medizin ist erforderlich.',
        'bill_number' => 'Rechnungsnummer',
        'payment_type' => 'Zahlungsart',
        'bill_date' => 'Rechnungsdatum',
        'select_patient' => 'Wählen Sie Patient aus',
        'new_medicine_bill' => 'Neues Arzneimittelgesetz',
        'print_bill' => 'Rechnung drucken',
        'cell_no' => 'Zellennr',
        'item_name' => 'Artikelname',
        'price' => 'Preis',
        'bill_id' => 'Rechnungs-ID',
        'select_payment_type' => 'Wähle eine Zahlmethode aus',
        'quantity_should' => 'Die Menge sollte größer als 0 sein.',
        'net_amount_cant'=>'Der Nettobetrag darf nicht leer sein.',
        'net_amount_cant_zero'=>'Der Nettobetrag darf nicht Null sein.',
        'tax_amt'=>'Der Steuerbetrag darf nicht Null oder leer sein.',
        'enter_lot_number'=>'Geben Sie die Chargennummer ein.',
        'enter_sale_price'=>'Geben Sie den Verkaufspreis ein.',
        'enter_puchase_price'=>'Kaufpreis eingeben',
        'tax_should_be' => 'Die Steuern sollten weniger als 100 % betragen.',
        'tax_cannot_be_zero_empty'=> 'Der Steuerbetrag darf nicht Null oder leer sein.',
        'the_discount_shoul'=> 'Der Rabatt sollte geringer sein als der Gesamtbetrag',
        'the_medicine_already_in_use'=> 'Dieses Arzneimittel wird bereits in Arzneimittelrechnungen verwendet. Möchten Sie es wirklich löschen?',
        'avl_qty' => 'Durchschn. Menge'
    ],

    'smart_patient_card' => [
        'smart_patient_cards' => 'Intelligente Patientenkarten',
        'smart_patient_card_templates' => 'Vorlagen für intelligente Patientenkarten',
        'templat_name' => 'Vorlagenname',
        'header_color' => 'Kopffarbe',
        'email_show' => 'E-Mail anzeigen',
        'phone_show' => 'Telefon anzeigen',
        'dob_show' => 'Geburtsdatum anzeigen',
        'blood_group_show' => 'Blutgruppe anzeigen',
        'address_show' => 'Adresse anzeigen',
        'unique_id_show' => 'Eindeutige ID anzeigen',
        'add_smart_card_templates' => 'Intelligente Kartenvorlagen hinzufügen',
        'add_smart_card' => 'Intelligente Karte hinzufügen',
        'edit_patient_card' => 'Intelligente Karte bearbeiten',
        'template_created' => 'Vorlage erfolgreich erstellt.',
        'template_update' => 'Vorlagenaktualisierung erfolgreich.',
        'template_deleted' => 'Vorlage erfolgreich gelöscht.',

        'generate_patient_smart_cards' => 'Intelligente Patientenkarten generieren',
        'generate_patient_card' => 'Intelligente Karte generieren',
        'select_template' => 'Vorlage auswählen',
        'for_all_patient' => 'Für alle Patienten',
        'only_one_patient' => 'Nur ein Patient',
        'remaning_patients' => 'Verbleibende Patienten',
        'select_patient' => 'Patient auswählen',
        'patient_smart_card_created' => 'Patienten-Smartcard erfolgreich erstellt.',
        'patient_smart_card_deleted' => 'Patienten-Smartcard erfolgreich gelöscht.',
        'enter_template_name' => 'Vorlagenname eingeben',
        'please_selest_patient' => 'Bitte wählen Sie Patient aus',
        'template' => 'Vorlage',
        'type' => 'Typ',
        'patient' => 'Patient',
    ],

];
