<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - English Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys

    'dashboard' => '仪表板',
    'users' => '用户',
    'patients' => '病人',
    'settings' => '设置',
    'clinic_schedules' => '诊所时间表',
    'start_time_invalid' => '當天的開始時間無效',
    'doctor_sessions' => '医生时间表',
    'apps' => '应用程序',
    'countries' => '国家',
    'states' => '国家',
    'cities' => '城市',
    'doctors' => '医生',
    'service_categories' => '服务类别',
    'specializations' => '专业',
    'services' => '服务',
    'roles' => '角色',
    'staffs' => '员工',
    'appointments' => '约会',
    'doctor_appointments' => '医生预约',
    'currencies' => '货币',
    'login' => '登录',
    'register' => '注册',
    'visits' => '访问',
    'front_cms' => '前端 CMS',
    'sliders' => '滑块',
    'front_services' => '前台服务',
    'faqs' => '常见问题',
    'front_medical_services' => '前线医疗服务',
    'front_patient_testimonials' => '前台患者推荐',
    'enquiries' => '查询',
    'subscribers' => '订阅者',
    'privacy_policy' => '隐私政策',
    'terms_conditions' => '条款和条件',
    'transactions' => '交易',
    'reviews' => '评论',
    'live_consultations' => '现场咨询',
    'email_password_reset_link' => '重設電子郵件密碼的鏈接',
    'resend_email_verification' => '重新发送电子邮件验证',
    'paytm' => '支付宝',
    'payment_detail' => '付款明细',
    'payment_for_booking_appointment_with_doctor' => '与医生预约的费用',
    'mobile_no' => '手机号码',
    'doctors_scheduled_time_ended_for_today__' => '今天医生预约时间结束，请选择其他医生或日期',
    'valid_number' => '有效号码',
    'invalid_number' => '无效号码',
    'invalid_country_code' => '国家代码无效',
    'too_short' => '很短',
    'too_long' => '太短',
    'note' => '注意：您必须在集成 Google 日历之前设置您的时区。',
    'medicine_categories' => '医药类别',
    'medicine_brands' => '药品品牌',
    'medicines' => '药物',

    'no_response' => '沒有回覆',
    'filter_success' => '過濾成功',
    'live_status_retrieved_successfully.' => '即時狀態已成功檢索。',
    'id' => 'ID',

    'holder_name_required' => '持卡人姓名欄位為必填項。',
    'holder_name_invalid' => '持卡人姓名無效。',
    'holder_number_invalid' => '卡號欄位為必填項。',
    'expiration_month_required' => '到期月份欄位是必需的。',
    'expiration_year_required' => '到期年份欄位是必需的。',
    'valid_expiration_date' => '輸入有效的到期日。',
    'cvv_number_required.' => 'CVV 號碼欄位為必填項。',
    'cvv_invalid.' => 'CVV 無效。',
    'card_number_invalid..' => '卡號無效。',

    'range_constructor_requires_trie_parameter' => 'Range 建構函式需要 Trie 參數',
    'requires_string_parameter' => 'rangeWithString 需要一個字串參數',
    'invalid_range' => '無效範圍',
    'card_type' => '信用卡類型',
    'not_supported' => '不支援',

    'image_file_type' => '圖像必須是以下類型的檔案：jpeg、jpg、png。',
    'icon_size' => '圖示大小應小於 2 MB',


    'web' => [
        'enter_your_email' => '输入你的电子邮箱',
        'emergency_help' => '紧急帮助',
        'qualified_doctors' => '合格医生',
        'best_professionals' => '最佳专业人士',
        'medical_treatment' => '药物治疗',
        'testimonial' => '推荐',
        'see_what_are_the_patients' => '看看病人是什么',
        'saying_about_us' => '说到我们',
        'our_team' => '我们的队伍',
        'our_doctor' => '我们的医生',
        'contact_us' => '联系我们',
        'faqs' => '常见问题',
        'location' => '地点',
        'quick_links' => '快速链接',
        'sign_up' => '报名',
        'year_experience' => '年经验',
        'working_process' => '工作流程',
        'how_we_works' => '我们如何工作',
        'registration' => '登记',
        'view_more' => '查看更多',
        'email_address' => '电子邮件地址',
        'make_appointment' => '约个时间',
        'take_treatment' => '接受治疗',
        'appointment_now' => '立即预约',
        'all_services' => '所有服务',
        'satisfied_patient' => '满意的病人',
        'Meet_best_doctors' => '遇见最好的医生',
        'all_rights_reserved' => '版权所有',
        'contact_us_for_any_information' => '联系我们获取任何信息',
        'patient_can_do_registration___' => '患者可以从这里注册基本信息。',
        'patient_can_book_an_appointment___' => '患者可以从登陆页面或他的登录面板与医生预约。',
        'doctors_can_interact___' => '医生可以与患者互动并进行相关治疗。',
        'we_cover_a_big___' => '我们涵盖各种各样的医疗服务',
        'we_provide_the_special_tips___' => '我们提供保健治疗和高水平最好的特别提示和建议。',
        'timings' => '时间',
        'book_an_appointment' => '预约',
        'login' => '登录',
        'home' => '家',
        'about_us' => '关于我们',
        'services' => '服务',
        'appointment' => '约会',
        'doctors' => '医生',
        'contact' => '联系方式',
        'call_us' => '给我们打电话',
        'send_an_email' => '发送电子邮件',
        'subscribe' => '订阅',
        'medical' => '医疗',
        'medical_services' => '医疗服务',
        'medical_about_us' => '关于我们的医疗',
        'medical_appointment' => '医疗预约',
        'medical_doctors' => '医生',
        'medical_contact' => '医疗联系人',
        'opening_hours' => '营业时间',
        'send_us_an_email' => '给我们发送电子邮件',
        'name' => '姓名',
        'reason' => '原因',
        'email' => '电子邮件',
        'phone' => '电话',
        'subject' => '主题',
        'message' => '消息',
        'send_message' => '发送消息',
        'closed' => '关闭',
        'enquiry_details' => '查询详情',
        'status' => '状态',
        'created_at' => '创建于',
        'total_services' => '总服务',
        'total_doctors' => '总医生',
        'total_registered_patient' => '总注册患者',
        'total_specializations' => '总专业化',
        'about_title' => '关于标题',
        'about_experience' => '关于体验',
        'about_short_description' => '关于简短描述',
        'patient_registration' => '病人登记',
        'already_have_an_account' => '已经有一个帐户',
        'sign_in_here' => '在此处登录',
        'i_agree' => '我同意',
        'terms_and_conditions' => '条款和条件',
        'sign_in' => '登录',
        'new_here' => '新来',
        'create_an_account' => '创建一个帐户',
        'remember_me' => '记住我',
        'forgot_password' => '忘记密码',
        'already_have_patient_account' => '已有患者账户',
        'confirm_booking' => '确认预订',
        'patient_name' => '患者姓名',
        'questions_before_booking' => '预订前的问题',
        'no_services_available' => '没有可用的服务',
        'meet_our_team_of_specialists' => '认识我们的专家团队',
        'enter_your_email_to_subscribe_to_our_newsletter' => '输入您的电子邮件以订阅我们的时事通讯',
        'we_make_sure_that_your_life_are_in_good_hands' => '我们确保您的生活得到妥善处理',
        'dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the' => '在集成结果之前动态地制定无错误的结果。 在没有成本效益的情况下大幅孵化整合资源。',
        'enquiry' => '询问',
        'book_appointment' => '预约',
    ],

    'admin_dashboard' => [
        'dashboard' => '仪表板',
        'name' => '姓名',
        'patient_id' => '患者唯一 ID',
        'registered' => '注册',
        'month' => '月',
        'week' => '周',
        'day' => '天',
        'total_doctor' => '总医生',
        'total_patients' => '总患者',
        'today_appointments' => '今日约会',
        'today_registered_patients' => '今天注册的患者',
        'recent_patients_registration' => '近期患者登记',
        'earnings_from_appointments' => '任命收入',
        'filter_options' => '过滤器选项',
    ],
    'common' => [
        'save' => '保存',
        'submit' => '提交',
        'cancel' => '取消',
        'discard' => '丢弃',
        'country' => '国家',
        'state' => '状态',
        'city' => '城市',
        'please_wait' => '请稍候...',
        'back' => '返回',
        'action' => '动作',
        'add' => '添加',
        'edit' => '编辑',
        'name' => '姓名',
        'details' => '详情',
        'service' => '服务',
        'active' => '活动',
        'de_active' => '停用',
        'overview' => '概述',
        'n/a' => '不适用',
        'filter' => '过滤',
        'filter_option' => '过滤选项',
        'apply' => '申请',
        'reset' => '重置',
        'no_data_available' => '无可用数据',
        'no_records_found' => '没有找到记录。',
        'impersonate' => '模仿',
        'email_verified' => '电子邮件已验证',
        'custom' => '风俗',
        'from' => '从',
        'to' => '至',
        'select_service' => '选择服务',
        'select_category' => '选择类别',
        'select_doctor' => '选择医生',
        'delete' => '删除',
        'search' => '搜索',
        'twitter_url' => '推特网址',
        'linkedin_url' => '领英网址',
        'instagram_url' => 'Instagram 网址',
        'show' => '节目',
        'are_you_sure' => '你确定要删除这个',
        'cancelled_appointment' => '取消约会！',
        'are_you_sure_cancel' => '你确定要取消吗',
        'has_cancel' => ' 已经取消了。',
        'no' => '不，取消',
        'yes' => '是的，删除！',
        'select_country' => '选择国家',
        'select_state' => '选择状态',
        'select_city' => '选择城市',
        'no_data_available_in_table' => '表中无可用数据',
        'read' => '读',
        'unread' => '未读',
        'change_image' => '更改图像',
        'hour' => '小时',
        'minutes' => '分钟',
        'deleted' => '已删除！',
        'has_been' => '已被删除。',
        'yes_update' => '是的，更新！',
        'error' => '错误',
        'booked' => '预订',
        'check in' => '报到',
        'check out' => '查看',
        'cancelled' => '取消',
        'view' => '看法',
        'note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar' => '注意：我们在日历中创建约会时会采用您医生的时区。如果 Doctor 没有设置时区，那么它将采用默认的 UTC 时区。',

        'download' => '下载',
        'select_brand' => '选择品牌',
        'observation_white_space' => '观察字段不仅仅包含空白',
        'problem_white_space' => '问题字段不仅仅包含空格',
        'note_white_space' => '注意字段不仅仅包含空格',

        'showing' => '显示中',
        'to' => '到',
        'of' => '的',
        'results' => '结果',
        'google_captcha_required' => '谷歌验证码字段是必需的。',
        'processing' => '加工..',
        'first_name_required' => '名字字段是必需的。',
        'last_name_required' => '姓氏字段是必需的。',
        'email_required' => '电子邮件字段为必填项。',
        'doctor_required' => '需要医生字段。',
        'service_required' => '服务字段为必填项。',
        'appointment_date_required' => '预约日期字段为必填项。',
        'payment_type_required' => '付款方式字段为必填项。',
        'prescription_report' => '处方报告',
        'age' => '年龄',
        'years' => '年',
        'maximum_55' => '最多允许 55 个字符。',
        'name_required' => '姓名字段为必填项',
        'name_already_taken' => '该名字已被占用',
        'any_one_permission' => '请选择任意一项权限。',
        'add_credential' => '请添加缩放凭据',
        'connected_zoom' => '与zoom连接成功。',
        'contact_number' => '联系电话是',
        'purchase_price' => '购买价格',
        'email_already_exist' => '该电子邮件已订阅。',
        'email_not_register' => '电子邮件未注册。',
        'category_required' => '类别字段是必需的。',
        'brand_required' => '品牌字段为必填项。',


        'message_required' => '消息字段为必填项.',
        'subject_required' => '主题字段为必填项.',
        'email_max' => '电子邮件的最大大小为 255.',
        'email_regex' => '电子邮件字段必须是有效的格式.',
        'Attempt_read_property_access_token_null' => '嘗試讀取 null 上的屬性“access_token”',
        'default_language' => '預設語言',

        'not_allow__assess_record' => '看來您無權存取此記錄。',
        'zoom_credentials' => '請新增縮放憑證。',

        'forgot_your_password' => '忘記密碼了嗎',
        'remember_me' => '記住帳號',
        'Forgot_password_lable'=> '你忘記密碼了嗎？沒問題。只需告訴我們您的電子郵件地址，我們將向您發送一個密碼重置鏈接，您可以透過該鏈接選擇一個新密碼。',
        'reset_password' => '重新設密碼',
        'verify_lable1' => '感謝您的註冊！在開始之前，您可以透過點擊我們剛剛透過電子郵件發送給您的連結來驗證您的電子郵件地址嗎？如果您沒有收到電子郵件，我們很樂意向您發送另一封電子郵件。',
        'verify_lable2' => '新的驗證連結已發送至您註冊時提供的電子郵件地址。',
        'resend_verification_email' => '重新發送驗證郵件',
        'logout' => '登出',
        'confirm' => '確認'
    ],

    'user' => [
        'profile_details' => '个人资料详情',
        'edit_profile' => '编辑个人资料',
        'avatar' => '头像',
        'full_name' => '全名',
        'email' => '电子邮件',
        'contact_number' => '联系电话',
        'save_changes' => '保存更改',
        'setting' => '设置',
        'account_setting' => '账户设置',
        'change_password' => '更改密码',
        'current_password' => '当前密码',
        'new_password' => '新密码',
        'confirm_password' => '确认密码',
        'account' => '帐户',
        'staff_details' => '员工详情',
        'gender' => '性别',
        'language' => '语言',
        'sign_out' => '退出',
        'return_to_admin' => '返回管理员',
        'email_notification' => '电子邮件通知',
        'time_zone' => '时区',
        'change_language' => '改变语言',
        'select_time_zone' => '选择时区',
    ],

    'setting' => [
        'setting' => '环境',
        'general' => '一般',
        'contact_information' => '联系方式',
        'currency_settings' => '货币设置',
        'general_details' => '一般详情',
        'clinic_name' => '诊所名称',
        'specialities' => '专业',
        'currency' => '货币',
        'prefix' => '前缀',
        'address' => '地址',
        'postal_code' => '邮政编码',
        'logo' => '标志',
        'favicon' => '收藏夹',
        'default_country_code' => '默认国家代码',
        'do_not_allow_to_login_without_email_verification' => '不允许在没有电子邮件验证的情况下登录',
        'connect_google_calendar' => '连接谷歌日历',
        'connect_your_google_calendar' => '连接你的谷歌日历',
        'disconnect_your_google_calendar' => '断开您的 Google 日历',
        'sync_your_google_calendar' => '同步你的谷歌日历',
        'select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments' => '选择您要在其中创建约会的日历（来自 Google 日历）',
        'when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars' => '当患者与您预约时，将在选定的日历上创建新的预约',
        'when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars' => '当您预订约会时，将在所选日历上创建新约会',
        'when_checkbox_disable' => '当复选框被禁用时，电子邮件验证不适用于新用户。',
        'change_app_logo' => '更改应用程序徽标',
        'change_favicon' => '更改网站图标',
        'default_language_suggest' => '透過更新，整個應用程式的語言將在醫生、患者登入以及前端發生變化。'
    ],

    'patient' => [
        'add' => '添加患者',
        'edit' => '编辑患者',
        'name' => '姓名',
        'first_name' => '名字',
        'last_name' => '姓氏',
        'patient_unique_id' => '患者唯一 ID',
        'email' => '电子邮件',
        'password' => '密码',
        'confirm_password' => '确认密码',
        'contact_no' => '联系号码',
        'save_changes' => '保存更改',
        'profile' => '个人资料',
        'dob' => '出生日期',
        'gender' => '性别',
        'blood_group' => '血型',
        'male' => '男',
        'female' => '女',
        'address1' => '地址 1',
        'address2' => '地址 2',
        'city' => '城市',
        'state' => '状态',
        'country' => '国家',
        'postal_code' => '邮政编码',
        'address_information' => '地址信息',
        'registered_on' => '注册',
        'details' => '患者详细信息',
        'last_updated' => '最后更新',
        'enter_email' => '輸入電子郵件',
        'enter_password' => '輸入密碼',
        'filter' => '篩選',
        'today' => '今天',
        'emailverified' => '電子郵件已驗證',
    ],

    'country' => [
        'country' => '国家',
        'add_country' => '添加国家',
        'short_code' => '短代码',
    ],

    'state' => [
        'states' => '状态',
        'add_state' => '添加状态',
        'state' => '状态',
        'edit_state' => '编辑状态',
        'country' => '国家',
    ],

    'doctor_session' => [
        'doctor_session' => '医生时间表',
        'my_schedule' => '我的日程',
        'session' => '会话',
        'add' => '添加医生时间表',
        'edit' => '编辑医生时间表',
        'doctor' => '医生',
        'morning_session' => '早间时间表',
        'evening_session' => '晚间时间表',
        'session_time_in_minutes' => '安排会议时间',
        'doctor_session_details' => '医生日程详情',
        'week_days' => '工作日',
        'all' => '全部',
        'monday' => '周一',
        'tuesday' => '周二',
        'wednesday' => '周三',
        'thursday' => '周四',
        'friday' => '星期五',
        'saturday' => '周六',
        'sunday' => '星期日',
        'gap_between_appointment' => '约会间隔',
        'session_gap' => '时间间隔',
        'session_meeting_time' => '安排会议时间',
        'unavailable' => '不可用',
        'copy' => '复制',
        'select_session_gap' => '选择进度间隔',
        'select_meeting_time' => '选择会议时间',
    ],

    'city' => [
        'city' => '城市',
        'add_city' => '添加城市',
        'edit_city' => '编辑城市',
        'state' => '状态',
    ],

    'specialization' => [
        'add_specialization' => '添加专业化',
        'edit_specialization' => '编辑专业化',
        'retrieved_successfully' => '專業化已成功檢索。'
    ],

    'service_category' => [
        'add_category' => '添加服务类别',
        'edit_category' => '编辑服务类别',
        'service_category' => '服务类别',
    ],

    'doctor' => [
        'add' => '添加医生',
        'edit' => '编辑医生',
        'first_name' => '名字',
        'last_name' => '姓氏',
        'dob' => '出生日期',
        'experience' => '年度经验',
        'status' => '状态',
        'specialization' => '专业化',
        'select_gender' => '选择性别',
        'male' => '男',
        'female' => '女',
        'profile' => '个人资料',
        'allowed_img' => '允许的文件类型：png、jpg、jpeg。',
        'address_information' => '地址信息',
        'address1' => '地址 1',
        'address2' => '地址 2',
        'city' => '城市',
        'state' => '状态',
        'country' => '国家',
        'postal_code' => '邮政编码',
        'add_qualification' => '添加资格',
        'degree' => '学位',
        'university' => '大学',
        'year' => '年',
        'passout_year' => '传递年份',
        'sr_no' => 'SR NO',
        'collage_university' => '拼贴/大学',
        'doctor' => '医生',
        'created_at' => '创建于',
        'updated_at' => '更新时间',
        'qualification_information' => '资格信息',
        'doctor_detail' => '医生详情',
        'select_doctors' => '选择医生',
        'qualification' => '资质',
        'select_blood_group' => '选择血型',
        'select_year' => '选择年份',
        'twitter' => '推特',
        'linkedin' => '领英',
        'instagram' => 'Instagram',
        'select_date' => '选择日期',

    ],

    'service' => [
        'add_service' => '添加服务',
        'edit_service' => '编辑服务',
        'category' => '类别',
        'charges' => '收费',
        'short_description' => '简短说明',
    ],

    'role' => [
        'role' => '角色',
        'add_role' => '添加角色',
        'edit_role' => '编辑角色',
        'permissions' => '权限',
        'role_permissions' => '角色权限',
        'select_all_permissions' => '选择所有权限',
    ],

    'staff' => [
        'staff' => '员工',
        'add_staff' => '添加员工',
        'edit_staff' => '编辑人员',
        'staff_details' => '员工详情',
        'first_name' => '名字',
        'last_name' => '姓氏',
        'email' => '电子邮件',
        'password' => '密码',
        'confirm_password' => '确认密码',
        'contact_no' => '联系号码',
        'gender' => '性别',
        'role' => '角色',
        'male' => '男',
        'female' => '女',
        'select_role' => '选择角色',
    ],

    'appointment' => [
        'appointments' => '约会',
        'add_new_appointment' => '添加约会',
        'edit_appointment' => '编辑约会',
        'patient' => '病人',
        'date' => '日期',
        'available_slot' => '可用插槽',
        'description' => '说明',
        'charge' => '充电',
        'extra_fees' => '额外费用',
        'total_payable_amount' => '总应付金额',
        'payable_amount' => '应付金额',
        'no_slot_found' => '没有找到时间段。',
        'service' => '服务',
        'service_charge' => '服务费',
        'time' => '时间',
        'upcoming_meetings' => '即将召开的会议',
        'appointments_schedule' => '约会时间表',
        'patient_id' => '患者 ID',
        'appointment_details' => '约会详情',
        'appointment_at' => '预约时间',
        'appointment_unique_id' => '约会ID',
        'appointment_date' => '预约日期',
        'switch_to_calendar' => '切换到日历',
        'starts' => '开始',
        'ends' => '结束',
        'calendar' => '日历',
        'status' => '状态',
        'booked' => '预订',
        'available' => '可用',
        'check_in' => '签到',
        'check_out' => '退房',
        'cancelled' => '取消',
        'payment' => '支付',
        'Select_payment_method' => '选择付款方式',
        'payment_method' => '付款方法',
        'cancel_appointment' => '取消预约',
        'session_created_successfully' => '会话创建成功',
        'appointment_status' => '预约状态',
        'payment_status' => '支付狀態',
        'ServiceRequired' => '服務欄位為必填項。',
        'PatientRequired' => '需要患者字段。',
        'SelectAppointment' => '請選擇預約時段。',
        'authorize_session_created_successfully' => '授權會話創建成功。',
        'patient_name_retrieved' => '患者姓名檢索成功',
        'session_id_required' => '會話 ID 為必填項',

    ],

    'doctor_appointment' => [
        'patient' => '病人',
        'service' => '服务',
        'from_time' => '从时间',
        'to_time' => '时间',
        'amount' => '金额',
    ],

    'doctor_dashboard' => [
        'total_appointments' => '总约会',
        'recent_appointments' => '最近的约会',
    ],

    'patient_dashboard' => [
        'today_appointments' => '今日约会',
        'completed_appointments' => '已完成的约会',
        'upcoming_appointments' => '即将到来的约会',
        'next_appointment' => '下次约会',
    ],

    'currency' => [
        'add_currency' => '添加货币',
        'edit_currency' => '编辑货币',
        'currency_name' => '货币名称',
        'currency_icon' => '货币图标',
        'currency_code' => '货币代码',
        'name' => '姓名',
        'add_currency_code_as_per_three_letter_iso_code' => '根据三字母 ISO 代码添加货币代码',
        'you_can_find_out_here' => '你可以在这里找到',
    ],

    'visit' => [
        'add_visit' => '添加访问',
        'edit_visit' => '编辑访问',
        'visit_date' => '访问日期',
        'visit_details' => '访问详情',
        'patient' => '病人',
        'doctor' => '医生',
        'description' => '说明',
        'title' => '标题',
        'problems' => '问题',
        'observations' => '观察',
        'notes' => '备注',
        'visit_detail' => '参观详情',
        'prescriptions' => '处方',
        'enter_problem' => '输入问题',
        'enter_observation' => '进入观察',
        'enter_note' => '输入备注',

    ],

    'prescription' => [
        'name' => '姓名',
        'frequency' => '频率',
        'duration' => '持续时间',
        'prescription' => '处方',
        'prescriptions' => '处方药',
        'prescription_details' => '处方详情',
        'new_prescription' => '新处方',
        'edit_prescription' => '编辑处方',
        'patient' => '患者',
        'doctor' => '医生',
        'food_allergies' => '食物过敏',
        'tendency_bleed' => '倾向流血',
        'heart_disease' => '心脏病',
        'high_blood_pressure' => '高血压',
        'diabetic' => '糖尿病的',
        'surgery' => '手术',
        'accident' => '事故',
        'others' => '其他',
        'medical_history' => '病史',
        'current_medication' => '当前药物',
        'female_pregnancy' => '女性怀孕',
        'breast_feeding' => '母乳喂养',
        'health_insurance' => '健康保险',
        'low_income' => '低收入',
        'reference' => '参考',
        'physical_information' => '物理信息',
        'new_medicine' => '新药',
        'plus_rate' => '心率',
        'temperature' => '温度',
        'problem_description' => '问题描述',
        'test' => '测试',
        'advice' => '建议',
        'next_visit' => '下次访问',
        'time' => '时间',
        'comment' => '评论',
        'problem' => '问题',
        'Rx' => '接收',
        'medicine_name' => '药名',
        'duration' => '期间',
        'days' => '天',
        'after meal' => '吃饭后',
        'before meal' => '饭前',
        'dosage' => '剂量',
        'prescription_updated' => '处方更新成功。',
        'prescription_saved' => '处方保存成功。',
        'appointment_slot' => '预约时段',
        'ok' => '好的',
        'connect_with_zoom' => ' 与 飞涨 连接',
        'not_add_duplicate_medicines' => '不能重複添加藥物。',
        'available_quantity_of' => '可用數量 ',
        'is' => '是',
        'selectMedicine' => "選擇藥物",
        'total_quantity' => '總數（量'
    ],

    'slider' => [
        'add_slider' => '添加滑块',
        'edit_slider' => '编辑滑块',
        'title' => '标题',
        'short_description' => '简短说明',
        'image' => '图片',
    ],

    'front_service' => [
        'add_front_service' => '添加前台服务',
        'edit_front_service' => '编辑前台服务',
        'title' => '标题',
        'short_description' => '简短说明',
        'icon' => '图标',
    ],

    'faq' => [
        'add_faq' => '添加常见问题',
        'edit_faq' => '编辑常见问题',
        'question' => '问题',
        'answer' => '答案',
    ],

    'front_medical_service' => [
        'add_front_medical_service' => '添加前线医疗服务',
        'edit_front_medical_service' => '编辑前线医疗服务',
        'title' => '标题',
        'short_description' => '简短说明',
    ],

    'front_patient_testimonial' => [
        'add_front_patient_testimonial' => '添加前台患者推荐',
        'edit_front_patient_testimonial' => '编辑前台患者推荐',
        'name' => '姓名',
        'profile' => '个人资料',
        'designation' => '指定',
        'short_description' => '简短说明',
        'patient_testimonials' => '患者感言',
        'more_patient_feedbacks' => '更多患者反馈...',
    ],

    'cms' => [
        'cms' => '内容管理系统',
        'terms_conditions' => '条款和条件',
        'privacy_policy' => '隐私政策',
        'about_image' => '关于形象',
        'title_no_white_space' => '關於標題欄位不僅僅包含空格',
        'description_no_white_space' => '關於簡短描述欄位不僅僅包含空格',
        'experience_required' => '關於經驗欄位是必要的。',
        'Terms_Conditions_required' => '條款和條件為必填項',
        'privacy_policy_required.' => '需要隱私權政策。',

    ],

    'transaction' => [
        'transaction_detail' => '交易详情',
        'transaction_id' => '交易编号',
        'payment_status' => '支付状态',
        'paid' => '有薪酬的',
        'pending' => '待办的',
        'payment_accepted_by' => '付款接受者',

    ],

    'notification' => [
        'you_don`t_have_any_new_notification' => '您没有任何新通知',
        'notification' => '通知',
        'mark_all_as_read' => '标记为已读',
    ],

    'review' => [
        'write_a_review' => '写评论',
        'add_review' => '添加评论',
        'review' => '审查',
        'edit_review' => '编辑评论',
        'no_doctors_available_to_give_rating' => '没有医生可提供评级。',
    ],

    'live_consultation' => [
        'new_live_consultation' => '新的现场咨询',
        'add_live_consultation' => '添加实时咨询',
        'consultation_title' => '咨询标题',
        'consultation_date' => '咨询日期',
        'select_consultation_date' => '选择咨询日期',
        'select_doctor_name' => '选择医生姓名',
        'select_patient_name' => '选择患者姓名',
        'consultation_minutes' => '咨询纪要',
        'description' => '描述',
        'live_consultation_details' => '现场咨询详情',
        'consultation_duration_minutes' => '咨询时间分钟',
        'client_video' => '客户视频',
        'host_video' => '主机视频',
        'enable' => '使能够',
        'disabled' => '禁用',
        'type' => '类型',
        'type_number' => '型号',
        'created_by' => '由...制作',
        'created_for' => '创造',
        'new_live_meeting' => '新的实时会议',
        'staff_list' => '员工名单',
        'edit_live_consultation' => '编辑实时咨询',
        'duration' => '持续时间（以分钟为单位）',
        'start_now' => '现在开始',
        'join_now' => '现在加入',
        'edit_live_meeting' => '编辑实时会议',
        'add_credential' => '添加凭据',
        'zoom_api_key' => '缩放 API 键',
        'zoom_api_secret' => '缩放 API 秘密',
        'awaited' => '等待中',
        'finished' => '完成的',
    ],
    'months' => [
        'jan' => '简',
        'feb' => '二月',
        'mar' => '三月',
        'apr' => '四月',
        'may' => '可能',
        'jun' => '君',
        'jul' => '八月',
        'aug' => '九月',
        'sep' => '十月',
        'oct' => '十一月',
        'nov' => '十二月',
        'dec' => '太阳',
    ],
    'weekdays' => [
        'sun' => '太阳',
        'mon' => '星期一',
        'tue' => '周二',
        'wed' => '星期三',
        'thu' => '周四',
        'fri' => '周五',
        'sat' => '星期六',
    ],
    'datepicker' => [
        'today' => '今天',
        'yesterday' => '昨天',
        'last_30_days' => '过去 30 天',
        'this_week' => '本星期',
        'last_week' => '上周',
        'this_month' => '这个月',
        'last_month' => '上个月',
    ],

    'filter' => [
        'all' => '全部',
        'paid' => '有薪酬的',
        'pending' => '待办的',
        'active' => '积极的',
        'deactive' => '停用',
        'awaited' => '等待',
        'finished' => '完成的',
        'booked' => '预订',
        'check in' => '报到',
        'check out' => '查看',
        'cancelled' => '取消',
        'read' => '读',
        'unread' => '未读',
    ],

    'flash' => [
        'patients_retrieve' => '患者检索成功。',
        'data_retrieve' => '数据检索成功。',
        'schedule_crete' => '计划创建成功。',
        'schedule_update' => '日程更新成功。',
        'schedule_delete' => '计划删除成功。',
        'schedule_not_found' => '未找到时间表。',
        'retrieve' => '检索成功。',
        'doctor_session_not_found' => '未找到医生会议。',
        'no_available_slots' => '在给定日期没有可用的插槽。',
        'google_calendar_connect' => '您的 Google 日历现已连接。',
        'something_went_wrong' => '出问题了',
        'calender_added' => '日历添加成功。',
        'google_calendar_disconnect' => 'Google 日历已成功断开连接。',
        'google_calendar_update' => '您的 Google 日历更新成功。',
        'states_retrieve' => '状态检索成功。',
        'cities_retrieve' => '城市检索成功',
        'session_retrieve' => '会话检索成功。',
        'review_add' => '审核添加成功。',
        'review_retrieved' => '评论检索成功。',
        'review_edit' => '评论编辑成功。',
        'live_consultation_save' => '实时咨询保存成功。',
        'live_consultation_retrieved' => '已成功检索实时咨询。',
        'live_consultation_update' => '实时咨询更新成功。',
        'live_consultation_delete' => '实时咨询删除成功。',
        'notification_read' => '通知读取成功。',
        'all_notification_read' => '所有通知读取成功。',
        'visit_prescription_update' => '访问处方更新成功。',
        'visit_prescription_added' => '访问处方添加成功。',
        'qualification_create' => '资格创建成功。',
        'prescription_retrieved' => '处方检索成功。',
        'prescription_delete' => '处方删除成功。',
        'problem_added' => '问题添加成功。',
        'problem_delete' => '问题删除成功。',
        'observation_added' => '观察添加成功。',
        'observation_delete' => '观察删除成功。',
        'note_added' => '笔记添加成功。',
        'note_delete' => '笔记删除成功。',
        'visit_create' => '访问创建成功。',
        'visit_update' => '访问更新成功。',
        'visit_delete' => '访问删除成功。',
        'doctor_create' => '医生创建成功。',
        'doctor_update' => '医生更新成功。',
        'doctor_delete' => '医生删除成功。',
        'doctor_use' => '医生使用成功。',
        'user_profile_update' => '用户资料更新成功。',
        'staff_create' => '员工创建成功。',
        'staff_update' => '员工更新成功。',
        'staff_delete' => '员工删除成功。',
        'staff_use' => '员工使用成功。',
        'specialization_create' => '专业化创建成功。',
        'specialization_update' => '专业更新成功。',
        'specialization_delete' => '专业化删除成功。',
        'specialization_use' => '专业化使用成功。',
        'service_cat_create' => '服务类别创建成功。',
        'service_cat_update' => '服务类别更新成功。',
        'service_cat_use' => '在其他地方使用的服务类别。',
        'service_cat_delete' => '服务类别删除成功。',
        'cat_retrieve' => '类别检索成功。',
        'service_create' => '服务创建成功。',
        'service_update' => '服务更新成功。',
        'service_delete' => '服务删除成功。',
        'service_use' => '在其他地方使用的服务。',
        'verified_email' => '电子邮件验证成功。',
        'email_notification' => '邮件通知更新成功。',
        'notification_send' => '邮件验证通知发送成功。',
        'theme_change' => '主题更改成功。',
        'reactive_account' => '通过邮件重新激活您的帐户。',
        'user_status' => '用户状态更新成功',
        'user_update' => '用户更新成功。',
        'user_profile' => '用户资料更新成功。',
        'user_already_verified' => '用户已经通过电子邮件验证。',
        'current_invalid' => '当前密码无效。',
        'password_update' => '密码更新成功。',
        'language_update' => '语言更新成功。',
        'language_change' => '语言更改成功',
        'order_create' => '订单创建成功。',
        'plan_update' => '计划更新成功。',
        'plan_status' => '计划状态更新成功',
        'plan_default' => '默认计划更改成功。',
        'patient_create' => '患者创建成功。',
        'patient_update' => '患者更新成功。',
        'patient_used' => '患者在其他地方使用过。',
        'patient_delete' => '患者删除成功。',
        'patient_not_found' => '未找到患者。',
        'country_create' => '国家创建成功。',
        'country_update' => '国家更新成功。',
        'country_used' => '国家在其他地方使用。',
        'country_delete' => '国家删除成功。',
        'currency_create' => '货币创建成功。',
        'currency_update' => '货币更新成功。',
        'currency_used' => '其他地方使用的货币。',
        'currency_delete' => '货币删除成功。',
        'state_create' => '状态创建成功。',
        'state_update' => '状态删除成功。',
        'state_delete' => '状态更新成功。',
        'state_use' => '国家在其他地方使用。',
        'city_create' => '城市创建成功。',
        'city_retrieved' => '城市检索成功。',
        'city_update' => '城市更新成功。',
        'city_used' => '在其他地方使用的城市。',
        'city_delete' => '城市删除成功。',
        'about_us_create' => '关于我们已成功保存。',
        'feature_update' => '功能更新成功。',
        'clinic_save' => '诊所时间表已成功保存。',
        'clinic_delete' => 'ClinicSchedule 删除成功。',
        'create_front_testimonial' => '证明创建成功。',
        'update_front_testimonial' => '证明更新成功。',
        'setting_update' => '设置更新成功。',
        'cms_update' => 'CMS 更新成功。',
        'enquire_sent' => '查询发送成功',
        'messages_sent' => '消息发送成功',
        'enquire_deleted' => '查询删除成功。',
        'create_blog' => 'VCard 博客创建成功。',
        'update_blog' => 'VCard 博客更新成功。',
        'role_create' => '角色创建成功。',
        'role_update' => '角色更新成功。',
        'doctor_appointment' => '医生预约日历数据检索成功。',
        'patient_appointment' => '患者预约日历数据检索成功。',
        'appointment_create' => '约会创建成功。',
        'appointment_not_found' => '未找到约会',
        'appointment_created_payment_complete' => '约会创建成功，付款完成。',
        'appointment_created_payment_not_complete' => '约会创建成功，付款未完成。',
        'appointment_delete' => '约会删除成功。',
        'appointment_retrieve' => '约会日历数据检索成功。',
        'appointment_cancel' => '预约取消。',
        'appointment_booked' => '预约成功',
        'status_update' => '状态更新成功。',
        'status_change' => '状态更改成功。',
        'payment_status_updated' => '付款状态更新成功。',
        'operation_performed_success' => '操作成功执行',
        'paystack_token_expired' => 'paystack 令牌已过期。请刷新页面并重试。',
        'default_role_not_delete' => '不删除默认角色。',
        'user_role_not_delete' => '无法删除此用户角色，因为它已分配给用户。',
        'role_delete' => '角色删除成功。',
        'faq_update' => '常见问题更新成功。',
        'faq_use' => '此常见问题解答在其他地方使用过。',
        'faq_delete' => 'FAQ 删除成功。',
        'slider_update' => '滑块更新成功',
        'subscriber_creat' => '订阅者创建成功。',
        'subscriber_delete' => '订阅者删除成功。',
        'testimonial_creat' => '前面的患者见证创建成功。',
        'testimonial_update' => '前面的患者见证更新成功。',
        'testimonial_use' => '前面的患者证明已成功使用。',
        'testimonial_delete' => '前面的病人见证删除成功。',
        'there_were' => '付款有问题。请稍后再试。',
        'your_reg_success' => '您的注册成功。请通过电子邮件验证您的帐户。',
        'some_doctors' => '有些医生把他们的日子安排在给定的未经检查的日子里，所以你确定要执行这个手术吗？',
        'email_send' => '邮件发送成功。',
        'faq_creat' => 'FAQ 创建成功。',
        'valid_twitter' => '请输入有效的 Twitter 网址',
        'valid_linkedin' => '请输入有效的领英网址',
        'valid_instagram' => '请输入有效的 Instagram 网址',
        'user_8_or' => '使用 6 个或更多字符，混合字母、数字和符号。',
        'degree_required' => '学位字段是必需的。',
        'university_required' => '大学是必需的。',
        'year_required' => '年份是必需的。',
        'select_payment' => '请选择任何一种付款方式',
        'maximum_char' => '最多允许 60 个字符。',
        'doctor_not_available' => '医生不可用', '医生不可用',
        'doctor_holiday' => '医生假期创建成功',
        'holiday_already_is_exist' => '该日期已存在假期',
        'profile_validation_message' => '配置文件必须是以下类型的文件：jpg、jpeg、png。',
        'logo_validation_message' => '应用程序徽标必须是以下类型的文件：jpg、jpeg、png。',
        'favicon_validation_message' => '图标必须是以下类型的文件：jpg、jpeg、png。',
        'icon_validation_message' => '图标必须是以下类型的文件：jpg、jpeg、png、svg。',
        'about_image_validation_message' => '关于图片必须是以下类型的文件：jpg、jpeg、png。',
        'user_zoom_credential_saved' => '用户 飞涨 凭证保存成功。',
        'select_calendar.' => 'Please select a calendar.'
    ],
    'holiday' => [
        'holiday' => '假期',
        'add_holiday' => '添加假期',
        'doctor_holiday' => '医生假期',
        'service_category' => '服务类别',
        'holiday_date' => '假期日期',
    ],

    'payment_method' => [
        'stripe' => '条纹',
        'paystack' => '支付宝',
        'paypal' => '贝宝',
        'razorpay' => '剃刀支付',
        'authorize' => '授权',
        'paytm' => '支付宝',
    ],

    'medicine' => [
        'medicine' => '药品',
        'medicine_category' => '药品类别',
        'medicine_category_details' => '药品类别详情',
        'medicines' => '药物',
        'medicine_details' => '药品详情',
        'new_medicine' => '新药',
        'new_medicine_category' => '新药类别',
        'edit_medicine_category' => '编辑药品类别',
        'edit_medicine' => '编辑医学',
        'name' => '姓名',
        'brand' => '品牌',
        'selling_price' => '售价',
        'buying_price' => '买价',
        'category' => '类别',
        'salt_composition' => '盐成分',
        'side_effects' => '副作用',
        'description' => '描述',
        'category_id' => '类别 ID',
        'brand_name' => '品牌',
        'medicine_brands' => '药品品牌',
        'medicine_brands_details' => '药品品牌详情',
        'new_brand' => '新品牌',
        'new_medicine_brand' => '新医药品牌',
        'edit_medicine_brand' => '编辑药品品牌',
        'medicine_name' => '药品名称',
        'dosage' => '剂量',
        'duration' => '期间',
        'saved_successfully' => '保存成功',
        'updated_successfully' => '更新成功',
        'deleted_successfully' => '删除成功',
        'cant_be_deleted' => '无法删除',
        'status_updated_successfully' => '状态更新成功。',
        'filter_options' => '过滤器选项',
        'available_quantity' => '可用数量',
        'brand' => '品牌',
        'category' => '类别',
        'quantity' => '数量',
        'medicine_retrieved_successfully' => '藥物成功取回',
        'no_use' => '未使用',
        'category_retrieved_successfully' => '藥品類別檢索成功。',
        'select_duration' => '選擇持續時間',
        'dose_interval' => '選擇劑量間隔',

    ],

    'purchase_medicine' => [
        'purchase_number' => '购买数量',
        'total' => '全部的',
        'discount' => '折扣',
        'tax_amount' => '税额',
        'net_amount' => '净额',
        'payment_mode' => '付款方式',
        'payment_note' => '付款单',
        'note' => '笔记',
        'purchase_medicine' => '购买药品',
        'purchase_medicines' => '购买药品',
        'purchase_medicine_details' => '购买药品详情',
        'purchase_medicine_overview' => '采购药品概览',
        'lot_no' => '批号',
        'tax' => '税',
        'quantity' => '数量',
        'amount' => '数量',
        'expiry_date' => '到期日',
        'other_details' => '其他详情',
        'dose_duration' => '剂量持续时间',
        'actions' => '行动',
        'export_to_excel' => '导出到 Excel',
        'purchased_medicine_success' => '药品购买成功',
    ],

    'used_medicine' => [
        'used_medicine' => '用过的药品',
        'used_medicines' => '用过的药品',
        'used_quantity' => '使用数量',
        'used_at' => '使用于',
    ],

    'medicine_bills' => [
        'medicine_bills' => '医药费',
        'medicine_bill' => '医药法案',
        'add_medicine_bill' => '添加药品账单',
        'edit_medicine_bill' => '编辑药品账单',
        'medicine_bill_details' => '药品账单详情',
        'dose_interval' => '剂量间隔',
        'available_quantity' => '可用数量',
        'is' => '是',
        'prescription_not_found' => '未找到处方',
        'medicine_not_selected' => '请至少选择一种药物。',
        'duplicate_medicine' => '不能重复添加药物。',
        'payment_status' => '支付状态',
        'sale_price' => '销售价格',
        'select_medicine' => '选择药物',
        'update_quantity' => '更新数量应小于之前的数量。',
        'net_amount_not_empty' => '净额不能为空。',
        'net_amount_not_zero' => '净额不能为零。',
        'medicine_required' => '需要医学领域。',
        'bill_number' => '帐单号码',
        'payment_type' => '付款方式',
        'bill_date' => '账单日期',
        'select_patient' => '选择患者',
        'new_medicine_bill' => '新医药法案',
        'print_bill' => '打印账单',
        'cell_no' => '小区编号',
        'item_name' => '项目名',
        'price' => '价格',
        'bill_id' => '帐单编号',
        'select_payment_type' => '选择付款方式',
        'quantity_should' => '数量应大于 0。',
        'net_amount_cant'=>'净额不能为空。',
        'net_amount_cant_zero'=>'净额不能为零。',
        'tax_amt'=>'税额不能为零或为空。',
        'enter_lot_number'=>'输入批号。',
        'enter_sale_price'=>'输入销售价格。',
        'enter_puchase_price'=>'输入购买价格',
        'tax_should_be' => '税收应低于 100%。',
        'tax_cannot_be_zero_empty'=> '税额不能为零或为空。',
        'the_discount_shoul'=> '折扣金额应小于总金额',
        'the_medicine_already_in_use'=> '该药已在医药账单中使用，您确定要删除吗？',
        'avl_qty' => '平均數量'


    ],

    'smart_patient_card' => [
        'smart_patient_cards' => '智能患者卡',
        'smart_patient_card_templates' => '智能患者卡模板',
        'templat_name' => '模板名称',
        'header_color' => '标题颜色',
        'email_show' => '显示电子邮件',
        'phone_show' => '显示电话',
        'dob_show' => '显示出生日期',
        'blood_group_show' => '显示血型',
        'address_show' => '显示地址',
        'unique_id_show' => '显示唯一标识',
        'add_smart_card_templates' => '添加智能卡模板',
        'add_smart_card' => '添加智能卡',
        'edit_patient_card' => '编辑智能卡',
        'template_created' => '成功创建模板。',
        'template_update' => '成功更新模板。',
        'template_deleted' => '成功删除模板。',

        'generate_patient_smart_cards' => '生成患者智能卡',
        'generate_patient_card' => '生成患者卡',
        'select_template' => '选择模板',
        'for_all_patient' => '所有患者',
        'only_one_patient' => '仅一个患者',
        'remaning_patients' => '剩余患者',
        'select_patient' => '选择患者',
        'patient_smart_card_created' => '成功创建患者智能卡。',
        'patient_smart_card_deleted' => '成功删除患者智能卡。',
        'enter_template_name' => '输入模板名称',
        'please_selest_patient' => '請選擇患者',
        'template' => '模板',
        'type' => '类型',
        'patient' => '患者',
    ],

];
