/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.auth":{"app":{"create":"\u0625\u0646\u0634\u0627\u0621","export":"\u062a\u0635\u062f\u064a\u0631","lock_account":"\u062a\u0623\u0645\u064a\u0646 \u0627\u0644\u062d\u0633\u0627\u0628","member_since":"\u0639\u0636\u0648 \u0645\u0646\u0630","messages":"\u0627\u0644\u0631\u0633\u0627\u0626\u0644","online":"\u0645\u062a\u0635\u0644","print":"\u0637\u0628\u0627\u0639\u0629","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","reload":"\u0625\u0639\u0627\u062f\u0629 \u062a\u062d\u0645\u064a\u0644","reset":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646","search":"\u0628\u062d\u062b","settings":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a"},"confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","emails":{"password":{"reset_link":"\u0627\u0646\u0642\u0631 \u0647\u0646\u0627 \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"}},"failed":"\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0647\u0630\u0647 \u0644\u0627 \u062a\u0637\u0627\u0628\u0642 \u0633\u062c\u0644\u0627\u062a\u0646\u0627.","forgot_password":{"send_pwd_reset":"\u0625\u0631\u0633\u0627\u0644 \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","title":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631"},"full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","login":{"forgot_password":"\u0644\u0642\u062f \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u064a","register_membership":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629","title":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0628\u062f\u0621 \u0627\u0644\u062c\u0644\u0633\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"},"password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","register":"\u062a\u0633\u062c\u064a\u0644","registration":{"have_membership":"\u0644\u062f\u064a \u0639\u0636\u0648\u064a\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","i_agree":"\u0623\u0648\u0627\u0641\u0642 \u0639\u0644\u0649","terms":"\u0627\u0644\u0634\u0631\u0648\u0637","title":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629"},"remember_me":"\u062a\u0630\u0643\u0631\u0646\u064a","reset_password":{"reset_pwd_btn":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","title":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"},"sign_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","sign_out":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062e\u0631\u0648\u062c","throttle":"\u0645\u062d\u0627\u0648\u0644\u0627\u062a \u062a\u0633\u062c\u064a\u0644 \u062f\u062e\u0648\u0644 \u0643\u062b\u064a\u0631\u0629 \u062c\u062f\u064b\u0627. \u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u062e\u0644\u0627\u0644: \u062b\u0648\u0627\u0646\u064a. "},"ar.livewire-tables::strings":{"All":"\u0627\u0644\u0643\u0644","Applied Filters":"\u0627\u0644\u062a\u0635\u0641\u064a\u0627\u062a \u0627\u0644\u0645\u0637\u0628\u0642\u0629","Applied Sorting":"\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0645\u0637\u0628\u0642","Bulk Actions":"\u0625\u062c\u0631\u0627\u0621\u0627\u062a","Clear":"\u0645\u0633\u062d","Filters":"\u0627\u0644\u062a\u0635\u0641\u064a\u0627\u062a","No items found. Try to broaden your search.":"Nessun risultato trovato. Prova ad ampliare la tua ricerca.","Remove filter option":"\u062d\u0630\u0641 \u062e\u064a\u0627\u0631 \u0627\u0644\u062a\u0635\u0641\u064a\u0629","Remove sort option":"\u062d\u0630\u0641 \u062e\u064a\u0627\u0631 \u0627\u0644\u062a\u0631\u062a\u064a\u0628","Search":"\u0628\u062d\u062b","Select All":"\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","Showing":"\u0627\u0633\u062a\u0639\u0631\u0627\u0636","Unselect All":"\u0625\u0644\u063a\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","You are currently selecting all":"\u0623\u0646\u062a \u0627\u0644\u0622\u0646 \u062a\u062e\u062a\u0627\u0631 \u0627\u0644\u0643\u0644","You are not connected to the internet.":"\u0623\u0646\u062a \u063a\u064a\u0631 \u0645\u062a\u0635\u0644 \u0628\u0627\u0644\u0625\u0646\u062a\u0631\u0646\u062a.","You have selected":"\u0644\u0642\u062f \u0642\u0645\u062a \u0628\u0627\u062e\u062a\u064a\u0627\u0631","of":"\u0645\u0646","results":"\u0627\u0644\u0646\u062a\u0627\u0626\u062c","rows":"\u0635\u0641\u0648\u0641","rows, do you want to select all":"\u0627\u0644\u0635\u0641\u0648\u0641 \u060c \u0647\u0644 \u062a\u0631\u064a\u062f \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0643\u0644","to":"\u0625\u0644\u0649"},"ar.messages":{"admin_dashboard":{"dashboard":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0642\u064a\u0627\u062f\u0629","day":"\u064a\u0648\u0645","earnings_from_appointments":"\u0627\u0644\u0623\u0631\u0628\u0627\u062d \u0645\u0646 \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","filter_options":"\u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u062a\u0635\u0641\u064a\u0629","month":"\u0634\u0647\u0631","name":"\u0627\u0644\u0627\u0633\u0645","patient_id":"\u0627\u0644\u0645\u0639\u0631\u0641 \u0627\u0644\u0641\u0631\u064a\u062f \u0644\u0644\u0645\u0631\u064a\u0636","recent_patients_registration":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0631\u0636\u0649 \u0627\u0644\u062c\u062f\u062f","registered":"\u0645\u0633\u062c\u0644","today_appointments":"\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u064a\u0648\u0645","today_registered_patients":"\u0627\u0644\u0645\u0631\u0636\u0649 \u0627\u0644\u0645\u0633\u062c\u0644\u064a\u0646 \u0627\u0644\u064a\u0648\u0645","total_doctor":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0623\u0637\u0628\u0627\u0621","total_patients":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0631\u0636\u0649","week":"\u0623\u0633\u0628\u0648\u0639"},"appointment":{"Select_payment_method":"\u0627\u062e\u062a\u0627\u0631 \u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","add_new_appointment":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0648\u0639\u062f","appointment_at":"\u0645\u0648\u0639\u062f \u0639\u0646\u062f","appointment_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u0648\u0639\u062f","appointment_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0648\u0639\u062f","appointment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u062a\u0639\u064a\u064a\u0646","appointment_unique_id":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0645\u0648\u0639\u062f","appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","appointments_schedule":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","authorize_session_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u062c\u0644\u0633\u0629 \u0627\u0644\u062a\u0641\u0648\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","available":"\u0645\u062a\u0627\u062d","available_slot":"\u0627\u0644\u0641\u062a\u062d\u0627\u062a \u0627\u0644\u0645\u062a\u0627\u062d\u0629","booked":"\u0645\u062d\u062c\u0648\u0632\u0629","calendar":"\u0627\u0644\u062a\u0642\u0648\u064a\u0645","cancel_appointment":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u062a\u0639\u064a\u064a\u0646","cancelled":"\u0645\u0644\u063a\u0627\u0629","charge":"\u0627\u0644\u0645\u0633\u0624\u0648\u0644","check_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0648\u0635\u0648\u0644","check_out":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062e\u0631\u0648\u062c","date":"\u0627\u0644\u062a\u0627\u0631\u064a\u062e","description":"\u0627\u0644\u0648\u0635\u0641","edit_appointment":"\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0648\u0639\u062f","ends":"\u064a\u0646\u062a\u0647\u064a","extra_fees":"\u0631\u0633\u0648\u0645 \u0625\u0636\u0627\u0641\u064a\u0629","no_slot_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0641\u062a\u0631\u0627\u062a \u0632\u0645\u0646\u064a\u0629.","patient":"\u0627\u0644\u0645\u0631\u064a\u0636","patient_id":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0645\u0631\u064a\u0636","patient_name_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0633\u0645 \u0627\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d","payable_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642 \u0627\u0644\u062f\u0641\u0639","payment":"\u0642\u0633\u0637","payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0627\u0648 \u0627\u0644\u0633\u062f\u0627\u062f","payment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0633\u062f\u0627\u062f","service":"\u0627\u0644\u062e\u062f\u0645\u0629","service_charge":"\u0631\u0633\u0648\u0645 \u0627\u0644\u062e\u062f\u0645\u0629","session_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062c\u0644\u0633\u0629 \u0628\u0646\u062c\u0627\u062d","session_id_required":"\u0645\u0639\u0631\u0641 \u0627\u0644\u062c\u0644\u0633\u0629 \u0645\u0637\u0644\u0648\u0628","starts":"\u064a\u0628\u062f\u0623","status":"\u0627\u0644\u062d\u0627\u0644\u0629","switch_to_calendar":"\u0627\u0644\u062a\u0628\u062f\u064a\u0644 \u0625\u0644\u0649 \u0627\u0644\u062a\u0642\u0648\u064a\u0645","time":"\u0627\u0644\u0648\u0642\u062a","total_payable_amount":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642 \u0627\u0644\u062f\u0641\u0639","upcoming_meetings":"\u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u0627\u062a \u0627\u0644\u0642\u0627\u062f\u0645\u0629"},"appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","apps":"\u062a\u0637\u0628\u064a\u0642\u0627\u062a","card_number_invalid..":"\u0631\u0642\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","card_type":"\u0646\u0648\u0639 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0627\u0626\u062a\u0645\u0627\u0646","cities":"\u0627\u0644\u0645\u062f\u0646","city":{"add_city":"\u0625\u0636\u0627\u0641\u0629 \u0645\u062f\u064a\u0646\u0629","city":"\u0645\u062f\u064a\u0646\u0629","edit_city":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u062f\u064a\u0646\u0629","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629"},"clinic_schedules":"\u062c\u062f\u0627\u0648\u0644 \u0627\u0644\u0639\u064a\u0627\u062f\u0629","cms":{"Terms_Conditions_required":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629","about_image":"\u062d\u0648\u0644 \u0627\u0644\u0635\u0648\u0631\u0629","cms":"CMS","description_no_white_space":"\u062d\u0648\u0644 \u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0645\u062e\u062a\u0635\u0631 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","experience_required":"\u062d\u0648\u0644 \u062d\u0642\u0644 \u0627\u0644\u062e\u0628\u0631\u0629 \u0645\u0637\u0644\u0648\u0628.","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","privacy_policy_required.":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","terms_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","title_no_white_space":"\u062d\u0648\u0644 \u062d\u0642\u0644 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637"},"common":{"Attempt_read_property_access_token_null":"\u0645\u062d\u0627\u0648\u0644\u0629 \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u062e\u0627\u0635\u064a\u0629 \\\"access_token\\\" \u0641\u0627\u0631\u063a\u0629","Forgot_password_lable":"\u062c\u062f\u064a\u062f\u0629. \u0633\u064a\u0633\u0645\u062d \u0644\u0643 \u0628\u0627\u062e\u062a\u064a\u0627\u0631 \u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u0630\u064a\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0648\u0633\u0646\u0631\u0633\u0644 \u0625\u0644\u064a\u0643 \u0639\u0628\u0631 \u0641\u0642\u0637 \u0623\u062e\u0628\u0631\u0646\u0627 \u0628\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643 \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631\u061f \u0644\u0627 \u0645\u0634\u0643\u0644\u0629.","action":"\u0627\u0644\u0625\u062c\u0631\u0627\u0621","active":"\u0646\u0634\u0637","add":"\u0625\u0636\u0627\u0641\u0629","add_credential":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u0636\u0627\u0641\u0629 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0639\u062a\u0645\u0627\u062f \u0627\u0644\u062a\u0643\u0628\u064a\u0631","age":"\u0639\u0645\u0631","any_one_permission":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0623\u064a \u0625\u0630\u0646 \u0648\u0627\u062d\u062f.","apply":"\u062a\u0637\u0628\u064a\u0642","appointment_date_required":"\u062d\u0642\u0644 \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u0648\u0639\u062f \u0645\u0637\u0644\u0648\u0628.","are_you_sure":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_cancel":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0644\u063a\u0627\u0621 \u0647\u0630\u0627","back":"\u0631\u062c\u0648\u0639","booked":"\u062d\u062c\u0632","brand_required":"\u062d\u0642\u0644 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629 \u0645\u0637\u0644\u0648\u0628.","cancel":"\u0625\u0644\u063a\u0627\u0621","cancelled":"\u0623\u0644\u063a\u064a\u062a","cancelled_appointment":"\u0627\u0644\u0645\u0648\u0639\u062f \u0627\u0644\u0645\u0644\u063a\u064a!","category_required":"\u062d\u0642\u0644 \u0627\u0644\u0641\u0626\u0629 \u0645\u0637\u0644\u0648\u0628.","change_image":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629","check in":"\u062a\u062d\u0642\u0642 \u0641\u064a","check out":"\u0627\u0644\u062f\u0641\u0639","city":"\u0645\u062f\u064a\u0646\u0629","confirm":"\u064a\u062a\u0623\u0643\u062f","connected_zoom":"\u062a\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u0627\u0644\u062a\u0643\u0628\u064a\u0631 \u0628\u0646\u062c\u0627\u062d.","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0647\u0648","country":"\u0627\u0644\u062f\u0648\u0644\u0629","custom":"\u0627\u0644\u0639\u0627\u062f\u0629","de_active":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u062a\u0646\u0634\u064a\u0637","default_language":"\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","details":"\u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644","discard":"\u062a\u062c\u0627\u0647\u0644","doctor_required":"\u0645\u0637\u0644\u0648\u0628 \u0645\u062c\u0627\u0644 \u0627\u0644\u0637\u0628\u064a\u0628.","download":"\u062a\u062d\u0645\u064a\u0644","edit":"\u062a\u062d\u0631\u064a\u0631","email_already_exist":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0642\u062f \u0627\u0634\u062a\u0631\u0643 \u0628\u0627\u0644\u0641\u0639\u0644.","email_max":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u062d\u062c\u0645 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0647\u0648 255.","email_not_register":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u063a\u064a\u0631 \u0645\u0633\u062c\u0644.","email_regex":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u062a\u0646\u0633\u064a\u0642 \u0635\u0627\u0644\u062d.","email_required":"\u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628.","email_verified":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","error":"\u062e\u0637\u0623","filter":"\u062a\u0635\u0641\u064a\u0629","filter_option":"\u062e\u064a\u0627\u0631 \u0627\u0644\u062a\u0635\u0641\u064a\u0629","first_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628. ","forgot_your_password":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","from":"\u0645\u0646","google_captcha_required":"\u062d\u0642\u0644 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 Google \u0645\u0637\u0644\u0648\u0628.","has_been":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","has_cancel":" \u062a\u0645 \u0625\u0644\u063a\u0627\u0621.","hour":"\u0633\u0627\u0639\u0629","impersonate":"\u0627\u0646\u062a\u062d\u0627\u0644 \u0634\u062e\u0635\u064a\u062a\u064a","instagram_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0644\u0640 Instagram","last_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631 \u0645\u0637\u0644\u0648\u0628.","linkedin_url":"\u0631\u0627\u0628\u0637 \u0644\u064a\u0646\u0643\u062f \u0625\u0646","logout":"\u062a\u0633\u062c\u064a\u0644 \u062e\u0631\u0648\u062c","maximum_55":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0647\u0648 55 \u062d\u0631\u0641\u064b\u0627.","message_required":"\u062d\u0642\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0645\u0637\u0644\u0648\u0628.","minutes":"\u0627\u0644\u062f\u0642\u0627\u0626\u0642","n\/a":"\u0644\u0627 \u064a\u0646\u0637\u0628\u0642","name":"\u0627\u0644\u0627\u0633\u0645","name_already_taken":"\u0644\u0642\u062f \u062a\u0645 \u0623\u062e\u0630 \u0627\u0644\u0627\u0633\u0645 \u0628\u0627\u0644\u0641\u0639\u0644.","name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0645\u0637\u0644\u0648\u0628","no":"\u0644\u0627 \u060c \u0625\u0644\u063a\u0627\u0621","no_data_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u0645\u062a\u0627\u062d\u0629","no_data_available_in_table":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u0645\u062a\u0648\u0641\u0631\u0629 \u0641\u064a \u0627\u0644\u062c\u062f\u0648\u0644","no_records_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a.","not_allow__assess_record":"\u064a\u0628\u062f\u0648 \u0623\u0646\u0647 \u063a\u064a\u0631 \u0645\u0633\u0645\u0648\u062d \u0644\u0643 \u0628\u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u0633\u062c\u0644.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"\u0645\u0644\u0627\u062d\u0638\u0629: \u0646\u062d\u0646 \u0646\u0623\u062e\u0630 \u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u0644\u0623\u0637\u0628\u0627\u0626\u0643 \u0623\u062b\u0646\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0645\u0648\u0639\u062f \u0641\u064a \u0627\u0644\u062a\u0642\u0648\u064a\u0645. \u0625\u0630\u0627 \u0644\u0645 \u064a\u0642\u0645 \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u062a\u0639\u064a\u064a\u0646 \u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u060c \u0641\u0633\u064a\u0633\u062a\u063a\u0631\u0642 \u0627\u0644\u0623\u0645\u0631 \u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0628\u0627\u0644\u062a\u0648\u0642\u064a\u062a \u0627\u0644\u0639\u0627\u0644\u0645\u064a \u0627\u0644\u0645\u0646\u0633\u0642 (UTC).","note_white_space":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","observation_white_space":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0645\u0631\u0627\u0642\u0628\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","of":"\u0644","overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629","payment_type_required":"\u062d\u0642\u0644 \u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0645\u0637\u0644\u0648\u0628.","please_wait":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631 ...","prescription_report":"\u062a\u0642\u0631\u064a\u0631 \u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629","problem_white_space":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","processing":"\u064a\u0639\u0627\u0644\u062c..","purchase_price":"\u0633\u0639\u0631 \u0627\u0644\u0634\u0631\u0627\u0621","read":"\u0627\u0642\u0631\u0623","remember_me":"\u062a\u0630\u0643\u0631\u0646\u0649","resend_verification_email":"\u0625\u0639\u0627\u062f\u0629 \u0627\u0631\u0633\u0627\u0644 \u0628\u0631\u064a\u062f \u0627\u0644\u062a\u062d\u0642\u0642","reset":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646","reset_password":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","results":"\u0646\u062a\u0627\u0626\u062c","save":"\u062d\u0641\u0638","search":"\u064a\u0628\u062d\u062b","select_brand":"\u062d\u062f\u062f \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_city":"\u0627\u062e\u062a\u0631 \u0645\u062f\u064a\u0646\u0629","select_country":"\u062d\u062f\u062f \u0627\u0644\u062f\u0648\u0644\u0629","select_doctor":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","select_service":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629","select_state":"\u0627\u062e\u062a\u0631 \u0648\u0644\u0627\u064a\u0647","service":"\u0627\u0644\u062e\u062f\u0645\u0629","service_required":"\u062d\u0642\u0644 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0645\u0637\u0644\u0648\u0628.","show":"\u064a\u0639\u0631\u0636","showing":"\u0639\u0631\u0636","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629","subject_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0645\u0637\u0644\u0648\u0628.","submit":"\u0625\u0631\u0633\u0627\u0644","this_weeks":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","to":"\u0644","twitter_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0639\u0644\u0649 Twitter","unread":"\u063a\u064a\u0631 \u0645\u0642\u0631\u0648\u0621","verify_lable1":"\u0634\u0643\u0631\u0627 \u0644\u062a\u0633\u062c\u064a\u0644\u0643! \u0642\u0628\u0644 \u0627\u0644\u0628\u062f\u0621\u060c \u0647\u0644\u064a\u0645\u0643\u0646\u0643 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646\u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0639\u0646 \u0637\u0631\u064a\u0642\u0627\u0644\u0646\u0642\u0631 \u0639\u0644\u0649 \u0627\u0644\u0631\u0627\u0628\u0637 \u0627\u0644\u0630\u064a \u0623\u0631\u0633\u0644\u0646\u0627\u0647\u0625\u0644\u064a\u0643 \u0644\u0644\u062a\u0648 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f\u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u061f \u0625\u0630\u0627 \u0644\u0645 \u062a\u062a\u0644\u0642 \u0631\u0633\u0627\u0644\u0629\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u060c \u0641\u0633\u0646\u0631\u0633\u0644 \u0644\u0643\u0628\u0643\u0644 \u0633\u0631\u0648\u0631 \u0631\u0633\u0627\u0644\u0629 \u0623\u062e\u0631\u0649.","verify_lable2":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0631\u0627\u0628\u0637 \u062a\u062d\u0642\u0642 \u062c\u062f\u064a\u062f \u0625\u0644\u0649\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0627\u0644\u0630\u064a \u0642\u062f\u0645\u062a\u0647 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u062a\u0633\u062c\u064a\u0644.","view":"\u0631\u0623\u064a","years":"\u0633\u0646\u064a\u0646","yes":"\u0646\u0639\u0645 \u060c \u0627\u062d\u0630\u0641!","yes_update":"\u0646\u0639\u0645 \u060c \u062a\u062d\u062f\u064a\u062b!","zoom_credentials":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u0636\u0627\u0641\u0629 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0639\u062a\u0645\u0627\u062f \u0627\u0644\u062a\u0643\u0628\u064a\u0631."},"countries":"\u0627\u0644\u0628\u0644\u062f\u0627\u0646","country":{"add_country":"\u0625\u0636\u0627\u0641\u0629 \u0628\u0644\u062f","country":"\u0627\u0644\u062f\u0648\u0644\u0629","short_code":"\u0631\u0645\u0632 \u0642\u0635\u064a\u0631"},"currencies":"\u0627\u0644\u0639\u0645\u0644\u0627\u062a","currency":{"add_currency":"\u0625\u0636\u0627\u0641\u0629 \u0639\u0645\u0644\u0629","add_currency_code_as_per_three_letter_iso_code":"\u0623\u0636\u0641 \u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629 \u0648\u0641\u0642\u064b\u0627 \u0644\u0631\u0645\u0632 ISO \u0627\u0644\u0645\u0643\u0648\u0646 \u0645\u0646 \u062b\u0644\u0627\u062b\u0629 \u0623\u062d\u0631\u0641","currency_code":"\u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629","currency_icon":"\u0631\u0645\u0632 \u0627\u0644\u0639\u0645\u0644\u0629","currency_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0645\u0644\u0629","edit_currency":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","name":"\u0627\u0644\u0627\u0633\u0645","you_can_find_out_here":"\u064a\u0645\u0643\u0646\u0643 \u0627\u0646 \u062a\u062c\u062f \u0647\u0646\u0627"},"cvv_invalid.":"CVV \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","cvv_number_required.":"\u062d\u0642\u0648\u0644 \u0631\u0642\u0645 CVV \u0645\u0637\u0644\u0648\u0628\u0629.","dashboard":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0642\u064a\u0627\u062f\u0629","datepicker":{"last_30_days":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","today":"\u0627\u0644\u064a\u0648\u0645","yesterday":"\u0641\u064a \u0627\u0644\u0627\u0645\u0633"},"doctor":{"add":"\u0625\u0636\u0627\u0641\u0629 \u0637\u0628\u064a\u0628","add_qualification":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0624\u0647\u0644","address1":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 1","address2":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 2","address_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0639\u0646\u0648\u0627\u0646","allowed_img":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","city":"\u0645\u062f\u064a\u0646\u0629","collage_university":"\u0643\u0644\u064a\u0629 \/ \u062c\u0627\u0645\u0639\u0629","country":"\u0627\u0644\u062f\u0648\u0644\u0629","created_at":"\u062a\u0645 \u0627\u0644\u0625\u0646\u0634\u0627\u0621 \u0641\u064a","degree":"\u062f\u0631\u062c\u0629","dob":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u064a\u0644\u0627\u062f","doctor":"\u062f\u0643\u062a\u0648\u0631","doctor_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0637\u0628\u064a\u0628","edit":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","experience":"\u0627\u0644\u062e\u0628\u0631\u0629 \u0641\u064a \u0627\u0644\u0639\u0627\u0645","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","instagram":"\u0625\u0646\u0633\u062a\u063a\u0631\u0627\u0645","last_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631","linkedin":"\u0644\u064a\u0646\u0643\u062f \u0625\u0646","male":"\u0630\u0643\u0631","passout_year":"\u0633\u0646\u0629 \u0627\u0644\u0646\u062c\u0627\u062d","postal_code":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","qualification":"\u0645\u0624\u0647\u0644","qualification_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u062a\u0623\u0647\u064a\u0644","select_blood_group":"\u062d\u062f\u062f \u0641\u0635\u064a\u0644\u0629 \u0627\u0644\u062f\u0645","select_date":"\u062d\u062f\u062f \u062a\u0627\u0631\u064a\u062e","select_doctors":"\u062d\u062f\u062f \u0627\u0644\u0623\u0637\u0628\u0627\u0621","select_gender":"\u062d\u062f\u062f \u0627\u0644\u062c\u0646\u0633","select_year":"\u062d\u062f\u062f \u0627\u0644\u0633\u0646\u0629","specialization":"\u0627\u0644\u062a\u062e\u0635\u0635","sr_no":"\u0644\u0627 \u0631\u064a\u0627\u0644 \u0633\u0639\u0648\u062f\u064a","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629","status":"\u0627\u0644\u062d\u0627\u0644\u0629","twitter":"\u062a\u0648\u064a\u062a\u0631","university":"\u062c\u0627\u0645\u0639\u0629","updated_at":"\u0645\u064f\u062d\u062f\u064e\u0651\u062b \u0641\u064a","year":"\u0627\u0644\u0633\u0646\u0629"},"doctor_appointment":{"amount":"\u0627\u0644\u0645\u0628\u0644\u063a","from_time":"\u0645\u0646 \u0648\u0642\u062a","patient":"\u0627\u0644\u0645\u0631\u064a\u0636","service":"\u0627\u0644\u062e\u062f\u0645\u0629","to_time":"\u0625\u0644\u0649 \u0627\u0644\u0648\u0642\u062a"},"doctor_appointments":"\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u0637\u0628\u064a\u0628","doctor_dashboard":{"recent_appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u0623\u062e\u064a\u0631\u0629","total_appointments":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f"},"doctor_session":{"add":"\u0625\u0636\u0627\u0641\u0629 \u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628","all":"\u0627\u0644\u0643\u0644","copy":"\u064a\u0646\u0633\u062e","doctor":"\u062f\u0643\u062a\u0648\u0631","doctor_session":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628","doctor_session_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628","edit":"\u062a\u062d\u0631\u064a\u0631 \u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628","evening_session":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0645\u0633\u0627\u0621","friday":"\u062c\u0645\u0639\u0629","gap_between_appointment":"\u0627\u0644\u0641\u062c\u0648\u0629 \u0628\u064a\u0646 \u0627\u0644\u062a\u0639\u064a\u064a\u0646","monday":"\u0627\u0644\u0627\u062b\u0646\u064a\u0646","morning_session":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0635\u0628\u0627\u062d","my_schedule":"\u0627\u0644\u062c\u062f\u0648\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0627\u0644\u062e\u0627\u0635 \u0628\u064a","saturday":"\u0627\u0644\u0633\u0628\u062a","select_meeting_time":"\u062d\u062f\u062f \u0648\u0642\u062a \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639","select_session_gap":"\u062d\u062f\u062f \u0641\u062c\u0648\u0629 \u0627\u0644\u062c\u062f\u0648\u0644 \u0627\u0644\u0632\u0645\u0646\u064a","session":"\u0627\u0644\u062c\u0644\u0633\u0629","session_gap":"\u0641\u062c\u0648\u0629 \u0627\u0644\u062c\u062f\u0648\u0644","session_meeting_time":"\u062c\u062f\u0648\u0644\u0629 \u0645\u0648\u0639\u062f \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639","session_time_in_minutes":"\u062c\u062f\u0648\u0644\u0629 \u0645\u0648\u0639\u062f \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639","sunday":"\u0627\u0644\u0623\u062d\u062f","thursday":"\u064a\u0648\u0645 \u0627\u0644\u062e\u0645\u064a\u0633","tuesday":"\u064a\u0648\u0645 \u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","unavailable":"\u063a\u064a\u0631 \u0645\u062a\u0648\u0641\u0631\u0647","wednesday":"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621","week_days":"\u0623\u064a\u0627\u0645 \u0627\u0644\u0623\u0633\u0628\u0648\u0639"},"doctor_sessions":"\u062c\u0644\u0633\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0628","doctors":"\u0623\u0637\u0628\u0627\u0621","doctors_scheduled_time_ended_for_today__":"\u0627\u0646\u062a\u0647\u0649 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u0642\u0631\u0631 \u0644\u0644\u0637\u0628\u064a\u0628 \u0644\u0647\u0630\u0627 \u0627\u0644\u064a\u0648\u0645 \u060c \u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u0637\u0628\u064a\u0628 \u0623\u0648 \u062a\u0627\u0631\u064a\u062e \u0645\u062e\u062a\u0644\u0641","email_password_reset_link":"\u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0644\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enquiries":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631\u0627\u062a","expiration_month_required":"\u062d\u0642\u0648\u0644 \u0634\u0647\u0631 \u0627\u0646\u062a\u0647\u0627\u0621 \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","expiration_year_required":"\u062d\u0642\u0648\u0644 \u0633\u0646\u0629 \u0627\u0646\u062a\u0647\u0627\u0621 \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","faq":{"add_faq":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u0627\u062a","answer":"\u0625\u062c\u0627\u0628\u0629","edit_faq":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062a\u0639\u0644\u064a\u0645\u0627\u062a","question":"\u0633\u0624\u0627\u0644"},"faqs":"\u0623\u0633\u0626\u0644\u0629 \u0648\u0623\u062c\u0648\u0628\u0629","filter":{"active":"\u0646\u0634\u064a\u0637","all":"\u0627\u0644\u062c\u0645\u064a\u0639","awaited":"\u0645\u0646\u062a\u0638\u0631","booked":"\u062d\u062c\u0632","cancelled":"\u0623\u0644\u063a\u064a\u062a","check in":"\u062a\u062d\u0642\u0642 \u0641\u064a","check out":"\u0627\u0644\u062f\u0641\u0639","deactive":"\u062a\u0639\u0637\u064a\u0644","finished":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0645\u0646","paid":"\u0645\u062f\u0641\u0648\u0639","pending":"\u0642\u064a\u062f \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631","read":"\u0627\u0642\u0631\u0623","unread":"\u063a\u064a\u0631 \u0645\u0642\u0631\u0648\u0621"},"filter_success":"\u0646\u062c\u0627\u062d \u0627\u0644\u062a\u0635\u0641\u064a\u0629","flash":{"about_image_validation_message":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u062d\u0648\u0644 \u0645\u0644\u0641 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg \u060c jpeg \u060c png.","all_notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u0625\u0634\u0639\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","appointment_booked":"\u062a\u0645 \u062d\u062c\u0632 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d","appointment_cancel":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f.","appointment_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d.","appointment_created_payment_complete":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d \u0648\u0627\u0643\u062a\u0645\u0644 \u0627\u0644\u062f\u0641\u0639.","appointment_created_payment_not_complete":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d \u0648\u0644\u0645 \u064a\u0643\u062a\u0645\u0644 \u0627\u0644\u062f\u0641\u0639.","appointment_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d.","appointment_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0648\u0639\u062f","appointment_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0628\u0646\u062c\u0627\u062d.","calender_added":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0628\u0646\u062c\u0627\u062d.","cat_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d.","cities_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u062f\u0646 \u0628\u0646\u062c\u0627\u062d","city_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","city_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","city_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","city_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0628\u0646\u062c\u0627\u062d.","city_used":"\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u062f\u064a\u0646\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","clinic_delete":"\u062a\u0645 \u062d\u0630\u0641 ClinicSchedule \u0628\u0646\u062c\u0627\u062d.","clinic_save":"\u062a\u0645 \u062d\u0641\u0638 \u062c\u062f\u0648\u0644 \u0627\u0644\u0639\u064a\u0627\u062f\u0629 \u0628\u0646\u062c\u0627\u062d.","cms_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b CMS \u0628\u0646\u062c\u0627\u062d.","country_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0628\u0644\u062f \u0628\u0646\u062c\u0627\u062d.","country_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0628\u0644\u062f \u0628\u0646\u062c\u0627\u062d.","country_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0628\u0644\u062f \u0628\u0646\u062c\u0627\u062d.","country_used":"\u0628\u0644\u062f \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","create_blog":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0645\u062f\u0648\u0646\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","create_front_testimonial":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0634\u0647\u0627\u062f\u0629 \u0628\u0646\u062c\u0627\u062d.","currency_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","currency_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","currency_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0639\u0645\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","currency_used":"\u0627\u0644\u0639\u0645\u0644\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","current_invalid":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","data_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","default_role_not_delete":"\u0644\u0627 \u064a\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062f\u0648\u0631 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a.","degree_required":"\u062d\u0642\u0644 \u0627\u0644\u0634\u0647\u0627\u062f\u0629 \u0645\u0637\u0644\u0648\u0628.","doctor_appointment":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u062a\u0642\u0648\u064a\u0645 \u0645\u0648\u0639\u062f \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u0646\u062c\u0627\u062d.","doctor_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u0646\u062c\u0627\u062d.","doctor_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u0646\u062c\u0627\u062d.","doctor_holiday":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 Doctor Holiday \u0628\u0646\u062c\u0627\u062d","doctor_not_available":"\u0637\u0628\u064a\u0628 \u063a\u064a\u0631 \u0645\u062a\u0648\u0641\u0631","doctor_session_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u062c\u0644\u0633\u0629 \u0627\u0644\u0637\u0628\u064a\u0628.","doctor_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u0646\u062c\u0627\u062d.","doctor_use":"\u0627\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0637\u0628\u064a\u0628 \u0628\u0646\u062c\u0627\u062d.","email_notification":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0625\u0634\u0639\u0627\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","email_send":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","enquire_deleted":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631 \u0628\u0646\u062c\u0627\u062d.","enquire_sent":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631 \u0628\u0646\u062c\u0627\u062d","faq_creat":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","faq_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","faq_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","faq_use":"\u0647\u0630\u0647 \u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","favicon_validation_message":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0645\u0641\u0636\u0644 \u0645\u0646 \u0646\u0648\u0639 \u0627\u0644\u0645\u0644\u0641: jpg \u060c jpeg \u060c png.","feature_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u064a\u0632\u0629 \u0628\u0646\u062c\u0627\u062d.","google_calendar_connect":"\u062a\u0642\u0648\u064a\u0645 Google \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0645\u062a\u0635\u0644 \u0627\u0644\u0622\u0646.","google_calendar_disconnect":"\u062a\u0645 \u0642\u0637\u0639 \u0627\u062a\u0635\u0627\u0644 \u062a\u0642\u0648\u064a\u0645 Google \u0628\u0646\u062c\u0627\u062d.","google_calendar_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062a\u0642\u0648\u064a\u0645 Google \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0628\u0646\u062c\u0627\u062d.","holiday_already_is_exist":"\u0627\u0644\u0639\u0637\u0644\u0629 \u0645\u0648\u062c\u0648\u062f\u0629 \u0628\u0627\u0644\u0641\u0639\u0644 \u0644\u0647\u0630\u0627 \u0627\u0644\u062a\u0627\u0631\u064a\u062e","icon_validation_message":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0631\u0645\u0632 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg \u060c jpeg \u060c png \u060c svg.","language_change":"\u062a\u063a\u064a\u0631\u062a \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d.","live_consultation_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","live_consultation_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","live_consultation_save":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","live_consultation_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","logo_validation_message":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg \u060c jpeg \u060c png.","maximum_char":"60 \u062d\u0631\u0641\u064b\u0627 \u0643\u062d\u062f \u0623\u0642\u0635\u0649 \u0645\u0633\u0645\u0648\u062d \u0628\u0647.","messages_sent":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d","no_available_slots":"\u0644\u0627 \u062a\u0648\u062c\u062f \u062e\u0627\u0646\u0627\u062a \u0632\u0645\u0646\u064a\u0629 \u0645\u062a\u0627\u062d\u0629 \u0641\u064a \u062a\u0627\u0631\u064a\u062e \u0645\u0639\u064a\u0646.","note_added":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0628\u0646\u062c\u0627\u062d.","note_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0628\u0646\u062c\u0627\u062d.","notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631 \u0628\u0646\u062c\u0627\u062d.","notification_send":"\u0625\u0631\u0633\u0627\u0644 \u0625\u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","observation_added":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0628\u0646\u062c\u0627\u062d.","observation_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0628\u0646\u062c\u0627\u062d.","operation_performed_success":"\u062a\u0645\u062a \u0627\u0644\u0639\u0645\u0644\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","order_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0637\u0644\u0628 \u0628\u0646\u062c\u0627\u062d.","password_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631 \u0628\u0646\u062c\u0627\u062d.","patient_appointment":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u062a\u0642\u0648\u064a\u0645 \u0645\u0648\u0639\u062f \u0627\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","patient_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","patient_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","patient_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0631\u064a\u0636.","patient_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","patient_used":"\u0627\u0644\u0645\u0631\u064a\u0636 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","patients_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u0631\u0636\u0649 \u0628\u0646\u062c\u0627\u062d.","payment_status_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639 \u0628\u0646\u062c\u0627\u062d.","paystack_token_expired":"\u0627\u0646\u062a\u0647\u062a \u0635\u0644\u0627\u062d\u064a\u0629 \u0631\u0645\u0632 \u062d\u0632\u0645\u0629 \u0627\u0644\u0631\u0627\u062a\u0628. \u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0635\u0641\u062d\u0629 \u0648\u062d\u0627\u0648\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.","plan_default":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","plan_status":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d","plan_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d.","prescription_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0648\u0635\u0641\u0629 \u0628\u0646\u062c\u0627\u062d.","prescription_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0648\u0635\u0641\u0629 \u0628\u0646\u062c\u0627\u062d.","problem_added":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","problem_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","profile_validation_message":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641 \u0627\u0644\u062a\u0639\u0631\u064a\u0641 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg \u060c jpeg \u060c png.","qualification_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062a\u0623\u0647\u064a\u0644 \u0628\u0646\u062c\u0627\u062d.","reactive_account":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0646\u0634\u064a\u0637 \u062d\u0633\u0627\u0628\u0643 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f.","retrieve":"\u062a\u0645 \u0627\u0644\u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u0646\u062c\u0627\u062d.","review_add":"\u0645\u0631\u0627\u062c\u0639\u0629 \u0627\u0644\u0625\u0636\u0627\u0641\u0629 \u0628\u0646\u062c\u0627\u062d.","review_edit":"\u062a\u0645 \u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0631\u0627\u062c\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","review_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0645\u0631\u0627\u062c\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","role_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","role_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","role_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","schedule_crete":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062c\u062f\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","schedule_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062c\u062f\u0648\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","schedule_not_found":"\u0627\u0644\u062c\u062f\u0648\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.","schedule_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062c\u062f\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","select_calendar.":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0642\u0648\u064a\u0645.","select_payment":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0623\u064a \u0637\u0631\u064a\u0642\u0629 \u062f\u0641\u0639 \u0648\u0627\u062d\u062f\u0629","service_cat_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_cat_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_cat_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_cat_use":"\u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","service_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062e\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d.","service_use":"\u0627\u0644\u062e\u062f\u0645\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","session_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062c\u0644\u0633\u0629 \u0628\u0646\u062c\u0627\u062d.","setting_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","slider_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631 \u0628\u0646\u062c\u0627\u062d","some_doctors":"\u062d\u062f\u062f \u0628\u0639\u0636 \u0627\u0644\u0623\u0637\u0628\u0627\u0621 \u0623\u064a\u0627\u0645\u0647\u0645 \u0641\u064a \u0623\u064a\u0627\u0645 \u063a\u064a\u0631 \u0645\u062d\u062f\u062f\u0629 \u060c \u0641\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u062c\u0631\u0627\u0621 \u0647\u0630\u0647 \u0627\u0644\u0639\u0645\u0644\u064a\u0629\u061f","something_went_wrong":"\u0647\u0646\u0627\u0643 \u062e\u0637\u0623 \u0645\u0627","specialization_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062a\u062e\u0635\u0635 \u0628\u0646\u062c\u0627\u062d.","specialization_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062a\u062e\u0635\u0635 \u0628\u0646\u062c\u0627\u062d.","specialization_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u062e\u0635\u0635 \u0628\u0646\u062c\u0627\u062d.","specialization_use":"\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062a\u062e\u0635\u0635 \u0628\u0646\u062c\u0627\u062d.","specialization_used_some_where":"\u0627\u0644\u062a\u062e\u0635\u0635 \u064a\u0633\u062a\u062e\u062f\u0645 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","staff_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644 \u0628\u0646\u062c\u0627\u062d.","staff_delete":"\u062d\u0630\u0641 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644 \u0628\u0646\u062c\u0627\u062d.","staff_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646 \u0628\u0646\u062c\u0627\u062d.","staff_use":"\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646 \u0628\u0646\u062c\u0627\u062d.","state_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0648\u0644\u0627\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","state_delete":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","state_update":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","state_use":"\u0627\u0644\u062f\u0648\u0644\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0641\u064a \u0645\u0643\u0627\u0646 \u0622\u062e\u0631.","states_retrieve":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062f\u0648\u0644 \u0628\u0646\u062c\u0627\u062d.","status_change":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","status_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","subscriber_creat":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0634\u062a\u0631\u0643 \u0628\u0646\u062c\u0627\u062d.","subscriber_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0634\u062a\u0631\u0643 \u0628\u0646\u062c\u0627\u062d.","testimonial_creat":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a \u0628\u0646\u062c\u0627\u062d.","testimonial_delete":"\u062a\u0645 \u062d\u0630\u0641 \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a \u0628\u0646\u062c\u0627\u062d.","testimonial_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a \u0628\u0646\u062c\u0627\u062d.","testimonial_use":"\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a \u0628\u0646\u062c\u0627\u062d.","theme_change":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0628\u0646\u062c\u0627\u062d.","there_were":"\u0643\u0627\u0646\u062a \u0647\u0646\u0627\u0643 \u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0627\u0644\u062f\u0641\u0639. \u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0644\u0627\u062d\u0642\u064b\u0627. '\u060c' \u062d\u062f\u062b\u062a \u0645\u0634\u0643\u0644\u0629 \u0641\u064a \u0627\u0644\u062f\u0641\u0639. \u0627\u0644\u0631\u062c\u0627\u0621 \u0645\u0639\u0627\u0648\u062f\u0629 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0641\u064a \u0648\u0642\u062a \u0644\u0627\u062d\u0642.","university_required":"\u0627\u0644\u062c\u0627\u0645\u0639\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","update_blog":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u062f\u0648\u0646\u0629 VCard \u0628\u0646\u062c\u0627\u062d.","update_front_testimonial":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0634\u0647\u0627\u062f\u0629 \u0628\u0646\u062c\u0627\u062d.","user_8_or":"\u0627\u0633\u062a\u062e\u062f\u0645 6 \u0623\u062d\u0631\u0641 \u0623\u0648 \u0623\u0643\u062b\u0631 \u0645\u0639 \u0645\u0632\u064a\u062c \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641 \u0648\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0648\u0627\u0644\u0631\u0645\u0648\u0632.","user_already_verified":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0644\u062f\u064a\u0647 \u0628\u0627\u0644\u0641\u0639\u0644 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646\u0647.","user_profile":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","user_profile_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","user_role_not_delete":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u062f\u0648\u0631 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0647\u0630\u0627 \u060c \u0644\u0623\u0646\u0647 \u062a\u0645 \u062a\u0639\u064a\u064a\u0646\u0647 \u0644\u0645\u0633\u062a\u062e\u062f\u0645.","user_status":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d","user_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","user_zoom_credential_saved":"\u062a\u0645 \u062d\u0641\u0638 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0639\u062a\u0645\u0627\u062f \u062a\u0643\u0628\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d.","valid_instagram":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Instagram","valid_linkedin":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Linkedin","valid_twitter":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u062a\u0648\u064a\u062a\u0631","verified_email":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","visit_create":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0632\u064a\u0627\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","visit_delete":"\u0642\u0645 \u0628\u0632\u064a\u0627\u0631\u0629 \u0627\u0644\u062d\u0630\u0641 \u0628\u0646\u062c\u0627\u062d.","visit_prescription_added":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0648\u0635\u0641\u0629 \u0627\u0644\u0632\u064a\u0627\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","visit_prescription_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0648\u0635\u0641\u0629 \u0627\u0644\u0632\u064a\u0627\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","visit_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0632\u064a\u0627\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","year_required":"\u0627\u0644\u0633\u0646\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","your_reg_success":"\u062a\u0633\u062c\u064a\u0644\u0643 \u0628\u0646\u062c\u0627\u062d. \u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u062d\u0633\u0627\u0628\u0643 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a."},"front_cms":"\u0627\u0644\u062c\u0628\u0647\u0629 CMS","front_medical_service":{"add_front_medical_service":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0627\u0644\u0637\u0628\u064a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","edit_front_medical_service":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631","title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"front_medical_services":"\u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","front_patient_testimonial":{"add_front_patient_testimonial":"\u0625\u0636\u0627\u0641\u0629 \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a","designation":"\u0627\u0644\u062a\u0639\u064a\u064a\u0646","edit_front_patient_testimonial":"\u062a\u062d\u0631\u064a\u0631 \u0634\u0647\u0627\u062f\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a","more_patient_feedbacks":"\u0627\u0644\u0645\u0632\u064a\u062f \u0645\u0646 \u0645\u0644\u0627\u062d\u0638\u0627\u062a \u0627\u0644\u0645\u0631\u064a\u0636 ...","name":"\u0627\u0644\u0627\u0633\u0645","patient_testimonials":"\u0634\u0647\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0631\u0636\u0649","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631"},"front_patient_testimonials":"\u0634\u0647\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0623\u0645\u0627\u0645\u064a","front_service":{"add_front_service":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","edit_front_service":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","icon":"\u0623\u064a\u0642\u0648\u0646\u0629","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631","title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"front_services":"\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u062c\u0628\u0647\u0629","holder_name_invalid":"\u0627\u0633\u0645 \u062d\u0627\u0645\u0644 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","holder_name_required":"\u062d\u0642\u0648\u0644 \u0627\u0633\u0645 \u062d\u0627\u0645\u0644 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","holder_number_invalid":"\u062d\u0642\u0648\u0644 \u0631\u0642\u0645 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","holiday":{"add_holiday":"\u0623\u0636\u0641 \u0639\u0637\u0644\u0629","doctor_holiday":"\u0639\u0637\u0644\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0628","holiday":"\u064a\u0648\u0645 \u0627\u0644\u0627\u062c\u0627\u0632\u0629","holiday_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0639\u0637\u0644\u0629","service_category":"\u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629"},"icon_size":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062d\u062c\u0645 \u0627\u0644\u0631\u0645\u0632 \u0623\u0642\u0644 \u0645\u0646 2 \u0645\u064a\u063a\u0627\u0628\u0627\u064a\u062a","id":"\u0628\u0637\u0627\u0642\u0629 \u062a\u0639\u0631\u064a\u0641","image_file_type":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpeg\u060c jpg\u060c png.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u062f\u0648\u0644\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062de","invalid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d","invalid_range":"\u0627\u0644\u0646\u0637\u0627\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","live_consultation":{"add_credential":"\u0625\u0636\u0627\u0641\u0629 \u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f","add_live_consultation":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0645\u0628\u0627\u0634\u0631\u0629","awaited":"\u0645\u0646\u062a\u0638\u0631","client_video":"\u0641\u064a\u062f\u064a\u0648 \u0627\u0644\u0639\u0645\u064a\u0644","consultation_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629","consultation_duration_minutes":"\u0645\u062d\u0636\u0631 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629","consultation_minutes":"\u0645\u062d\u0636\u0631 \u0627\u0644\u062a\u0634\u0627\u0648\u0631","consultation_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629","created_by":"\u0627\u0646\u0634\u0623 \u0645\u0646 \u0642\u0628\u0644","created_for":"\u062e\u0644\u0642\u062a \u0644","description":"\u0648\u0635\u0641","disabled":"\u0639\u0627\u062c\u0632","duration":"\u0627\u0644\u0645\u062f\u0629 (\u0628\u0627\u0644\u062f\u0642\u0627\u0626\u0642)","edit_live_consultation":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u062d\u064a\u0629","edit_live_meeting":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639 \u0627\u0644\u0645\u0628\u0627\u0634\u0631","enable":"\u064a\u0645\u0643\u0646","finished":"\u062a\u0645 \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621 \u0645\u0646","host_video":"\u0641\u064a\u062f\u064a\u0648 \u0645\u0636\u064a\u0641","join_now":"\u0646\u0636\u0645 \u0627\u0644\u0627\u0646","live_consultation_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0627\u0644\u062d\u064a\u0629","new_live_consultation":"\u0627\u0633\u062a\u0634\u0627\u0631\u0629 \u0645\u0628\u0627\u0634\u0631\u0629 \u062c\u062f\u064a\u062f\u0629","new_live_meeting":"\u0644\u0642\u0627\u0621 \u0645\u0628\u0627\u0634\u0631 \u062c\u062f\u064a\u062f","select_consultation_date":"\u062d\u062f\u062f \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0629","select_doctor_name":"\u0627\u062e\u062a\u0631 \u0627\u0633\u0645 \u0627\u0644\u0637\u0628\u064a\u0628","select_patient_name":"\u062d\u062f\u062f \u0627\u0633\u0645 \u0627\u0644\u0645\u0631\u064a\u0636","staff_list":"\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646","start_now":"\u0627\u0628\u062f\u0623 \u0627\u0644\u0622\u0646","type":"\u0646\u0648\u0639","type_number":"\u0646\u0648\u0639 \u0627\u0644\u0631\u0642\u0645","zoom_api_key":"Zoom Api Key","zoom_api_secret":"Zoom API Secret"},"live_consultations":"\u0627\u0633\u062a\u0634\u0627\u0631\u0627\u062a \u0645\u0628\u0627\u0634\u0631\u0629","live_status_retrieved_successfully.":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062d\u0627\u0644\u0629 \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629 \u0628\u0646\u062c\u0627\u062d.","login":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","medicine":{"available_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629","brand":"\u0645\u0627\u0631\u0643\u0629","brand_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629","buying_price":"\u0633\u0639\u0631 \u0627\u0644\u0634\u0631\u0627\u0621","cant_be_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641\u0647\u0627","category":"\u0641\u0626\u0629","category_id":"\u0645\u0639\u0631\u0641 \u0627\u0644\u0641\u0626\u0629","category_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0641\u0626\u0629 \u0627\u0644\u0637\u0628 \u0628\u0646\u062c\u0627\u062d.","deleted_successfully":"\u062d\u0630\u0641 \u0628\u0646\u062c\u0627\u062d","description":"\u0648\u0635\u0641","dosage":"\u0627\u0644\u062c\u0631\u0639\u0629","dose_interval":"\u062d\u062f\u062f \u0627\u0644\u0641\u0627\u0635\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0644\u0644\u062c\u0631\u0639\u0629","duration":"\u0645\u062f\u0629","edit_medicine":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0637\u0628","edit_medicine_brand":"\u062a\u062d\u0631\u064a\u0631 \u0645\u0627\u0631\u0643\u0629 \u0627\u0644\u062f\u0648\u0627\u0621","edit_medicine_category":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0626\u0629 \u0627\u0644\u0637\u0628","filter_options":"\u062e\u064a\u0627\u0631\u0627\u062a \u0627\u0644\u062a\u0635\u0641\u064a\u0629","medicine":"\u0627\u0644\u062f\u0648\u0627\u0621","medicine_brands":"\u0645\u0627\u0631\u0643\u0627\u062a \u0627\u0644\u0637\u0628","medicine_brands_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629 \u0627\u0644\u0637\u0628\u064a\u0629","medicine_category":"\u0641\u0626\u0629 \u0627\u0644\u0637\u0628","medicine_category_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0641\u0626\u0629 \u0627\u0644\u0637\u0628","medicine_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0637\u0628","medicine_name":"\u0627\u0633\u0645 \u0627\u0644\u0637\u0628","medicine_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062f\u0648\u0627\u0621 \u0628\u0646\u062c\u0627\u062d","medicines":"\u0627\u0644\u0623\u062f\u0648\u064a\u0629","name":"\u0627\u0633\u0645","new_brand":"\u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u062a\u062c\u0627\u0631\u064a\u0629 \u0627\u0644\u062c\u062f\u064a\u062f\u0629","new_medicine":"\u0627\u0644\u0637\u0628 \u0627\u0644\u062c\u062f\u064a\u062f","new_medicine_brand":"\u0645\u0627\u0631\u0643\u0629 \u062f\u0648\u0627\u0621 \u062c\u062f\u064a\u062f\u0629","new_medicine_category":"\u0641\u0626\u0629 \u0627\u0644\u0637\u0628 \u0627\u0644\u062c\u062f\u064a\u062f","no_use":"\u063a\u064a\u0631 \u0645\u0633\u062a\u062e\u062f\u0645","quantity":"\u0643\u0645\u064a\u0629","salt_composition":"\u062a\u0643\u0648\u064a\u0646 \u0627\u0644\u0645\u0644\u062d","saved_successfully":"\u062d\u0641\u0638 \u0628\u0646\u062c\u0627\u062d","select_duration":"\u062d\u062f\u062f \u0627\u0644\u0645\u062f\u0629","selling_price":"\u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639","side_effects":"\u0622\u062b\u0627\u0631 \u062c\u0627\u0646\u0628\u064a\u0629","status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","updated_successfully":"\u062a\u0645 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0628\u0646\u062c\u0627\u062d"},"medicine_bills":{"add_medicine_bill":"\u0627\u0636\u0627\u0641\u0629 \u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u062f\u0648\u0627\u0621","available_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629 \u0645\u0646","avl_qty":"\u0623\u0641\u0644 \u0627\u0644\u0643\u0645\u064a\u0629","bill_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","bill_id":"\u0645\u0639\u0631\u0641 \u0628\u064a\u0644","bill_number":"\u0631\u0642\u0645 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0647","cell_no":"\u062e\u0644\u064a\u0629 \u0644\u0627","dose_interval":"\u0627\u0644\u0641\u0627\u0635\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0644\u0644\u062c\u0631\u0639\u0629","duplicate_medicine":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0625\u0636\u0627\u0641\u0629 \u0623\u062f\u0648\u064a\u0629 \u0645\u0643\u0631\u0631\u0629.","edit_medicine_bill":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0637\u0628","enter_lot_number":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0642\u0637\u0639\u0629.","enter_puchase_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0634\u0631\u0627\u0621","enter_sale_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639.","is":"\u064a\u0643\u0648\u0646","item_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0646\u0635\u0631","medicine_bill":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0637\u0628","medicine_bill_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u062f\u0648\u0627\u0621","medicine_bills":"\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0637\u0628","medicine_not_selected":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u062f\u0648\u0627\u0621 \u0648\u0627\u062d\u062f \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644.","medicine_required":"\u0645\u062c\u0627\u0644 \u0627\u0644\u0637\u0628 \u0645\u0637\u0644\u0648\u0628.","net_amount_cant":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0641\u0627\u0631\u063a\u064b\u0627.","net_amount_cant_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0635\u0641\u0631\u0627\u064b.","net_amount_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0641\u0627\u0631\u063a\u064b\u0627.","net_amount_not_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0635\u0641\u0631\u064b\u0627.","new_medicine_bill":"\u0645\u0634\u0631\u0648\u0639 \u0642\u0627\u0646\u0648\u0646 \u0627\u0644\u0637\u0628 \u0627\u0644\u062c\u062f\u064a\u062f","payment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0633\u062f\u0627\u062f","payment_type":"\u0646\u0648\u0639 \u0627\u0644\u062f\u0641\u0639","prescription_not_found":"\u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629.","price":"\u0633\u0639\u0631","print_bill":"\u0637\u0628\u0627\u0639\u0629 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","quantity_should":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 0.","sale_price":"\u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639","select_medicine":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628","select_patient":"\u062d\u062f\u062f \u0627\u0644\u0645\u0631\u064a\u0636","select_payment_type":"\u0627\u062e\u062a\u0631 \u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","tax_amt":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0628\u0644\u063a \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u064b\u0627.","tax_cannot_be_zero_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0628\u0644\u063a \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u064b\u0627.","tax_should_be":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0636\u0631\u0627\u0626\u0628 \u0623\u0642\u0644 \u0645\u0646 100%.","the_discount_shoul":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062e\u0635\u0645 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a","the_medicine_already_in_use":"\u0647\u0630\u0627 \u0627\u0644\u062f\u0648\u0627\u0621 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a \u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0623\u062f\u0648\u064a\u0629\u060c \u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0631\u063a\u0628\u062a\u0643 \u0641\u064a \u062d\u0630\u0641\u0647\u061f","update_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0643\u0645\u064a\u0629 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0633\u0627\u0628\u0642\u0629."},"medicine_brands":"\u0645\u0627\u0631\u0643\u0627\u062a \u0627\u0644\u0637\u0628","medicine_categories":"\u0641\u0626\u0627\u062a \u0627\u0644\u0637\u0628","medicines":"\u0627\u0644\u0623\u062f\u0648\u064a\u0629","mobile_no":"\u0631\u0642\u0645 \u0627\u0644\u0645\u0648\u0628\u0627\u064a\u0644","months":{"apr":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","sep":"\u0633\u0628\u062a\u0645\u0628\u0631"},"no_data_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0628\u064a\u0627\u0646\u0627\u062a \u0645\u062a\u0627\u062d\u0629 \u0641\u064a \u0627\u0644\u062c\u062f\u0648\u0644","no_matching_records_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a \u0645\u0637\u0627\u0628\u0642\u0629","no_response":"\u0644\u0645 \u064a\u062a\u0645 \u0625\u0631\u062c\u0627\u0639 \u0623\u064a \u0631\u062f","not_supported":"\u063a\u064a\u0631 \u0645\u0639\u062a\u0645\u062f","note":"\u0645\u0644\u0627\u062d\u0638\u0629: \u064a\u062c\u0628 \u0639\u0644\u064a\u0643 \u062a\u0639\u064a\u064a\u0646 \u0645\u0646\u0637\u0642\u062a\u0643 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u0642\u0628\u0644 \u062f\u0645\u062c \u062a\u0642\u0648\u064a\u0645 Google.","notification":{"mark_all_as_read":"\u0627\u0634\u0631 \u0639\u0644\u064a\u0647\u0627 \u0628\u0627\u0646\u0647\u0627 \u0642\u0631\u0627\u062a","notification":"\u0625\u0634\u0639\u0627\u0631\u0627\u062a","you_don`t_have_any_new_notification":"\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 \u0623\u064a \u0625\u0634\u0639\u0627\u0631 \u062c\u062f\u064a\u062f"},"patient":{"add":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0631\u064a\u0636","address1":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 1","address2":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 2","address_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0639\u0646\u0648\u0627\u0646","blood_group":"\u0641\u0635\u064a\u0644\u0629 \u0627\u0644\u062f\u0645","city":"\u0645\u062f\u064a\u0646\u0629","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_no":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","country":"\u0627\u0644\u062f\u0648\u0644\u0629","details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0631\u064a\u0636","dob":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u064a\u0644\u0627\u062f","edit":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","emailverified":"\u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f","enter_email":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_password":"\u0623\u062f\u062e\u0644 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","female":"\u0623\u0646\u062b\u0649","filter":"\u0645\u0646\u0642\u064a","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","gender":"\u0627\u0644\u062c\u0646\u0633","last_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631","last_updated":"\u0622\u062e\u0631 \u062a\u062d\u062f\u064a\u062b","male":"\u0630\u0643\u0631","name":"\u0627\u0644\u0627\u0633\u0645","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","patient_unique_id":"\u0627\u0644\u0645\u0639\u0631\u0641 \u0627\u0644\u0641\u0631\u064a\u062f \u0644\u0644\u0645\u0631\u064a\u0636","postal_code":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a","profile":"\u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","registered_on":"\u0645\u0633\u062c\u0644 \u0639\u0644\u0649","save_changes":"\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629","today":"\u0627\u0644\u064a\u0648\u0645"},"patient_dashboard":{"completed_appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u0645\u0643\u062a\u0645\u0644\u0629","next_appointment":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u062a\u0627\u0644\u064a\u0629","today_appointments":"\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u064a\u0648\u0645","upcoming_appointments":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0627\u0644\u0642\u0627\u062f\u0645\u0629"},"patients":"\u0627\u0644\u0645\u0631\u0636\u0649","payment_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u062f\u0641\u0639","payment_for_booking_appointment_with_doctor":"\u0627\u0644\u062f\u0641\u0639 \u0645\u0642\u0627\u0628\u0644 \u062d\u062c\u0632 \u0645\u0648\u0639\u062f \u0645\u0639 \u0627\u0644\u0637\u0628\u064a\u0628","payment_method":{"authorize":"\u062a\u062e\u0648\u064a\u0644","paypal":"Paypal","paystack":"Paystack","paytm":"Paytm","razorpay":"\u0631\u0627\u0632\u0648\u0631\u0628\u0627\u064a","stripe":"\u0634\u0631\u064a\u0637"},"paytm":"Paytm","prescription":{"accident":"\u062d\u0627\u062f\u062b","advice":"\u0627\u0644\u0646\u0635\u064a\u062d\u0629","appointment_slot":"\u0641\u062a\u062d\u0627\u062a \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","available_quantity_of":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629 \u0645\u0646 ","breast_feeding":"\u0627\u0644\u0631\u0636\u0627\u0639\u0629 \u0627\u0644\u0637\u0628\u064a\u0639\u064a\u0629","comment":"\u062a\u0639\u0644\u064a\u0642","connect_with_zoom":" \u062a\u0648\u0627\u0635\u0644 \u0645\u0639 \u0632\u0648\u0648\u0645","current_medication":"\u0627\u0644\u062f\u0648\u0627\u0621 \u0627\u0644\u062d\u0627\u0644\u064a","diabetic":"\u0645\u0631\u064a\u0636 \u0628\u0627\u0644\u0633\u0643\u0631","dosage":"\u0627\u0644\u062c\u0631\u0639\u0629","duration":"\u0645\u062f\u0629","edit_prescription":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629","female_pregnancy":"\u0627\u0644\u062d\u0645\u0644 \u0627\u0644\u0623\u0646\u062b\u0648\u064a","food_allergies":"\u062d\u0633\u0627\u0633\u064a\u0629 \u0627\u0644\u0637\u0639\u0627\u0645","frequency":"\u0627\u0644\u062a\u0631\u062f\u062f","health_insurance":"\u062a\u0623\u0645\u064a\u0646 \u0635\u062d\u064a","heart_disease":"\u0645\u0631\u0636 \u0627\u0644\u0642\u0644\u0628","high_blood_pressure":"\u0636\u063a\u0637 \u062f\u0645 \u0645\u0631\u062a\u0641\u0639","is":"\u064a\u0643\u0648\u0646","low_income":"\u062f\u062e\u0644 \u0645\u0646\u062e\u0641\u0636","medical_history":"\u062a\u0627\u0631\u064a\u062e \u0637\u0628\u0649","medicine_name":"\u0627\u0633\u0645_\u0627\u0644\u0637\u0628","name":"\u0627\u0644\u0627\u0633\u0645","new_medicine":"\u0627\u0644\u0637\u0628 \u0627\u0644\u062c\u062f\u064a\u062f","new_prescription":"\u0648\u0635\u0641\u0629 \u0637\u0628\u064a\u0629 \u062c\u062f\u064a\u062f\u0629","next_visit":"\u0641\u064a \u0627\u0644\u0645\u0631\u0629 \u0627\u0644\u0642\u0627\u062f\u0645\u0629","not_add_duplicate_medicines":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0623\u062f\u0648\u064a\u0629 \u0627\u0644\u0645\u0643\u0631\u0631\u0629.","ok":"\u0646\u0639\u0645","others":"\u0627\u0644\u0622\u062e\u0631\u064a\u0646","patient":"\u0635\u0628\u0648\u0631","physical_information":"\u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0645\u0627\u062f\u064a\u0629","plus_rate":"\u0645\u0639\u062f\u0644 \u0646\u0628\u0636","prescription":"\u0648\u0635\u0641\u0629 \u0637\u0628\u064a\u0629","prescription_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629","prescription_saved":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","prescription_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0648\u0635\u0641\u0629 \u0627\u0644\u0637\u0628\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","prescriptions":"\u0627\u0644\u0648\u0635\u0641\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629","problem":"\u0645\u0634\u0643\u0644\u0629","problem_description":"\u0648\u0635\u0641 \u0627\u0644\u0645\u0634\u0643\u0644\u0629","reference":"\u0645\u0631\u062c\u0639","rx":"\u0622\u0631 \u0625\u0643\u0633","selectMedicine":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062f\u0648\u0627\u0621","surgery":"\u0627\u0644\u062c\u0631\u0627\u062d\u0629","temperature":"\u062f\u0631\u062c\u0629 \u0627\u0644\u062d\u0631\u0627\u0631\u0629","tendency_bleed":"\u062a\u064a\u0627\u0631 \u0627\u0644\u0646\u0632\u0641","test":"\u0627\u062e\u062a\u0628\u0627\u0631","time":"\u0632\u0645\u0646","total_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a\u0629"},"privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","purchase_medicine":{"actions":"\u0623\u062c\u0631\u0627\u0621\u0627\u062a","amount":"\u0643\u0645\u064a\u0629","discount":"\u062a\u062e\u0641\u064a\u0636","dose_duration":"\u0645\u062f\u0629 \u0627\u0644\u062c\u0631\u0639\u0629","expiry_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621","export_to_excel":"\u062a\u0635\u062f\u064a\u0631 \u0625\u0644\u0649 Excel","lot_no":"\u0627\u0644\u0643\u062b\u064a\u0631 \u0644\u0627.","net_amount":"\u0643\u0645\u064a\u0629 \u0627\u0644\u0634\u0628\u0643\u0629","note":"\u0645\u0644\u062d\u0648\u0638\u0629","other_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0623\u062e\u0631\u0649","payment_mode":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639","payment_note":"\u0645\u0630\u0643\u0631\u0629 \u0627\u0644\u062f\u0641\u0639","purchase_medicine":"\u0634\u0631\u0627\u0621 \u0627\u0644\u0623\u062f\u0648\u064a\u0629","purchase_medicine_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0634\u0631\u0627\u0621 \u0627\u0644\u062f\u0648\u0627\u0621","purchase_medicine_overview":"\u0646\u0638\u0631\u0629 \u0639\u0627\u0645\u0629 \u0639\u0644\u0649 \u0634\u0631\u0627\u0621 \u0627\u0644\u0623\u062f\u0648\u064a\u0629","purchase_medicines":"\u0634\u0631\u0627\u0621 \u0627\u0644\u0623\u062f\u0648\u064a\u0629","purchase_number":"\u0631\u0642\u0645 \u0627\u0644\u0634\u0631\u0627\u0621","purchased_medicine_success":"\u062a\u0645 \u0634\u0631\u0627\u0621 \u0627\u0644\u062f\u0648\u0627\u0621 \u0628\u0646\u062c\u0627\u062d","quantity":"\u0643\u0645\u064a\u0629","tax":"\u0636\u0631\u064a\u0628\u0629","tax_amount":"\u0642\u064a\u0645\u0629 \u0627\u0644\u0636\u0631\u064a\u0628\u0629","total":"\u0627\u0644\u0645\u062c\u0645\u0648\u0639"},"range_constructor_requires_trie_parameter":"\u064a\u062a\u0637\u0644\u0628 \u0645\u064f\u0646\u0634\u0626 \u0627\u0644\u0646\u0637\u0627\u0642 \u0645\u0639\u0644\u0645\u0629 Trie","register":"\u062a\u0633\u062c\u064a\u0644","requires_string_parameter":"\u064a\u062a\u0637\u0644\u0628 rangeWithString \u0645\u0639\u0644\u0645\u0629 \u0633\u0644\u0633\u0644\u0629","resend_email_verification":"\u0625\u0639\u0627\u062f\u0629 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","review":{"add_review":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0631\u0627\u062c\u0639\u0629","edit_review":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0631\u0627\u062c\u0639\u0629","no_doctors_available_to_give_rating":"\u0644\u0627 \u064a\u0648\u062c\u062f \u0623\u0637\u0628\u0627\u0621 \u0645\u062a\u0627\u062d\u0648\u0646 \u0644\u0645\u0646\u062d \u0627\u0644\u062a\u0642\u064a\u064a\u0645.","review":"\u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u0646\u0638\u0631","write_a_review":"\u0623\u0643\u062a\u0628 \u0645\u0631\u0627\u062c\u0639\u0629"},"reviews":"\u0627\u0644\u0627\u0633\u062a\u0639\u0631\u0627\u0636\u0627\u062a","role":{"add_role":"\u0625\u0636\u0627\u0641\u0629 \u062f\u0648\u0631","edit_role":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0631","permissions":"\u0623\u0630\u0648\u0646\u0627\u062a","role":"\u0627\u0644\u062f\u0648\u0631","role_permissions":"\u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u062f\u0648\u0631","select_all_permissions":"\u062a\u062d\u062f\u064a\u062f \u0643\u0627\u0641\u0629 \u0627\u0644\u0623\u0630\u0648\u0646\u0627\u062a"},"roles":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631","service":{"add_service":"\u0625\u0636\u0627\u0641\u0629 \u062e\u062f\u0645\u0629","category":"\u0627\u0644\u0641\u0626\u0629","charges":"\u0627\u0644\u0631\u0633\u0648\u0645","edit_service":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631"},"service_categories":"\u0641\u0626\u0627\u062a \u0627\u0644\u062e\u062f\u0645\u0629","service_category":{"add_category":"\u0625\u0636\u0627\u0641\u0629 \u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629","edit_category":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629","service_category":"\u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629"},"services":"\u0627\u0644\u062e\u062f\u0645\u0627\u062a","setting":{"address":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646","change_app_logo":"\u062a\u063a\u064a\u064a\u0631 \u0634\u0639\u0627\u0631 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","change_favicon":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0623\u064a\u0642\u0648\u0646\u0629 \u0627\u0644\u0645\u0641\u0636\u0644\u0629","clinic_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u064a\u0627\u062f\u0629","connect_google_calendar":"\u0631\u0628\u0637 \u062a\u0642\u0648\u064a\u0645 \u0645\u062a\u0635\u0641\u062d \u0627\u0644\u062c\u0648\u062c\u0644","connect_your_google_calendar":"\u0631\u0628\u0637 \u062a\u0642\u0648\u064a\u0645 \u0645\u062a\u0635\u0641\u062d \u0627\u0644\u062c\u0648\u062c\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","contact_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644","currency":"\u0627\u0644\u0639\u0645\u0644\u0629","currency_settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0639\u0645\u0644\u0629","default_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a","default_language_suggest":"\u0645\u0646 \u062e\u0644\u0627\u0644 \u062a\u062d\u062f\u064a\u062b \u0647\u0630\u0627\u060c \u0633\u062a\u062a\u063a\u064a\u0631 \u0644\u063a\u0629 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0628\u0627\u0644\u0643\u0627\u0645\u0644 \u0639\u0646\u062f \u0627\u0644\u0637\u0628\u064a\u0628 \u0648\u062a\u0633\u062c\u064a\u0644\u0627\u062a \u062f\u062e\u0648\u0644 \u0627\u0644\u0645\u0631\u064a\u0636 \u0648\u0643\u0630\u0644\u0643 \u0627\u0644\u062c\u0627\u0646\u0628 \u0627\u0644\u0623\u0645\u0627\u0645\u064a.","disconnect_your_google_calendar":"\u0642\u0637\u0639 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u062a\u0642\u0648\u064a\u0645 \u0645\u062a\u0635\u0641\u062d \u0627\u0644\u062c\u0648\u062c\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","do_not_allow_to_login_without_email_verification":"\u0644\u0627 \u062a\u0633\u0645\u062d \u0628\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0628\u062f\u0648\u0646 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","favicon":"\u0641\u0627\u0641\u064a\u0643\u0648\u0646","general":"\u0639\u0627\u0645","general_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0639\u0627\u0645\u0629","logo":"\u0627\u0644\u0634\u0639\u0627\u0631","postal_code":"\u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0628\u0631\u064a\u062f\u064a","prefix":"\u0628\u0627\u062f\u0626\u0629","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"\u062d\u062f\u062f \u0627\u0644\u062a\u0642\u0648\u064a\u0645\u0627\u062a \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643 (\u0645\u0646 \u062a\u0642\u0648\u064a\u0645 \u0645\u062a\u0635\u0641\u062d \u062c\u0648\u062c\u0644) \u0627\u0644\u062a\u064a \u062a\u0631\u064a\u062f \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f \u0641\u064a\u0647\u0627","setting":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f","specialities":"\u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","sync_your_google_calendar":"\u0645\u0632\u0627\u0645\u0646\u0629 \u062a\u0642\u0648\u064a\u0645 \u0645\u062a\u0635\u0641\u062d \u0627\u0644\u062c\u0648\u062c\u0644 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","when_checkbox_disable":"\u0639\u0646\u062f \u062a\u0639\u0637\u064a\u0644 \u062e\u0627\u0646\u0629 \u0627\u0644\u0627\u062e\u062a\u064a\u0627\u0631 \u060c \u0644\u0627 \u064a\u0639\u0645\u0644 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u062c\u062f\u062f.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"\u0639\u0646\u062f\u0645\u0627 \u064a\u062d\u062c\u0632 \u0627\u0644\u0645\u0631\u064a\u0636 \u0645\u0648\u0639\u062f\u064b\u0627 \u0645\u0639\u0643 \u060c \u0633\u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0645\u0648\u0639\u062f \u062c\u062f\u064a\u062f \u0641\u064a \u0627\u0644\u062a\u0642\u0648\u064a\u0645\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062f\u0629","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"\u0639\u0646\u062f \u062d\u062c\u0632 \u0645\u0648\u0639\u062f \u060c \u0633\u064a\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0645\u0648\u0639\u062f \u062c\u062f\u064a\u062f \u0641\u064a \u0627\u0644\u062a\u0642\u0648\u064a\u0645\u0627\u062a \u0627\u0644\u0645\u062d\u062f\u062f\u0629"},"settings":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a","slider":{"add_slider":"\u0625\u0636\u0627\u0641\u0629 \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631","edit_slider":"\u062a\u062d\u0631\u064a\u0631 \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631","image":"\u0635\u0648\u0631\u0629","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631","title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646"},"sliders":"\u0627\u0644\u0645\u062a\u0632\u0644\u062c\u0648\u0646","smart_patient_card":{"add_smart_card":"\u0625\u0636\u0627\u0641\u0629 \u0628\u0637\u0627\u0642\u0629 \u0630\u0643\u064a\u0629","add_smart_card_templates":"\u0625\u0636\u0627\u0641\u0629 \u0642\u0648\u0627\u0644\u0628 \u0628\u0637\u0627\u0642\u0627\u062a \u0630\u0643\u064a\u0629","address_show":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","blood_group_show":"\u0625\u0638\u0647\u0627\u0631 \u0641\u0635\u064a\u0644\u0629 \u0627\u0644\u062f\u0645","dob_show":"\u0625\u0638\u0647\u0627\u0631 \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u064a\u0644\u0627\u062f","edit_patient_card":"\u062a\u0639\u062f\u064a\u0644 \u0628\u0637\u0627\u0642\u0629 \u0630\u0643\u064a\u0629","email_show":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_template_name":"\u0623\u062f\u062e\u0644 \u0627\u0633\u0645 \u0627\u0644\u0642\u0627\u0644\u0628","for_all_patient":"\u0644\u062c\u0645\u064a\u0639 \u0627\u0644\u0645\u0631\u0636\u0649","generate_patient_card":"\u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0629 \u0645\u0631\u064a\u0636","generate_patient_smart_cards":"\u0625\u0646\u0634\u0627\u0621 \u0628\u0637\u0627\u0642\u0627\u062a \u0645\u0631\u064a\u0636 \u0630\u0643\u064a\u0629","header_color":"\u0644\u0648\u0646 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","only_one_patient":"\u0644\u0645\u0631\u064a\u0636 \u0648\u0627\u062d\u062f \u0641\u0642\u0637","patient":"\u0645\u0631\u064a\u0636","patient_smart_card_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0630\u0643\u064a\u0629 \u0644\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","patient_smart_card_deleted":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0630\u0643\u064a\u0629\u0644\u0644\u0645\u0631\u064a\u0636 \u0628\u0646\u062c\u0627\u062d.","phone_show":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0647\u0627\u062a\u0641","please_selest_patient":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","remaning_patients":"\u0627\u0644\u0645\u0631\u0636\u0649 \u0627\u0644\u0645\u062a\u0628\u0642\u064a\u0646","select_patient":"\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u0631\u064a\u0636","select_template":"\u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0642\u0627\u0644\u0628","smart_patient_card_templates":"\u0642\u0648\u0627\u0644\u0628 \u0628\u0637\u0627\u0642\u0627\u062a \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0630\u0643\u064a\u0629","smart_patient_cards":"\u0628\u0637\u0627\u0642\u0627\u062a \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0630\u0643\u064a\u0629","templat_name":"\u0627\u0633\u0645 \u0627\u0644\u0642\u0627\u0644\u0628","template":"\u0642\u0627\u0644\u0628","template_created":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0642\u0627\u0644\u0628 \u0628\u0646\u062c\u0627\u062d.","template_deleted":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0642\u0627\u0644\u0628 \u0628\u0646\u062c\u0627\u062d.","template_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0642\u0627\u0644\u0628 \u0628\u0646\u062c\u0627\u062d.","type":"\u0646\u0648\u0639","unique_id_show":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0647\u0648\u064a\u0629 \u0627\u0644\u0641\u0631\u064a\u062f\u0629"},"specialization":{"add_specialization":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u062a\u062e\u0635\u0635","edit_specialization":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062a\u062e\u0635\u0635","retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u062a\u062e\u0635\u0635 \u0628\u0646\u062c\u0627\u062d."},"specializations":"\u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","staff":{"add_staff":"\u0625\u0636\u0627\u0641\u0629 \u0637\u0627\u0642\u0645 \u0639\u0645\u0644","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_no":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","edit_staff":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0631\u064a\u0642 \u0627\u0644\u0639\u0645\u0644","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","gender":"\u0627\u0644\u062c\u0646\u0633","last_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631","male":"\u0630\u0643\u0631","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","role":"\u0627\u0644\u062f\u0648\u0631","select_role":"\u062d\u062f\u062f \u0627\u0644\u062f\u0648\u0631","staff":"\u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644","staff_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646"},"staffs":"\u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646","start_time_invalid":"\u0648\u0642\u062a \u0627\u0644\u0628\u062f\u0621 \u0627\u0644\u064a\u0648\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","state":{"add_state":"\u0623\u0636\u0641 \u062f\u0648\u0644\u0629","country":"\u0627\u0644\u062f\u0648\u0644\u0629","edit_state":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062d\u0627\u0644\u0629","state":"\u0627\u0644\u0648\u0644\u0627\u064a\u0629","states":"\u0627\u0644\u062f\u0648\u0644"},"states":"\u0627\u0644\u062f\u0648\u0644","subscribers":"\u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0648\u0646","terms_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","transaction":{"paid":"\u062f\u0641\u0639","payment_accepted_by":"\u0627\u0644\u062f\u0641\u0639 \u0645\u0642\u0628\u0648\u0644 \u0645\u0646","payment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0633\u062f\u0627\u062f","pending":"\u0642\u064a\u062f \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631","transaction_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0635\u0641\u0642\u0629","transaction_id":"\u0631\u0642\u0645 \u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0629"},"transactions":"\u0627\u0644\u0645\u0639\u0627\u0645\u0644\u0627\u062a","used_medicine":{"used_at":"\u062a\u0633\u062a\u062e\u062f\u0645 \u0641\u064a","used_medicine":"\u0627\u0644\u0637\u0628 \u0627\u0644\u0645\u0633\u062a\u0639\u0645\u0644","used_medicines":"\u0627\u0644\u0623\u062f\u0648\u064a\u0629 \u0627\u0644\u0645\u0633\u062a\u0639\u0645\u0644\u0629","used_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629"},"user":{"account":"\u0627\u0644\u062d\u0633\u0627\u0628","account_setting":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u062d\u0633\u0627\u0628","avatar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","change_language":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629","change_password":"\u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","edit_profile":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_notification":"\u0625\u0639\u0644\u0627\u0645 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","gender":"\u0627\u0644\u062c\u0646\u0633","language":"\u0627\u0644\u0644\u063a\u0629","new_password":"\u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u062c\u062f\u064a\u062f\u0629","profile_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","return_to_admin":"\u0627\u0644\u0639\u0648\u062f\u0629 \u0625\u0644\u0649 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","save_changes":"\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","select_time_zone":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u062c\u0627\u0644 \u0627\u0644\u0632\u0645\u0646\u064a","setting":"\u0627\u0644\u0625\u0639\u062f\u0627\u062f","sign_out":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062e\u0631\u0648\u062c","staff_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646","time_zone":"\u0648\u062d\u062f\u0629 \u0632\u0645\u0646\u064a\u0629"},"users":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646","valid_expiration_date":"\u0623\u062f\u062e\u0644 \u062a\u0627\u0631\u064a\u062e \u0627\u0646\u062a\u0647\u0627\u0621 \u0635\u0644\u0627\u062d\u064a\u0629 \u0635\u0627\u0644\u062d\u064b\u0627.","valid_number":"\u0631\u0642\u0645 \u0635\u0627\u0644\u062d","visit":{"add_visit":"\u0625\u0636\u0627\u0641\u0629 \u0632\u064a\u0627\u0631\u0629","description":"\u0627\u0644\u0648\u0635\u0641","doctor":"\u062f\u0643\u062a\u0648\u0631","edit_visit":"\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0632\u064a\u0627\u0631\u0629","enter_note":"\u0623\u062f\u062e\u0644 \u0645\u0644\u0627\u062d\u0638\u0629","enter_observation":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629","enter_problem":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629","notes":"\u0645\u0644\u0627\u062d\u0638\u0627\u062a","observations":"\u0645\u0644\u0627\u062d\u0638\u0627\u062a","patient":"\u0627\u0644\u0645\u0631\u064a\u0636","prescriptions":"\u0627\u0644\u0648\u0635\u0641\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629","problems":"\u0645\u0634\u0627\u0643\u0644","title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646","visit_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0632\u064a\u0627\u0631\u0629","visit_detail":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0632\u064a\u0627\u0631\u0629","visit_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0632\u064a\u0627\u0631\u0629"},"visits":"\u0632\u064a\u0627\u0631\u0627\u062a","web":{"Meet_best_doctors":"\u062a\u0639\u0631\u0641 \u0639\u0644\u0649 \u0623\u0641\u0636\u0644 \u0627\u0644\u0623\u0637\u0628\u0627\u0621","about_experience":"\u0639\u0646 \u0627\u0644\u062e\u0628\u0631\u0629","about_short_description":"\u062d\u0648\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0645\u062e\u062a\u0635\u0631","about_title":"\u062d\u0648\u0644 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","about_us":"\u0646\u0628\u0630\u0629 \u0639\u0646\u0627","all_rights_reserved":"\u0643\u0644 \u0627\u0644\u062d\u0642\u0648\u0642 \u0645\u062d\u0641\u0648\u0638\u0629","all_services":"\u062c\u0645\u064a\u0639 \u0627\u0644\u062e\u062f\u0645\u0627\u062a","already_have_an_account":"\u0644\u062f\u064a\u0643 \u062d\u0633\u0627\u0628 \u0628\u0627\u0644\u0641\u0639\u0644","already_have_patient_account":"\u0644\u062f\u064a\u0643 \u062d\u0633\u0627\u0628 \u0645\u0631\u064a\u0636 \u0628\u0627\u0644\u0641\u0639\u0644","appointment":"\u0645\u0648\u0639\u062f","appointment_now":"\u0645\u0648\u0639\u062f \u0627\u0644\u0622\u0646","best_professionals":"\u0623\u0641\u0636\u0644 \u0627\u0644\u0645\u062d\u062a\u0631\u0641\u064a\u0646","book_an_appointment":"\u062d\u062c\u0632 \u0645\u0648\u0639\u062f","book_appointment":"\u0645\u0648\u0639\u062f \u0627\u0644\u0643\u062a\u0627\u0628","call_us":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627","closed":"\u0645\u063a\u0644\u0642","confirm_booking":"\u062a\u0623\u0643\u064a\u062f \u0627\u0644\u062d\u062c\u0632","contact":"\u0627\u0644\u0627\u062a\u0635\u0627\u0644","contact_us":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627","contact_us_for_any_information":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627 \u0644\u0644\u062d\u0635\u0648\u0644 \u0639\u0644\u0649 \u0623\u064a \u0645\u0639\u0644\u0648\u0645\u0627\u062a","create_an_account":"\u0625\u0646\u0634\u0627\u0621 \u062d\u0633\u0627\u0628","created_at":"\u062a\u0645 \u0627\u0644\u0625\u0646\u0634\u0627\u0621 \u0641\u064a","doctors":"\u0623\u0637\u0628\u0627\u0621","doctors_can_interact___":"\u064a\u0645\u0643\u0646 \u0644\u0644\u0623\u0637\u0628\u0627\u0621 \u0627\u0644\u062a\u0641\u0627\u0639\u0644 \u0645\u0639 \u0627\u0644\u0645\u0631\u0636\u0649 \u0648\u0627\u0644\u0642\u064a\u0627\u0645 \u0628\u0627\u0644\u0639\u0644\u0627\u062c \u0630\u064a \u0627\u0644\u0635\u0644\u0629.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"\u0635\u064a\u0627\u063a\u0629 \u0646\u062a\u0627\u0626\u062c \u062e\u0627\u0644\u064a\u0629 \u0645\u0646 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0628\u0634\u0643\u0644 \u062f\u064a\u0646\u0627\u0645\u064a\u0643\u064a \u0642\u0628\u0644 \u062f\u0645\u062c \u0627\u0644\u0646\u062a\u0627\u0626\u062c. \u0627\u062d\u062a\u0636\u0627\u0646 \u0627\u0644\u0645\u0648\u0627\u0631\u062f \u0627\u0644\u0645\u062a\u0643\u0627\u0645\u0644\u0629 \u0628\u0634\u0643\u0644 \u0643\u0628\u064a\u0631 \u062f\u0648\u0646 \u062a\u0643\u0644\u0641\u0629 \u0641\u0639\u0627\u0644\u0629 \"\u062e\u0627\u0631\u062c.","email":"\u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","emergency_help":"\u0645\u0633\u0627\u0639\u062f\u0629 \u0627\u0644\u0637\u0648\u0627\u0631\u0626","enquiry":"\u0633\u0624\u0627\u0644","enquiry_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0627\u0633\u062a\u0641\u0633\u0627\u0631","enter_your_email":"\u0623\u062f\u062e\u0644 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_your_email_to_subscribe_to_our_newsletter":"\u0623\u062f\u062e\u0644 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0641\u064a \u0627\u0644\u0646\u0634\u0631\u0629 \u0627\u0644\u0625\u062e\u0628\u0627\u0631\u064a\u0629","faqs":"\u0623\u0633\u0626\u0644\u0629 \u0648\u0623\u062c\u0648\u0628\u0629","forgot_password":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","home":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","how_we_works":"\u0643\u064a\u0641 \u0646\u0639\u0645\u0644","i_agree":"\u0623\u0648\u0627\u0641\u0642","location":"\u0645\u0648\u0642\u0639\u0643","login":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","make_appointment":"\u062d\u062f\u062f \u0645\u0648\u0639\u062f\u0627","medical":"\u0637\u0628\u064a","medical_about_us":"\u0637\u0628\u064a \u0639\u0646\u0627","medical_appointment":"\u0645\u0648\u0639\u062f \u0637\u0628\u064a","medical_contact":"\u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0627\u0644\u0637\u0628\u064a","medical_doctors":"\u0623\u0637\u0628\u0627\u0621","medical_services":"\u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629","medical_treatment":"\u0627\u0644\u0639\u0644\u0627\u062c \u0627\u0644\u0637\u0628\u064a","meet_our_team_of_specialists":"\u0642\u0627\u0628\u0644 \u0641\u0631\u064a\u0642 \u0627\u0644\u0645\u062a\u062e\u0635\u0635\u064a\u0646 \u0644\u062f\u064a\u0646\u0627","message":"\u0631\u0633\u0627\u0644\u0629","name":"\u0627\u0644\u0627\u0633\u0645","new_here":"\u062c\u062f\u064a\u062f \u0647\u0646\u0627","no_services_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u062e\u062f\u0645\u0627\u062a \u0645\u062a\u0627\u062d\u0629","opening_hours":"\u0633\u0627\u0639\u0627\u062a \u0627\u0644\u0639\u0645\u0644","our_doctor":"\u0637\u0628\u064a\u0628\u0646\u0627","our_team":"\u0641\u0631\u064a\u0642\u0646\u0627","patient_can_book_an_appointment___":"\u064a\u0645\u0643\u0646 \u0644\u0644\u0645\u0631\u064a\u0636 \u062d\u062c\u0632 \u0645\u0648\u0639\u062f \u0645\u0639 \u0627\u0644\u0637\u0628\u064a\u0628 \u0645\u0646 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0645\u0642\u0635\u0648\u062f\u0629 \u0623\u0648 \u0645\u0646 \u0644\u0648\u062d\u0629 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0647.","patient_can_do_registration___":"\u064a\u0645\u0643\u0646 \u0644\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0645\u0646 \u0647\u0646\u0627 \u0628\u0627\u0644\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629.","patient_name":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0631\u064a\u0636","patient_registration":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0631\u064a\u0636","phone":"\u0627\u0644\u0647\u0627\u062a\u0641","qualified_doctors":"\u0623\u0637\u0628\u0627\u0621 \u0645\u0624\u0647\u0644\u0648\u0646","questions_before_booking":"\u0623\u0633\u0626\u0644\u0629 \u0642\u0628\u0644 \u0627\u0644\u062d\u062c\u0632","quick_links":"\u0631\u0648\u0627\u0628\u0637 \u0633\u0631\u064a\u0639\u0629","reason":"\u0633\u0628\u0628","registration":"\u062a\u0633\u062c\u064a\u0644","remember_me":"\u062a\u0630\u0643\u0631\u0646\u064a","satisfied_patient":"\u0645\u0631\u064a\u0636 \u0631\u0627\u0636","saying_about_us":"\u0642\u0648\u0644 \u0639\u0646\u0627","see_what_are_the_patients":"\u0627\u0646\u0638\u0631 \u0645\u0646 \u0647\u0645 \u0627\u0644\u0645\u0631\u0636\u0649","send_an_email":"\u0625\u0631\u0633\u0627\u0644 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","send_message":"\u0625\u0631\u0633\u0627\u0644 \u0631\u0633\u0627\u0644\u0629","send_us_an_email":"\u0623\u0631\u0633\u0644 \u0625\u0644\u064a\u0646\u0627 \u0628\u0631\u064a\u062f\u064b\u0627 \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u064b\u0627","services":"\u0627\u0644\u062e\u062f\u0645\u0627\u062a","sign_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","sign_in_here":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0647\u0646\u0627","sign_up":"\u0627\u0634\u062a\u0631\u0627\u0643","status":"\u0627\u0644\u062d\u0627\u0644\u0629","subject":"\u0627\u0644\u0645\u0648\u0636\u0648\u0639","subscribe":"\u0627\u0634\u062a\u0631\u0627\u0643","take_treatment":"\u062e\u0630 \u0627\u0644\u0639\u0644\u0627\u062c","terms_and_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","testimonial":"\u0634\u0647\u0627\u062f\u0629","timings":"\u0627\u0644\u0645\u0648\u0627\u0639\u064a\u062f","total_doctors":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0623\u0637\u0628\u0627\u0621","total_registered_patient":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u0645\u0631\u0636\u0649 \u0627\u0644\u0645\u0633\u062c\u0644\u064a\u0646","total_services":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u062e\u062f\u0645\u0627\u062a","total_specializations":"\u0625\u062c\u0645\u0627\u0644\u064a \u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","view_more":"\u0639\u0631\u0636 \u0627\u0644\u0645\u0632\u064a\u062f","we_cover_a_big___":"\u0646\u062d\u0646 \u0646\u063a\u0637\u064a \u0645\u062c\u0645\u0648\u0639\u0629 \u0643\u0628\u064a\u0631\u0629 \u0648\u0645\u062a\u0646\u0648\u0639\u0629 \u0645\u0646 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629","we_make_sure_that_your_life_are_in_good_hands":"\u0646\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646 \u062d\u064a\u0627\u062a\u0643 \u0641\u064a \u0623\u064a\u062f \u0623\u0645\u064a\u0646\u0629","we_provide_the_special_tips___":"\u0646\u062d\u0646 \u0646\u0642\u062f\u0645 \u0627\u0644\u0646\u0635\u0627\u0626\u062d \u0648\u0627\u0644\u0646\u0635\u0627\u0626\u062d \u0627\u0644\u062e\u0627\u0635\u0629 \u0644\u0644\u0639\u0644\u0627\u062c \u0627\u0644\u0635\u062d\u064a \u0648\u0645\u0633\u062a\u0648\u0649 \u0639\u0627\u0644\u064d \u0645\u0646 \u0627\u0644\u0623\u0641\u0636\u0644.","working_process":"\u0639\u0645\u0644\u064a\u0629 \u0627\u0644\u0639\u0645\u0644","year_experience":"\u0633\u0646\u0629 \u0645\u0646 \u0627\u0644\u062e\u0628\u0631\u0629"},"weekdays":{"fri":"\u0627\u0644\u0627\u0628","mon":"\u0645","sat":"\u0633","sun":"\u0633","thu":"\u062a\u064a","tue":"\u062a\u064a","wed":"\u062f\u0628\u0644\u064a\u0648"}},"ar.pagination":{"next":"\u0627\u0644\u062a\u0627\u0644\u0649","previous":"\u0627\u0644\u0633\u0627\u0628\u0642"},"ar.passwords":{"reset":"\u062a\u0645\u062a \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","sent":"\u0644\u0642\u062f \u0623\u0631\u0633\u0644\u0646\u0627 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","throttled":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631 \u0642\u0628\u0644 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629.","token":"\u0631\u0645\u0632 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0647\u0630\u0627 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","user":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0646\u0627 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0647\u0630\u0627."},"ar.validation":{"accepted":"\u064a\u062c\u0628 \u0642\u0628\u0648\u0644 \u0627\u0644\u0633\u0645\u0629:.","active_url":"\u0627\u0644\u0633\u0645\u0629: \u0644\u064a\u0633\u062a \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d\u064b\u0627.","after":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","after_or_equal":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f: \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0645\u0633\u0627\u0648\u064a\u064b\u0627 \u0644\u0647.","alpha":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0625\u0644\u0627 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641.","alpha_dash":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0625\u0644\u0627 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645 \u0648\u0634\u0631\u0637\u0627\u062a \u0648\u0634\u0631\u0637\u0627\u062a \u0633\u0641\u0644\u064a\u0629.","alpha_num":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0625\u0644\u0627 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645.","array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0645\u0635\u0641\u0648\u0641\u0629.","attributes":[],"before":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0642\u0628\u0644: \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","before_or_equal":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0642\u0628\u0644: \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0645\u0633\u0627\u0648\u064a\u064b\u0627 \u0644\u0647.","between":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0645\u0627 \u0628\u064a\u0646: min \u0648: max items.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0628\u064a\u0646: min \u0648: max \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0628\u064a\u0646: min \u0648: max.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0628\u064a\u0646: min \u0648: max \u0645\u0646 \u0627\u0644\u0623\u062d\u0631\u0641."},"boolean":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0635\u062d\u064a\u062d\u064b\u0627 \u0623\u0648 \u062e\u0637\u0623.","confirmed":"\u062a\u0623\u0643\u064a\u062f \u0627\u0644\u0633\u0645\u0629 \u063a\u064a\u0631 \u0645\u0637\u0627\u0628\u0642.","current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","custom":{"attribute-name":{"rule-name":"\u0631\u0633\u0627\u0644\u0629 \u0645\u062e\u0635\u0635\u0629"}},"date":"\u0627\u0644\u0633\u0645\u0629: \u0644\u064a\u0633\u062a \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0635\u0627\u0644\u062d\u064b\u0627.","date_equals":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u062a\u0627\u0631\u064a\u062e \u064a\u0633\u0627\u0648\u064a: date.","date_format":"\u0627\u0644\u0633\u0645\u0629: \u0644\u0627 \u062a\u062a\u0648\u0627\u0641\u0642 \u0645\u0639 \u0627\u0644\u062a\u0646\u0633\u064a\u0642: \u0627\u0644\u062a\u0646\u0633\u064a\u0642.","different":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0648: \u0623\u062e\u0631\u0649 \u0645\u062e\u062a\u0644\u0641\u0629.","digits":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0631\u0642\u0627\u0645 \u0623\u0631\u0642\u0627\u0645.","digits_between":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0628\u064a\u0646: min \u0648: max \u0623\u0631\u0642\u0627\u0645.","dimensions":"\u0627\u0644\u0633\u0645\u0629 \u0644\u0647\u0627 \u0623\u0628\u0639\u0627\u062f \u0635\u0648\u0631\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","distinct":"\u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0639\u0644\u0649 \u0642\u064a\u0645\u0629 \u0645\u0643\u0631\u0631\u0629.","email":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u0627\u0644\u062d.","ends_with":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0646\u062a\u0647\u064a: \u0627\u0644\u0633\u0645\u0629 \u0628\u0623\u062d\u062f \u0645\u0627 \u064a\u0644\u064a: \u0627\u0644\u0642\u064a\u0645.","exists":"\u0627\u0644\u0633\u0645\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0645\u0644\u0641\u064b\u0627.","filled":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0639\u0644\u0649 \u0642\u064a\u0645\u0629.","gt":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: \u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u0642\u064a\u0645\u0629.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: \u0627\u0644\u0642\u064a\u0645\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: \u0627\u0644\u0642\u064a\u0645\u0629.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"gte":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0639\u0646\u0627\u0635\u0631 \u0642\u064a\u0645\u0629 \u0623\u0648 \u0623\u0643\u062b\u0631.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: \u0627\u0644\u0642\u064a\u0645\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: value.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"image":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0635\u0648\u0631\u0629.","in":"\u0627\u0644\u0633\u0645\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","in_array":"\u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629: \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a: \u0623\u062e\u0631\u0649.","integer":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0639\u062f\u062f\u064b\u0627 \u0635\u062d\u064a\u062d\u064b\u0627.","ip":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646\u0648\u0627\u0646 IP \u0635\u0627\u0644\u062d\u064b\u0627.","ipv4":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646\u0648\u0627\u0646 IPv4 \u0635\u0627\u0644\u062d\u064b\u0627.","ipv6":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646\u0648\u0627\u0646 IPv6 \u0635\u0627\u0644\u062d\u064b\u0627.","json":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0633\u0644\u0633\u0644\u0629 JSON \u0635\u0627\u0644\u062d\u0629.","lt":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0623\u0642\u0644 \u0645\u0646: \u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u0642\u064a\u0645\u0629.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646: value \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646: \u0627\u0644\u0642\u064a\u0645\u0629.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"lte":{"array":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: \u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u0642\u064a\u0645\u0629.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: value \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: \u0627\u0644\u0642\u064a\u0645\u0629.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0642\u0644 \u0645\u0646 \u0623\u0648 \u062a\u0633\u0627\u0648\u064a: \u0623\u062d\u0631\u0641 \u0627\u0644\u0642\u064a\u0645\u0629."},"max":{"array":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646: max items.","file":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: \u0623\u0642\u0635\u0649 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: max.","string":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0623\u0643\u0628\u0631 \u0645\u0646: max \u062d\u0631\u0641\u064b\u0627."},"mimes":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: \u0627\u0644\u0642\u064a\u0645.","mimetypes":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: \u0627\u0644\u0642\u064a\u0645.","min":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 \u0639\u0644\u0649: min \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u062a\u0642\u0644 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646: \u062f\u0642\u064a\u0642\u0629 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: min.","string":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u062a\u0642\u0644 \u0627\u0644\u0633\u0645\u0629: \u0639\u0646: min \u062d\u0631\u0641\u064b\u0627."},"multiple_of":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0645\u0646 \u0645\u0636\u0627\u0639\u0641\u0627\u062a: \u0627\u0644\u0642\u064a\u0645\u0629.","not_in":"\u0627\u0644\u0633\u0645\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u0629: \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","not_regex":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0633\u0645\u0629: \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629 \u0631\u0642\u0645\u064b\u0627.","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","present":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0648\u062c\u0648\u062f\u064b\u0627.","prohibited":": \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u062d\u0638\u0648\u0631.","prohibited_if":"\u064a\u064f\u062d\u0638\u0631: \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0622\u062e\u0631 \u0647\u0648: \u0627\u0644\u0642\u064a\u0645\u0629.","prohibited_unless":"\u064a\u064f\u062d\u0638\u0631: \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0627 \u0644\u0645: \u0627\u0644\u0622\u062e\u0631 \u0641\u064a: \u0627\u0644\u0642\u064a\u0645.","regex":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0633\u0645\u0629: \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","required":": \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628.","required_if":"\u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628\u064b\u0627 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0622\u062e\u0631 \u0647\u0648: \u0627\u0644\u0642\u064a\u0645\u0629.","required_unless":"\u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629: \u0645\u0637\u0644\u0648\u0628 \u0625\u0644\u0627 \u0625\u0630\u0627 \u0643\u0627\u0646 \u0627\u0644\u0622\u062e\u0631 \u0641\u064a: \u0627\u0644\u0642\u064a\u0645.","required_with":"\u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0642\u064a\u0645 \u0645\u0648\u062c\u0648\u062f\u0629.","required_with_all":"\u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628\u064b\u0627 \u0639\u0646\u062f\u0645\u0627 \u062a\u0643\u0648\u0646: \u0627\u0644\u0642\u064a\u0645 \u0645\u0648\u062c\u0648\u062f\u0629.","required_without":"\u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627: \u0627\u0644\u0642\u064a\u0645 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629.","required_without_all":"\u064a\u0643\u0648\u0646 \u062d\u0642\u0644 \u0627\u0644\u0633\u0645\u0629 \u0645\u0637\u0644\u0648\u0628\u064b\u0627 \u0641\u064a \u062d\u0627\u0644\u0629 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0623\u064a \u0645\u0646 \u0642\u064a\u0645:.","same":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642 \u0627\u0644\u0633\u0645\u0629: \u0648: other.","size":{"array":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u0645\u0629: \u0639\u0644\u0649 \u0639\u0646\u0627\u0635\u0631 \u0627\u0644\u062d\u062c\u0645.","file":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0627\u0644\u062d\u062c\u0645 \u0643\u064a\u0644\u0648\u0628\u0627\u064a\u062a.","numeric":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0627\u0644\u062d\u062c\u0645.","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u062d\u062c\u0645 \u0627\u0644\u0623\u062d\u0631\u0641."},"starts_with":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0628\u062f\u0623 \u0627\u0644\u0633\u0645\u0629: \u0628\u0623\u062d\u062f \u0627\u0644\u0642\u064a\u0645 \u0627\u0644\u062a\u0627\u0644\u064a\u0629:","string":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0633\u0644\u0633\u0644\u0629.","timezone":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: \u0645\u0646\u0637\u0642\u0629 \u0635\u0627\u0644\u062d\u0629.","unique":"\u062a\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0633\u0645\u0629:.","uploaded":"\u0641\u0634\u0644 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0633\u0645\u0629:.","url":"\u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0633\u0645\u0629: \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","uuid":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0633\u0645\u0629: UUID \u0635\u0627\u0644\u062d\u064b\u0627."},"ca.livewire-tables::strings":{"All":"Tot","Applied Filters":"Filtres Aplicats","Applied Sorting":"Ordenaci\u00f3 Aplicada","Bulk Actions":"Accions Massives","Clear":"Esborra","Columns":"Columnes","Done Reordering":"Reordenaci\u00f3 finalitzada","Filters":"Filtres","No items found. Try to broaden your search.":"No s'han trobat elements. Intenti ampliar la cerca.","Remove filter option":"Elimina opci\u00f3 de filtre","Remove sort option":"Elimina opci\u00f3 d'ordenaci\u00f3","Reorder":"Reordena","Search":"Cerca","Select All":"Selecciona tot","Showing":"Mostrant","Unselect All":"Deselecciona tot","You are currently selecting all":"Actualment est\u00e0 seleccionant tot","You are not connected to the internet.":"No est\u00e0 conectat a Internet.","You have selected":"Ha seleccionat","of":"de","results":"resultats","row":"fila","rows":"files","rows, do you want to select all":"files, vol seleccionar totes","to":"a"},"de.auth":{"app":{"create":"Erstellen","export":"Exportieren","lock_account":"Konto sperren","member_since":"Mitglied seit","messages":"Nachrichten","online":"Online","print":"Drucken","profile":"Profil","reload":"Neu laden","reset":"Zur\u00fccksetzen","search":"Suche","settings":"Einstellungen"},"confirm_password":"Passwort best\u00e4tigen","email":"E-Mail","emails":{"password":{"reset_link":"Klicken Sie hier, um Ihr Passwort zur\u00fcckzusetzen"}},"failed":"Diese Zugangsdaten stimmen nicht mit unseren Aufzeichnungen \u00fcberein.","forgot_password":{"send_pwd_reset":"Link zum Zur\u00fccksetzen des Passworts senden","title":"E-Mail eingeben, um das Passwort zur\u00fcckzusetzen"},"full_name":"Vollst\u00e4ndiger Name","login":{"forgot_password":"Ich habe mein Passwort vergessen","register_membership":"Neue Mitgliedschaft registrieren","title":"Melden Sie sich an, um Ihre Sitzung zu starten"},"password":"Passwort","register":"Registrieren","registration":{"have_membership":"Ich habe bereits eine Mitgliedschaft","i_agree":"Ich stimme zu","terms":"die Begriffe","title":"Neue Mitgliedschaft registrieren"},"remember_me":"Erinnere dich an mich","reset_password":{"reset_pwd_btn":"Passwort zur\u00fccksetzen","title":"Passwort zur\u00fccksetzen"},"sign_in":"Anmelden","sign_out":"Abmelden","throttle":"Zu viele Anmeldeversuche. Bitte versuchen Sie es in :Sekunden Sekunden erneut."},"de.livewire-tables::strings":{"All":"Alle","Applied Filters":"Angewendete Filter","Applied Sorting":"Angewendete Sortierung","Bulk Actions":"Aktionen","Clear":"Zur\u00fccksetzen","Columns":"Spalten","Done Reordering":"Sortieren abgeschlossen","Filters":"Filter","No items found. Try to broaden your search.":"Es gibt keine Ergebnisse\/Eintr\u00e4ge. Versuche die Suche zu erweitern.","Remove filter option":"Entferne Filterauswahl","Remove sort option":"Entferne Sortierauswahl","Reorder":"erneut Sortieren","Search":"Suche","Select All":"Alle ausw\u00e4hlen","Showing":"Anzeigen","Unselect All":"Alle abw\u00e4hlen","You are currently selecting all":"Es sind schon alle ausgew\u00e4hlt","You are not connected to the internet.":"Es liegt keine Verbindung zum Internet vor.","You have selected":"Es sind ausgew\u00e4hlt","of":"von","results":"Ergebnisse","rows":"Zeilen","rows, do you want to select all":"Zeilen, sollen alle ausgew\u00e4hlt werden","to":"nach"},"de.messages":{"admin_dashboard":{"dashboard":"Dashboard","day":"Tag","earnings_from_appointments":"Einnahmen aus Terminen","filter_options":"Filteroptionen","month":"Monat","name":"Name","patient_id":"Eindeutige Patienten-ID","recent_patients_registration":"Neue Patientenregistrierung","registered":"Registriert","today_appointments":"Heute Termine","today_registered_patients":"Heute registrierte Patienten","total_doctor":"\u00c4rzte insgesamt","total_patients":"Gesamtpatienten","week":"Woche"},"appointment":{"Select_payment_method":"W\u00e4hlen Sie die Zahlungsmethode","add_new_appointment":"Termin hinzuf\u00fcgen","appointment_at":"Termin um","appointment_date":"Termintermin","appointment_details":"Termindetails","appointment_status":"Terminstatus","appointment_unique_id":"Termin-ID","appointments":"Termine","appointments_schedule":"Terminplan","authorize_session_created_successfully":"Autorisierungssitzung erfolgreich erstellt.","available":"Verf\u00fcgbar","available_slot":"Verf\u00fcgbare Slots","booked":"Gebucht","calendar":"Kalender","cancel_appointment":"Termin stornieren","cancelled":"Storniert","charge":"Laden","check_in":"Einchecken","check_out":"Auschecken","date":"Datum","description":"Beschreibung","edit_appointment":"Termin bearbeiten","ends":"Ende","extra_fees":"Zus\u00e4tzliche Geb\u00fchren","no_slot_found":"Keine Zeitfenster gefunden.","patient":"Patient","patient_id":"Patienten-ID","patient_name_retrieved":"Patientenname erfolgreich abgerufen","payable_amount":"Zahlbarer Betrag","payment":"Zahlung","payment_method":"Bezahlverfahren","payment_status":"Zahlungsstatus","service":"Dienst","service_charge":"Servicegeb\u00fchr","session_created_successfully":"Sitzung erfolgreich erstellt","session_id_required":"Sitzungs-ID ist erforderlich","starts":"Startet","status":"Status","switch_to_calendar":"Zum Kalender wechseln","time":"Zeit","total_payable_amount":"Zahlbarer Gesamtbetrag","upcoming_meetings":"anstehende Treffen"},"appointments":"Termine","apps":"Apps","card_number_invalid..":"Kartennummer ist ung\u00fcltig.","card_type":"Kreditkartentyp","cities":"St\u00e4dte","city":{"add_city":"Stadt hinzuf\u00fcgen","city":"Stadt","edit_city":"Stadt bearbeiten","state":"Staat"},"clinic_schedules":"Klinikpl\u00e4ne","cms":{"Terms_Conditions_required":"Allgemeine Gesch\u00e4ftsbedingungen sind erforderlich","about_image":"\u00dcber Bild","cms":"CMS","description_no_white_space":"Das Feld \u201eKurzbeschreibung\u201c enth\u00e4lt nicht nur Leerzeichen","experience_required":"Das Feld \u201e\u00dcber Erfahrung\u201c ist erforderlich.","privacy_policy":"Datenschutzerkl\u00e4rung","privacy_policy_required.":"Die Datenschutzerkl\u00e4rung ist erforderlich.","terms_conditions":"Allgemeine Gesch\u00e4ftsbedingungen","title_no_white_space":"Das Feld \u201e\u00dcber den Titel\u201c enth\u00e4lt nicht nur Leerzeichen"},"common":{"Attempt_read_property_access_token_null":"Versuchen Sie, die Eigenschaft \u201eaccess_token\u201c auf Null zu lesen","Forgot_password_lable":"Haben Sie Ihr Passwort vergessen? Kein Problem. Teilen Sie uns einfach Ihre E-Mail-Adresse mit und wir senden Ihnen einen Link zum Zur\u00fccksetzen Ihres Passworts, \u00fcber den Sie ein neues Passwort ausw\u00e4hlen k\u00f6nnen.","action":"Aktion","active":"Aktiv","add":"Hinzuf\u00fcgen","add_credential":"Bitte f\u00fcgen Sie Zoom-Zugangsdaten hinzu","age":"Alter","any_one_permission":"Bitte w\u00e4hlen Sie eine beliebige Berechtigung aus.","apply":"Bewerben","appointment_date_required":"Das Feld \u201eTermindatum\u201c ist erforderlich.","are_you_sure":"M\u00f6chten Sie dies wirklich l\u00f6schen?","are_you_sure_cancel":"M\u00f6chten Sie dies wirklich abbrechen?","back":"Zur\u00fcck","booked":"Gebucht","brand_required":"Das Markenfeld ist erforderlich.","cancel":"Abbrechen","cancelled":"Abgesagt","cancelled_appointment":"Termin abgesagt !","category_required":"Das Kategoriefeld ist erforderlich.","change_image":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","check in":"Check-In","check out":"Kasse","city":"Stadt","confirm":"Best\u00e4tigen","connected_zoom":"Erfolgreich mit Zoom verbunden.","contact_number":"Kontaktnummer ist","country":"Land","custom":"Brauch","de_active":"Deaktivieren","default_language":"Standardsprache","delete":"L\u00f6schen","deleted":"\u00a1Eliminado!","details":"Details","discard":"Verwerfen","doctor_required":"Das Feld \u201eArzt\u201c ist erforderlich.","download":"Herunterladen","edit":"Bearbeiten","email_already_exist":"Die E-Mail wurde bereits abonniert.","email_max":"Die maximale E-Mail-Gr\u00f6\u00dfe betr\u00e4gt 255.","email_not_register":"E-Mail ist nicht registriert.","email_regex":"Das E-Mail-Feld muss ein g\u00fcltiges Format haben.","email_required":"Das E-Mail-Feld ist erforderlich.","email_verified":"Email \u00fcberpr\u00fcft","error":"Error","filter":"Filter","filter_option":"Filteroption","first_name_required":"Das Feld \u201eVorname\u201c ist erforderlich. ","forgot_your_password":"Haben Sie Ihr Passwort vergessen","from":"Aus","google_captcha_required":"Das Google-Captcha-Feld ist erforderlich.","has_been":"ha sido eliminado.","has_cancel":" wurde abgebrochen.","hour":"Stunde","impersonate":"Imitieren","instagram_url":"Instagram-URL","last_name_required":"Das Feld \u201eNachname\u201c ist erforderlich.","linkedin_url":"Linkedin-URL","logout":"Ausloggen","maximum_55":"Maximal 55 Zeichen zul\u00e4ssig.","message_required":"Das Nachrichtenfeld ist erforderlich.","minutes":"Protokoll","n\/a":"N\/A","name":"Name","name_already_taken":"Der Name ist bereits vergeben","name_required":"Das Namensfeld ist erforderlich","no":"Nein, Abbrechen","no_data_available":"Keine Daten verf\u00fcgbar","no_data_available_in_table":"Keine Daten in der Tabelle verf\u00fcgbar","no_records_found":"Keine Datens\u00e4tze gefunden.","not_allow__assess_record":"Anscheinend sind Sie nicht berechtigt, auf diesen Datensatz zuzugreifen.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Hinweis: Wir verwenden die Zeitzone Ihrer \u00c4rzte, w\u00e4hrend wir einen Termin im Kalender erstellen. Wenn der Arzt die Zeitzone nicht eingestellt hat, wird die UTC-Standardzeitzone verwendet.","note_white_space":"Das Hinweisfeld enth\u00e4lt nicht nur Leerzeichen","observation_white_space":"Das Beobachtungsfeld enth\u00e4lt nicht nur Leerzeichen.","of":"von","overview":"\u00dcbersicht","payment_type_required":"Das Feld \u201eZahlungsmethode\u201c ist erforderlich.","please_wait":"Bitte warten...","prescription_report":"Rezeptbericht","problem_white_space":"Das Problemfeld enth\u00e4lt nicht nur Leerzeichen","processing":"Wird bearbeitet..","purchase_price":"Kaufpreis","read":"Lesen","remember_me":"Erinnere dich an mich","resend_verification_email":"Best\u00e4tigungsmail erneut senden","reset":"Zur\u00fccksetzen","reset_password":"Passwort zur\u00fccksetzen","results":"Ergebnisse","save":"Speichern","search":"Suche","select_brand":"W\u00e4hlen Sie Marke aus","select_category":"Kategorie w\u00e4hlen","select_city":"Stadt w\u00e4hlen","select_country":"Land ausw\u00e4hlen","select_doctor":"Arzt ausw\u00e4hlen","select_service":"Dienst ausw\u00e4hlen","select_state":"Staat w\u00e4hlen","service":"Dienst","service_required":"Das Feld \u201eDienste\u201c ist erforderlich.","show":"Zeigen","showing":"Zeigt","state":"Staat","subject_required":"Das Betrefffeld ist erforderlich.","submit":"Senden","to":"Zu","twitter_url":"Twitter-URL","unread":"Ungelesen","verify_lable1":"Danke f\u00fcr's Registrieren! Bevor Sie beginnen, k\u00f6nnen Sie Ihre E-Mail-Adresse best\u00e4tigen, indem Sie auf den Link klicken, den wir Ihnen gerade per E-Mail zugesandt haben. Wenn Sie die E-Mail nicht erhalten haben, senden wir Ihnen gerne eine neue zu.","verify_lable2":"Ein neuer Best\u00e4tigungslink wurde an die E-Mail-Adresse gesendet, die Sie bei der Registrierung angegeben haben.","view":"Aussicht","years":"Jahre","yes":"Ja, l\u00f6schen!","yes_update":"\u00a1S\u00ed, actualizaci\u00f3n!","zoom_credentials":"Bitte f\u00fcgen Sie Zoom-Zugangsdaten hinzu."},"countries":"L\u00e4nder","country":{"add_country":"Land hinzuf\u00fcgen","country":"Land","short_code":"Kurzcode"},"currencies":"W\u00e4hrungen","currency":{"add_currency":"W\u00e4hrung hinzuf\u00fcgen","add_currency_code_as_per_three_letter_iso_code":"F\u00fcgen Sie den W\u00e4hrungscode gem\u00e4\u00df dem dreistelligen ISO-Code hinzu","currency_code":"W\u00e4hrungscode","currency_icon":"W\u00e4hrungssymbol","currency_name":"W\u00e4hrungsname","edit_currency":"W\u00e4hrung bearbeiten","name":"Name","you_can_find_out_here":"das erf\u00e4hrst du hier"},"cvv_invalid.":"CVV ist ung\u00fcltig.","cvv_number_required.":"CVV-Nummernfelder sind erforderlich.","dashboard":"Dashboard","datepicker":{"last_30_days":"Letzte 30 Tage","last_month":"Im vergangenen Monat","last_week":"Letzte Woche","this_month":"Diesen Monat","this_week":"In dieser Woche","today":"Heute","yesterday":"Gestern"},"doctor":{"add":"Arzt hinzuf\u00fcgen","add_qualification":"Qualifikation hinzuf\u00fcgen","address1":"Adresse 1","address2":"Adresse 2","address_information":"Adressinformationen","allowed_img":"Erlaubte Dateitypen: png, jpg, jpeg.","city":"Stadt","collage_university":"COLLAGE\/UNIVERSIT\u00c4T","country":"Land","created_at":"Erstellt am","degree":"Abschluss","dob":"Geburtstag","doctor":"Arzt","doctor_detail":"Arztdetails","edit":"\u00c4rztin bearbeiten","experience":"Erfahrung im Jahr","female":"Weiblich","first_name":"Vorname","instagram":"Instagram","last_name":"Nachname","linkedin":"Linkedin","male":"M\u00e4nnlich","passout_year":"Passionsjahr","postal_code":"Postleitzahl","profile":"Profil","qualification":"Qualifikation","qualification_information":"Qualifikationsinformationen","select_blood_group":"Blutgruppe ausw\u00e4hlen","select_date":"Datum ausw\u00e4hlen","select_doctors":"\u00c4rzte ausw\u00e4hlen","select_gender":"Geschlecht ausw\u00e4hlen","select_year":"Jahr ausw\u00e4hlen","specialization":"Spezialisierung","sr_no":"SR NEIN","state":"Staat","status":"Status","twitter":"Twitter","university":"Universit\u00e4t","updated_at":"Aktualisiert um","year":"Jahr"},"doctor_appointment":{"amount":"Betrag","from_time":"Aus der Zeit","patient":"Patient","service":"Dienst","to_time":"Zur Zeit"},"doctor_appointments":"Arzttermine","doctor_dashboard":{"recent_appointments":"Letzte Termine","total_appointments":"Gesamttermine"},"doctor_session":{"add":"Arztplan hinzuf\u00fcgen","all":"Alle","copy":"Kopieren","doctor":"Arzt","doctor_session":"Arztplan","doctor_session_details":"Details zum Arzttermin","edit":"Arztplan bearbeiten","evening_session":"Abendplan","friday":"Freitag","gap_between_appointment":"L\u00fccke zwischen Termin","monday":"Montag","morning_session":"Morgenplan","my_schedule":"Mein Zeitplan","saturday":"Samstag","select_meeting_time":"Besprechungszeit ausw\u00e4hlen","select_session_gap":"Fahrplanl\u00fccke ausw\u00e4hlen","session":"Sitzung","session_gap":"Zeitplanl\u00fccke","session_meeting_time":"Besprechungszeit planen","session_time_in_minutes":"Besprechungszeit planen","sunday":"Sonntag","thursday":"Donnerstag","tuesday":"Dienstag","unavailable":"Nicht verf\u00fcgbar","wednesday":"Mittwoch","week_days":"Wochentage"},"doctor_sessions":"Arztpl\u00e4ne","doctors":"\u00c4rzte","doctors_scheduled_time_ended_for_today__":"Die geplante Zeit des Arztes ist f\u00fcr heute abgelaufen, bitte w\u00e4hlen Sie einen anderen Arzt oder ein anderes Datum aus","email_password_reset_link":"Link zum Zur\u00fccksetzen des E-Mail-Passworts","enquiries":"Anfragen","expiration_month_required":"Felder f\u00fcr den Ablaufmonat sind erforderlich.","expiration_year_required":"Felder f\u00fcr das Ablaufjahr sind erforderlich.","faq":{"add_faq":"FAQ hinzuf\u00fcgen","answer":"Antwort","edit_faq":"FAQ bearbeiten","question":"Frage"},"faqs":"H\u00e4ufig gestellte Fragen","filter":{"active":"Aktiv","all":"Alle","awaited":"erwartet","booked":"Gebucht","cancelled":"Abgesagt","check in":"Check-In","check out":"Kasse","deactive":"Deaktivieren","finished":"Fertig","paid":"Bezahlt","pending":"Ausstehend","read":"Lesen","unread":"Ungelesen"},"filter_success":"Filtererfolg","flash":{"about_image_validation_message":"Das About-Bild muss ein Dateityp sein: jpg, jpeg, png.","about_us_create":"\u00dcber uns erfolgreich gespeichert.","all_notification_read":"Alle Benachrichtigungen erfolgreich gelesen.","appointment_booked":"Termin erfolgreich gebucht","appointment_cancel":"Termin abgesagt.","appointment_create":"Termin erfolgreich erstellt.","appointment_created_payment_complete":"Termin erfolgreich erstellt und Zahlung abgeschlossen.","appointment_created_payment_not_complete":"Termin erfolgreich erstellt und Zahlung nicht abgeschlossen.","appointment_delete":"Termin erfolgreich gel\u00f6scht.","appointment_not_found":"Termin nicht gefunden","appointment_retrieve":"Terminkalenderdaten erfolgreich abgerufen.","calender_added":"Kalender erfolgreich hinzugef\u00fcgt.","cat_retrieve":"Kategorie erfolgreich abgerufen.","cities_retrieve":"St\u00e4dte erfolgreich abgerufen","city_create":"Stadt erfolgreich erstellt.","city_delete":"Stadt erfolgreich gel\u00f6scht.","city_retrieved":"Stadt erfolgreich abgerufen.","city_update":"Stadt erfolgreich aktualisiert.","city_used":"Stadt woanders verwendet.","clinic_delete":"ClinicSchedule erfolgreich gel\u00f6scht.","clinic_save":"Klinikplan erfolgreich gespeichert.","cms_update":"CMS erfolgreich aktualisiert.","country_create":"Land erfolgreich erstellt.","country_delete":"Land erfolgreich gel\u00f6scht.","country_update":"Land erfolgreich aktualisiert.","country_used":"Land woanders verwendet.","create_blog":"VCard-Blog erfolgreich erstellt.","create_front_testimonial":"Testimonial erfolgreich erstellt.","currency_create":"W\u00e4hrung erfolgreich erstellt.","currency_delete":"W\u00e4hrung erfolgreich gel\u00f6scht.","currency_update":"W\u00e4hrung erfolgreich aktualisiert.","currency_used":"W\u00e4hrung woanders verwendet.","current_invalid":"Aktuelles Passwort ist ung\u00fcltig.","data_retrieve":"Daten erfolgreich abgerufen.","default_role_not_delete":"Standardrolle nicht gel\u00f6scht.","degree_required":"Das Studienfach ist erforderlich.","doctor_appointment":"Arztterminkalenderdaten erfolgreich abgerufen.","doctor_create":"Arzt erfolgreich erstellt.","doctor_delete":"Arzt erfolgreich gel\u00f6scht.","doctor_holiday":"Doctor Holiday erfolgreich erstellt","doctor_not_available":"Arzt nicht erreichbar","doctor_session_not_found":"Arztsitzung nicht gefunden.","doctor_update":"Doktor erfolgreich aktualisiert.","doctor_use":"Arzt erfolgreich eingesetzt.","email_notification":"E-Mail-Benachrichtigung erfolgreich aktualisiert.","email_send":"E-Mail erfolgreich gesendet.","enquire_deleted":"Anfrage erfolgreich gel\u00f6scht.","enquire_sent":"Anfrage erfolgreich gesendet","faq_creat":"FAQ erfolgreich erstellt.","faq_delete":"FAQ erfolgreich gel\u00f6scht.","faq_update":"FAQ erfolgreich aktualisiert.","faq_use":"Diese FAQ wurde woanders verwendet.","favicon_validation_message":"Das Favicon muss ein Dateityp sein: jpg, jpeg, png.","feature_update":"Funktion erfolgreich aktualisiert.","google_calendar_connect":"Ihr Google Kalender ist jetzt verbunden.","google_calendar_disconnect":"Google Kalender wurde erfolgreich getrennt.","google_calendar_update":"Ihr Google Kalender wurde erfolgreich aktualisiert.","holiday_already_is_exist":"F\u00fcr dieses Datum existiert bereits ein Feiertag","icon_validation_message":"Das Symbol muss ein Dateityp sein: jpg, jpeg, png, svg.","language_change":"Sprache erfolgreich ge\u00e4ndert","language_update":"Sprache erfolgreich aktualisiert.","live_consultation_delete":"Live-Konsultation erfolgreich gel\u00f6scht.","live_consultation_retrieved":"Live-Konsultation erfolgreich abgerufen.","live_consultation_save":"Live-Konsultation erfolgreich gespeichert.","live_consultation_update":"Live-Konsultation erfolgreich aktualisiert.","logo_validation_message":"Das Anwendungslogo muss ein Dateityp sein: jpg, jpeg, png.","maximum_char":"Maximal 60 Zeichen erlaubt.","messages_sent":"Nachricht erfolgreich gesendet","no_available_slots":"Zum angegebenen Datum sind keine Slots verf\u00fcgbar.","note_added":"Notiz erfolgreich hinzugef\u00fcgt.","note_delete":"Notiz erfolgreich gel\u00f6scht.","notification_read":"Benachrichtigung erfolgreich gelesen.","notification_send":"E-Mail-Best\u00e4tigungsbenachrichtigung erfolgreich gesendet.","observation_added":"Beobachtung erfolgreich hinzugef\u00fcgt.","observation_delete":"Beobachtung erfolgreich gel\u00f6scht.","operation_performed_success":"Operation erfolgreich durchgef\u00fchrt","order_create":"Bestellung erfolgreich erstellt.","password_update":"Passwort erfolgreich aktualisiert.","patient_appointment":"Patiententerminkalenderdaten erfolgreich abgerufen.","patient_create":"Patient erfolgreich erstellt.","patient_delete":"Patient erfolgreich gel\u00f6scht.","patient_not_found":"Patient nicht gefunden.","patient_update":"Patient erfolgreich aktualisiert.","patient_used":"Patient woanders verwendet.","patients_retrieve":"Patienten erfolgreich gefunden.","payment_status_updated":"Zahlungsstatus erfolgreich aktualisiert.","paystack_token_expired":"Das Paystack-Token ist abgelaufen. Bitte aktualisieren Sie die Seite und versuchen Sie es erneut.","plan_default":"Standardplan erfolgreich ge\u00e4ndert.","plan_status":"Planstatus erfolgreich aktualisiert","plan_update":"Plan erfolgreich aktualisiert.","prescription_delete":"Rezept erfolgreich gel\u00f6scht.","prescription_retrieved":"Rezept erfolgreich abgerufen.","problem_added":"Problem erfolgreich hinzugef\u00fcgt.","problem_delete":"Problem erfolgreich gel\u00f6scht.","profile_validation_message":"Das Profil muss eine Datei des Typs: jpg, jpeg, png sein.","qualification_create":"Qualifikation erfolgreich erstellt.","reactive_account":"Reaktivieren Sie Ihr Konto von Mail.","retrieve":"Erfolgreich abgerufen.","review_add":"Hinzuf\u00fcgen erfolgreich \u00fcberpr\u00fcft.","review_edit":"Bewertung erfolgreich bearbeitet.","review_retrieved":"Bewertung erfolgreich abgerufen.","role_create":"Rolle erfolgreich erstellt.","role_delete":"Rolle erfolgreich gel\u00f6scht.","role_update":"Rolle erfolgreich aktualisiert.","schedule_crete":"Zeitplan erfolgreich erstellt.","schedule_delete":"Zeitplan erfolgreich gel\u00f6scht.","schedule_not_found":"Zeitplan nicht gefunden.","schedule_update":"Zeitplan erfolgreich aktualisiert.","select_calendar.":"Bitte w\u00e4hlen Sie einen Kalender aus.","select_payment":"Bitte w\u00e4hlen Sie eine Zahlungsmethode aus","service_cat_create":"Dienstkategorie erfolgreich erstellt.","service_cat_delete":"Dienstkategorie erfolgreich gel\u00f6scht.","service_cat_update":"Dienstkategorie erfolgreich aktualisiert.","service_cat_use":"Servicekategorie woanders verwendet.","service_create":"Dienst erfolgreich erstellt.","service_delete":"Dienst erfolgreich gel\u00f6scht.","service_update":"Dienst erfolgreich aktualisiert.","service_use":"Dienst woanders verwendet.","session_retrieve":"Sitzung erfolgreich abgerufen.","setting_update":"Einstellungen erfolgreich aktualisiert.","slider_update":"Slider erfolgreich aktualisiert","some_doctors":"Einige \u00c4rzte haben ihre Tage in bestimmten ungepr\u00fcften Tagen geplant, also sind Sie sicher, dass Sie diese Operation durchf\u00fchren m\u00f6chten?","something_went_wrong":"Etwas ist schief gelaufen","specialization_create":"Spezialisierung erfolgreich erstellt.","specialization_delete":"Spezialisierung erfolgreich gel\u00f6scht.","specialization_update":"Spezialisierung erfolgreich aktualisiert.","specialization_use":"Spezialisierung erfolgreich eingesetzt.","staff_create":"Personal erfolgreich erstellt.","staff_delete":"Mitarbeiter erfolgreich gel\u00f6scht.","staff_update":"Mitarbeiter erfolgreich aktualisiert.","staff_use":"Personal erfolgreich eingesetzt.","state_create":"Status erfolgreich erstellt.","state_delete":"Status erfolgreich aktualisiert.","state_update":"Status erfolgreich gel\u00f6scht.","state_use":"Zustand woanders verwendet.","states_retrieve":"Zust\u00e4nde erfolgreich abgerufen.","status_change":"Status erfolgreich ge\u00e4ndert.","status_update":"Status erfolgreich aktualisiert.","subscriber_creat":"Abonnent erfolgreich erstellt.","subscriber_delete":"Abonnent erfolgreich gel\u00f6scht.","testimonial_creat":"Front Patient Testimonial erfolgreich erstellt.","testimonial_delete":"Front Patient Testimonial erfolgreich gel\u00f6scht.","testimonial_update":"Front Patient Testimonial wurde erfolgreich aktualisiert.","testimonial_use":"Front Patient Testimonial erfolgreich verwendet.","theme_change":"Design erfolgreich ge\u00e4ndert.","there_were":"Es gab ein Problem mit der Zahlung. Bitte versuchen Sie es sp\u00e4ter noch einmal.","university_required":"Die Universit\u00e4t ist erforderlich.","update_blog":"VCard-Blog erfolgreich aktualisiert.","update_front_testimonial":"Testimonial erfolgreich aktualisiert.","user_8_or":"Verwenden Sie 6 oder mehr Zeichen mit einer Mischung aus Buchstaben, Zahlen und Symbolen.","user_already_verified":"Benutzer hat bereits E-Mail best\u00e4tigt.","user_profile":"Benutzerprofil erfolgreich aktualisiert.","user_profile_update":"Benutzerprofil erfolgreich aktualisiert.","user_role_not_delete":"Diese Benutzerrolle konnte nicht gel\u00f6scht werden, da sie einem Benutzer zugewiesen ist.","user_status":"Benutzerstatus erfolgreich aktualisiert","user_update":"Benutzer erfolgreich aktualisiert.","user_zoom_credential_saved":"Benutzer-Zoomen-Anmeldeinformationen erfolgreich gespeichert.","valid_instagram":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","valid_linkedin":"Bitte geben Sie eine g\u00fcltige Linkedin-URL ein","valid_twitter":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","verified_email":"E-Mail erfolgreich best\u00e4tigt.","visit_create":"Besuch erfolgreich erstellt.","visit_delete":"L\u00f6schen erfolgreich besucht.","visit_prescription_added":"Besuchsrezept erfolgreich hinzugef\u00fcgt.","visit_prescription_update":"Besuchsrezept erfolgreich aktualisiert.","visit_update":"Besuch erfolgreich aktualisiert.","year_required":"Das Jahr ist erforderlich.","your_reg_success":"Ihre Registrierung erfolgreich. Bitte best\u00e4tigen Sie Ihr Konto per E-Mail."},"front_cms":"Front-CMS","front_medical_service":{"add_front_medical_service":"Front\u00e4rztlichen Dienst hinzuf\u00fcgen","edit_front_medical_service":"Front Sanit\u00e4tsdienst bearbeiten","short_description":"Kurze Beschreibung","title":"Titel"},"front_medical_services":"Front\u00e4rztlicher Dienst","front_patient_testimonial":{"add_front_patient_testimonial":"Vorderseite Patientenbericht hinzuf\u00fcgen","designation":"Bezeichnung","edit_front_patient_testimonial":"Vorderseite Patientenbericht bearbeiten","more_patient_feedbacks":"Mehr Patienten-Feedbacks...","name":"Name","patient_testimonials":"Patientenberichte","profile":"Profil","short_description":"Kurze Beschreibung"},"front_patient_testimonials":"Vorderseite Patientenberichte","front_service":{"add_front_service":"Frontservice hinzuf\u00fcgen","edit_front_service":"Frontservice bearbeiten","icon":"Symbol","short_description":"Kurze Beschreibung","title":"Titel"},"front_services":"Frontdienste","holder_name_invalid":"Der Name des Karteninhabers ist ung\u00fcltig.","holder_name_required":"Felder f\u00fcr den Namen des Karteninhabers sind Pflichtfelder.","holder_number_invalid":"Kartennummernfelder sind Pflichtfelder.","holiday":{"add_holiday":"Urlaub hinzuf\u00fcgen","doctor_holiday":"Arzt Urlaub","holiday":"Ferien","holiday_date":"Feiertagsdatum","service_category":"Servicekategorie"},"icon_size":"Die Symbolgr\u00f6\u00dfe sollte weniger als 2 MB betragen","id":"AUSWEIS","image_file_type":"Das Bild muss eine Datei des folgenden Typs sein: jpeg, jpg, png.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","invalid_range":"Ung\u00fcltiger Bereich","live_consultation":{"add_credential":"Anmeldeinformationen hinzuf\u00fcgen","add_live_consultation":"Live-Beratung hinzuf\u00fcgen","awaited":"Erwartet","client_video":"Kundenvideo","consultation_date":"Beratungstermin","consultation_duration_minutes":"Beratungsdauer Minuten","consultation_minutes":"Beratungsprotokoll","consultation_title":"Beratungstitel","created_by":"Erstellt von","created_for":"Hergestellt f\u00fcr","description":"Beschreibung","disabled":"Behindert","duration":"Dauer (in Minuten)","edit_live_consultation":"Live-Beratung bearbeiten","edit_live_meeting":"Live-Meeting bearbeiten","enable":"Erm\u00f6glichen","finished":"Fertig","host_video":"Host-Video","join_now":"Jetzt beitreten","live_consultation_details":"Einzelheiten zur Live-Beratung","new_live_consultation":"Neue Live-Beratung","new_live_meeting":"Neues Live-Meeting","select_consultation_date":"Beratungsdatum ausw\u00e4hlen","select_doctor_name":"Name des Arztes ausw\u00e4hlen","select_patient_name":"Patientennamen ausw\u00e4hlen","staff_list":"Mitarbeiterliste","start_now":"Jetzt anfangen","type":"Typ","type_number":"Nummer eingeben","zoom_api_key":"Zoom-API-Schl\u00fcssel","zoom_api_secret":"Zoom-API-Geheimnis"},"live_consultations":"Live-Beratungen","live_status_retrieved_successfully.":"Live-Status erfolgreich abgerufen.","login":"Anmelden","medicine":{"available_quantity":"verf\u00fcgbare Anzahl","brand":"Marke","brand_name":"Markenname","buying_price":"Kaufpreis","cant_be_deleted":"kann nicht gel\u00f6scht werden","category":"Kategorie","category_id":"Kategorie ID","category_retrieved_successfully":"Medizinkategorie erfolgreich abgerufen.","deleted_successfully":"Erfolgreich gel\u00f6scht","description":"Beschreibung","dosage":"Dosierung","dose_interval":"W\u00e4hlen Sie Dosisintervall","duration":"Dauer","edit_medicine":"Medizin bearbeiten","edit_medicine_brand":"Medizinmarke bearbeiten","edit_medicine_category":"Kategorie \u201eMedizin\u201c bearbeiten","filter_options":"Filteroptionen","medicine":"Medizin","medicine_brands":"Arzneimittelmarken","medicine_brands_details":"Details zur Arzneimittelmarke","medicine_category":"Kategorie Medizin","medicine_category_details":"Details zur Arzneimittelkategorie","medicine_details":"Einzelheiten zu Medikamenten","medicine_name":"Name des Arzneimittels","medicine_retrieved_successfully":"Medizin erfolgreich abgerufen","medicines":"Medikamente","name":"Name","new_brand":"Neue Marke","new_medicine":"Neue Medizin","new_medicine_brand":"Neue Medizinmarke","new_medicine_category":"Kategorie \u201eNeue Medizin\u201c.","no_use":"Nicht in Gebrauch","quantity":"Menge","salt_composition":"Salzzusammensetzung","saved_successfully":"Erfolgreich gespeichert","select_duration":"W\u00e4hlen Sie Dauer aus","selling_price":"Verkaufspreis","side_effects":"Nebenwirkungen","status_updated_successfully":"Status erfolgreich aktualisiert.","updated_successfully":"Erfolgreich geupdated"},"medicine_bills":{"add_medicine_bill":"Arzneimittelrechnung hinzuf\u00fcgen","available_quantity":"Die verf\u00fcgbare Menge von","avl_qty":"Durchschn. Menge","bill_date":"Rechnungsdatum","bill_id":"Rechnungs-ID","bill_number":"Rechnungsnummer","cell_no":"Zellennr","dose_interval":"Dosisintervall","duplicate_medicine":"Es k\u00f6nnen keine doppelten Medikamente hinzugef\u00fcgt werden.","edit_medicine_bill":"Bearbeiten Sie das Arzneimittelgesetz","enter_lot_number":"Geben Sie die Chargennummer ein.","enter_puchase_price":"Kaufpreis eingeben","enter_sale_price":"Geben Sie den Verkaufspreis ein.","is":"Ist","item_name":"Artikelname","medicine_bill":"Medizingesetz","medicine_bill_details":"Einzelheiten zum Arzneimittelgesetz","medicine_bills":"Arzneimittelrechnungen","medicine_not_selected":"Bitte w\u00e4hlen Sie mindestens ein Arzneimittel aus.","medicine_required":"Fachrichtung Medizin ist erforderlich.","net_amount_cant":"Der Nettobetrag darf nicht leer sein.","net_amount_cant_zero":"Der Nettobetrag darf nicht Null sein.","net_amount_not_empty":"Der Nettobetrag darf nicht leer sein.","net_amount_not_zero":"Der Nettobetrag darf nicht Null sein.","new_medicine_bill":"Neues Arzneimittelgesetz","payment_status":"Zahlungsstatus","payment_type":"Zahlungsart","prescription_not_found":"Rezept nicht gefunden","price":"Preis","print_bill":"Rechnung drucken","quantity_should":"Die Menge sollte gr\u00f6\u00dfer als 0 sein.","sale_price":"Verkaufspreis","select_medicine":"W\u00e4hlen Sie Medizin","select_patient":"W\u00e4hlen Sie Patient aus","select_payment_type":"W\u00e4hle eine Zahlmethode aus","tax_amt":"Der Steuerbetrag darf nicht Null oder leer sein.","tax_cannot_be_zero_empty":"Der Steuerbetrag darf nicht Null oder leer sein.","tax_should_be":"Die Steuern sollten weniger als 100 % betragen.","the_discount_shoul":"Der Rabatt sollte geringer sein als der Gesamtbetrag","the_medicine_already_in_use":"Dieses Arzneimittel wird bereits in Arzneimittelrechnungen verwendet. M\u00f6chten Sie es wirklich l\u00f6schen?","update_quantity":"Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge."},"medicine_brands":"Arzneimittelmarken","medicine_categories":"Medizinkategorien","medicines":"Medikamente","mobile_no":"Handy-Nr","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Juli","jun":"Jun","mar":"Besch\u00e4digen","may":"Kann","nov":"Nov","oct":"Okt","sep":"Sep"},"no_response":"Es wurde keine Antwort zur\u00fcckgegeben","not_supported":"nicht unterst\u00fctzt","note":"Hinweis: Sie m\u00fcssen Ihre Zeitzone festlegen, bevor Sie Google Kalender integrieren.","notification":{"mark_all_as_read":"Alles als gelesen markieren","notification":"Benachrichtigungen","you_don`t_have_any_new_notification":"Sie haben keine neue Benachrichtigung"},"patient":{"add":"Patienten hinzuf\u00fcgen","address1":"Adresse 1","address2":"Adresse 2","address_information":"Adressinformationen","blood_group":"Blutgruppe","city":"Stadt","confirm_password":"Passwort best\u00e4tigen","contact_no":"Kontakt-Nr","country":"Land","details":"Patientendaten","dob":"Geburtstag","edit":"Patient bearbeiten","email":"E-Mail","emailverified":"Email \u00fcberpr\u00fcft","enter_email":"Email eingeben","enter_password":"Passwort eingeben","female":"Weiblich","filter":"Filter","first_name":"Vorname","gender":"Geschlecht","last_name":"Nachname","last_updated":"Zuletzt aktualisiert","male":"M\u00e4nnlich","name":"Name","password":"Passwort","patient_unique_id":"Eindeutige Patienten-ID","postal_code":"Postleitzahl","profile":"Profil","registered_on":"Registriert am","save_changes":"\u00c4nderungen speichern","state":"Staat","today":"Heute"},"patient_dashboard":{"completed_appointments":"Abgeschlossene Termine","next_appointment":"N\u00e4chste Termine","today_appointments":"Heute Termine","upcoming_appointments":"Anstehende Termine"},"patients":"Patienten","payment_detail":"Zahlungsdetails","payment_for_booking_appointment_with_doctor":"Zahlung f\u00fcr die Buchung eines Arzttermins","payment_method":{"authorize":"Autorisieren","paypal":"Paypal","paystack":"Lohn","paytm":"Paytm","razorpay":"Rasiererzahlung","stripe":"Streifen"},"paytm":"Zahlung","prescription":{"accident":"Unfall","advice":"Rat","appointment_slot":"Terminslots","available_quantity_of":"Die verf\u00fcgbare Menge von ","breast_feeding":"Stillen","comment":"Kommentar","connect_with_zoom":" Verbinden Sie sich mit Zoomen","current_medication":"Derzeitige Medikamente","diabetic":"Diabetikerin","doctor":"Arzt","dosage":"Dosierung","duration":"Dauer","edit_prescription":"Rezept bearbeiten","female_pregnancy":"Weibliche Schwangerschaft","food_allergies":"Essensallergien","frequency":"Frequenz","health_insurance":"Krankenversicherung","heart_disease":"Herzkrankheit","high_blood_pressure":"Bluthochdruck","is":"Ist","low_income":"Niedriges Einkommen","medical_history":"Krankengeschichte","medicine_name":"Medizinname","name":"Name","new_medicine":"neue Medizin","new_prescription":"Neues Rezept","next_visit":"n\u00e4chster Besuch","not_add_duplicate_medicines":"Es k\u00f6nnen keine doppelten Medikamente hinzugef\u00fcgt werden.","ok":"OK","others":"Andere","patient":"Geduldig","physical_information":"physikalische Informationen","plus_rate":"Impuls Tarif","prescription":"Rezept","prescription_details":"Rezeptdetails","prescription_saved":"Rezept erfolgreich gespeichert.","prescription_updated":"Rezept erfolgreich aktualisiert.","prescriptions":"Rezepte","problem":"Problem","problem_description":"Problembeschreibung","reference":"Referenz","rx":"Empfang","selectMedicine":"W\u00e4hlen Sie ein Medikament aus","surgery":"Chirurgie","temperature":"Temperatur","tendency_bleed":"Tendenz bluten","test":"Pr\u00fcfung","time":"Zeit","total_quantity":"Gesamtmenge"},"privacy_policy":"Datenschutzerkl\u00e4rung","purchase_medicine":{"actions":"Aktionen","amount":"Menge","discount":"Rabatt","dose_duration":"Dosisdauer","expiry_date":"Verfallsdatum","export_to_excel":"Nach Excel exportieren","lot_no":"Lot-Nr.","net_amount":"Netto-Betrag","note":"Notiz","other_details":"Andere Details","payment_mode":"Zahlungsart","payment_note":"Zahlungshinweis","purchase_medicine":"Kaufen Sie Medikamente","purchase_medicine_details":"Details zum Kauf von Arzneimitteln","purchase_medicine_overview":"\u00dcbersicht \u00fcber den Kauf von Arzneimitteln","purchase_medicines":"Kaufen Sie Medikamente","purchase_number":"Kaufnummer","purchased_medicine_success":"Medikament erfolgreich gekauft","quantity":"Menge","tax":"Steuer","tax_amount":"Steuerbetrag","total":"Gesamt"},"range_constructor_requires_trie_parameter":"Der Bereichskonstruktor erfordert einen Trie-Parameter","register":"Registrieren","requires_string_parameter":"rangeWithString erfordert einen String-Parameter","resend_email_verification":"E-Mail-Best\u00e4tigung erneut senden","review":{"add_review":"Bewertung hinzuf\u00fcgen","edit_review":"Bewertung bearbeiten","no_doctors_available_to_give_rating":"Keine \u00c4rzte verf\u00fcgbar, um eine Bewertung abzugeben.","review":"Rezension","write_a_review":"Eine Rezension schreiben"},"reviews":"Bewertungen","role":{"add_role":"Rolle hinzuf\u00fcgen","edit_role":"Rolle bearbeiten","permissions":"Berechtigungen","role":"Rolle","role_permissions":"Rollenberechtigungen","select_all_permissions":"Alle Berechtigungen ausw\u00e4hlen"},"roles":"Rollen","service":{"add_service":"Dienst hinzuf\u00fcgen","category":"Kategorie","charges":"Geb\u00fchren","edit_service":"Dienst bearbeiten","short_description":"Kurze Beschreibung"},"service_categories":"Dienstleistungskategorien","service_category":{"add_category":"Dienstkategorie hinzuf\u00fcgen","edit_category":"Servicekategorie bearbeiten","service_category":"Servicekategorie"},"services":"Dienste","setting":{"address":"Adresse","change_app_logo":"App-Logo \u00e4ndern","change_favicon":"Favicon \u00e4ndern","clinic_name":"Klinikname","connect_google_calendar":"Google Kalender verbinden","connect_your_google_calendar":"Verbinden Sie Ihren Google-Kalender","contact_information":"Kontaktinformationen","currency":"W\u00e4hrung","currency_settings":"W\u00e4hrungseinstellungen","default_country_code":"Standard-L\u00e4ndercode","default_language_suggest":"Durch die Aktualisierung \u00e4ndert sich die gesamte App-Sprache beim Arzt- und Patienten-Login sowie auf der Vorderseite.","disconnect_your_google_calendar":"Verbindung zu Ihrem Google-Kalender trennen","do_not_allow_to_login_without_email_verification":"Anmeldung ohne E-Mail-Verifizierung nicht zulassen","favicon":"Favicon","general":"Allgemein","general_details":"Allgemeine Details","logo":"Logo","postal_code":"Postleitzahl","prefix":"Pr\u00e4fix","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"W\u00e4hlen Sie Ihre Kalender (aus Google Kalender) aus, in denen Sie die Termine erstellen m\u00f6chten","setting":"Einstellung","specialities":"Spezialit\u00e4ten","sync_your_google_calendar":"Ihren Google-Kalender synchronisieren","when_checkbox_disable":"Wenn das Kontrollk\u00e4stchen deaktiviert ist, funktioniert die E-Mail-\u00dcberpr\u00fcfung nicht f\u00fcr neue Benutzer.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Wenn ein Patient einen Termin bei Ihnen bucht, wird in ausgew\u00e4hlten Kalendern ein neuer Termin erstellt","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Wenn Sie einen Termin buchen, wird in ausgew\u00e4hlten Kalendern ein neuer Termin erstellt"},"settings":"Einstellungen","slider":{"add_slider":"Schieberegler hinzuf\u00fcgen","edit_slider":"Schieberegler bearbeiten","image":"Bild","short_description":"Kurze Beschreibung","title":"Titel"},"sliders":"Schieberegler","smart_patient_card":{"add_smart_card":"Intelligente Karte hinzuf\u00fcgen","add_smart_card_templates":"Intelligente Kartenvorlagen hinzuf\u00fcgen","address_show":"Adresse anzeigen","blood_group_show":"Blutgruppe anzeigen","dob_show":"Geburtsdatum anzeigen","edit_patient_card":"Intelligente Karte bearbeiten","email_show":"E-Mail anzeigen","enter_template_name":"Vorlagenname eingeben","for_all_patient":"F\u00fcr alle Patienten","generate_patient_card":"Intelligente Karte generieren","generate_patient_smart_cards":"Intelligente Patientenkarten generieren","header_color":"Kopffarbe","only_one_patient":"Nur ein Patient","patient":"Patient","patient_smart_card_created":"Patienten-Smartcard erfolgreich erstellt.","patient_smart_card_deleted":"Patienten-Smartcard erfolgreich gel\u00f6scht.","phone_show":"Telefon anzeigen","please_selest_patient":"Bitte w\u00e4hlen Sie Patient aus","remaning_patients":"Verbleibende Patienten","select_patient":"Patient ausw\u00e4hlen","select_template":"Vorlage ausw\u00e4hlen","smart_patient_card_templates":"Vorlagen f\u00fcr intelligente Patientenkarten","smart_patient_cards":"Intelligente Patientenkarten","templat_name":"Vorlagenname","template":"Vorlage","template_created":"Vorlage erfolgreich erstellt.","template_deleted":"Vorlage erfolgreich gel\u00f6scht.","template_update":"Vorlagenaktualisierung erfolgreich.","type":"Typ","unique_id_show":"Eindeutige ID anzeigen"},"specialization":{"add_specialization":"Spezialisierung hinzuf\u00fcgen","edit_specialization":"Spezialisierung bearbeiten","retrieved_successfully":"Spezialisierung erfolgreich abgerufen."},"specializations":"Spezialisierungen","staff":{"add_staff":"Personal hinzuf\u00fcgen","confirm_password":"Passwort best\u00e4tigen","contact_no":"Kontakt-Nr","edit_staff":"Personal bearbeiten","email":"E-Mail","female":"Weiblich","first_name":"Vorname","gender":"Geschlecht","last_name":"Nachname","male":"M\u00e4nnlich","password":"Passwort","role":"Rolle","select_role":"Rolle ausw\u00e4hlen","staff":"Personal","staff_details":"Personaldetails"},"staffs":"Mitarbeiter","start_time_invalid":"Die Startzeit des Tages ist ung\u00fcltig","state":{"add_state":"Staat hinzuf\u00fcgen","country":"Land","edit_state":"Status bearbeiten","state":"Staat","states":"Staaten"},"states":"Staaten","subscribers":"Abonnenten","terms_conditions":"Allgemeine Gesch\u00e4ftsbedingungen","too_long":"Zu lang","too_short":"Zu kurz","transaction":{"paid":"bezahlt","payment_accepted_by":"Zahlung akzeptiert von","payment_status":"Zahlungsstatus","pending":"Ausstehend","transaction_detail":"Transaktionsdetails","transaction_id":"Transaktions-ID"},"transactions":"Transaktionen","used_medicine":{"used_at":"Verwendet bei","used_medicine":"Gebrauchte Medizin","used_medicines":"Gebrauchte Medikamente","used_quantity":"Gebrauchte Menge"},"user":{"account":"Konto","account_setting":"Kontoeinstellungen","avatar":"Avatar","change_language":"Sprache \u00e4ndern","change_password":"Passwort \u00e4ndern","confirm_password":"Passwort best\u00e4tigen","contact_number":"Kontaktnummer","current_password":"Aktuelles Passwort","edit_profile":"Profil bearbeiten","email":"E-Mail","email_notification":"Email Benachrichtigung","full_name":"Vollst\u00e4ndiger Name","gender":"Geschlecht","language":"Sprache","new_password":"Neues Passwort","profile_details":"Profildetails","return_to_admin":"Zur\u00fcck zum Administrator","save_changes":"\u00c4nderungen speichern","select_time_zone":"W\u00e4hle Zeitzone aus","setting":"Einstellung","sign_out":"Abmelden","staff_details":"Personaldetails","time_zone":"Zeitzone"},"users":"Benutzer","valid_expiration_date":"Geben Sie ein g\u00fcltiges Ablaufdatum ein.","valid_number":"G\u00fcltige Nummer","visit":{"add_visit":"Besuch hinzuf\u00fcgen","description":"Beschreibung","doctor":"Arzt","edit_visit":"Besuch bearbeiten","enter_note":"Notiz eingeben","enter_observation":"Beobachtung eingeben","enter_problem":"Problem eingeben","notes":"Notizen","observations":"Beobachtungen","patient":"Patient","prescriptions":"Rezepte","problems":"Probleme","title":"Titel","visit_date":"Besuchsdatum","visit_detail":"Besuchsdetails","visit_details":"Besuchsdetails"},"visits":"Besuche","web":{"Meet_best_doctors":"Treffen Sie die besten \u00c4rzte","about_experience":"\u00dcber Erfahrung","about_short_description":"\u00dcber Kurzbeschreibung","about_title":"\u00dcber Titel","about_us":"\u00dcber uns","all_rights_reserved":"Alle Rechte vorbehalten","all_services":"Alle Dienste","already_have_an_account":"Habe bereits ein Konto","already_have_patient_account":"Habe bereits ein Patientenkonto","appointment":"Termin","appointment_now":"Termin jetzt","best_professionals":"Beste Fachleute","book_an_appointment":"Termin buchen","book_appointment":"Einen Termin verabreden","call_us":"Rufen Sie uns an","closed":"Geschlossen","confirm_booking":"Buchung best\u00e4tigen","contact":"Kontakt","contact_us":"Kontakt","contact_us_for_any_information":"Kontaktieren Sie uns f\u00fcr alle Informationen","create_an_account":"Konto erstellen","created_at":"Erstellt am","doctors":"\u00c4rzte","doctors_can_interact___":"\u00c4rzte k\u00f6nnen mit Patienten interagieren und damit verbundene Behandlungen durchf\u00fchren.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Formulieren Sie fehlerfreie Ergebnisse dynamisch, bevor Sie die Ergebnisse integrieren. Integrierte Ressourcen drastisch inkubieren, ohne kosteneffektiv au\u00dferhalb der.","email":"E-Mail","email_address":"E-Mail-Addresse","emergency_help":"Nothilfe","enquiry":"Anfrage","enquiry_details":"Anfragedetails","enter_your_email":"Geben sie ihre E-Mail Adresse ein","enter_your_email_to_subscribe_to_our_newsletter":"Geben Sie Ihre E-Mail-Adresse ein, um unseren Newsletter zu abonnieren","faqs":"H\u00e4ufig gestellte Fragen","forgot_password":"Passwort vergessen","home":"Zuhause","how_we_works":"Wie wir arbeiten","i_agree":"Ich stimme zu","location":"Lage","login":"Anmelden","make_appointment":"Einen Termin machen","medical":"Medizinisch","medical_about_us":"Medizinisch \u00fcber uns","medical_appointment":"\u00c4rztlicher Termin","medical_contact":"Medizinischer Kontakt","medical_doctors":"\u00c4rzte","medical_services":"Medizinische Dienste","medical_treatment":"Medizinische Behandlung","meet_our_team_of_specialists":"Treffen Sie unser Team von Spezialisten","message":"Nachricht","name":"Name","new_here":"Neu hier","no_services_available":"Keine Dienste verf\u00fcgbar","opening_hours":"\u00d6ffnungszeiten","our_doctor":"Unser Arzt","our_team":"Unser Team","patient_can_book_an_appointment___":"Der Patient kann \u00fcber die Landingpage oder \u00fcber sein Login-Panel einen Termin beim Arzt buchen.","patient_can_do_registration___":"Der Patient kann sich von hier aus mit grundlegenden Informationen registrieren.","patient_name":"Patientenname","patient_registration":"Patientenregistrierung","phone":"Telefon","qualified_doctors":"Qualifizierte \u00c4rzte","questions_before_booking":"Fragen vor der Buchung","quick_links":"Schnelllinks","reason":"Grund","registration":"Anmeldung","remember_me":"Erinnere dich an mich","satisfied_patient":"Zufriedener Patient","saying_about_us":"\u00dcber uns sagen","see_what_are_the_patients":"Sehen Sie, was die Patienten sind","send_an_email":"E-Mail senden","send_message":"Nachricht senden","send_us_an_email":"Senden Sie uns eine E-Mail","services":"Dienste","sign_in":"Anmelden","sign_in_here":"Hier anmelden","sign_up":"Anmeldung","status":"Status","subject":"Betreff","subscribe":"Abonnieren","take_treatment":"Behandlung durchf\u00fchren","terms_and_conditions":"Allgemeine Gesch\u00e4ftsbedingungen","testimonial":"Zeugnis","timings":"Zeiten","total_doctors":"\u00c4rzte insgesamt","total_registered_patient":"Gesamt registrierte Patienten","total_services":"Gesamtdienste","total_specializations":"Gesamtspezialisierungen","view_more":"Mehr sehen","we_cover_a_big___":"Wir decken eine gro\u00dfe Vielfalt medizinischer Leistungen ab","we_make_sure_that_your_life_are_in_good_hands":"Wir sorgen daf\u00fcr, dass Ihr Leben in guten H\u00e4nden ist","we_provide_the_special_tips___":"Wir geben die speziellen Tipps und Ratschl\u00e4ge der Gesundheitspflege und des h\u00f6chsten Niveaus.","working_process":"Arbeitsprozess"},"weekdays":{"fri":"FR","mon":"MO","sat":"Sa","sun":"SONNE","thu":"DO","tue":"DI","wed":"HEIRATEN"}},"de.pagination":{"next":"N\u00e4chster","previous":"Bisherige"},"de.passwords":{"password":"Passw\u00f6rter m\u00fcssen mindestens acht Zeichen lang sein und mit der Best\u00e4tigung \u00fcbereinstimmen.","reset":"Dein Passwort wurde zur\u00fcck gesetzt!","sent":"Wir haben Ihren Link zum Zur\u00fccksetzen Ihres Passworts per E-Mail gesendet!","token":"Dieses Token zum Zur\u00fccksetzen des Passworts ist ung\u00fcltig.","user":"Wir k\u00f6nnen keinen Benutzer mit dieser E-Mail-Adresse finden."},"de.validation":{"accepted":"Das :attribute muss akzeptiert werden.","active_url":"Das :attribute ist keine g\u00fcltige URL.","after":"Das :attribute muss ein Datum nach :date sein.","after_or_equal":"Das :attribute muss ein Datum nach oder gleich :date sein.","alpha":"Das :attribute darf nur Buchstaben enthalten.","alpha_dash":"Das :attribute darf nur Buchstaben, Zahlen, Bindestriche und Unterstriche enthalten.","alpha_num":"Das :attribute darf nur Buchstaben und Zahlen enthalten.","array":"Das :attribute muss ein Array sein.","attributes":[],"before":"Das :attribute muss ein Datum vor :date sein.","before_or_equal":"Das :attribute muss ein Datum vor oder gleich :date sein.","between":{"array":"Das :attribute muss zwischen :min und :max liegen.","file":"Das :attribute muss zwischen :min und :max Kilobyte liegen.","numeric":"Das :attribute muss zwischen :min und :max liegen.","string":"Das :attribute muss zwischen den Zeichen :min und :max liegen."},"boolean":"Das :attribute muss wahr oder falsch sein.","confirmed":"Die Best\u00e4tigung des :attribute stimmt nicht \u00fcberein.","current_password":"Das Passwort ist inkorrekt.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"Das :attribute ist kein g\u00fcltiges Datum.","date_equals":"Das :attribute muss ein Datum sein, das dem :date entspricht.","date_format":"Das :attribute stimmt nicht mit dem Format :format \u00fcberein.","different":"Das :attribute und :other muss unterschiedlich sein.","digits":"Das :attribute muss sein :digits Ziffern.","digits_between":"Das :attribute muss zwischen den Ziffern :min und :max liegen.","dimensions":"Das :attribute hat ung\u00fcltige Bildabmessungen.","distinct":"Das :attribute hat einen doppelten Wert.","email":"Das :attribute muss eine g\u00fcltige E-Mail-Adresse sein.","ends_with":"Das :attribute muss mit einem der folgenden Werte enden : :values.","exists":"Das :attribute selected ist ung\u00fcltig.","file":"Das :attribute muss eine Datei sein.","filled":"Das :attribute muss einen Wert haben.","gt":{"array":"Das :attribute muss mehr als :value Elemente enthalten.","file":"Das :attribute muss gr\u00f6\u00dfer sein als :value Kilobyte.","numeric":"Das :attribute muss gr\u00f6\u00dfer als der :value sein.","string":"Das :attribute muss gr\u00f6\u00dfer sein als :value Zeichen."},"gte":{"array":"Das :attribute muss mindestens :value Elemente enthalten.","file":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value Kilobyte sein.","numeric":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value sein.","string":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value zeichen sein."},"image":"Das :attribute muss ein Bild sein.","in":"Das :attribute selected ist ung\u00fcltig.","in_array":"Das :attribute existiert nicht in :other.","integer":"Das :attribute muss eine Ganzzahl sein.","ip":"Das :attribute muss eine g\u00fcltige IP-Adresse sein.","ipv4":"Das :attribute muss eine g\u00fcltige IPv4-Adresse sein.","ipv6":"Das :attribute muss eine g\u00fcltige IPv6-Adresse sein.","json":"Das :attribute muss eine g\u00fcltige JSON-Zeichenfolge sein.","lt":{"array":"Das :attribute muss weniger als :value Elemente enthalten.","file":"Das :attribute muss kleiner als :value Kilobyte sein.","numeric":"Das :attribute muss kleiner als :value sein.","string":"Das :attribute muss kleiner als :value sein."},"lte":{"array":"Das :attribute darf nicht mehr als :value Elemente enthalten.","file":"Das :attribute muss kleiner oder gleich :value Kilobyte sein.","numeric":"Das :attribute muss kleiner oder gleich :value sein.","string":"Das :attribute muss kleiner oder gleich :value zeichen sein."},"max":{"array":"Das :attribute darf nicht mehr als :max Elemente enthalten.","file":"Das :attribute darf nicht gr\u00f6\u00dfer als :max Kilobyte sein.","numeric":"Das :attribute darf nicht gr\u00f6\u00dfer sein als :max.","string":"Das :attribute darf nicht gr\u00f6\u00dfer als :max Zeichen sein."},"mimes":"Das :attribute muss eine Datei vom Typ : :values sein.","mimetypes":"Das :attribute muss eine Datei vom Typ : :values sein.","min":{"array":"Das :attribute muss mindestens :min Elemente enthalten.","file":"Das :attribute muss mindestens :min Kilobyte betragen.","numeric":"Das :attribute muss mindestens :min sein.","string":"Das :attribute muss mindestens :min Zeichen enthalten."},"multiple_of":"Das :Attribut muss ein Vielfaches von :Wert sein.","not_in":"Das :attribute selected ist ung\u00fcltig.","not_regex":"Das :attribute format ist ung\u00fcltig.","numeric":"Das :attribute muss eine Zahl sein.","password":"Das Passwort ist inkorrekt.","present":"Das :attribute muss vorhanden sein.","prohibited":"Das :Attributfeld ist verboten.","prohibited_if":"Das Feld :attribute ist verboten, wenn :other :value ist.","prohibited_unless":"Das Feld :attribute ist verboten, es sei denn, :other ist in :values.","regex":"Das :attribute ist ung\u00fcltig.","required":"Das Feld :attribute ist erforderlich.","required_if":"Das Feld :attribute ist erforderlich, wenn :other ist :value .","required_unless":"Das :attribute ist erforderlich, es sei denn :other befindet sich in: values.","required_with":"Das :attribute ist erforderlich, wenn :values vorhanden ist.","required_with_all":"Das :attribute ist erforderlich, wenn :values vorhanden sind.","required_without":"Das Feld :attribute ist erforderlich, wenn :values nicht vorhanden ist.","required_without_all":"Das Feld :attribute ist erforderlich, wenn keiner der Werte vorhanden ist.","same":"Das :attribute und :other m\u00fcssen \u00fcbereinstimmen.","size":{"array":"Das :attribute muss Elemente der :Gr\u00f6\u00dfe enthalten.","file":"Das :attribute muss :Gr\u00f6\u00dfe Kilobyte sein.","numeric":"Das :attribute muss :size sein.","string":"Das :attribute muss Zeichen der :Gr\u00f6\u00dfe sein."},"starts_with":"Das :attribute muss mit einem der folgenden Werte beginnen : :values.","string":"Das :attribute muss eine Zeichenfolge sein.","timezone":"Das :attribute muss eine g\u00fcltige Zone sein.","unique":"Das :attribute wurde bereits \u00fcbernommen.","uploaded":"Das :attribute konnte nicht hochgeladen werden.","url":"Das :attribute format ist ung\u00fcltig.","uuid":"Das :attribute muss eine g\u00fcltige UUID sein."},"en.auth":{"app":{"create":"Create","export":"Export","lock_account":"Lock Account","member_since":"Member since","messages":"Messages","online":"Online","print":"Print","profile":"Profile","reload":"Reload","reset":"Reset","search":"Search","settings":"Settings"},"confirm_password":"Confirm Password","email":"Email","emails":{"password":{"reset_link":"Click here to reset your password"}},"failed":"These credentials do not match our records.","forgot_password":{"send_pwd_reset":"Send Password Reset Link","title":"Enter Email to reset password"},"full_name":"Full Name","login":{"forgot_password":"I forgot my password","register_membership":"Register a new membership","title":"Sign in to start your session"},"password":"Password","register":"Register","registration":{"have_membership":"I already have a membership","i_agree":"I agree to","terms":"the terms","title":"Register a new membership"},"remember_me":"Remember Me","reset_password":{"reset_pwd_btn":"Reset Password","title":"Reset your password"},"sign_in":"Sign In","sign_out":"Sign out","throttle":"Too many login attempts. Please try again in :seconds seconds."},"en.livewire-tables::strings":{"All":"All","Applied Filters":"Applied Filters","Applied Sorting":"Applied Sorting","Bulk Actions":"Bulk Actions","Clear":"Clear","Columns":"Columns","Done Reordering":"Done Reordering","Filters":"Filters","No items found. Try to broaden your search.":"No items found. Try to broaden your search.","Remove filter option":"Remove filter option","Remove sort option":"Remove sort option","Reorder":"Reorder","Search":"Search","Select All":"Select All","Showing":"Showing","Unselect All":"Unselect All","You are currently selecting all":"You are currently selecting all","You are not connected to the internet.":"You are not connected to the internet.","You have selected":"You have selected","of":"of","results":"results","rows":"rows","rows, do you want to select all":"rows, do you want to select all","to":"to"},"en.messages":{"admin_dashboard":{"dashboard":"Dashboard","day":"Day","earnings_from_appointments":"Earnings From Appointments","filter_options":"Filter Options","month":"Month","name":"Name","patient_id":"Patient Unique Id","recent_patients_registration":"Recent Patients Registration","registered":"Registered","today_appointments":"Today Appointments","today_registered_patients":"Today Registered Patients","total_doctor":"Total Doctors","total_patients":"Total Patients","week":"Week"},"all_rights_reserved":"All rights reserved","appointment":{"Select_payment_method":"Select payment method","add_new_appointment":"Add Appointment","appointment_at":"Appointment At","appointment_date":"Appointment Date","appointment_details":"Appointment Details","appointment_status":"Appointment Status","appointment_unique_id":"Appointment ID","appointments":"Appointments","appointments_schedule":"Appointments schedule","authorize_session_created_successfully":"Authorize session created successfully.","available":"Available","available_slot":"Available Slots","booked":"Booked","calendar":"Calendar","cancel_appointment":"Cancel Appointment","cancelled":"Cancelled","charge":"Charge","check_in":"Check In","check_out":"Check Out","date":"Date","description":"Description","edit_appointment":"Edit Appointment","ends":"Ends","extra_fees":"Extra Fees","no_slot_found":"No time slots found.","patient":"Patient","patient_id":"Patient Id","patient_name_retrieved":"Patient name retrieved successfully","payable_amount":"Payable Amount","payment":"Payment","payment_method":"Payment Method","payment_status":"Payment Status","service":"Service","service_charge":"Service Charge","session_created_successfully":"session created successfully","session_id_required":"session id is required","starts":"Starts","status":"Status","switch_to_calendar":"Switch to Calendar","time":"Time","total_payable_amount":"Total Payable Amount","upcoming_meetings":"upcoming meetings"},"appointments":"Appointments","apps":"Apps","card_number_invalid..":"Card number is invalid.","card_type":"Credit card type","cities":"Cities","city":{"add_city":"Add City","city":"City","edit_city":"Edit City","state":"State"},"clinic_schedules":"Clinic Schedules","cms":{"Terms_Conditions_required":"Terms & Conditions is required","about_image":"About Image","cms":"CMS","description_no_white_space":"About Short Description field is not contain only white space","experience_required":"About Experience field is required.","privacy_policy":"Privacy Policy","privacy_policy_required.":"The Privacy Policy is required.","terms_conditions":"Terms & Conditions","title_no_white_space":"About Title field is not contain only white space"},"common":{"Attempt_read_property_access_token_null":"Attempt to read property \\\"access_token\\\" on null","Forgot_password_lable":"Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.","action":"Action","active":"Active","add":"Add","add_credential":"Please add zoom credentials","age":"Age","any_one_permission":"Please select any one permission.","apply":"Apply","appointment_date_required":"Appointment date field is required.","are_you_sure":"Are you sure want to delete this","are_you_sure_cancel":"Are you sure want to cancel this ","back":"Back","booked":"Booked","brand_required":"The brand field is required.","cancel":"Cancel","cancelled":"Cancelled","cancelled_appointment":"Cancelled Appointment !","category_required":"The category field is required.","change_image":"Change Image","check in":"Check in","check out":"Check out","city":"City","confirm":"Confirm","connected_zoom":"Connected with zoom successfully.","contact_number":"Contact number is ","country":"Country","custom":"Custom","de_active":"Deactivate","default_language":"Default Language","delete":"Delete","deleted":"Deleted!","details":"Details","discard":"Discard","doctor_required":"Doctor field is required.","download":"Download","edit":"Edit","email_already_exist":"The email has already subscribe.","email_max":"Maximum size of email is 255.","email_not_register":"Email is not registered.","email_regex":"The email field must be valid format.","email_required":"Email field is required.","email_verified":"Email Verified","error":"Error","filter":"Filter","filter_option":"Filter Option","first_name_required":"First name field is required. ","forgot_your_password":"Forgot your password","from":"From","google_captcha_required":"Google captcha field is required.","has_been":"has been deleted.","has_cancel":" has been Cancelled.","hour":"Hour","icon":"Icon","impersonate":"Impersonate","instagram_url":"Instagram URL","last_name_required":"Last name field is required.","linkedin_url":"Linkedin URL","logout":"Logout","maximum_55":"Maximum 55 character allow.","message_required":"The message field is required.","minutes":"Minutes","n\/a":"N\/A","name":"Name","name_already_taken":"The name has already been taken.","name_required":"Name field is required","no":"No, Cancel","no_data_available":"No Data Available","no_data_available_in_table":"No data available in table","no_records_found":"No records founds.","not_allow__assess_record":"Seems, you are not allowed to access this record.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Note: We are taking the timezone of your doctors while creating appointment in calendar. If Doctor have not set the timezone then it will take default UTC timezone.","note_white_space":"Note field is not contain only white space.","note_you_must_need_to_set_your_timezone_before_integrating_google_calendar":"Note: You must need to set your timezone\n                                before integrating Google Calendar","observation_white_space":"Observation field is not contain only white space.","of":"of","overview":"Overview","payment_type_required":"Payment Method field is required.","please_wait":"Please wait...","prescription_report":"Prescription Report","problem_white_space":"Problem field is not contain only white space.","processing":"Processing..","purchase_price":"Purchase Price","read":"Read","remember_me":"Remember me","resend_verification_email":"Resend Verification Email","reset":"Reset","reset_password":"Reset Password","results":"results","save":"Save","search":"Search","select_brand":"Select Brand","select_category":"Select Category","select_city":"Select City","select_country":"Select Country","select_doctor":"Select Doctor","select_service":"Select Service","select_state":"Select State","service":"Service","service_required":"Services field is required.","show":"Show","showing":"Showing","state":"State","status":"Status","subject_required":"The subject field is required.","submit":"Submit","to":"to","twitter_url":"Twitter URL","unread":"Unread","verify_lable1":"Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.","verify_lable2":"A new verification link has been sent to the email address you provided during registration.","view":"View","years":"Years","yes":"Yes, Delete!","yes_update":"Yes, Update!","zoom_credentials":"Please add zoom credentials."},"contact_us":"Contact Us","countries":"Countries","country":{"add_country":"Add Country","country":"Country","short_code":"Short Code"},"currencies":"Currencies","currency":{"add_currency":"Add Currency","add_currency_code_as_per_three_letter_iso_code":"Add currency code as per three-letter ISO code","currency_code":"Currency Code","currency_icon":"Currency Icon","currency_name":"Currency Name","edit_currency":"Edit Currency","name":"Name","note":"Note","you_can_find_out_here":"you can find out here"},"cvv_invalid.":"CVV is invalid.","cvv_number_required.":"CVV number fields are required.","dashboard":"Dashboard","datepicker":{"custom":"Custom Range","last_30_days":"Last 30 Days","last_month":"Last Month","last_week":"Last Week","this_month":"This Month","this_week":"This Week","today":"Today","yesterday":"Yesterday"},"doctor":{"add":"Add Doctor","add_qualification":"Add Qualification","address1":"Address 1","address2":"Address 2","address_information":"Address Information","allowed_img":"Allowed file types: png, jpg, jpeg.","city":"City","collage_university":"COLLAGE\/UNIVERSITY","country":"Country","created_at":"Created At","degree":"Degree","dob":"DOB","doctor":"Doctor","doctor_detail":"Doctor Details","doctor_holiday":"Doctor Holidays","edit":"Edit Doctor","experience":"Experience In Year","female":"Female","first_name":"First Name","instagram":"Instagram","last_name":"Last Name","linkedin":"Linkedin","male":"Male","passout_year":"Passout Year","postal_code":"Postal Code","profile":"Profile","qualification":"Qualification","qualification_information":"Qualification Information","select_blood_group":"Select Blood Group","select_date":"Select Date","select_doctors":"Select Doctors","select_gender":" Select Gender","select_year":"Select Year","specialization":" Specialization","sr_no":"SR NO","state":"State","status":"Status","twitter":"Twitter","university":"University","updated_at":"Updated At","year":"Year"},"doctor_appointment":{"amount":"Amount","from_time":"From Time","patient":"Patient","service":"Service","to_time":"To Time"},"doctor_appointments":"Doctor Appointments","doctor_dashboard":{"recent_appointments":"Recent Appointments","total_appointments":"Total Appointments"},"doctor_session":{"add":"Add Doctor Schedule","all":"All","copy":"Copy","doctor":"Doctor","doctor_session":"Doctor Schedule","doctor_session_details":"Doctor Schedule Details","edit":"Edit Doctor Schedule","evening_session":"Evening Schedule","friday":"Friday","gap_between_appointment":"Gap Between Appointment","monday":"Monday","morning_session":"Morning Schedule","my_schedule":"My Schedule","saturday":"Saturday","select_meeting_time":"Select meeting time","select_session_gap":"Select schedule gap","session":"Session","session_gap":"Schedule Gap","session_meeting_time":"Schedule Meeting Time","session_time_in_minutes":"Schedule Meeting Time","sunday":"Sunday","thursday":"Thursday","tuesday":"Tuesday","unavailable":"Unavailable","wednesday":"Wednesday","week_days":"Week Days"},"doctor_sessions":"Doctor Schedules","doctors":"Doctors","doctors_scheduled_time_ended_for_today__":"Doctor's scheduled time ended for today, please select different doctor or date","email_password_reset_link":"Email Password Reset Link","enquiries":"Enquiries","expiration_month_required":"Expiration month fields are required.","expiration_year_required":"Expiration year fields are required.","faq":{"add_faq":"Add FAQ","answer":"Answer","edit_faq":"Edit FAQ","question":"Question"},"faqs":"FAQs","filter":{"active":"Active","all":"All","awaited":"Awaited","booked":"Booked","cancelled":"Cancelled","check in":"Check in","check out":"Check out","deactive":"Deactivate","finished":"Finished","paid":"Paid","pending":"Pending","read":"Read","unread":"Unread"},"filter_success":"filter success","flash":{"about_image_validation_message":"The about image must be a file of type: jpg, jpeg, png.","about_us_create":"About Us saved successfully.","all_notification_read":"All Notification read successfully.","appointment_booked":"Appointment Booked successfully","appointment_cancel":"Appointment Cancelled.","appointment_create":"Appointment created successfully.","appointment_created_payment_complete":"Appointment created successfully and Payment is completed.","appointment_created_payment_not_complete":"Appointment created successfully and Payment is not completed.","appointment_delete":"Appointment deleted successfully.","appointment_not_found":"Appointment not found","appointment_retrieve":"Appointment calendar data retrieved successfully.","calender_added":"Calendar Added Successfully.","cat_retrieve":"Category retrieved successfully.","cities_retrieve":"Cities retrieved successfully","city_create":"City created successfully.","city_delete":"City deleted successfully.","city_retrieved":"City retrieved successfully.","city_update":"City updated successfully.","city_used":"City used somewhere else.","clinic_delete":"ClinicSchedule deleted successfully.","clinic_save":"Clinic Schedule saved successfully.","cms_update":"CMS updated successfully.","country_create":"Country created successfully.","country_delete":"Country deleted successfully.","country_update":"Country updated successfully.","country_used":"Country used somewhere else.","create_blog":"VCard blog created successfully.","create_front_testimonial":"Testimonial created successfully.","currency_create":"Currency created successfully.","currency_delete":"Currency deleted successfully.","currency_update":"Currency updated successfully.","currency_used":"Currency used somewhere else.","current_invalid":"Current password is invalid.","data_retrieve":"Data Retrieved Successfully.","default_role_not_delete":"Default role do not deleted.","degree_required":"The degree field is required.","doctor_appointment":"Doctor Appointment calendar data retrieved successfully.","doctor_create":"Doctor created successfully.","doctor_delete":"Doctor deleted successfully.","doctor_holiday":"Doctor holiday created successfully","doctor_not_available":"Doctor not available","doctor_session_not_found":"Doctor Session not found.","doctor_update":"Doctor updated successfully.","doctor_use":"Doctor used successfully.","email_notification":"Email notification updated successfully.","email_send":"Email send successfully.","enquire_deleted":"Enquiry deleted successfully.","enquire_sent":"Enquiry Sent Successfully","faq_creat":"FAQ created successfully.","faq_delete":"FAQ deleted successfully.","faq_update":"FAQ updated successfully.","faq_use":"This FAQ used somewhere else.","favicon_validation_message":"The favicon must be a file of type: jpg, jpeg, png.","feature_update":"Feature updated successfully.","google_calendar_connect":"Your Google Calendar is now connected.","google_calendar_disconnect":"Google Calendar disconnected successfully.","google_calendar_update":"Your Google Calendar updated successfully.","holiday_already_is_exist":"Holiday already exists for this date","icon_validation_message":"The icon must be a file of type: jpg, jpeg, png, svg.","language_change":"Language changed successfully","language_update":"Language updated successfully.","live_consultation_delete":"Live Consultation deleted successfully.","live_consultation_retrieved":"Live Consultation retrieved successfully.","live_consultation_save":"Live Consultation saved successfully.","live_consultation_update":"Live Consultation updated successfully.","logo_validation_message":"The app logo must be a file of type: jpg, jpeg, png.","maximum_char":"Maximum 60 character allow.","messages_sent":"Message Send Successfully","no_available_slots":"There is no available slots on given date.","note_added":"Note added successfully.","note_delete":"Note delete successfully.","notification_read":"Notification read successfully.","notification_send":"Email verification notification send successfully.","observation_added":"Observation added successfully.","observation_delete":"Observation delete successfully.","operation_performed_success":"Operation performed successfully","order_create":"Order created successfully.","password_update":"Password updated successfully.","patient_appointment":"Patient Appointment calendar data retrieved successfully.","patient_create":"Patient created successfully.","patient_delete":"Patient deleted successfully.","patient_not_found":"Patient not found.","patient_update":"Patient updated successfully.","patient_used":"Patient used somewhere else.","patients_retrieve":"Patients retrieved successfully.","payment_status_updated":"Payment status updated successfully.","paystack_token_expired":"The paystack token has expired. Please refresh the page and try again.","plan_default":"Default plan changed successfully.","plan_status":"Plan status updated successfully","plan_update":"Plan updated successfully.","prescription_delete":"Prescription delete successfully.","prescription_retrieved":"Prescription retrieved successfully.","problem_added":"Problem added successfully.","problem_delete":"Problem delete successfully.","profile_validation_message":"The image must be a file of type: jpg, jpeg, png.","qualification_create":"Qualification created successfully.","reactive_account":"Reactivate your account from mail.","retrieve":"Retrieved successfully.","review_add":"Review add successfully.","review_edit":"Review edited successfully.","review_retrieved":"Review retrieved successfully.","role_create":"Role created successfully.","role_delete":"Role deleted successfully.","role_update":"Role updated successfully.","schedule_crete":"Schedule created successfully.","schedule_delete":"Schedule deleted successfully.","schedule_not_found":"Schedule not found.","schedule_update":"Schedule updated successfully.","select_calendar.":"Please select a calendar.","select_payment":"Please select any one Payment Method","service_cat_create":"Service category created successfully.","service_cat_delete":"Service category delete successfully.","service_cat_update":"Service category updated successfully.","service_cat_use":"Service category used somewhere else.","service_create":"Service created successfully.","service_delete":"Service delete successfully.","service_update":"Service updated successfully.","service_use":"Service used somewhere else.","session_retrieve":"Session retrieved successfully.","setting_update":"Settings updated successfully.","slider_update":"Banner updated successfully","some_doctors":"Some doctors have scheduled their days in given unchecked days, so are you sure you want to perform this operation?","something_went_wrong":"Something went wrong","specialization_create":"Specialization created successfully.","specialization_delete":"Specialization delete successfully.","specialization_update":"Specialization updated successfully.","specialization_use":"Specialization used successfully.","staff_create":"Staff created successfully.","staff_delete":"Staff delete successfully.","staff_update":"Staff updated successfully.","staff_use":"Staff used successfully.","state_create":"State created successfully.","state_delete":"State updated successfully.","state_update":"State deleted successfully.","state_use":"State used somewhere else.","states_retrieve":"States retrieved successfully.","status_change":"Status changed successfully.","status_update":"Status updated successfully.","subscriber_creat":"Subscriber created successfully.","subscriber_delete":"Subscriber deleted successfully.","testimonial_creat":"Front Patient Testimonial created successfully.","testimonial_delete":"Front Patient Testimonial delete successfully.","testimonial_update":"Front Patient Testimonial update successfully.","testimonial_use":"Front Patient Testimonial used successfully.","theme_change":"Theme Changed Successfully.","there_were":"There were some issue with the payment. Please try again later.","university_required":"The university is required.","update_blog":"VCard blog updated successfully.","update_front_testimonial":"Testimonial updated successfully.","user_8_or":"Use 6 or more characters with a mix of letters, numbers & symbols.","user_already_verified":"User has already email Verified.","user_profile":"User profile updated successfully.","user_profile_update":"User profile updated successfully.","user_role_not_delete":"This user role could not be deleted, because it\u2019s assigned to a user.","user_status":"User status updated successfully","user_update":"User updated successfully.","user_zoom_credential_saved":"User Zoom Credential saved successfully.","valid_instagram":"Please enter a valid Instagram Url","valid_linkedin":"Please enter a valid Linkedin Url","valid_twitter":"Please enter a valid Twitter Url","verified_email":"Email verified successfully.","visit_create":"Visit created successfully.","visit_delete":"Visit delete successfully.","visit_prescription_added":"Visit Prescription added successfully.","visit_prescription_update":"Visit Prescription updated successfully.","visit_update":"Visit updated successfully.","year_required":"The year is required.","your_reg_success":"Your registration successfully.Please Verify your account from email."},"front_cms":"Front CMS","front_faqs":"FAQs","front_medical_service":{"add_front_medical_service":"Add Front Medical Service","edit_front_medical_service":"Edit Front Medical Service","short_description":"Short Description","title":"Title"},"front_medical_services":"Front Medical Services","front_patient_testimonial":{"add_front_patient_testimonial":"Add Front Patient Testimonial","designation":"Designation","edit_front_patient_testimonial":"Edit Front Patient Testimonial","more_patient_feedbacks":"More Patient Feedbacks...","name":"Name","patient_testimonials":"Patient Testimonials","profile":"Profile","short_description":"Short Description"},"front_patient_testimonials":"Front Patient Testimonials","front_service":{"add_front_service":"Add Front Service","edit_front_service":"Edit Front Service","icon":"Icon","short_description":"Short Description","title":"Title"},"front_services":"Front Services","google_calendar":"Google Calendar","holder_name_invalid":"Card holder name is Invalid.","holder_name_required":"Card holder name fields are required.","holder_number_invalid":"Card number fields are required.","holiday":{"add_holiday":"Add Holiday","doctor_holiday":"Doctor Holidays","holiday":"Holiday","holiday_date":"Holiday Date","service_category":"Service Category"},"how_we_care":"How We Care","how_we_cares":{"add_how_we_care":"Add How We Care","edit_how_we_care":"Edit How We Care","icon":"Icon","short_description":"Short Description","status":"Status","title":"Title"},"icon_size":"Icon size should be less than 2 MB","id":"ID","image_file_type":"The image must be a file of type: jpeg, jpg, png.","invalid_country_code":"Invalid country code","invalid_number":"Invalid Number","invalid_range":"Invalid range","live_consultation":{"add_credential":"Add Credential","add_live_consultation":"Add Live Consultation","awaited":"Awaited","client_video":"Client Video","consultation_date":"Consultation Date","consultation_duration_minutes":"Consultation Duration Minutes","consultation_minutes":"Consultation Minutes","consultation_title":"Consultation Title","created_by":"Created By","created_for":"Created For","description":"Description","disabled":"Disabled","duration":"Duration (in minutes)","edit_live_consultation":"Edit Live Consultation","edit_live_meeting":"Edit Live Meeting","enable":"Enable","finished":"Finished","host_video":"Host Video","join_now":"Join Now","live_consultation_details":"Live Consultation Details","new_live_consultation":"New Live Consultation","new_live_meeting":"New Live Meeting","select_consultation_date":"Select Consultation Date","select_doctor_name":"Select Doctor Name","select_patient_name":"Select Patient Name","staff_list":"Staff List","start_now":"Start Now","type":"Type","type_number":"Type Number","zoom_api_key":"Zoom Api Key","zoom_api_secret":"Zoom API Secret"},"live_consultations":"Live Consultations","live_status_retrieved_successfully.":"Live Status retrieved successfully.","login":"Login","medicine":{"available_quantity":"Available Quantity","brand":"Brand","brand_name":"Brand Name","buying_price":"Buying Price","cant_be_deleted":"can't be deleted","category":"Category","category_id":"Category Id","category_retrieved_successfully":"Medicine category retrieved successfully.","deleted_successfully":"deleted successfully","description":"Description","dosage":"Dosage","dose_interval":"Select Dose Interval","duration":"Duration","edit_medicine":"Edit Medicine","edit_medicine_brand":"Edit Medicine Brand","edit_medicine_category":"Edit Medicine Category","filter_options":"Filter Options","medicine":"Medicine","medicine_brands":"Medicine Brands","medicine_brands_details":"Medicine Brand Details","medicine_category":"Medicine Category","medicine_category_details":"Medicine Category Details","medicine_details":"Medicine Details","medicine_name":"Medicine Name","medicine_retrieved_successfully":"Medicine Retrieved Successfully","medicines":"Medicines","name":"Name","new_brand":"New Brand","new_medicine":"New Medicine","new_medicine_brand":"New Medicine Brand","new_medicine_category":"New Medicine Category","no_use":"Not in use","quantity":"Quantity","salt_composition":"Salt Composition","saved_successfully":"saved successfully","select_duration":"Select Duration","selling_price":"Selling Price","side_effects":"Side Effects","status_updated_successfully":"Status updated successfully.","updated_successfully":"updated successfully"},"medicine_bills":{"add_medicine_bill":"Add Medicine Bill","available_quantity":"The available quantity of","avl_qty":"Avl Qty","bill_date":"Bill Date","bill_id":"Bill ID","bill_number":"Bill Number","cell_no":"Cell No","dose_interval":"Dose Interval","duplicate_medicine":"Cannot add duplicate medicines.","edit_medicine_bill":"Edit Medicine Bill","enter_lot_number":"Enter lot number.","enter_puchase_price":"Enter purchase price","enter_sale_price":"Enter sale price.","is":"is","item_name":"Item Name","medicine_bill":"Medicine Bill","medicine_bill_details":"Medicine Bill Details","medicine_bills":"Medicine Bills","medicine_not_selected":"Please select at least one medicine.","medicine_required":"Medicine field is required.","net_amount_cant":"Net amount can not be empty.","net_amount_cant_zero":"Net amount can not be zero.","net_amount_not_empty":"Net amount can not be empty.","net_amount_not_zero":"Net amount can not be zero.","new_medicine_bill":"New Medicine Bill","payment_status":"Payment Status","payment_type":"Payment Type","prescription_not_found":"Prescription not found.","price":"Price","print_bill":"Print Bill","quantity_should":"Quantity should be greater than 0.","sale_price":"Sale Price","select_medicine":"Select Medicine","select_patient":"Select Patient","select_payment_type":"Select Payment Type","tax_amt":"The tax amount can not be zero or empty.","tax_cannot_be_zero_empty":"The tax amount can not be zero or empty.","tax_should_be":"Taxes should be less than 100%.","the_discount_shoul":"The discount should be less than the total amount","the_medicine_already_in_use":"This medicine is already used in medicine bills, are you sure want to delete it?","update_quantity":"Update quantity should be less than previous quantity."},"medicine_brands":"Medicine Brands","medicine_categories":"Medicine Categories","medicines":"Medicines","mobile_no":"Mobile No","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"no_data_available":"No data available in table","no_matching_records_found":"No matching records found","no_response":"No response returned","not_supported":"not supported","note":"Note: You must need to set your timezone before integrating Google Calendar.","notification":{"mark_all_as_read":"Mark All As Read","notification":"Notifications","you_don`t_have_any_new_notification":"You don't have any new notification"},"our_team":"Our Team","patient":{"add":"Add Patient","address1":"Address 1","address2":"Address 2","address_information":"Address Information","blood_group":"Blood Group","city":"City","confirm_password":"Confirm Password","contact_no":"Contact No","country":"Country","details":"Patient Details","dob":"DOB","edit":"Edit Patient","email":"Email","emailverified":"Email Verified","enter_email":"Enter Email","enter_password":"Enter Password","female":"Female","filter":"Filter","first_name":"First Name","gender":"Gender","last_name":"Last Name","last_updated":"Last Updated","male":"Male","name":"Name","password":"Password","patient_unique_id":"Patient Unique ID","postal_code":"Postal Code","profile":"Profile","registered_on":"Registered On","save_changes":"Save Changes","state":"State","today":"Today"},"patient_dashboard":{"completed_appointments":"Completed Appointments","next_appointment":"Next Appointments","today_appointments":"Today Appointments","upcoming_appointments":"Upcoming Appointments"},"patients":"Patients","payment_detail":"Payment detail","payment_for_booking_appointment_with_doctor":"Payment for booking appointment with doctor","payment_method":{"authorize":"Authorize","paypal":"Paypal","paystack":"Paystack","paytm":"Paytm","razorpay":"Razorpay","stripe":"Stripe"},"paytm":"Paytm","prescription":{"accident":"Accident","advice":"Advice","after meal":"After Meal","appointment_slot":"Appointment Slots","available_quantity_of":"The available quantity of ","before meal":"Before Meal","breast_feeding":"Breast Feeding","comment":"Comment","connect_with_zoom":" Connect with Zoom","current_medication":"Current Medication","days":"Days","diabetic":"Diabetic","doctor":"Doctor","dosage":"Dosage","duration":"Duration","edit_prescription":"Edit Prescription","female_pregnancy":"Female Pregnancy","food_allergies":"Food Allergies","frequency":"Frequency","health_insurance":"Health Insurance","heart_disease":"Heart Disease","high_blood_pressure":"High Blood Pressure","is":"is","low_income":"Low Income","medical_history":"Medical History","medicine_name":"Medicine Name","name":"Name","new_medicine":"New Medicine","new_prescription":"New Prescription","next_visit":"Next Visit","not_add_duplicate_medicines":"Cannot add duplicate medicines.","ok":"Ok","others":"Others","patient":"Patient","physical_information":"Physical Information","plus_rate":"Pulse Rate","prescription":"Prescription","prescription_details":"Prescription Details","prescription_saved":"Prescription saved successfully.","prescription_updated":"Prescription updated successfully.","prescriptions":"Prescriptions","problem":"Problem","problem_description":"Problem Description","reference":"Reference","rx":"Rx","selectMedicine":"Select medicine","surgery":"Surgery","temperature":"Temperature","tendency_bleed":"Tendency Bleed","test":"Test","time":"Time","total_quantity":"Total Quantity"},"privacy_policy":"Privacy Policy","purchase_medicine":{"actions":"Actions","amount":"Amount","discount":"Discount","dose_duration":"Dose Duration","expiry_date":"Expiry Date","export_to_excel":"Export to Excel","lot_no":"Lot no.","net_amount":"Net Amount","note":"Note","other_details":"Other Details","payment_mode":"Payment Mode","payment_note":"Payment Note","purchase_medicine":"Purchase Medicine","purchase_medicine_details":"Purchase Medicine Details","purchase_medicine_overview":"Purchase Medicine Overview","purchase_medicines":"Purchase Medicines","purchase_number":"Purchase Number","purchased_medicine_success":"Medicine purchased successfully","quantity":"Quantity","tax":"Tax","tax_amount":"Tax Amount","total":"Total"},"qr_patient_detail":{"patient_detail":"Patient Detail","used_at":"Used At","used_medicines":"Used Medicines","used_quantity":"Used Quantity"},"range_constructor_requires_trie_parameter":"Range constructor requires a Trie parameter","register":"Register","requires_string_parameter":"rangeWithString requires a string parameter","resend_email_verification":"Resend Email Verification","review":{"add_review":"Add review","edit_review":"Edit Review","no_doctors_available_to_give_rating":"No Doctors available to give rating.","review":"Review","write_a_review":"Write a review"},"reviews":"Reviews","role":{"add_role":"Add Role","edit_role":"Edit Role","permissions":"Permissions","role":"Role","role_permissions":"Role Permissions","select_all_permissions":"Select All Permissions"},"roles":"Roles","satisfied_patient":"Satisfied Patient","service":{"add_service":"Add Service","category":"Category","charges":"Charges","edit_service":"Edit Service","short_description":"Short Description","status":"Status"},"service_categories":"Service Categories","service_category":{"add_category":"Add Service Category","edit_category":"Edit Service Category","service_category":"Service Category"},"services":"Services","setting":{"address":"Address","change_app_logo":"Change app logo","change_favicon":"Change favicon","clinic_name":"Clinic Name","connect_google_calendar":"Connect Google Calendar","connect_your_google_calendar":"Connect your Google Calendar","contact_information":"Contact Information","currency":"Currency","currency_settings":"Currency Settings","default_country_code":"Default Country Code","default_language_suggest":"By updating this the entire app language will change at doctor, patient logins as well as front side.","disconnect_your_google_calendar":"Disconnect your Google Calendar","do_not_allow_to_login_without_email_verification":"Do not allow to login without email verification","favicon":"Favicon","general":"General","general_details":"General Details","logo":"Logo","postal_code":"Postal Code","prefix":"Prefix","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"Select your calendars (from Google Calendar) in which you want to create the appointments","setting":"Setting","specialities":"Specialities","sync_your_google_calendar":"Sync your Google Calendar","when_checkbox_disable":"When checkbox is disable email verification is not working for new users.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"When patient book an appointment with you, new appointment will created on selected calendars","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"When you book an appointment, new appointment will created on selected calendars"},"settings":"Settings","sign_up":"Sign Up","slider":{"add_slider":"Add Banner","edit_slider":"Edit Banner","image":"Image","short_description":"Short Description","title":"Title"},"sliders":"Banner","smart_patient_card":{"add_smart_card":"Add Smart card","add_smart_card_templates":"Add Smart Card Templates","address_show":"Address Show","blood_group_show":"Blood Group Show","dob_show":"DOB Show","edit_patient_card":"Edit Smart Card","email_show":"Email show","enter_template_name":"Enter Template Name","for_all_patient":"For All Patients","generate_patient_card":"Generate Patient Card","generate_patient_smart_cards":"Generate Patient Smart Cards","header_color":"Header Color","only_one_patient":"Only One Patient","patient":"Patient","patient_smart_card_created":"Patient Smart Card Created successfully.","patient_smart_card_deleted":"Patient Smart Card","phone_show":"Phone Show","please_selest_patient":"Please Select Patient","remaning_patients":"Remaining Patients","select_patient":"Select Patient","select_template":"Select Template","smart_patient_card_templates":"Smart Patient Card Templates","smart_patient_cards":"Smart Patient Cards","templat_name":"Template Name","template":"Template","template_created":"Template Created successfully.","template_deleted":"Template Deleted successfully.","template_update":"Template Update successfully.","type":"Type","unique_id_show":"Unique ID Show"},"specialization":{"add_specialization":"Add Specialization","edit_specialization":"Edit Specialization","retrieved_successfully":"Specialization retrieved successfully."},"specializations":"Specializations","staff":{"add_staff":"Add Staff","confirm_password":"Confirm Password","contact_no":"Contact No","edit_staff":"Edit Staff","email":"Email","female":"Female","first_name":"First Name","gender":"Gender","last_name":"Last Name","male":"Male","password":"Password","role":"Role","select_role":"Select Role","staff":"Staff","staff_details":"Staff Details"},"staffs":"Staffs","start_time_invalid":"day start time is invalid","state":{"add_state":"Add State","country":"Country","edit_state":"Edit State","state":"State","states":"states"},"states":"States","subscribers":"Subscribers","terms_conditions":"Terms & Conditions","this_is_an_alert":"This is an alert","too_long":"Too long","too_short":"Too short","transaction":{"paid":"Paid","payment_accepted_by":"Payment Accepted By","payment_status":"Payment Status","pending":"Pending","transaction_detail":"Transaction Detail","transaction_id":"Transaction ID"},"transactions":"Transactions","used_medicine":{"used_at":"Used At","used_medicine":"Used Medicine","used_medicines":"Used Medicines","used_quantity":"Used Quantity"},"user":{"account":"Account","account_setting":"Account Settings","avatar":"Avatar","change_language":"Change Language","change_password":"Change Password","confirm_password":"Confirm Password","contact_number":"Contact Number","current_password":"Current Password","edit_profile":"Edit Profile","email":"Email","email_notification":"Email Notification","full_name":"Full Name","gender":"Gender","language":"Language","new_password":"New Password","profile_details":"Profile Details","return_to_admin":"Return To Admin","save_changes":"Save Changes","select_time_zone":"Select Time Zone","setting":"Setting","sign_out":"Sign Out","staff_details":"Staff Details","time_zone":"Time Zone"},"users":"Users","valid_expiration_date":"Enter valid expiration date.","valid_number":"Valid Number","visit":{"add_visit":"Add Visit","description":"Description","doctor":"Doctor","edit_visit":"Edit Visit","enter_note":"Enter note","enter_observation":"Enter observation","enter_problem":"Enter problem","notes":"Notes","observations":"Observations","patient":"Patient","prescriptions":"Prescriptions","problems":"Problems","title":"Title","visit_date":"Visit Date","visit_detail":"Visit Detail","visit_details":"Visit Details"},"visits":"Visits","web":{"Meet_best_doctors":"Meet Best Doctors","about_experience":"About Experience","about_short_description":"About Short Description","about_title":"About Title","about_us":"About Us","all_rights_reserved":"All Rights Reserved","all_services":"All Services","already_have_an_account":"Already have an account","already_have_patient_account":"Already Have Patient Account","appointment":"Appointment","appointment_now":"Appointment Now","best_professionals":"Best Professionals","book_an_appointment":"Book An Appointment","book_appointment":"Book Appointment","call_us":"Call Us","closed":"Closed","confirm_booking":"Confirm Booking","contact":"Contact","contact_us":"Contact Us","contact_us_for_any_information":"Contact Us For Any Information","create_an_account":"Create an Account","created_at":"Created At","doctors":"Doctors","doctors_can_interact___":"Doctors can interact with patients and do related treatment.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Dynamically formulate error-free results before integrated results. Dramatically incubate integrated resources without cost effective outside the.","email":"Email","email_address":"Email Address","emergency_help":"Emergency Help","enquiry":"Enquiry","enquiry_details":"Enquiry Details","enter_your_email":"Enter Your Email","enter_your_email_to_subscribe_to_our_newsletter":"Enter your Email to Subscribe to our Newsletter","faqs":"FAQs","forgot_password":"Forgot Password","home":"Home","how_we_works":"How we works","i_agree":"I Agree","location":"location","login":"Login","make_appointment":"Make Appointment","medical":"Home","medical_about_us":"About Us","medical_appointment":"Appointments","medical_contact":"Contact","medical_doctors":"Doctors","medical_services":"Services","medical_treatment":"Medical Treatment","meet_our_team_of_specialists":"Meet our Team of Specialists","message":"Message","name":"Name","new_here":"New Here","no_services_available":"No Services Available","opening_hours":"Opening Hours","our_doctor":"Our Doctor","our_services":"Our Service","our_team":"Our Team","patient_can_book_an_appointment___":"Patient can book an appointment with doctor from landing page or from his login panel.","patient_can_do_registration___":"Patient can do registration from here with basic information.","patient_name":"Patient Name","patient_registration":"Patient Registration","phone":"Phone","qualified_doctors":"Qualified Doctors","questions_before_booking":"Questions Before Booking","quick_links":"Quick Links","reason":"Reason","registration":"Registration","remember_me":"Remember me","satisfied_patient":"Satisfied Patient","saying_about_us":"Saying About us","see_what_are_the_patients":"See What Are The Patients","send_an_email":"Send An Email","send_message":"Send Message","send_us_an_email":"Send us an Email","services":"Services","sign_in":"Sign In","sign_in_here":"Sign in here","sign_up":"Sign Up","status":"Status","subject":"Subject","subscribe":"Subscribe","take_treatment":"Take Treatment","terms_and_conditions":"Terms and conditions","testimonial":"Testimonial","timings":"Timings","total_doctors":"Total Doctors","total_registered_patient":"Total Registered Patients","total_services":"Total Services","total_specializations":"Total Specializations","view_more":"View More","we_cover_a_big___":"We Cover A Big Variety Of Medical Services","we_make_sure_that_your_life_are_in_good_hands":"We make sure that your Life are in Good Hands","we_provide_the_special_tips___":"We provide the special tips and advice\u2019s of heath care treatment and high level of best.","working_process":"Working Process","year_experience":"Year Experience"},"weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"}},"en.pagination":{"next":"Next","previous":"Previous"},"en.passwords":{"reset":"Your password has been reset!","sent":"We have emailed your password reset link!","throttled":"Please wait before retrying.","token":"This password reset token is invalid.","user":"We cannot find a user with that email address."},"en.validation":{"accepted":"The :attribute field must be accepted.","accepted_if":"The :attribute field must be accepted when :other is :value.","active_url":"The :attribute field must be a valid URL.","after":"The :attribute field must be a date after :date.","after_or_equal":"The :attribute field must be a date after or equal to :date.","alpha":"The :attribute field must only contain letters.","alpha_dash":"The :attribute field must only contain letters, numbers, dashes, and underscores.","alpha_num":"The :attribute field must only contain letters and numbers.","array":"The :attribute field must be an array.","ascii":"The :attribute field must only contain single-byte alphanumeric characters and symbols.","attributes":[],"before":"The :attribute field must be a date before :date.","before_or_equal":"The :attribute field must be a date before or equal to :date.","between":{"array":"The :attribute field must have between :min and :max items.","file":"The :attribute field must be between :min and :max kilobytes.","numeric":"The :attribute field must be between :min and :max.","string":"The :attribute field must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","can":"The :attribute field contains an unauthorized value.","confirmed":"The :attribute field confirmation does not match.","current_password":"The password is incorrect.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"The :attribute field must be a valid date.","date_equals":"The :attribute field must be a date equal to :date.","date_format":"The :attribute field must match the format :format.","decimal":"The :attribute field must have :decimal decimal places.","declined":"The :attribute field must be declined.","declined_if":"The :attribute field must be declined when :other is :value.","different":"The :attribute field and :other must be different.","digits":"The :attribute field must be :digits digits.","digits_between":"The :attribute field must be between :min and :max digits.","dimensions":"The :attribute field has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","doesnt_end_with":"The :attribute field must not end with one of the following: :values.","doesnt_start_with":"The :attribute field must not start with one of the following: :values.","email":"The :attribute field must be a valid email address.","ends_with":"The :attribute field must end with one of the following: :values.","enum":"The selected :attribute is invalid.","exists":"The selected :attribute is invalid.","file":"The :attribute field must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute field must have more than :value items.","file":"The :attribute field must be greater than :value kilobytes.","numeric":"The :attribute field must be greater than :value.","string":"The :attribute field must be greater than :value characters."},"gte":{"array":"The :attribute field must have :value items or more.","file":"The :attribute field must be greater than or equal to :value kilobytes.","numeric":"The :attribute field must be greater than or equal to :value.","string":"The :attribute field must be greater than or equal to :value characters."},"image":"The :attribute field must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field must exist in :other.","integer":"The :attribute field must be an integer.","ip":"The :attribute field must be a valid IP address.","ipv4":"The :attribute field must be a valid IPv4 address.","ipv6":"The :attribute field must be a valid IPv6 address.","json":"The :attribute field must be a valid JSON string.","lowercase":"The :attribute field must be lowercase.","lt":{"array":"The :attribute field must have less than :value items.","file":"The :attribute field must be less than :value kilobytes.","numeric":"The :attribute field must be less than :value.","string":"The :attribute field must be less than :value characters."},"lte":{"array":"The :attribute field must not have more than :value items.","file":"The :attribute field must be less than or equal to :value kilobytes.","numeric":"The :attribute field must be less than or equal to :value.","string":"The :attribute field must be less than or equal to :value characters."},"mac_address":"The :attribute field must be a valid MAC address.","max":{"array":"The :attribute field must not have more than :max items.","file":"The :attribute field must not be greater than :max kilobytes.","numeric":"The :attribute field must not be greater than :max.","string":"The :attribute field must not be greater than :max characters."},"max_digits":"The :attribute field must not have more than :max digits.","mimes":"The :attribute field must be a file of type: :values.","mimetypes":"The :attribute field must be a file of type: :values.","min":{"array":"The :attribute field must have at least :min items.","file":"The :attribute field must be at least :min kilobytes.","numeric":"The :attribute field must be at least :min.","string":"The :attribute field must be at least :min characters."},"min_digits":"The :attribute field must have at least :min digits.","missing":"The :attribute field must be missing.","missing_if":"The :attribute field must be missing when :other is :value.","missing_unless":"The :attribute field must be missing unless :other is :value.","missing_with":"The :attribute field must be missing when :values is present.","missing_with_all":"The :attribute field must be missing when :values are present.","multiple_of":"The :attribute field must be a multiple of :value.","not_in":"The selected :attribute is invalid.","not_regex":"The :attribute field format is invalid.","numeric":"The :attribute field must be a number.","password":{"letters":"The :attribute field must contain at least one letter.","mixed":"The :attribute field must contain at least one uppercase and one lowercase letter.","numbers":"The :attribute field must contain at least one number.","symbols":"The :attribute field must contain at least one symbol.","uncompromised":"The given :attribute has appeared in a data leak. Please choose a different :attribute."},"present":"The :attribute field must be present.","prohibited":"The :attribute field is prohibited.","prohibited_if":"The :attribute field is prohibited when :other is :value.","prohibited_unless":"The :attribute field is prohibited unless :other is in :values.","prohibits":"The :attribute field prohibits :other from being present.","regex":"The :attribute field format is invalid.","required":"The :attribute field is required.","required_array_keys":"The :attribute field must contain entries for: :values.","required_if":"The :attribute field is required when :other is :value.","required_if_accepted":"The :attribute field is required when :other is accepted.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values are present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute field must match :other.","size":{"array":"The :attribute field must contain :size items.","file":"The :attribute field must be :size kilobytes.","numeric":"The :attribute field must be :size.","string":"The :attribute field must be :size characters."},"starts_with":"The :attribute field must start with one of the following: :values.","string":"The :attribute field must be a string.","timezone":"The :attribute field must be a valid timezone.","ulid":"The :attribute field must be a valid ULID.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","uppercase":"The :attribute field must be uppercase.","url":"The :attribute field must be a valid URL.","uuid":"The :attribute field must be a valid UUID."},"es.auth":{"app":{"create":"Crear","export":"Exportar","lock_account":"Bloquear cuenta","member_since":"Miembro desde","messages":"Mensajes","online":"En l\u00ednea","print":"Imprimir","profile":"Perfil","reload":"Recargar","reset":"Reiniciar","search":"Buscar","settings":"Configuraci\u00f3n"},"confirm_password":"Confirmar contrase\u00f1a","email":"Correo electr\u00f3nico","emails":{"password":{"reset_link":"Haga clic aqu\u00ed para restablecer la contrase\u00f1a"}},"failed":"Estas credenciales no coinciden con nuestros registros.","forgot_password":{"send_pwd_reset":"Enviar enlace de restablecimiento de contrase\u00f1a","title":"Ingrese el correo electr\u00f3nico para restablecer la contrase\u00f1a"},"full_name":"Nombre completo","login":{"forgot_password":"Olvid\u00e9 mi contrase\u00f1a","register_membership":"Registrar una nueva membres\u00eda","title":"Inicie sesi\u00f3n para iniciar su sesi\u00f3n"},"password":"Contrase\u00f1a","register":"Registrarse","registration":{"have_membership":"Ya tengo una membres\u00eda","i_agree":"Estoy de acuerdo con","terms":"los t\u00e9rminos","title":"Registrar una nueva membres\u00eda"},"remember_me":"Recu\u00e9rdame","reset_password":{"reset_pwd_btn":"Restablecer contrase\u00f1a","title":"Restablecer su contrase\u00f1a"},"sign_in":"Iniciar sesi\u00f3n","sign_out":"Cerrar sesi\u00f3n","throttle":"Demasiados intentos de inicio de sesi\u00f3n. Vuelva a intentarlo en: segundos segundos. "},"es.livewire-tables::strings":{"All":"Todo","Applied Filters":"Filtros Aplicados","Applied Sorting":"Ordenamiento Aplicado","Bulk Actions":"Acciones Masivas","Clear":"Borrar","Columns":"Columnas","Done Reordering":"Reordenamiento finalizado","Filters":"Filtros","No items found. Try to broaden your search.":"No se encontraron elementos. Intente ampliar la b\u00fasqueda.","Remove filter option":"Remover opci\u00f3n de filtro","Remove sort option":"Remover opci\u00f3n de ordenamiento","Reorder":"Reordenar","Search":"Buscar","Select All":"Seleccionar todo","Showing":"Mostrando","Unselect All":"Deseleccionar todo","You are currently selecting all":"Actualmente est\u00e1 seleccionando todo","You are not connected to the internet.":"No est\u00e1 conectado a Internet.","You have selected":"Ha seleccionado","of":"de","results":"resultados","row":"fila","rows":"filas","rows, do you want to select all":"filas, desea seleccionar todas","to":"a"},"es.messages":{"admin_dashboard":{"dashboard":"Panel de control","day":"D\u00eda","earnings_from_appointments":"Ganancias de citas","filter_options":"Opciones de filtro","month":"Mes","name":"Nombre","patient_id":"Identificaci\u00f3n \u00fanica del paciente","recent_patients_registration":"Registro de pacientes recientes","registered":"Registrado","today_appointments":"Citas de hoy","today_registered_patients":"Pacientes registrados hoy","total_doctor":"Total de m\u00e9dicos","total_patients":"Total de pacientes","week":"Semana"},"appointment":{"Select_payment_method":"Seleccionar m\u00e9todo de pago","add_new_appointment":"Agregar cita","appointment_at":"Cita en","appointment_date":"Fecha de cita","appointment_details":"Detalles de la cita","appointment_status":"Estado de la cita","appointment_unique_id":"ID de cita","appointments":"Citas","appointments_schedule":"Programaci\u00f3n de citas","authorize_session_created_successfully":"Autorizar sesi\u00f3n creada exitosamente.","available":"Disponible","available_slot":"Ranuras disponibles","booked":"Reservado","calendar":"Calendario","cancel_appointment":"Cancelar cita","cancelled":"Cancelado","charge":"Cargar","check_in":"Registrarse","check_out":"Salida","date":"Fecha","description":"Descripci\u00f3n","edit_appointment":"Editar cita","ends":"Finaliza","extra_fees":"Tarifas adicionales","no_slot_found":"No se encontraron franjas horarias.","patient":"Paciente","patient_id":"Identificaci\u00f3n del paciente","patient_name_retrieved":"Nombre del paciente recuperado exitosamente","payable_amount":"Importe a pagar","payment":"Pago","payment_method":"M\u00e9todo de pago","payment_status":"Estado de pago","service":"Servicio","service_charge":"Cargo por servicio","session_created_successfully":"sesi\u00f3n creada con \u00e9xito","session_id_required":"Se requiere ID de sesi\u00f3n","starts":"Comienza","status":"Estado","switch_to_calendar":"Cambiar a Calendario","time":"Hora","total_payable_amount":"Importe total a pagar","upcoming_meetings":"pr\u00f3ximas reuniones"},"appointments":"Citas","apps":"Aplicaciones","card_number_invalid..":"El n\u00famero de tarjeta no es v\u00e1lido.","card_type":"Tipo de tarjeta de cr\u00e9dito","cities":"Ciudades","city":{"add_city":"Agregar ciudad","city":"Ciudad","edit_city":"Editar ciudad","state":"Estado"},"clinic_schedules":"Horarios de la cl\u00ednica","cms":{"Terms_Conditions_required":"Se requieren t\u00e9rminos y condiciones","about_image":"Acerca de la imagen","cms":"CMS","description_no_white_space":"El campo Acerca de la descripci\u00f3n breve no contiene solo espacios en blanco","experience_required":"El campo Acerca de la experiencia es obligatorio.","privacy_policy":"Pol\u00edtica de privacidad","privacy_policy_required.":"La Pol\u00edtica de Privacidad es obligatoria.","terms_conditions":"T\u00e9rminos y condiciones","title_no_white_space":"El campo Acerca del t\u00edtulo no contiene solo espacios en blanco"},"common":{"Attempt_read_property_access_token_null":"Intente leer la propiedad \\ \"access_token \\\" en nulo","Forgot_password_lable":"\u00bfOlvidaste tu contrase\u00f1a? Ning\u00fan problema. Simplemente h\u00e1ganos saber su direcci\u00f3n de correo electr\u00f3nico y le enviaremos un enlace para restablecer su contrase\u00f1a que le permitir\u00e1 elegir una nueva.","action":"Acci\u00f3n","active":"Activo","add":"Agregar","add_credential":"Por favor agregue credenciales de zoom","age":"Edad","any_one_permission":"Seleccione cualquier permiso.","apply":"Aplicar","appointment_date_required":"El campo de fecha de la cita es obligatorio.","are_you_sure":"\u00bfEst\u00e1s segura de que quieres eliminar esto?","are_you_sure_cancel":"\u00bfEst\u00e1s seguro de que quieres cancelar esto?","back":"Atr\u00e1s","booked":"Reservado","brand_required":"El campo de marca es obligatorio.","cancel":"Cancelar","cancelled":"Cancelado","cancelled_appointment":"\u00a1Cita cancelada!","category_required":"El campo de categor\u00eda es obligatorio.","change_image":"Cambiar imagen","check in":"Registrarse","check out":"Verificar","city":"Ciudad","confirm":"Confirmar","connected_zoom":"Conectado con zoom exitosamente.","contact_number":"El n\u00famero de contacto es","country":"Pa\u00eds","custom":"Disfraz","de_active":"Desactivar","default_language":"Idioma predeterminado","delete":"Borrar","deleted":"Gel\u00f6scht!","details":"Detalles","discard":"Descartar","doctor_required":"Se requiere campo m\u00e9dico.","download":"Descargar","edit":"Editar","email_already_exist":"El correo electr\u00f3nico ya se ha suscrito.","email_max":"El tama\u00f1o m\u00e1ximo del correo electr\u00f3nico es 255.","email_not_register":"El correo electr\u00f3nico no est\u00e1 registrado.","email_regex":"El campo de correo electr\u00f3nico debe tener un formato v\u00e1lido..","email_required":"El campo de correo electr\u00f3nico es obligatorio.","email_verified":"Correo Electr\u00f3nico Verificado","error":"error","filter":"Filtro","filter_option":"Opci\u00f3n de filtro","first_name_required":"El campo de nombre es obligatorio.","forgot_your_password":"Olvidaste tu contrase\u00f1a","from":"De","google_captcha_required":"El campo captcha de Google es obligatorio.","has_been":"wurde gel\u00f6scht.","has_cancel":" has been Cancelled.","hour":"Hora","impersonate":"Personificar","instagram_url":"URL de Instagram","last_name_required":"El campo de apellido es obligatorio.","linkedin_url":"URL de Linkedin","logout":"Cerrar sesi\u00f3n","maximum_55":"Se permiten un m\u00e1ximo de 55 caracteres.","message_required":"El campo del mensaje es obligatorio..","minutes":"Minutos","n\/a":"N \/ A","name":"Nombre","name_already_taken":"El nombre ya ha sido tomado.","name_required":"El campo de nombre es obligatorio","no":"No, Cancelar","no_data_available":"No hay datos disponibles","no_data_available_in_table":"No hay datos disponibles en la tabla","no_records_found":"No se encontraron registros.","not_allow__assess_record":"Parece que no tiene permiso para acceder a este registro.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Nota: Tomamos la zona horaria de sus m\u00e9dicos al crear una cita en el calendario. Si Doctor no ha configurado la zona horaria, tomar\u00e1 la zona horaria UTC predeterminada.","note_white_space":"El campo de nota no contiene solo espacios en blanco","observation_white_space":"El campo de observaci\u00f3n no contiene solo espacios en blanco.","of":"de","overview":"Resumen","payment_type_required":"El campo M\u00e9todo de pago es obligatorio.","please_wait":"Por favor espere ...","prescription_report":"Informe de prescripci\u00f3n","problem_white_space":"El campo del problema no contiene solo espacios en blanco","processing":"Procesando..","purchase_price":"Precio de compra","read":"Leer","remember_me":"Acu\u00e9rdate de m\u00ed","resend_verification_email":"Reenviar correo electr\u00f3nico de verificaci\u00f3n","reset":"Reiniciar","reset_password":"Restablecer la contrase\u00f1a","results":"resultados","save":"Guardar","search":"B\u00fasqueda","select_brand":"Seleccionar marca","select_category":"Selecciona una categor\u00eda","select_city":"Ciudad selecta","select_country":"Seleccionar pa\u00eds","select_doctor":"Seleccionar m\u00e9dico","select_service":"Seleccionar servicio","select_state":"Seleccione estado","service":"Servicio","service_required":"El campo de servicios es obligatorio.","show":"Espect\u00e1culo","showing":"Demostraci\u00f3n","state":"Estado","subject_required":"El campo de asunto es obligatorio.","submit":"Enviar","to":"a","twitter_url":"URL de Twitter","unread":"No le\u00eddo","verify_lable1":"Gracias por registrarte! Antes de comenzar, \u00bfpodr\u00edas verificar tu direcci\u00f3n de correo electr\u00f3nico haciendo clic en el enlace que te acabamos de enviar por correo electr\u00f3nico? Si no recibi\u00f3 el correo electr\u00f3nico, con gusto le enviaremos otro.","verify_lable2":"Se ha enviado un nuevo enlace de verificaci\u00f3n a la direcci\u00f3n de correo electr\u00f3nico que proporcion\u00f3 durante el registro.","view":"Vista","years":"A\u00f1os","yes":"\u00a1S\u00ed, eliminar!","yes_update":"Ja, aktualisieren!","zoom_credentials":"Agregue las credenciales de zoom."},"countries":"Pa\u00edses","country":{"add_country":"Agregar pa\u00eds","country":"Pa\u00eds","short_code":"C\u00f3digo corto"},"currencies":"Monedas","currency":{"add_currency":"Agregar moneda","add_currency_code_as_per_three_letter_iso_code":"Agregue el c\u00f3digo de moneda seg\u00fan el c\u00f3digo ISO de tres letras","currency_code":"C\u00f3digo de moneda","currency_icon":"Icono de moneda","currency_name":"Nombre de la moneda","edit_currency":"Editar moneda","name":"Nombre","you_can_find_out_here":"puedes averiguarlo aqu\u00ed"},"cvv_invalid.":"CVV no es v\u00e1lido.","cvv_number_required.":"Los campos del n\u00famero CVV son obligatorios.","dashboard":"Panel de control","datepicker":{"last_30_days":"\u00daltimos 30 d\u00edas","last_month":"El mes pasado","last_week":"La semana pasada","this_month":"Este mes","this_week":"Esta semana","today":"Este Dia","yesterday":"El dia de ayer"},"doctor":{"add":"Agregar m\u00e9dico","add_qualification":"Agregar calificaci\u00f3n","address1":"Direcci\u00f3n 1","address2":"Direcci\u00f3n 2","address_information":"Informaci\u00f3n de direcci\u00f3n","allowed_img":"Tipos de archivos permitidos: png, jpg, jpeg.","city":"Ciudad","collage_university":"COLLAGE \/ UNIVERSIDAD","country":"Pa\u00eds","created_at":"Creado en","degree":"Grado","dob":"fecha de nacimiento","doctor":"Doctor","doctor_detail":"Detalles del m\u00e9dico","doctor_holiday":"Doctor Holidays","edit":"Editar doctor","experience":"Experiencia en el a\u00f1o","female":"Mujer","first_name":"Nombre","instagram":"Instagram","last_name":"Apellido","linkedin":"LinkedIn","male":"Hombre","passout_year":"A\u00f1o de Passout","postal_code":"C\u00f3digo postal","profile":"Perfil","qualification":"Calificaci\u00f3n","qualification_information":"Informaci\u00f3n de calificaci\u00f3n","select_blood_group":"Seleccionar grupo sangu\u00edneo","select_date":"Seleccione fecha","select_doctors":"m\u00e9dicos selectos","select_gender":"Seleccionar g\u00e9nero","select_year":"Seleccionar a\u00f1o","specialization":"Especializaci\u00f3n","sr_no":"SR NO","state":"Estado","status":"Estado","twitter":"Gorjeo","university":"Universidad","updated_at":"Actualizado en","year":"A\u00f1o"},"doctor_appointment":{"amount":"Cantidad","from_time":"Desde el tiempo","patient":"Paciente","service":"Servicio","to_time":"Hasta el momento"},"doctor_appointments":"Citas con el m\u00e9dico","doctor_dashboard":{"recent_appointments":"Citas recientes","total_appointments":"Total de citas"},"doctor_session":{"add":"Agregar horario m\u00e9dico","all":"Todos","copy":"Copiar","doctor":"Doctor","doctor_session":"Horario m\u00e9dico","doctor_session_details":"Detalles del horario del m\u00e9dico","edit":"Editar horario m\u00e9dico","evening_session":"Horario de la tarde","friday":"Viernes","gap_between_appointment":"Espacio entre citas","monday":"Lunes","morning_session":"Horario de la ma\u00f1ana","my_schedule":"Mi horario","saturday":"S\u00e1bado","select_meeting_time":"Select meeting time","select_session_gap":"Select schedule gap","session":"Sesi\u00f3n","session_gap":"Horario de intervalo","session_meeting_time":"Programar hora de reuni\u00f3n","session_time_in_minutes":"Programar hora de reuni\u00f3n","sunday":"Domingo","thursday":"Jueves","tuesday":"Martes","unavailable":"Indisponible","wednesday":"Mi\u00e9rcoles","week_days":"D\u00edas de la semana"},"doctor_sessions":"Horarios del m\u00e9dico","doctors":"Doctores","doctors_scheduled_time_ended_for_today__":"La hora programada del m\u00e9dico termin\u00f3 para hoy, seleccione otro m\u00e9dico o fecha","email_password_reset_link":"Enlace para restablecer la contrase\u00f1a del correo electr\u00f3nico","enquiries":"Consultas","expiration_month_required":"Los campos del mes de vencimiento son obligatorios.","expiration_year_required":"Los campos del a\u00f1o de vencimiento son obligatorios.","faq":{"add_faq":"Agregar preguntas frecuentes","answer":"Responder","edit_faq":"Editar preguntas frecuentes","question":"Pregunta"},"faqs":"Preguntas frecuentes","filter":{"active":"Activo","all":"Todos","awaited":"esperado","booked":"Reservado","cancelled":"Cancelado","check in":"Registrarse","check out":"Dinero","deactive":"Desactivar","finished":"Acabado","paid":"Pagado","pending":"Pendiente","read":"Leer","unread":"No le\u00eddo"},"filter_success":"\u00e9xito del filtro","flash":{"about_image_validation_message":"La imagen sobre debe ser un archivo de tipo: jpg, jpeg, png.","about_us_create":"Acerca de nosotros guardado con \u00e9xito.","all_notification_read":"Todas las notificaciones se leyeron correctamente.","appointment_booked":"Cita reservada con \u00e9xito","appointment_cancel":"Cita cancelada.","appointment_create":"Cita creada con \u00e9xito.","appointment_created_payment_complete":"La cita se cre\u00f3 con \u00e9xito y el pago se complet\u00f3.","appointment_created_payment_not_complete":"La cita se cre\u00f3 con \u00e9xito y el pago no se complet\u00f3.","appointment_delete":"Cita eliminada con \u00e9xito.","appointment_not_found":"Cita no encontrada","appointment_retrieve":"Datos del calendario de citas recuperados con \u00e9xito.","calender_added":"Calendario agregado con \u00e9xito.","cat_retrieve":"Categor\u00eda recuperada con \u00e9xito.","cities_retrieve":"Ciudades recuperadas con \u00e9xito","city_create":"Ciudad creada con \u00e9xito.","city_delete":"Ciudad eliminada con \u00e9xito.","city_retrieved":"Ciudad recuperada con \u00e9xito.","city_update":"Ciudad actualizada correctamente.","city_used":"Ciudad utilizada en otro lugar.","clinic_delete":"ClinicSchedule eliminado con \u00e9xito.","clinic_save":"Horario de la cl\u00ednica guardado con \u00e9xito.","cms_update":"CMS actualizado con \u00e9xito.","country_create":"Pa\u00eds creado con \u00e9xito.","country_delete":"Pa\u00eds eliminado con \u00e9xito.","country_update":"Pa\u00eds actualizado con \u00e9xito.","country_used":"Pa\u00eds utilizado en otro lugar.","create_blog":"Blog de VCard creado con \u00e9xito.","create_front_testimonial":"Testimonio creado con \u00e9xito.","currency_create":"Moneda creada con \u00e9xito.","currency_delete":"Moneda eliminada con \u00e9xito.","currency_update":"Moneda actualizada con \u00e9xito.","currency_used":"Divisa utilizada en otro lugar.","current_invalid":"La contrase\u00f1a actual no es v\u00e1lida.","data_retrieve":"Datos recuperados con \u00e9xito.","default_role_not_delete":"La funci\u00f3n predeterminada no se elimina.","degree_required":"El campo de grado es obligatorio.","doctor_appointment":"Los datos del calendario de citas con el m\u00e9dico se recuperaron correctamente.","doctor_create":"El m\u00e9dico se cre\u00f3 con \u00e9xito.","doctor_delete":"El doctor elimin\u00f3 con \u00e9xito.","doctor_holiday":"Doctor Holiday creado con \u00e9xito","doctor_not_available":"Doctor no disponible","doctor_session_not_found":"Sesi\u00f3n de m\u00e9dico no encontrada.","doctor_update":"M\u00e9dico actualizado con \u00e9xito.","doctor_use":"M\u00e9dico usado con \u00e9xito.","email_notification":"Notificaci\u00f3n por correo electr\u00f3nico actualizada con \u00e9xito.","email_send":"Correo electr\u00f3nico enviado con \u00e9xito.","enquire_deleted":"Consulta eliminada con \u00e9xito.","enquire_sent":"Consulta enviada con \u00e9xito","faq_creat":"Preguntas frecuentes creadas con \u00e9xito.","faq_delete":"Preguntas frecuentes eliminadas con \u00e9xito.","faq_update":"Preguntas frecuentes actualizadas con \u00e9xito.","faq_use":"Estas preguntas frecuentes se usaron en otro lugar.","favicon_validation_message":"El favicon debe ser un tipo de archivo: jpg, jpeg, png.","feature_update":"Caracter\u00edstica actualizada con \u00e9xito.","google_calendar_connect":"Tu Google Calendar ahora est\u00e1 conectado.","google_calendar_disconnect":"Google Calendar se desconect\u00f3 correctamente.","google_calendar_update":"Su calendario de Google se actualiz\u00f3 correctamente.","holiday_already_is_exist":"Ya existe un feriado para esta fecha","icon_validation_message":"El icono debe ser un archivo de tipo: jpg, jpeg, png, svg.","language_change":"Idioma cambiado con \u00e9xito","language_update":"Idioma actualizado correctamente.","live_consultation_delete":"Consulta en vivo eliminada con \u00e9xito.","live_consultation_retrieved":"Consulta en vivo recuperada con \u00e9xito.","live_consultation_save":"Consulta en vivo guardada con \u00e9xito.","live_consultation_update":"Consulta en vivo actualizada con \u00e9xito.","logo_validation_message":"El logotipo de la aplicaci\u00f3n debe ser un tipo de archivo: jpg, jpeg, png.","maximum_char":"Se permite un m\u00e1ximo de 60 caracteres.","messages_sent":"Mensaje enviado exitosamente","no_available_slots":"No hay espacios disponibles en la fecha dada.","note_added":"Nota a\u00f1adida correctamente.","note_delete":"Nota eliminada con \u00e9xito.","notification_read":"Notificaci\u00f3n le\u00edda con \u00e9xito.","notification_send":"Notificaci\u00f3n de verificaci\u00f3n de correo electr\u00f3nico enviada con \u00e9xito.","observation_added":"Observaci\u00f3n a\u00f1adida con \u00e9xito.","observation_delete":"Observaci\u00f3n eliminada con \u00e9xito.","operation_performed_success":"Operaci\u00f3n realizada con \u00e9xito","order_create":"Pedido creado con \u00e9xito.","password_update":"Contrase\u00f1a actualizada exitosamente.","patient_appointment":"Los datos del calendario de citas del paciente se recuperaron correctamente.","patient_create":"Paciente creado con \u00e9xito.","patient_delete":"Paciente eliminado con \u00e9xito.","patient_not_found":"Paciente no encontrado.","patient_update":"Paciente actualizado con \u00e9xito.","patient_used":"Paciente utilizado en otro lugar.","patients_retrieve":"Pacientes recuperados con \u00e9xito.","payment_status_updated":"Estado de pago actualizado con \u00e9xito.","paystack_token_expired":"El token de la pila de pago ha caducado. Actualice la p\u00e1gina y vuelva a intentarlo.","plan_default":"El plan predeterminado se cambi\u00f3 con \u00e9xito.","plan_status":"Estado del plan actualizado con \u00e9xito","plan_update":"Plan actualizado con \u00e9xito.","prescription_delete":"Eliminaci\u00f3n de la receta con \u00e9xito.","prescription_retrieved":"Receta recuperada con \u00e9xito.","problem_added":"Problema agregado con \u00e9xito.","problem_delete":"Problema eliminado con \u00e9xito.","profile_validation_message":"El perfil debe ser un archivo de tipo: jpg, jpeg, png.","qualification_create":"Calificaci\u00f3n creada con \u00e9xito.","reactive_account":"Reactiva tu cuenta desde el correo.","retrieve":"Recuperado con \u00e9xito.","review_add":"Revisar agregar con \u00e9xito.","review_edit":"Rese\u00f1a editada con \u00e9xito.","review_retrieved":"Revisi\u00f3n recuperada con \u00e9xito.","role_create":"Rol creado con \u00e9xito.","role_delete":"Rol eliminado con \u00e9xito.","role_update":"Rol actualizado con \u00e9xito.","schedule_crete":"Horario creado con \u00e9xito.","schedule_delete":"Programa eliminado con \u00e9xito.","schedule_not_found":"Horario no encontrado.","schedule_update":"Horario actualizado con \u00e9xito.","select_calendar.":"Por favor seleccione un calendario.","select_payment":"Seleccione cualquier m\u00e9todo de pago","service_cat_create":"Categor\u00eda de servicio creada con \u00e9xito.","service_cat_delete":"Categor\u00eda de servicio eliminada con \u00e9xito.","service_cat_update":"Categor\u00eda de servicio actualizada con \u00e9xito.","service_cat_use":"Categor\u00eda de servicio utilizada en otro lugar.","service_create":"Servicio creado con \u00e9xito.","service_delete":"Servicio eliminado con \u00e9xito.","service_update":"Servicio actualizado con \u00e9xito.","service_use":"Servicio utilizado en otro lugar.","session_retrieve":"Sesi\u00f3n recuperada con \u00e9xito.","setting_update":"Configuraci\u00f3n actualizada con \u00e9xito.","slider_update":"Control deslizante actualizado con \u00e9xito","some_doctors":"Algunos m\u00e9dicos han programado sus d\u00edas en d\u00edas no marcados, \u00bfest\u00e1 seguro de que desea realizar esta operaci\u00f3n?","something_went_wrong":"Algo sali\u00f3 mal","specialization_create":"Especializaci\u00f3n creada con \u00e9xito.","specialization_delete":"Especializaci\u00f3n eliminada con \u00e9xito.","specialization_update":"Especializaci\u00f3n actualizada con \u00e9xito.","specialization_use":"Especializaci\u00f3n utilizada con \u00e9xito.","staff_create":"Personal creado con \u00e9xito.","staff_delete":"El personal se elimin\u00f3 con \u00e9xito.","staff_update":"Personal actualizado con \u00e9xito.","staff_use":"Personal utilizado con \u00e9xito.","state_create":"Estado creado con \u00e9xito.","state_delete":"Estado actualizado con \u00e9xito.","state_update":"Estado eliminado con \u00e9xito.","state_use":"Estado utilizado en otro lugar.","states_retrieve":"Estados recuperados con \u00e9xito.","status_change":"Estado cambiado con \u00e9xito.","status_update":"Estado actualizado con \u00e9xito.","subscriber_creat":"Suscriptor creado con \u00e9xito.","subscriber_delete":"Suscriptor eliminado con \u00e9xito.","testimonial_creat":"Testimonio de paciente frontal creado con \u00e9xito.","testimonial_delete":"Testimonio de paciente frontal eliminado con \u00e9xito.","testimonial_update":"Actualizaci\u00f3n exitosa del Testimonio del paciente frontal.","testimonial_use":"Testimonio de paciente frontal utilizado con \u00e9xito.","theme_change":"Tema cambiado con \u00e9xito.","there_were":"Hubo alg\u00fan problema con el pago. Por favor, int\u00e9ntelo de nuevo m\u00e1s tarde.","university_required":"Se requiere la universidad.","update_blog":"Blog de VCard actualizado con \u00e9xito.","update_front_testimonial":"Testimonio actualizado con \u00e9xito.","user_8_or":"Utilice 6 o m\u00e1s caracteres con una combinaci\u00f3n de letras, n\u00fameros y s\u00edmbolos.","user_already_verified":"El usuario ya tiene un correo electr\u00f3nico verificado.","user_profile":"Perfil de usuario actualizado con \u00e9xito.","user_profile_update":"Perfil de usuario actualizado con \u00e9xito.","user_role_not_delete":"Esta funci\u00f3n de usuario no se pudo eliminar porque est\u00e1 asignada a un usuario.","user_status":"Estado de usuario actualizado con \u00e9xito","user_update":"Usuario actualizado con \u00e9xito.","user_zoom_credential_saved":"La credencial de Zoom del usuario se guard\u00f3 correctamente.","valid_instagram":"Ingrese una URL de Instagram v\u00e1lida","valid_linkedin":"Ingrese una URL de Linkedin v\u00e1lida","valid_twitter":"Ingrese una URL de Twitter v\u00e1lida","verified_email":"Correo electr\u00f3nico verificado con \u00e9xito.","visit_create":"Visita creada con \u00e9xito.","visit_delete":"Visita eliminar con \u00e9xito.","visit_prescription_added":"Prescripci\u00f3n de visita agregada con \u00e9xito.","visit_prescription_update":"Receta de visita actualizada con \u00e9xito.","visit_update":"Visita actualizada con \u00e9xito.","year_required":"El a\u00f1o es obligatorio.","your_reg_success":"Su registro fue exitoso. Verifique su cuenta desde el correo electr\u00f3nico."},"front_cms":"CMS frontal","front_medical_service":{"add_front_medical_service":"Agregar servicio m\u00e9dico frontal","edit_front_medical_service":"Editar servicio m\u00e9dico frontal","short_description":"Descripci\u00f3n breve","title":"T\u00edtulo"},"front_medical_services":"Servicios m\u00e9dicos frontales","front_patient_testimonial":{"add_front_patient_testimonial":"Agregar testimonio del paciente frontal","designation":"Designaci\u00f3n","edit_front_patient_testimonial":"Editar testimonio del paciente frontal","more_patient_feedbacks":"M\u00e1s comentarios de los pacientes ...","name":"Nombre","patient_testimonials":"Testimonios de pacientes","profile":"Perfil","short_description":"Descripci\u00f3n breve"},"front_patient_testimonials":"Testimonios de pacientes frontales","front_service":{"add_front_service":"Agregar servicio frontal","edit_front_service":"Editar servicio frontal","icon":"Icono","short_description":"Descripci\u00f3n breve","title":"T\u00edtulo"},"front_services":"Servicios frontales","holder_name_invalid":"El nombre del titular de la tarjeta no es v\u00e1lido.","holder_name_required":"Los campos del nombre del titular de la tarjeta son obligatorios.","holder_number_invalid":"Los campos del n\u00famero de tarjeta son obligatorios.","holiday":{"add_holiday":"Agregar vacaciones","doctor_holiday":"Vacaciones m\u00e9dicas","holiday":"Fiesta","holiday_date":"Fecha de vacaciones","service_category":"Categor\u00eda de servicio"},"icon_size":"El tama\u00f1o del icono debe ser inferior a 2 MB.","id":"IDENTIFICACI\u00d3N","image_file_type":"La imagen debe ser un archivo de tipo: jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invalid_range":"Rango no v\u00e1lido","live_consultation":{"add_credential":"Agregar credencial","add_live_consultation":"Agregar consulta en vivo","awaited":"Esperada","client_video":"V\u00eddeo del cliente","consultation_date":"Fecha de consulta","consultation_duration_minutes":"Minutos de duraci\u00f3n de la consulta","consultation_minutes":"Actas de Consulta","consultation_title":"T\u00edtulo de consulta","created_by":"Creado por","created_for":"Creado para","description":"Descripci\u00f3n","disabled":"Discapacitado","duration":"Duraci\u00f3n (en minutos)","edit_live_consultation":"Editar consulta en vivo","edit_live_meeting":"Editar reuni\u00f3n en vivo","enable":"Permitir","finished":"Acabada","host_video":"Host Video","join_now":"\u00danete ahora","live_consultation_details":"Detalles de la consulta en vivo","new_live_consultation":"Nueva consulta en vivo","new_live_meeting":"Nueva reuni\u00f3n en vivo","select_consultation_date":"Seleccione Fecha de Consulta","select_doctor_name":"Seleccione el nombre del m\u00e9dico","select_patient_name":"Seleccione el nombre del paciente","staff_list":"Lista de personal","start_now":"Empezar ahora","type":"Escribe","type_number":"Teclea un n\u00famero","zoom_api_key":"Zoom clave API","zoom_api_secret":"Zoom API Secreto"},"live_consultations":"consultas en vivo","live_status_retrieved_successfully.":"Estado en vivo recuperado exitosamente.","login":"Iniciar sesi\u00f3n","medicine":{"available_quantity":"Cantidad disponible","brand":"Marca","brand_name":"Nombre de la marca","buying_price":"Precio de compra","cant_be_deleted":"no se puede eliminar","category":"Categor\u00eda","category_id":"Categoria ID","category_retrieved_successfully":"Categor\u00eda de medicamento recuperada exitosamente.","deleted_successfully":"borrado exitosamente","description":"Descripci\u00f3n","dosage":"Dosis","dose_interval":"Seleccione el intervalo de dosis","duration":"Duraci\u00f3n","edit_medicine":"Editar Medicina","edit_medicine_brand":"Editar marca de medicamento","edit_medicine_category":"Editar categor\u00eda de medicina","filter_options":"Opciones de filtro","medicine":"Medicamento","medicine_brands":"Marcas de medicamentos","medicine_brands_details":"Detalles de la marca de medicamentos","medicine_category":"Categor\u00eda de medicina","medicine_category_details":"Detalles de la categor\u00eda de medicamentos","medicine_details":"Detalles de la medicina","medicine_name":"Nombre del medicamento","medicine_retrieved_successfully":"Medicine Retrieved Successfully","medicines":"Medicamentos","name":"Nombre","new_brand":"Marca nueva","new_medicine":"nueva medicina","new_medicine_brand":"Nueva marca de medicamentos","new_medicine_category":"Nueva categor\u00eda de medicina","no_use":"No esta en uso","quantity":"Cantidad","salt_composition":"Composici\u00f3n de sal","saved_successfully":"Guardado exitosamente","select_duration":"Seleccionar duraci\u00f3n","selling_price":"Precio de venta","side_effects":"Efectos secundarios","status_updated_successfully":"Estado actualizado correctamente.","updated_successfully":"actualizado con \u00e9xito"},"medicine_bills":{"add_medicine_bill":"Agregar factura de medicamentos","available_quantity":"La cantidad disponible de","avl_qty":"Cantidad promedio","bill_date":"Fecha de pago","bill_id":"ID de factura","bill_number":"N\u00famero de factura","cell_no":"N\u00famero de celda","dose_interval":"Intervalo de dosis","duplicate_medicine":"No se pueden agregar medicamentos duplicados.","edit_medicine_bill":"Editar factura de medicamentos","enter_lot_number":"Introduzca el n\u00famero de lote.","enter_puchase_price":"Introduzca el precio de compra","enter_sale_price":"Ingrese el precio de venta.","is":"es","item_name":"Nombre del \u00e1rticulo","medicine_bill":"Proyecto de ley de medicamentos","medicine_bill_details":"Detalles de la factura de medicamentos","medicine_bills":"Facturas de medicamentos","medicine_not_selected":"Seleccione al menos un medicamento.","medicine_required":"Se requiere campo de medicina.","net_amount_cant":"El importe neto no puede estar vac\u00edo.","net_amount_cant_zero":"El importe neto no puede ser cero.","net_amount_not_empty":"El importe neto no puede estar vac\u00edo.","net_amount_not_zero":"El importe neto no puede ser cero.","new_medicine_bill":"Nuevo proyecto de ley de medicamentos","payment_status":"Estado de pago","payment_type":"Tipo de pago","prescription_not_found":"Receta no encontrada","price":"Precio","print_bill":"Imprimir factura","quantity_should":"La cantidad debe ser mayor que 0.","sale_price":"Precio de venta","select_medicine":"Seleccione Medicina","select_patient":"Seleccione Paciente","select_payment_type":"Seleccionar tipo de pago","tax_amt":"El monto del impuesto no puede ser cero ni estar vac\u00edo.","tax_cannot_be_zero_empty":"Los impuestos deben ser inferiores al 100%.","tax_should_be":"Taxes should be less than 100%.","the_discount_shoul":"El descuento debe ser menor que el monto total.","the_medicine_already_in_use":"Este medicamento ya se utiliza en las facturas de medicamentos, \u00bfseguro que deseas eliminarlo?","update_quantity":"La cantidad de actualizaci\u00f3n debe ser menor que la cantidad anterior."},"medicine_brands":"Marcas de medicamentos","medicine_categories":"Categor\u00edas de medicamentos","medicines":"Medicamentos","mobile_no":"No m\u00f3viles","months":{"apr":"Abr","aug":"Ago","dec":"Dic","feb":"Feb","jan":"Ene","jul":"Jul","jun":"Jun","mar":"Mar","may":"Mayo","nov":"Nov","oct":"Oct","sep":"Sep"},"no_response":"No se obtuvo respuesta","not_supported":"No soportado","note":"Nota: Debe configurar su zona horaria antes de integrar Google Calendar.","notification":{"mark_all_as_read":"Marcar todo como leido","notification":"Notificaciones","you_don`t_have_any_new_notification":"No tienes ninguna notificaci\u00f3n nueva"},"patient":{"add":"Agregar paciente","address1":"Direcci\u00f3n 1","address2":"Direcci\u00f3n 2","address_information":"Informaci\u00f3n de direcci\u00f3n","blood_group":"Grupo sangu\u00edneo","city":"Ciudad","confirm_password":"Confirmar contrase\u00f1a","contact_no":"No de contacto","country":"Pa\u00eds","details":"Detalles del paciente","dob":"fecha de nacimiento","edit":"Editar paciente","email":"Correo electr\u00f3nico","emailverified":"Correo Electr\u00f3nico Verificado","enter_email":"Ingrese correo electr\u00f3nico","enter_password":"Introducir la contrase\u00f1a","female":"Mujer","filter":"filtrar","first_name":"Nombre","gender":"G\u00e9nero","last_name":"Apellido","last_updated":"\u00daltima actualizaci\u00f3n","male":"Hombre","name":"Nombre","password":"Contrase\u00f1a","patient_unique_id":"Identificaci\u00f3n \u00fanica del paciente","postal_code":"C\u00f3digo postal","profile":"Perfil","registered_on":"Registrado en","save_changes":"Guardar cambios","state":"Estado","today":"Hoy"},"patient_dashboard":{"completed_appointments":"Citas completadas","next_appointment":"Pr\u00f3ximas citas","today_appointments":"Citas de hoy","upcoming_appointments":"Pr\u00f3ximas citas"},"patients":"Pacientes","payment_detail":"Detalles de pago","payment_for_booking_appointment_with_doctor":"Pago por reserva de cita con el m\u00e9dico.","payment_method":{"authorize":"Autorizar","paypal":"Paypal","paystack":"Pila de pago","paytm":"Pago","razorpay":"Pago de la maquinilla de afeitar","stripe":"Raya"},"paytm":"pago","prescription":{"accident":"Accidente","advice":"consejo","after meal":"despu\u00e9s de comer","appointment_slot":"Espacios para citas","available_quantity_of":"La cantidad disponible de ","before meal":"Antes de la comida","breast_feeding":"Lactancia materna","comment":"comentario","connect_with_zoom":" Con\u00e9ctate con Zoom","current_medication":"Medicaci\u00c3\u00b3n actual","days":"d\u00edas","diabetic":"Diab\u00c3\u00a9tica","doctor":"M\u00c3\u00a9dico","dosage":"Dosis","duration":"Duraci\u00f3n","edit_prescription":"Editar receta","female_pregnancy":"Embarazo femenino","food_allergies":"Alergias a los alimentos","frequency":"Frecuencia","health_insurance":"Seguro de salud","heart_disease":"Enfermedad del coraz\u00c3\u00b3n","high_blood_pressure":"Alta presi\u00c3\u00b3n sangu\u00c3\u00adnea","is":"es","low_income":"De bajos ingresos","medical_history":"Historial m\u00c3\u00a9dico","medicine_name":"nombre_medicamento","name":"Nombre","new_medicine":"nueva medicina","new_prescription":"Nueva receta","next_visit":"siguiente visita","not_add_duplicate_medicines":"No se pueden agregar medicamentos duplicados.","ok":"De acuerdo","others":"Otras","patient":"Paciente","physical_information":"Informaci\u00f3n F\u00edsica","plus_rate":"legumbres adicional","prescription":"Prescripci\u00c3\u00b3n","prescription_details":"Detalles de prescripci\u00c3\u00b3n","prescription_saved":"La receta se guard\u00f3 correctamente.","prescription_updated":"Receta actualizada exitosamente.","prescriptions":"Recetas","problem":"problema","problem_description":"Descripci\u00f3n del problema","reference":"Referencia","rx":"Rx","selectMedicine":"Seleccionar medicamento","surgery":"Cirug\u00c3\u00ada","temperature":"la temperatura","tendency_bleed":"Tendencia de Sangrado","test":"prueba","time":"tiempo","total_quantity":"Cantidad total"},"privacy_policy":"Pol\u00edtica de privacidad","purchase_medicine":{"actions":"Comportamiento","amount":"Cantidad","discount":"Descuento","dose_duration":"Dosis Duraci\u00f3n","expiry_date":"Fecha de caducidad","export_to_excel":"Exportar a Excel","lot_no":"Mucho no.","net_amount":"Importe neto","note":"Nota","other_details":"Otros detalles","payment_mode":"Modo de pago","payment_note":"Nota de pago","purchase_medicine":"Comprar Medicina","purchase_medicine_details":"Detalles de la compra de medicamentos","purchase_medicine_overview":"Descripci\u00f3n general de la compra de medicamentos","purchase_medicines":"Comprar Medicamentos","purchase_number":"N\u00famero de compra","purchased_medicine_success":"Medicamento comprado con \u00e9xito","quantity":"Cantidad","tax":"Impuesto","tax_amount":"Importe del impuesto","total":"Total"},"range_constructor_requires_trie_parameter":"El constructor de rango requiere un par\u00e1metro Trie","register":"Registrarse","requires_string_parameter":"rangeWithString requiere un par\u00e1metro de cadena","resend_email_verification":"Reenviar verificaci\u00f3n de correo electr\u00f3nico","review":{"add_review":"Agregar una opini\u00f3n","edit_review":"Editar rese\u00f1a","no_doctors_available_to_give_rating":"No hay m\u00e9dicos disponibles para calificar.","review":"Revisar","write_a_review":"Escribe una rese\u00f1a"},"reviews":"cr\u00edticas","role":{"add_role":"Agregar rol","edit_role":"Editar rol","permissions":"Permisos","role":"Rol","role_permissions":"Permisos de rol","select_all_permissions":"Seleccionar todos los permisos"},"roles":"Roles","service":{"add_service":"Agregar servicio","category":"Categor\u00eda","charges":"Cargos","edit_service":"Editar servicio","short_description":"Descripci\u00f3n breve"},"service_categories":"Categor\u00edas de servicios","service_category":{"add_category":"Agregar categor\u00eda de servicio","edit_category":"Editar categor\u00eda de servicio","service_category":"Categor\u00eda de servicio"},"services":"Servicios","setting":{"address":"Direcci\u00f3n","change_app_logo":"Cambiar el logotipo de la aplicaci\u00f3n","change_favicon":"Cambiar icono de favorito","clinic_name":"Nombre de la cl\u00ednica","connect_google_calendar":"Google Kalender verbinden","connect_your_google_calendar":"Verbinden Sie Ihren Google-Kalender","contact_information":"Informaci\u00f3n de contacto","currency":"Moneda","currency_settings":"Configuraci\u00f3n de moneda","default_country_code":"C\u00f3digo de pa\u00eds predeterminado","default_language_suggest":"Al actualizar esto, el idioma completo de la aplicaci\u00f3n cambiar\u00e1 en los inicios de sesi\u00f3n del m\u00e9dico, del paciente y en la parte frontal.","disconnect_your_google_calendar":"Verbindung zu Ihrem Google-Kalender trennen","do_not_allow_to_login_without_email_verification":"No permitir iniciar sesi\u00f3n sin verificaci\u00f3n de correo electr\u00f3nico","favicon":"Favicon","general":"General","general_details":"Detalles generales","logo":"Logotipo","postal_code":"C\u00f3digo postal","prefix":"Prefijo","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"Seleccione sus calendarios (de Google Calendar) en los que desea crear las citas","setting":"Configuraci\u00f3n","specialities":"Especialidades","sync_your_google_calendar":"Ihren Google-Kalender synchronisieren","when_checkbox_disable":"Cuando la casilla de verificaci\u00f3n est\u00e1 desactivada, la verificaci\u00f3n de correo electr\u00f3nico no funciona para los nuevos usuarios.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Cuando el paciente reserve una cita con usted, se crear\u00e1 una nueva cita en los calendarios seleccionados","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Cuando reserve una cita, se crear\u00e1 una nueva cita en los calendarios seleccionados"},"settings":"Configuraci\u00f3n","slider":{"add_slider":"Agregar control deslizante","edit_slider":"Editar control deslizante","image":"Imagen","short_description":"Descripci\u00f3n breve","title":"T\u00edtulo"},"sliders":"Deslizadores","smart_patient_card":{"add_smart_card":"Agregar Tarjeta Inteligente","add_smart_card_templates":"Agregar Plantillas de Tarjetas Inteligentes","address_show":"Mostrar Direcci\u00f3n","blood_group_show":"Mostrar Grupo Sangu\u00edneo","dob_show":"Mostrar Fecha de Nacimiento","edit_patient_card":"Editar Tarjeta Inteligente","email_show":"Mostrar Correo Electr\u00f3nico","enter_template_name":"Ingresar Nombre de Plantilla","for_all_patient":"Para Todos los Pacientes","generate_patient_card":"Generar Tarjeta de Paciente","generate_patient_smart_cards":"Generar Tarjetas de Pacientes Inteligentes","header_color":"Color del Encabezado","only_one_patient":"Solo para un Paciente","patient":"Paciente","patient_smart_card_created":"Tarjeta inteligente del paciente creada correctamente.","patient_smart_card_deleted":"Tarjeta inteligente del paciente eliminada correctamente.","phone_show":"Mostrar Tel\u00e9fono","please_selest_patient":"Por favor seleccione paciente","remaning_patients":"Pacientes Restantes","select_patient":"Seleccionar Paciente","select_template":"Seleccionar Plantilla","smart_patient_card_templates":"Plantillas de Tarjetas de Pacientes Inteligentes","smart_patient_cards":"Tarjetas de Pacientes Inteligentes","templat_name":"Nombre de la Plantilla","template":"Plantilla","template_created":"Plantilla creada correctamente.","template_deleted":"Plantilla eliminada correctamente.","template_update":"Actualizaci\u00f3n de plantilla exitosa.","type":"Tipo","unique_id_show":"Mostrar Identificador \u00danico"},"specialization":{"add_specialization":"Agregar especializaci\u00f3n","edit_specialization":"Editar especializaci\u00f3n","retrieved_successfully":"Especializaci\u00f3n recuperada con \u00e9xito."},"specializations":"Especializaciones","staff":{"add_staff":"Agregar personal","confirm_password":"Confirmar contrase\u00f1a","contact_no":"No de contacto","edit_staff":"Editar personal","email":"Correo electr\u00f3nico","female":"Mujer","first_name":"Nombre","gender":"G\u00e9nero","last_name":"Apellido","male":"Hombre","password":"Contrase\u00f1a","role":"Rol","select_role":"Seleccionar rol","staff":"personal","staff_details":"Detalles del personal"},"staffs":"Bastones","start_time_invalid":"la hora de inicio del d\u00eda no es v\u00e1lida","state":{"add_state":"Agregar estado","country":"Pa\u00eds","edit_state":"Editar estado","state":"Estado","states":"estados"},"states":"Estados","subscribers":"Suscriptores","terms_conditions":"T\u00e9rminos y condiciones","too_long":"Demasiado largo","too_short":"Demasiado corto","transaction":{"paid":"Pay\u00e9","payment_accepted_by":"Pago aceptado por","payment_status":"Estado de pago","pending":"Pendiente","transaction_detail":"Detalle de la transacci\u00f3n","transaction_id":"ID de transacci\u00f3n"},"transactions":"actas","used_medicine":{"used_at":"Usado en","used_medicine":"Medicina Usada","used_medicines":"Medicamentos Usados","used_quantity":"Cantidad usada"},"user":{"account":"Cuenta","account_setting":"Configuraci\u00f3n de la cuenta","avatar":"Avatar","change_language":"Cambiar idioma","change_password":"Cambiar contrase\u00f1a","confirm_password":"Confirmar contrase\u00f1a","contact_number":"N\u00famero de contacto","current_password":"Contrase\u00f1a actual","edit_profile":"Editar perfil","email":"Correo electr\u00f3nico","email_notification":"Notificaci\u00f3n de correo electr\u00f3nico","full_name":"Nombre completo","gender":"G\u00e9nero","language":"Idioma","new_password":"Nueva contrase\u00f1a","profile_details":"Detalles del perfil","return_to_admin":"Volver al administrador","save_changes":"Guardar cambios","select_time_zone":"Selecciona la zona horaria","setting":"Configuraci\u00f3n","sign_out":"Cerrar sesi\u00f3n","staff_details":"Detalles del personal","time_zone":"Zona horaria"},"users":"Usuarios","valid_expiration_date":"Ingrese una fecha de vencimiento v\u00e1lida.","valid_number":"N\u00famero v\u00e1lido","visit":{"add_visit":"Agregar visita","description":"Descripci\u00f3n","doctor":"Doctor","edit_visit":"Editar visita","enter_note":"Ingresar nota","enter_observation":"Introducir observaci\u00f3n","enter_problem":"Introduce el problema","notes":"Notas","observations":"Observaciones","patient":"Paciente","prescriptions":"Recetas","problems":"Problemas","title":"T\u00edtulo","visit_date":"Fecha de visita","visit_detail":"Detalle de la visita","visit_details":"Detalles de la visita"},"visits":"Visitas","web":{"Meet_best_doctors":"Conoce a los mejores m\u00e9dicos","about_experience":"Acerca de la experiencia","about_short_description":"Acerca de la descripci\u00f3n breve","about_title":"Acerca del t\u00edtulo","about_us":"sobre","all_rights_reserved":"Reservados todos los derechos","all_services":"Todos los servicios","already_have_an_account":"Ya tengo una cuenta","already_have_patient_account":"Ya tengo una cuenta de paciente","appointment":"Cita","appointment_now":"Cita ahora","best_professionals":"Mejores Profesionales","book_an_appointment":"Reserve una cita","book_appointment":"Reservar una cita","call_us":"Ll\u00e1manos","closed":"Cerrado","confirm_booking":"Confirmar reserva","contact":"Contacto","contact_us":"Cont\u00e1ctenos","contact_us_for_any_information":"Cont\u00e1ctenos para cualquier informaci\u00f3n","create_an_account":"Crear una cuenta","created_at":"Creado en","doctors":"Doctores","doctors_can_interact___":"Los m\u00e9dicos pueden interactuar con los pacientes y realizar tratamientos relacionados","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Formule din\u00e1micamente resultados sin errores antes de los resultados integrados. Incubar dram\u00e1ticamente los recursos integrados sin costo efectivo \"fuera del.","email":"Correo electr\u00f3nico","email_address":"Direcci\u00f3n de correo electr\u00f3nico","emergency_help":"Ayuda de emergencia","enquiry":"Consulta","enquiry_details":"Detalles de la consulta","enter_your_email":"Introduce tu correo electr\u00f3nico","enter_your_email_to_subscribe_to_our_newsletter":"Ingrese su correo electr\u00f3nico para suscribirse a nuestro bolet\u00edn","faqs":"Preguntas frecuentes","forgot_password":"Olvid\u00e9 mi contrase\u00f1a","home":"Inicio","how_we_works":"C\u00f3mo trabajamos","i_agree":"Estoy de acuerdo","location":"localizaci\u00f3n","login":"Iniciar sesi\u00f3n","make_appointment":"Concertar cita","medical":"M\u00e9dico","medical_about_us":"M\u00e9dico acerca de nosotros","medical_appointment":"Cita m\u00e9dica","medical_contact":"Contacto m\u00e9dico","medical_doctors":"M\u00e9dicos","medical_services":"Servicios m\u00e9dicos","medical_treatment":"Tratamiento m\u00e9dico","meet_our_team_of_specialists":"Conozca a nuestro equipo de especialistas","message":"Mensaje","name":"Nombre","new_here":"Nuevo aqu\u00ed","no_services_available":"No hay servicios disponibles","opening_hours":"Horarios de apertura","our_doctor":"Nuestro Doctor","our_team":"Nuestro equipo","patient_can_book_an_appointment___":"El paciente puede reservar una cita con el m\u00e9dico desde la p\u00e1gina de inicio o desde su panel de inicio de sesi\u00f3n.","patient_can_do_registration___":"El paciente puede hacer el registro desde aqu\u00ed con informaci\u00f3n b\u00e1sica.","patient_name":"Nombre del paciente","patient_registration":"Registro de pacientes","phone":"Tel\u00e9fono","qualified_doctors":"Doctores calificados","questions_before_booking":"Preguntas antes de reservar","quick_links":"Enlaces r\u00e1pidos","reason":"Raz\u00f3n","registration":"Registro","remember_me":"Recu\u00e9rdame","satisfied_patient":"Paciente satisfecho","saying_about_us":"Diciendo sobre nosotros","see_what_are_the_patients":"Ver qu\u00e9 son los pacientes","send_an_email":"Enviar un correo electr\u00f3nico","send_message":"Enviar mensaje","send_us_an_email":"Env\u00edenos un correo electr\u00f3nico","services":"Servicios","sign_in":"Iniciar sesi\u00f3n","sign_in_here":"Iniciar sesi\u00f3n aqu\u00ed","sign_up":"Inscribirse","status":"Estado","subject":"Asunto","subscribe":"Suscribirse","take_treatment":"Tomar tratamiento","terms_and_conditions":"T\u00e9rminos y condiciones","testimonial":"Testimonial","timings":"Tiempos","total_doctors":"Total de m\u00e9dicos","total_registered_patient":"Total de pacientes registrados","total_services":"Servicios totales","total_specializations":"Especializaciones totales","view_more":"Ver m\u00e1s","we_cover_a_big___":"Cubrimos una gran variedad de servicios m\u00e9dicos","we_make_sure_that_your_life_are_in_good_hands":"Nos aseguramos de que su vida est\u00e9 en buenas manos","we_provide_the_special_tips___":"Brindamos los consejos y sugerencias especiales de tratamiento de atenci\u00f3n m\u00e9dica y un alto nivel de lo mejor.","working_process":"Proceso de trabajo","year_experience":"Experiencia de un a\u00f1o"},"weekdays":{"fri":"VIE","mon":"LUN","sat":"Se sent\u00f3","sun":"SOL","thu":"JUE","tue":"MAR","wed":"CASARSE"}},"es.pagination":{"next":"pr\u00f3ximo","previous":"Anterior"},"es.passwords":{"reset":"\u00a1Tu contrase\u00f1a ha sido restablecida!","sent":"\u00a1Hemos enviado su enlace de restablecimiento de contrase\u00f1a por correo electr\u00f3nico!","throttled":"Espere antes de volver a intentarlo.","token":"Este token de restablecimiento de contrase\u00f1a no es v\u00e1lido.","user":"No podemos encontrar un usuario con esa direcci\u00f3n de correo electr\u00f3nico."},"es.validation":{"accepted":"Se debe aceptar el atributo :.","active_url":"El atributo: no es una URL v\u00e1lida.","after":"El atributo: debe ser una fecha posterior a: fecha.","after_or_equal":"El atributo: debe ser una fecha posterior o igual a: fecha.","alpha":"El atributo: solo puede contener letras.","alpha_dash":"El atributo: solo puede contener letras, n\u00fameros, guiones y guiones bajos.","alpha_num":"El atributo: solo puede contener letras y n\u00fameros.","array":"El atributo: debe ser una matriz.","attributes":[],"before":"El atributo: debe ser una fecha anterior a: fecha.","before_or_equal":"El atributo: debe ser una fecha anterior o igual a: fecha.","between":{"array":"El atributo: debe tener entre: min y: max elementos.","file":"El atributo: debe estar entre: min y: max kilobytes.","numeric":"El atributo: debe estar entre: min y: max.","string":"El atributo: debe estar entre: min y: max caracteres."},"boolean":"El campo de atributo: debe ser verdadero o falso.","confirmed":"La confirmaci\u00f3n del atributo: no coincide.","current_password":"La contrase\u00f1a es incorrecta.","custom":{"attribute-name":{"rule-name":"mensaje personalizado"}},"date":"El atributo: no es una fecha v\u00e1lida.","date_equals":"El atributo: debe ser una fecha igual a: fecha.","date_format":"El atributo: no coincide con el formato: formato.","different":"El: atributo y: otro deben ser diferentes.","digits":"El atributo: debe ser: d\u00edgitos d\u00edgitos.","digits_between":"El atributo: debe estar entre: min y: max d\u00edgitos.","dimensions":"El atributo: tiene dimensiones de imagen no v\u00e1lidas.","distinct":"El campo de atributo: tiene un valor duplicado.","email":"El atributo: debe ser una direcci\u00f3n de correo electr\u00f3nico v\u00e1lida.","ends_with":"El atributo: debe terminar con uno de los siguientes valores::.","exists":"El atributo seleccionado: no es v\u00e1lido.","file":"El atributo: debe ser un archivo.","filled":"El campo de atributo: debe tener un valor.","gt":{"array":"El atributo: debe tener m\u00e1s de: elementos de valor.","file":"El atributo: debe ser mayor que: valor kilobytes.","numeric":"El: atributo debe ser mayor que: valor.","string":"El atributo: debe ser mayor que los caracteres de valor."},"gte":{"array":"El atributo: debe tener: elementos de valor o m\u00e1s.","file":"El atributo: debe ser mayor o igual que: valor kilobytes.","numeric":"El: atributo debe ser mayor o igual que: valor.","string":"El atributo: debe ser mayor o igual que los caracteres de valor."},"image":"El atributo: debe ser una imagen.","in":"El atributo seleccionado: no es v\u00e1lido.","in_array":"El campo de atributo: no existe en: otro.","integer":"El: atributo debe ser un entero.","ip":"El atributo: debe ser una direcci\u00f3n IP v\u00e1lida.","ipv4":"El atributo: debe ser una direcci\u00f3n IPv4 v\u00e1lida.","ipv6":"El: atributo debe ser una direcci\u00f3n IPv6 v\u00e1lida.","json":"El atributo: debe ser una cadena JSON v\u00e1lida.","lt":{"array":"El atributo: debe tener menos de: elementos de valor.","file":"El atributo: debe ser menor que: valor kilobytes.","numeric":"El atributo: debe ser menor que: valor.","string":"El atributo: debe tener menos de: valores de caracteres."},"lte":{"array":"El atributo: no debe tener m\u00e1s de: elementos de valor.","file":"El atributo: debe ser menor o igual que: valor kilobytes.","numeric":"El: atributo debe ser menor o igual que: valor.","string":"El atributo: debe ser menor o igual que los caracteres de valor."},"max":{"array":"El atributo: no puede tener m\u00e1s de: elementos m\u00e1ximos.","file":"El atributo: no puede ser mayor que: kilobytes m\u00e1ximos.","numeric":"El atributo: no puede ser mayor que: m\u00e1x.","string":"El atributo: no puede ser mayor que: m\u00e1ximo de caracteres."},"mimes":"El atributo: debe ser un archivo de tipo:: valores.","mimetypes":"El atributo: debe ser un archivo de tipo:: valores.","min":{"array":"El atributo: debe tener al menos: elementos m\u00ednimos.","file":"El: atributo debe ser al menos: min kilobytes.","numeric":"El atributo: debe ser al menos: min.","string":"El atributo: debe tener al menos: min caracteres."},"multiple_of":"El atributo: debe ser un m\u00faltiplo de: valor.","not_in":"El atributo seleccionado: no es v\u00e1lido.","not_regex":"El formato del atributo no es v\u00e1lido.","numeric":"El: atributo debe ser un n\u00famero.","password":"La contrase\u00f1a es incorrecta.","present":"El campo de atributo: debe estar presente.","prohibited":"El campo de atributo: est\u00e1 prohibido.","prohibited_if":"El campo de atributo: est\u00e1 prohibido cuando: otro es: valor.","prohibited_unless":"El campo de atributo: est\u00e1 prohibido a menos que: otro est\u00e9 en: valores.","regex":"El formato del atributo no es v\u00e1lido.","required":"El campo de atributo: es obligatorio.","required_if":"El campo de atributo: es obligatorio cuando: otro es: valor.","required_unless":"El campo: atributo es obligatorio a menos que: otro est\u00e9 en: valores.","required_with":"El campo: atributo es obligatorio cuando: valores est\u00e1n presentes.","required_with_all":"El campo: atributo es obligatorio cuando: los valores est\u00e1n presentes.","required_without":"El campo: atributo es obligatorio cuando: los valores no est\u00e1n presentes.","required_without_all":"El campo de atributo: es obligatorio cuando ninguno de los valores: est\u00e1 presente.","same":"El atributo: y: otro deben coincidir.","size":{"array":"El atributo: debe contener: art\u00edculos de tama\u00f1o.","file":"El atributo: debe ser: tama\u00f1o kilobytes.","numeric":"El atributo: debe ser: tama\u00f1o.","string":"El atributo: debe tener: caracteres de tama\u00f1o."},"starts_with":"El atributo: debe comenzar con uno de los siguientes valores::","string":"El atributo: debe ser una cadena.","timezone":"El atributo: debe ser una zona v\u00e1lida.","unique":"El atributo: ya se ha tomado.","uploaded":"El: atributo no se pudo cargar.","url":"El formato del atributo no es v\u00e1lido.","uuid":"El atributo: debe ser un UUID v\u00e1lido."},"fr.auth":{"app":{"create":"Cr\u00e9er","export":"Exporter","lock_account":"Verrouiller le compte","member_since":"Membre depuis","messages":"Messages","online":"En ligne","print":"Imprimer","profile":"Profil","reload":"Recharger","reset":"R\u00e9initialiser","search":"Rechercher","settings":"Param\u00e8tres"},"confirm_password":"Confirmer le mot de passe","email":"Courriel","emails":{"password":{"reset_link":"Cliquez ici pour r\u00e9initialiser votre mot de passe"}},"failed":"Ces informations d'identification ne correspondent pas \u00e0 nos enregistrements.","forgot_password":{"send_pwd_reset":"Envoyer le lien de r\u00e9initialisation du mot de passe","title":"Entrez l'email pour r\u00e9initialiser le mot de passe"},"full_name":"Nom complet","login":{"forgot_password":"J'ai oubli\u00e9 mon mot de passe","register_membership":"Enregistrer une nouvelle adh\u00e9sion","title":"Connectez-vous pour d\u00e9marrer votre session"},"password":"Mot de passe","register":"Register","registration":{"have_membership":"J'ai d\u00e9j\u00e0 un abonnement","i_agree":"J'accepte","terms":"les termes","title":"Enregistrer une nouvelle adh\u00e9sion"},"remember_me":"Se souvenir de moi","reset_password":{"reset_pwd_btn":"R\u00e9initialiser le mot de passe","title":"R\u00e9initialiser votre mot de passe"},"sign_in":"Connexion","sign_out":"D\u00e9connexion","throttle":"Trop de tentatives de connexion. Veuillez r\u00e9essayer dans :secondes secondes."},"fr.messages":{"admin_dashboard":{"dashboard":"Tableau de bord","day":"Jour","earnings_from_appointments":"Revenus des nominations","filter_options":"Options de filtrage","month":"Mois","name":"Nom","patient_id":"Identifiant unique du patient","recent_patients_registration":"Enregistrement des Patients R\u00e9cents","registered":"Inscrit","today_appointments":"Rendez-vous aujourd'hui","today_registered_patients":"Patients enregistr\u00e9s aujourd'hui","total_doctor":"Total des m\u00e9decins","total_patients":"Total des patients","week":"Semaine"},"appointment":{"Select_payment_method":"S\u00e9lectionnez le mode de paiement","add_new_appointment":"Ajouter un rendez-vous","appointment_at":"Rendez-vous \u00e0","appointment_date":"Date de rendez-vous","appointment_details":"D\u00e9tails du rendez-vous","appointment_status":"Statut du rendez-vous","appointment_unique_id":"Identifiant de rendez-vous","appointments":"Rendez-vous","appointments_schedule":"Calendrier des rendez-vous","authorize_session_created_successfully":"Autoriser la session cr\u00e9\u00e9e avec succ\u00e8s.","available":"Disponible","available_slot":"Slots disponibles","booked":"R\u00e9serv\u00e9","calendar":"Calendrier","cancel_appointment":"Annuler rendez-vous","cancelled":"Annul\u00e9","charge":"Frais","check_in":"Enregistrer","check_out":"R\u00e9cup\u00e9rer","date":"Date","description":"Description","edit_appointment":"Modifier le rendez-vous","ends":"Fin","extra_fees":"Frais suppl\u00e9mentaires","no_slot_found":"Aucune plage horaire trouv\u00e9e.","patient":"Patient","patient_id":"Identifiant du patient","patient_name_retrieved":"Nom du patient r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","payable_amount":"Montant \u00e0 payer","payment":"Paiement","payment_method":"Mode de paiement","payment_status":"Statut de paiement","service":"Service","service_charge":"Frais de service","session_created_successfully":"session cr\u00e9\u00e9e avec succ\u00e8s","session_id_required":"l'identifiant de session est requis","starts":"D\u00e9marre","status":"Statut","switch_to_calendar":"Passer au Calendrier","time":"Temps","total_payable_amount":"Montant total \u00e0 payer","upcoming_meetings":"rendez-vous \u00e0 venir"},"appointments":"Rendez-vous","apps":"Applications","card_number_invalid..":"Le num\u00e9ro de carte est invalide.","card_type":"Type de carte de cr\u00e9dit","cities":"Villes","city":{"add_city":"Ajouter une ville","city":"Ville","edit_city":"Modifier la ville","state":"Etat"},"clinic_schedules":"Horaires des Cliniques","cms":{"Terms_Conditions_required":"Les conditions g\u00e9n\u00e9rales sont requises","about_image":"\u00c0 propos de l'image","cms":"CMS","description_no_white_space":"Le champ \u00c0 propos de la description courte ne contient pas uniquement des espaces blancs","experience_required":"Le champ \u00c0 propos de l\u2019exp\u00e9rience est obligatoire.","privacy_policy":"Politique de confidentialit\u00e9","privacy_policy_required.":"La politique de confidentialit\u00e9 est requise.","terms_conditions":"Termes & Conditions","title_no_white_space":"Le champ \u00c0 propos du titre ne contient pas uniquement des espaces blancs"},"common":{"Attempt_read_property_access_token_null":"Tentative de lecture de la propri\u00e9t\u00e9 \u00ab\u00a0access_token\u00a0\u00bb sur null","Forgot_password_lable":"Avez-vous oubli\u00e9 votre mot de passe? Aucun probl\u00e8me. Indiquez-nous simplement votre adresse e-mail et nous vous enverrons un lien de r\u00e9initialisation de mot de passe qui vous permettra d'en choisir un nouveau.","action":"Action","active":"Actif","add":"Ajouter","add_credential":"Veuillez ajouter les informations d'identification du zoom","age":"\u00c2ge","any_one_permission":"Veuillez s\u00e9lectionner une autorisation..","apply":"Appliquer","appointment_date_required":"Le champ date du rendez-vous est obligatoire.","are_you_sure":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_cancel":"\u00cates-vous s\u00fbr de vouloir annuler ceci","back":"Retour","booked":"R\u00e9serv\u00e9","brand_required":"Le champ marque est obligatoire.","cancel":"Annuler","cancelled":"Annul\u00e9","cancelled_appointment":"Rendez-vous annul\u00e9 !","category_required":"Le champ cat\u00e9gorie est obligatoire.","change_image":"Changer l'image","check in":"Enregistrement","check out":"V\u00e9rifier","city":"Ville","confirm":"Confirmer","connected_zoom":"Connect\u00e9 avec zoom avec succ\u00e8s.","contact_number":"Le num\u00e9ro de contact est","country":"Pays","custom":"Personnalis\u00e9","de_active":"D\u00e9sactiver","default_language":"Langage par d\u00e9faut","delete":"Effacer","deleted":"Supprim\u00e9\u00a0!","details":"D\u00e9tails","discard":"Rejeter","doctor_required":"Le champ M\u00e9decin est obligatoire.","download":"T\u00e9l\u00e9charger","edit":"Modifier","email_already_exist":"L'e-mail est d\u00e9j\u00e0 abonn\u00e9.","email_max":"La taille maximale de l'e-mail est de 255.","email_not_register":"L'e-mail n'est pas enregistr\u00e9.","email_regex":"Le champ email doit \u00eatre au format valide.","email_required":"Le champ e-mail est obligatoire.","email_verified":"Email verifi\u00e9","error":"Erreur","filter":"Filtre","filter_option":"Option de filtrage","first_name_required":"Le champ Pr\u00e9nom est obligatoire.","forgot_your_password":"Mot de passe oubli\u00e9","from":"De","google_captcha_required":"Le champ captcha Google est obligatoire.","has_been":"a \u00e9t\u00e9 supprim\u00e9.","has_cancel":" a \u00e9t\u00e9 annul\u00e9.","hour":"Heure","impersonate":"imiter","instagram_url":"URL Instagram","last_name_required":"Le champ Nom de famille est obligatoire.","linkedin_url":"URL Linkedin","logout":"Se d\u00e9connecter","maximum_55":"Un maximum de 55\u00a0caract\u00e8res est autoris\u00e9.","message_required":"Le champ message est obligatoire.","minutes":"Minutes","n\/a":"N\/A","name":"Nom","name_already_taken":"Le nom a d\u00e9j\u00e0 \u00e9t\u00e9 pris","name_required":"Le champ Nom est obligatoire","no":"Non, Annuler","no_data_available":"Aucune donn\u00e9e disponible","no_data_available_in_table":"aucune donn\u00e9e disponible","no_records_found":"Aucun enregistrement trouv\u00e9.","not_allow__assess_record":"Il semble que vous n'\u00eates pas autoris\u00e9 \u00e0 acc\u00e9der \u00e0 cet enregistrement.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Remarque : Nous prenons le fuseau horaire de vos m\u00e9decins lors de la cr\u00e9ation de rendez-vous dans le calendrier. Si le m\u00e9decin n'a pas d\u00e9fini le fuseau horaire, il utilisera le fuseau horaire UTC par d\u00e9faut.","note_white_space":"Le champ de note ne contient pas uniquement des espaces blancs","observation_white_space":"Le champ d'observation ne contient pas uniquement des espaces blancs","of":"de","overview":"Aper\u00e7u","payment_type_required":"Le champ Mode de paiement est obligatoire.","please_wait":"Veuillez patienter...","prescription_report":"Rapport de prescription","problem_white_space":"Le champ du probl\u00e8me ne contient pas uniquement des espaces blancs","processing":"Traitement..","purchase_price":"Prix \u200b\u200bd'achat","read":"Lis","remember_me":"Souviens-toi de moi","resend_verification_email":"Renvoyer l'e-mail de v\u00e9rification","reset":"R\u00e9initialiser","reset_password":"r\u00e9initialiser le mot de passe","results":"r\u00e9sultats","save":"Enregistrer","search":"Chercher","select_brand":"S\u00e9lectionnez la marque","select_category":"Choisir une cat\u00e9gorie","select_city":"S\u00e9lectionnez une ville","select_country":"Choisissez le pays","select_doctor":"S\u00e9lectionner un m\u00e9decin","select_service":"S\u00e9lectionner service","select_state":"S\u00e9lectionnez l'\u00e9tat","service":"Service","service_required":"Le champ Services est obligatoire.","show":"Spectacle","showing":"Affichage","state":"Etat","subject_required":"Le champ sujet est obligatoire.","submit":"Envoyer","to":"\u00e0","twitter_url":"URL Twitter","unread":"Non lu","verify_lable1":"Merci pour l'enregistrement! Avant de commencer, pourriez-vous v\u00e9rifier votre adresse e-mail en cliquant sur le lien que nous venons de vous envoyer par e-mail ? Si vous n'avez pas re\u00e7u l'e-mail, nous vous en enverrons volontiers un autre.","verify_lable2":"Un nouveau lien de v\u00e9rification a \u00e9t\u00e9 envoy\u00e9 \u00e0 l'adresse e-mail que vous avez fournie lors de l'inscription.","view":"Voir","years":"Ann\u00e9es","yes":"Oui, Supprimer\u00a0!","yes_update":"Oui, mise \u00e0 jour\u00a0!","zoom_credentials":"Veuillez ajouter les informations d'identification du zoom."},"countries":"Pays","country":{"add_country":"Ajouter un pays","country":"Pays","short_code":"Code court"},"currencies":"Devises","currency":{"add_currency":"Ajouter une devise","add_currency_code_as_per_three_letter_iso_code":"Ajouter le code de devise selon le code ISO \u00e0 trois lettres","currency_code":"Code Devise","currency_icon":"Ic\u00f4ne Devise","currency_name":"Nom de la devise","edit_currency":"Modifier la devise","name":"Nom","you_can_find_out_here":"vous pouvez d\u00e9couvrir ici"},"cvv_invalid.":"Le CVV n'est pas valide.","cvv_number_required.":"Les champs du num\u00e9ro CVV sont obligatoires.","dashboard":"Tableau de bord","datepicker":{"last_30_days":"Les 30 derniers jours","last_month":"Le mois dernier","last_week":"La semaine derni\u00e8re","this_month":"Ce mois-ci","this_week":"Cette semaine","today":"Aujourd'hui","yesterday":"Hier"},"doctor":{"add":"Ajouter un docteur","add_qualification":"Ajouter une qualification","address1":"Adresse 1","address2":"Adresse 2","address_information":"Informations sur l'adresse","allowed_img":"Types de fichiers autoris\u00e9s : png, jpg, jpeg.","city":"Ville","collage_university":"COLLAGE\/UNIVERSITE","country":"Pays","created_at":"Cr\u00e9\u00e9 \u00e0","degree":"Degr\u00e9","dob":"Date de naissance","doctor":"Docteur","doctor_detail":"D\u00e9tails du docteur","edit":"Modifier le docteur","experience":"Exp\u00e9rience en ann\u00e9e","female":"Femme","first_name":"Pr\u00e9nom","instagram":"Instagram","last_name":"Nom","linkedin":"Linkedin","male":"Homme","passout_year":"Ann\u00e9e Passout","postal_code":"Code Postal","profile":"Profil","qualification":"Qualification","qualification_information":"Informations de qualification","select_blood_group":"S\u00e9lectionnez le groupe sanguin","select_date":"S\u00e9lectionner une date","select_doctors":"s\u00e9lectionner les m\u00e9decins","select_gender":"S\u00e9lectionner le genre","select_year":"S\u00e9lectionnez l'ann\u00e9e","specialization":"Sp\u00e9cialisation","sr_no":"SR NON","state":"Etat","status":"Statut","twitter":"Twitter","university":"Universit\u00e9","updated_at":"Mise \u00e0 jour \u00e0","year":"Ann\u00e9e"},"doctor_appointment":{"amount":"Montant","from_time":"Du Temps","patient":"Patient","service":"Service","to_time":"Au Temps"},"doctor_appointments":"Rendez-vous chez le m\u00e9decin","doctor_dashboard":{"recent_appointments":"Rendez-vous r\u00e9cents","total_appointments":"Total des rendez-vous"},"doctor_session":{"add":"Ajouter un horaire de m\u00e9decin","all":"Tous","copy":"Copie","doctor":"Docteur","doctor_session":"Calendrier du docteur","doctor_session_details":"D\u00e9tails de l'horaire du m\u00e9decin","edit":"Modifier l'horaire du m\u00e9decin","evening_session":"Horaire du soir","friday":"Friday","gap_between_appointment":"Ecart entre les rendez-vous","monday":"Monday","morning_session":"Programme du matin","my_schedule":"Mon emploi du temps","saturday":"Saturday","select_meeting_time":"S\u00e9lectionner l'heure de la r\u00e9union","select_session_gap":"S\u00e9lectionner un intervalle d'horaire","session":"S\u00e9ance","session_gap":"Ecart d'horaire","session_meeting_time":"Planifier l'heure du rendez-vous","session_time_in_minutes":"Planifier l'heure du rendez-vous","sunday":"Sunday","thursday":"Thursday","tuesday":"Tuesday","unavailable":"Indisponible","wednesday":"Wednesday","week_days":"Jours de la semaine"},"doctor_sessions":"Horaires des m\u00e9decins","doctors":"M\u00e9decins","doctors_scheduled_time_ended_for_today__":"L'heure pr\u00e9vue par le m\u00e9decin est termin\u00e9e pour aujourd'hui, veuillez s\u00e9lectionner un autre m\u00e9decin ou une autre date","email_password_reset_link":"Lien pour r\u00e9initialiser le mot de passe de messagerie","enquiries":"Demandes","expiration_month_required":"Les champs du mois d\u2019expiration sont obligatoires.","expiration_year_required":"Les champs de l\u2019ann\u00e9e d\u2019expiration sont obligatoires.","faq":{"add_faq":"Ajouter FAQ","answer":"R\u00e9pondre","edit_faq":"Modifier la FAQ","question":"Question"},"faqs":"FAQ","filter":{"active":"Actif","all":"Tout","awaited":"Attendu","booked":"R\u00e9serv\u00e9","cancelled":"Annul\u00e9","check in":"Enregistrement","check out":"V\u00e9rifier","deactive":"D\u00e9sactiver","finished":"Achev\u00e9","paid":"Pay\u00e9","pending":"En attente","read":"Lis","unread":"Non lu"},"filter_success":"succ\u00e8s du filtre","flash":{"about_image_validation_message":"L'image \u00c0 propos doit \u00eatre un fichier du type suivant\u00a0: jpg, jpeg, png.","about_us_create":"\u00c0 propos de nous enregistr\u00e9 avec succ\u00e8s.","all_notification_read":"Toutes les notifications ont \u00e9t\u00e9 lues avec succ\u00e8s.","appointment_booked":"Rendez-vous pris avec succ\u00e8s","appointment_cancel":"Rendez-vous annul\u00e9.","appointment_create":"Rendez-vous cr\u00e9\u00e9 avec succ\u00e8s.","appointment_created_payment_complete":"Le rendez-vous a \u00e9t\u00e9 cr\u00e9\u00e9 avec succ\u00e8s et le paiement est termin\u00e9.","appointment_created_payment_not_complete":"Le rendez-vous a \u00e9t\u00e9 cr\u00e9\u00e9 avec succ\u00e8s et le paiement n'est pas termin\u00e9.","appointment_delete":"Rendez-vous supprim\u00e9 avec succ\u00e8s.","appointment_not_found":"Rendez-vous introuvable","appointment_retrieve":"Les donn\u00e9es du calendrier de rendez-vous ont \u00e9t\u00e9 r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s.","calender_added":"Calendrier ajout\u00e9 avec succ\u00e8s.","cat_retrieve":"Cat\u00e9gorie r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","cities_retrieve":"Villes r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s","city_create":"Ville cr\u00e9\u00e9e avec succ\u00e8s.","city_delete":"Ville supprim\u00e9e avec succ\u00e8s.","city_retrieved":"Ville r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","city_update":"Ville mise \u00e0 jour avec succ\u00e8s.","city_used":"Ville utilis\u00e9e ailleurs.","clinic_delete":"ClinicSchedule supprim\u00e9 avec succ\u00e8s.","clinic_save":"L'horaire de la clinique a \u00e9t\u00e9 enregistr\u00e9 avec succ\u00e8s.","cms_update":"CMS mis \u00e0 jour avec succ\u00e8s.","country_create":"Pays cr\u00e9\u00e9 avec succ\u00e8s.","country_delete":"Pays supprim\u00e9 avec succ\u00e8s.","country_update":"Pays mis \u00e0 jour avec succ\u00e8s.","country_used":"Pays utilis\u00e9 ailleurs.","create_blog":"Blog VCard cr\u00e9\u00e9 avec succ\u00e8s.","create_front_testimonial":"T\u00e9moignage cr\u00e9\u00e9 avec succ\u00e8s.","currency_create":"Devise cr\u00e9\u00e9e avec succ\u00e8s.","currency_delete":"Devise supprim\u00e9e avec succ\u00e8s.","currency_update":"Devise mise \u00e0 jour avec succ\u00e8s.","currency_used":"Devise utilis\u00e9e ailleurs.","current_invalid":"Le mot de passe actuel n'est pas valide.","data_retrieve":"Donn\u00e9es r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s.","default_role_not_delete":"Le r\u00f4le par d\u00e9faut ne doit pas \u00eatre supprim\u00e9.","degree_required":"Le champ dipl\u00f4me est obligatoire.","doctor_appointment":"Les donn\u00e9es du calendrier des rendez-vous chez le m\u00e9decin ont \u00e9t\u00e9 r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s.","doctor_create":"Docteur cr\u00e9\u00e9 avec succ\u00e8s.","doctor_delete":"M\u00e9decin supprim\u00e9 avec succ\u00e8s.","doctor_holiday":"Doctor Holiday cr\u00e9\u00e9 avec succ\u00e8s","doctor_not_available":"M\u00e9decin non disponible","doctor_session_not_found":"Session m\u00e9decin introuvable.","doctor_update":"M\u00e9decin mis \u00e0 jour avec succ\u00e8s.","doctor_use":"M\u00e9decin utilis\u00e9 avec succ\u00e8s.","email_notification":"Notification par e-mail mise \u00e0 jour avec succ\u00e8s.","email_send":"E-mail envoy\u00e9 avec succ\u00e8s.","enquire_deleted":"Demande supprim\u00e9e avec succ\u00e8s.","enquire_sent":"Demande envoy\u00e9e avec succ\u00e8s","faq_creat":"FAQ cr\u00e9\u00e9e avec succ\u00e8s.","faq_delete":"FAQ supprim\u00e9e avec succ\u00e8s.","faq_update":"FAQ mise \u00e0 jour avec succ\u00e8s.","faq_use":"Cette FAQ est utilis\u00e9e ailleurs.","favicon_validation_message":"Le favicon doit \u00eatre un fichier de type : jpg, jpeg, png.","feature_update":"Fonctionnalit\u00e9 mise \u00e0 jour avec succ\u00e8s.","google_calendar_connect":"Votre agenda Google est maintenant connect\u00e9.","google_calendar_disconnect":"Google Agenda s'est d\u00e9connect\u00e9 avec succ\u00e8s.","google_calendar_update":"Votre agenda Google a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s.","holiday_already_is_exist":"Un jour f\u00e9ri\u00e9 existe d\u00e9j\u00e0 pour cette date","icon_validation_message":"L'ic\u00f4ne doit \u00eatre un fichier du type suivant : jpg, jpeg, png, svg.","language_change":"Langue chang\u00e9e avec succ\u00e8s","language_update":"Langue mise \u00e0 jour avec succ\u00e8s.","live_consultation_delete":"La consultation en direct a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s.","live_consultation_retrieved":"La consultation en direct a \u00e9t\u00e9 r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","live_consultation_save":"La consultation en direct a \u00e9t\u00e9 enregistr\u00e9e avec succ\u00e8s.","live_consultation_update":"La consultation en direct a \u00e9t\u00e9 mise \u00e0 jour avec succ\u00e8s.","logo_validation_message":"Le logo de l'application doit \u00eatre un fichier de type : jpg, jpeg, png.","maximum_char":"Un maximum de 60 caract\u00e8res est autoris\u00e9.","messages_sent":"Message envoy\u00e9 avec succ\u00e8s","no_available_slots":"Il n'y a pas de cr\u00e9neaux disponibles \u00e0 la date indiqu\u00e9e.","note_added":"Note ajout\u00e9e avec succ\u00e8s.","note_delete":"Note supprim\u00e9e avec succ\u00e8s.","notification_read":"Notification lue avec succ\u00e8s.","notification_send":"La notification de v\u00e9rification par e-mail a \u00e9t\u00e9 envoy\u00e9e avec succ\u00e8sy.","observation_added":"Observation ajout\u00e9e avec succ\u00e8s.","observation_delete":"Observation supprim\u00e9e avec succ\u00e8s.","operation_performed_success":"Op\u00e9ration effectu\u00e9e avec succ\u00e8s","order_create":"Commande cr\u00e9\u00e9e avec succ\u00e8s.","password_update":"Mot de passe mis \u00e0 jour avec succ\u00e8s.","patient_appointment":"Les donn\u00e9es du calendrier de rendez-vous du patient ont \u00e9t\u00e9 r\u00e9cup\u00e9r\u00e9es avec succ\u00e8s.","patient_create":"Patient cr\u00e9\u00e9 avec succ\u00e8s.","patient_delete":"Patient supprim\u00e9 avec succ\u00e8s.","patient_not_found":"Patient introuvable.","patient_update":"Patient mis \u00e0 jour avec succ\u00e8s.","patient_used":"Le patient a utilis\u00e9 ailleurs.","patients_retrieve":"Patients r\u00e9cup\u00e9r\u00e9s avec succ\u00e8s.","payment_status_updated":"Statut de paiement mis \u00e0 jour avec succ\u00e8s.","paystack_token_expired":"Le jeton de paie a expir\u00e9. Veuillez actualiser la page et r\u00e9essayer.","plan_default":"Le plan par d\u00e9faut a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.","plan_status":"Statut du plan mis \u00e0 jour avec succ\u00e8s","plan_update":"Plan mis \u00e0 jour avec succ\u00e8s.","prescription_delete":"Prescription supprim\u00e9e avec succ\u00e8s.","prescription_retrieved":"Prescription r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","problem_added":"Probl\u00e8me ajout\u00e9 avec succ\u00e8s.","problem_delete":"Probl\u00e8me supprim\u00e9 avec succ\u00e8s.","profile_validation_message":"Le profil doit \u00eatre un fichier de type : jpg, jpeg, png.","qualification_create":"Qualification cr\u00e9\u00e9e avec succ\u00e8s.","reactive_account":"R\u00e9activez votre compte \u00e0 partir du courrier.","retrieve":"R\u00e9cup\u00e9r\u00e9 avec succ\u00e8s.","review_add":"V\u00e9rifier l'ajout avec succ\u00e8s.","review_edit":"L'avis a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.","review_retrieved":"Avis r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s.","role_create":"R\u00f4le cr\u00e9\u00e9 avec succ\u00e8s.","role_delete":"R\u00f4le supprim\u00e9 avec succ\u00e8s.","role_update":"R\u00f4le mis \u00e0 jour avec succ\u00e8s.","schedule_crete":"Planification cr\u00e9\u00e9e avec succ\u00e8s.","schedule_delete":"Calendrier supprim\u00e9 avec succ\u00e8s.","schedule_not_found":"Calendrier introuvable.","schedule_update":"Calendrier mis \u00e0 jour avec succ\u00e8s.","select_calendar.":"Veuillez s\u00e9lectionner un calendrier.","select_payment":"Veuillez s\u00e9lectionner un mode de paiement","service_cat_create":"Cat\u00e9gorie de service cr\u00e9\u00e9e avec succ\u00e8s.","service_cat_delete":"Cat\u00e9gorie de service supprim\u00e9e avec succ\u00e8s.","service_cat_update":"Cat\u00e9gorie de service mise \u00e0 jour avec succ\u00e8s.","service_cat_use":"Cat\u00e9gorie de service utilis\u00e9e ailleurs.","service_create":"Service cr\u00e9\u00e9 avec succ\u00e8s.","service_delete":"Le service a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.","service_update":"Service mis \u00e0 jour avec succ\u00e8s.","service_use":"Service utilis\u00e9 ailleurs.","session_retrieve":"Session r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","setting_update":"Param\u00e8tres mis \u00e0 jour avec succ\u00e8s.","slider_update":"Curseur mis \u00e0 jour avec succ\u00e8s","some_doctors":"Certains m\u00e9decins ont programm\u00e9 leurs journ\u00e9es en jours non coch\u00e9s, alors \u00eates-vous s\u00fbr de vouloir effectuer cette op\u00e9ration ?","something_went_wrong":"Quelque chose s'est mal pass\u00e9","specialization_create":"Sp\u00e9cialisation cr\u00e9\u00e9e avec succ\u00e8s.","specialization_delete":"La sp\u00e9cialisation a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s.","specialization_update":"Sp\u00e9cialisation mise \u00e0 jour avec succ\u00e8s.","specialization_use":"Sp\u00e9cialisation utilis\u00e9e avec succ\u00e8s.","staff_create":"Port\u00e9e cr\u00e9\u00e9e avec succ\u00e8s.","staff_delete":"Suppression du personnel r\u00e9ussie.","staff_update":"Le personnel a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s.","staff_use":"B\u00e2ton utilis\u00e9 avec succ\u00e8s.","state_create":"\u00c9tat cr\u00e9\u00e9 avec succ\u00e8s.","state_delete":"\u00c9tat mis \u00e0 jour avec succ\u00e8s.","state_update":"\u00c9tat supprim\u00e9 avec succ\u00e8s.","state_use":"\u00c9tat utilis\u00e9 ailleurs.","states_retrieve":"\u00c9tats r\u00e9cup\u00e9r\u00e9s avec succ\u00e8s.","status_change":"Le statut a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.","status_update":"Statut mis \u00e0 jour avec succ\u00e8s.","subscriber_creat":"Abonn\u00e9 cr\u00e9\u00e9 avec succ\u00e8s.","subscriber_delete":"Abonn\u00e9 supprim\u00e9 avec succ\u00e8s.","testimonial_creat":"T\u00e9moignage du patient avant cr\u00e9\u00e9 avec succ\u00e8s.","testimonial_delete":"Le t\u00e9moignage du patient avant a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.","testimonial_update":"Mise \u00e0 jour du t\u00e9moignage du patient avant r\u00e9ussie.","testimonial_use":"T\u00e9moignage du patient utilis\u00e9 avec succ\u00e8s.","theme_change":"Th\u00e8me modifi\u00e9 avec succ\u00e8s.","there_were":"Il y a eu un probl\u00e8me avec le paiement. Veuillez r\u00e9essayer plus tard.","university_required":"L'universit\u00e9 est obligatoire.","update_blog":"Blog VCard mis \u00e0 jour avec succ\u00e8s.","update_front_testimonial":"T\u00e9moignage mis \u00e0 jour avec succ\u00e8s.","user_8_or":"Utilisez 6 caract\u00e8res ou plus avec un m\u00e9lange de lettres, de chiffres et de symboles.","user_already_verified":"L'utilisateur a d\u00e9j\u00e0 un e-mail v\u00e9rifi\u00e9.","user_profile":"Profil utilisateur mis \u00e0 jour avec succ\u00e8s.","user_profile_update":"Profil utilisateur mis \u00e0 jour avec succ\u00e8s.","user_role_not_delete":"Ce r\u00f4le d'utilisateur n'a pas pu \u00eatre supprim\u00e9, car il est attribu\u00e9 \u00e0 un utilisateur.","user_status":"Le statut de l'utilisateur a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s","user_update":"L'utilisateur a \u00e9t\u00e9 mis \u00e0 jour avec succ\u00e8s.","user_zoom_credential_saved":"Les informations d'identification du zoom utilisateur ont \u00e9t\u00e9 enregistr\u00e9es avec succ\u00e8s.","valid_instagram":"Veuillez entrer une URL Instagram valide","valid_linkedin":"Veuillez saisir une URL Linkedin valide","valid_twitter":"Veuillez saisir une URL Twitter valide","verified_email":"E-mail v\u00e9rifi\u00e9 avec succ\u00e8s.","visit_create":"Visite cr\u00e9\u00e9e avec succ\u00e8s.","visit_delete":"La visite a \u00e9t\u00e9 supprim\u00e9e avec succ\u00e8s.","visit_prescription_added":"Prescription de visite ajout\u00e9e avec succ\u00e8s.","visit_prescription_update":"Visit Prescription mis \u00e0 jour avec succ\u00e8s.","visit_update":"Visite mise \u00e0 jour avec succ\u00e8s.","year_required":"L'ann\u00e9e est obligatoire.","your_reg_success":"Votre inscription a r\u00e9ussi.Veuillez v\u00e9rifier votre compte par e-mail."},"front_cms":"CMS avant","front_medical_service":{"add_front_medical_service":"Ajouter un service m\u00e9dical avant","edit_front_medical_service":"Modifier le service m\u00e9dical avant","short_description":"Description courte","title":"Titre"},"front_medical_services":"Avant Services M\u00e9dicaux","front_patient_testimonial":{"add_front_patient_testimonial":"Ajouter un t\u00e9moignage de patient avant","designation":"D\u00e9signation","edit_front_patient_testimonial":"Modifier le t\u00e9moignage d'un patient avant","more_patient_feedbacks":"Plus de commentaires des patients...","name":"Nom","patient_testimonials":"T\u00e9moignages de patients","profile":"Profil","short_description":"Description courte"},"front_patient_testimonials":"T\u00e9moignages de patients avant","front_service":{"add_front_service":"Ajouter un service frontal","edit_front_service":"Modifier le service avant","icon":"Ic\u00f4ne","short_description":"Description courte","title":"Titre"},"front_services":"Avant Services","holder_name_invalid":"Le nom du titulaire de la carte est invalide.","holder_name_required":"Les champs du nom du titulaire de la carte sont obligatoires.","holder_number_invalid":"Les champs du num\u00e9ro de carte sont obligatoires.","holiday":{"add_holiday":"Ajouter un jour f\u00e9ri\u00e9","doctor_holiday":"Vacances de docteur","holiday":"Vacance","holiday_date":"Jour f\u00e9ri\u00e9","service_category":"Cat\u00e9gorie de services"},"icon_size":"La taille de l'ic\u00f4ne doit \u00eatre inf\u00e9rieure \u00e0 2 Mo","id":"IDENTIFIANT","image_file_type":"L'image doit \u00eatre un fichier de type : jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invalid_range":"Plage invalide","live_consultation":{"add_credential":"Agregar credencial","add_live_consultation":"Ajouter une consultation en direct","awaited":"attendu","client_video":"Vid\u00e9o du client","consultation_date":"Fecha de consulta","consultation_duration_minutes":"Minutos de duraci\u00f3n de la consulta","consultation_minutes":"Comptes rendus des consultations","consultation_title":"Titre de consultation","created_by":"Creado por","created_for":"Creado para","description":"La description","disabled":"Discapacit\u00e9","duration":"Duraci\u00f3n (en minutos)","edit_live_consultation":"Editer consulta en vivo","edit_live_meeting":"Editar r\u00e9union en vivo","enable":"Permis","finished":"Achev\u00e9","host_video":"Vid\u00e9o h\u00f4te","join_now":"\u00danete ahora","live_consultation_details":"D\u00e9tails de la consultation en direct","new_live_consultation":"Nueva consulta en vivo","new_live_meeting":"Nouvelle r\u00e9union en vivo","select_consultation_date":"S\u00e9lectionner la date de consultation","select_doctor_name":"S\u00e9lectionner le nom du m\u00e9decin","select_patient_name":"S\u00e9lectionner le nom du patient","staff_list":"Liste de personnel","start_now":"Empezar ahora","type":"Ecrire","type_number":"Teclea un n\u00famero","zoom_api_key":"Zoom clave API","zoom_api_secret":"Zoom API Secreto"},"live_consultations":"Consultations en direct","live_status_retrieved_successfully.":"Statut en direct r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s.","login":"Connexion","medicine":{"available_quantity":"quantit\u00e9 disponible","brand":"Marque","brand_name":"Marque","buying_price":"Prix \u200b\u200bd'achat","cant_be_deleted":"ne peut pas \u00eatre supprim\u00e9","category":"Cat\u00e9gorie","category_id":"Identifiant de cat\u00e9gorie","category_retrieved_successfully":"Cat\u00e9gorie de m\u00e9dicament r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s.","deleted_successfully":"Supprim\u00e9 avec succ\u00e8s","description":"Description","dosage":"Dosage","dose_interval":"S\u00e9lectionnez l'intervalle de dose","duration":"Dur\u00e9e","edit_medicine":"Modifier le m\u00e9dicament","edit_medicine_brand":"Modifier la marque du m\u00e9dicament","edit_medicine_category":"Modifier la cat\u00e9gorie de m\u00e9dicament","filter_options":"Options de filtrage","medicine":"M\u00e9decine","medicine_brands":"Marques de m\u00e9dicaments","medicine_brands_details":"D\u00e9tails de la marque de m\u00e9dicaments","medicine_category":"Cat\u00e9gorie de m\u00e9decine","medicine_category_details":"D\u00e9tails de la cat\u00e9gorie de m\u00e9dicaments","medicine_details":"D\u00e9tails de la m\u00e9decine","medicine_name":"Nom du m\u00e9dicament","medicine_retrieved_successfully":"M\u00e9dicament r\u00e9cup\u00e9r\u00e9 avec succ\u00e8s","medicines":"M\u00e9dicaments","name":"Nom","new_brand":"Nouvelle marque","new_medicine":"Nouvelle m\u00e9decine","new_medicine_brand":"Nouvelle marque de m\u00e9dicaments","new_medicine_category":"Nouvelle cat\u00e9gorie de m\u00e9dicaments","no_use":"Hors service","quantity":"Quantit\u00e9","salt_composition":"Composition du sel","saved_successfully":"enregistr\u00e9 avec succ\u00e8s","select_duration":"S\u00e9lectionnez la dur\u00e9e","selling_price":"Prix \u200b\u200bde vente","side_effects":"Effets secondaires","status_updated_successfully":"Statut mis \u00e0 jour avec succ\u00e8s.","updated_successfully":"Mis \u00e0 jour avec succ\u00e9s"},"medicine_bills":{"add_medicine_bill":"Ajouter une facture de m\u00e9dicaments","available_quantity":"La quantit\u00e9 disponible de","avl_qty":"Qt\u00e9 moyenne","bill_date":"Date de facturation","bill_id":"Identifiant de facture","bill_number":"Num\u00e9ro de facture","cell_no":"Num\u00e9ro de cellule","dose_interval":"Intervalle de dose","duplicate_medicine":"Impossible d'ajouter des m\u00e9dicaments en double.","edit_medicine_bill":"Modifier la facture de m\u00e9dicaments","enter_lot_number":"Entrez le num\u00e9ro de lot.","enter_puchase_price":"Entrez le prix d'achat","enter_sale_price":"Entrez le prix de vente.","is":"est","item_name":"Nom de l'article","medicine_bill":"Facture de m\u00e9decine","medicine_bill_details":"D\u00e9tails de la facture des m\u00e9dicaments","medicine_bills":"Factures de m\u00e9dicaments","medicine_not_selected":"Veuillez s\u00e9lectionner au moins un m\u00e9dicament.","medicine_required":"Le domaine de la m\u00e9decine est obligatoire.","net_amount_cant":"Le montant net ne peut pas \u00eatre vide.","net_amount_cant_zero":"Le montant net ne peut \u00eatre nul.","net_amount_not_empty":"Le montant net ne peut pas \u00eatre vide.","net_amount_not_zero":"Le montant net ne peut pas \u00eatre nul.","new_medicine_bill":"Nouveau projet de loi sur les m\u00e9dicaments","payment_status":"Statut de paiement","payment_type":"Type de paiement","prescription_not_found":"Ordonnance introuvable","price":"Prix","print_bill":"Imprimer la facture","quantity_should":"La quantit\u00e9 doit \u00eatre sup\u00e9rieure \u00e0 0.","sale_price":"Prix \u200b\u200bde vente","select_medicine":"S\u00e9lectionnez un m\u00e9dicament","select_patient":"S\u00e9lectionnez un patient","select_payment_type":"S\u00e9lectionnez le type de paiement","tax_amt":"Le montant de la taxe ne peut pas \u00eatre nul ou vide.","tax_cannot_be_zero_empty":"Le montant de la taxe ne peut pas \u00eatre nul ou vide.","tax_should_be":"Les taxes devraient \u00eatre inf\u00e9rieures \u00e0 100\u00a0%.","the_discount_shoul":"La remise doit \u00eatre inf\u00e9rieure au montant total.","the_medicine_already_in_use":"Ce m\u00e9dicament est d\u00e9j\u00e0 utilis\u00e9 dans les factures de m\u00e9dicaments, \u00eates-vous s\u00fbr de vouloir le supprimer\u00a0?","update_quantity":"La quantit\u00e9 mise \u00e0 jour doit \u00eatre inf\u00e9rieure \u00e0 la quantit\u00e9 pr\u00e9c\u00e9dente."},"medicine_brands":"Marques de m\u00e9dicaments","medicine_categories":"Cat\u00e9gories de m\u00e9dicaments","medicines":"M\u00e9dicaments","mobile_no":"Mobile Non","months":{"apr":"Avr","aug":"Ao\u00fbt","dec":"D\u00e9c","feb":"F\u00e9v","jan":"Jan","jul":"Juil","jun":"Juin","mar":"Mar","may":"Peut","nov":"Nov","oct":"Oct","sep":"Sep"},"no_response":"Aucune r\u00e9ponse renvoy\u00e9e","not_supported":"non support\u00e9","note":"Remarque\u00a0: Vous devez d\u00e9finir votre fuseau horaire avant d'int\u00e9grer Google\u00a0Agenda.","notification":{"mark_all_as_read":"Tout marquer comme lu","notification":"Avis","you_don`t_have_any_new_notification":"Vous n`avez aucune nouvelle notification"},"patient":{"add":"Ajouter un patient","address1":"Adresse 1","address2":"Adresse 2","address_information":"Informations sur l'adresse","blood_group":"Groupe Sanguin","city":"Ville","confirm_password":"Confirmer le mot de passe","contact_no":"N\u00b0 de contact","country":"Pays","details":"D\u00e9tails du patient","dob":"Date de naissance","edit":"Modifier le patient","email":"Courriel","emailverified":"Email verifi\u00e9","enter_email":"Entrez l'e-mail","enter_password":"Entrer le mot de passe","female":"Femme","filter":"filtre","first_name":"Pr\u00e9nom","gender":"Genre","last_name":"Nom","last_updated":"Derni\u00e8re mise \u00e0 jour","male":"Homme","name":"Nom","password":"Mot de passe","patient_unique_id":"Identifiant unique du patient","postal_code":"Code Postal","profile":"Profil","registered_on":"Inscrit le","save_changes":"Enregistrer les modifications","state":"Etat","today":"Aujourd hui"},"patient_dashboard":{"completed_appointments":"Rendez-vous termin\u00e9s","next_appointment":"Prochains Rendez-vous","today_appointments":"Rendez-vous aujourd'hui","upcoming_appointments":"Prochains Rendez-vous"},"patients":"Patient","payment_detail":"D\u00e9tail du paiement","payment_for_booking_appointment_with_doctor":"Paiement pour la prise de rendez-vous avec le m\u00e9decin","payment_method":{"authorize":"Autoriser","paypal":"Pay Pal","paystack":"Paiement","paytm":"Paiement","razorpay":"Razorpay","stripe":"Bande"},"paytm":"Paiement","prescription":{"Rx":"Rx","accident":"Accident","advice":"conseils","after meal":"apr\u00e8s manger","appointment_slot":"Cr\u00e9neaux de rendez-vous","available_quantity_of":"La quantit\u00e9 disponible de ","before meal":"Avant le repas","breast_feeding":"Allaitement maternel","comment":"commentaire","connect_with_zoom":" Connectez-vous avec Zoom","current_medication":"M\u00e9dicament actuel","days":"journ\u00e9es","diabetic":"Diab\u00e9tique","doctor":"M\u00e9decin","dosage":"Dosage","duration":"Dur\u00e9e","edit_prescription":"Modifier la prescription","female_pregnancy":"Grossesse f\u00e9minine","food_allergies":"Allergies alimentaires","frequency":"Fr\u00e9quence","health_insurance":"Assurance sant\u00e9","heart_disease":"Maladie cardiaque","high_blood_pressure":"Hypertension art\u00e9rielle","is":"est","low_income":"Faible revenu","medical_history":"Ant\u00e9c\u00e9dents m\u00e9dicaux","medicine_name":"nom_du_medicament","name":"Nom","new_medicine":"nouveau m\u00e9dicament","new_prescription":"Nouvelle ordonnance","next_visit":"prochaine visite","not_add_duplicate_medicines":"Impossible d'ajouter des m\u00e9dicaments en double.","ok":"D'accord","others":"Autres","patient":"Patiente","physical_information":"informations physiques","plus_rate":"impulsion major\u00e9","prescription":"Prescription","prescription_details":"D\u00e9tails de la prescription","prescription_saved":"Prescription enregistr\u00e9e avec succ\u00e8s.","prescription_updated":"Prescription mise \u00e0 jour avec succ\u00e8s.","prescriptions":"Prescriptions","problem":"probl\u00e8me","problem_description":"Description du probl\u00e8me","reference":"R\u00e9f\u00e9rence","selectMedicine":"S\u00e9lectionnez un m\u00e9dicament","surgery":"Chirurgie","temperature":"temperature","tendency_bleed":"Saignement de tendance","test":"test","time":"temps","total_quantity":"Quantit\u00e9 totale"},"privacy_policy":"Politique de confidentialit\u00e9","purchase_medicine":{"actions":"Actions","amount":"Montant","discount":"Rabais","dose_duration":"Dur\u00e9e de la dose","expiry_date":"Date d'expiration","export_to_excel":"Exporter vers Excel","lot_no":"N\u00b0 de lot","net_amount":"Montant net","note":"Note","other_details":"Autres d\u00e9tails","payment_mode":"Mode de paiement","payment_note":"Bulletin de paiement","purchase_medicine":"Acheter des m\u00e9dicaments","purchase_medicine_details":"Acheter des d\u00e9tails sur les m\u00e9dicaments","purchase_medicine_overview":"Aper\u00e7u de l'achat de m\u00e9dicaments","purchase_medicines":"Acheter des m\u00e9dicaments","purchase_number":"Num\u00e9ro d'achat","purchased_medicine_success":"M\u00e9dicament achet\u00e9 avec succ\u00e8s","quantity":"Quantit\u00e9","tax":"Imp\u00f4t","tax_amount":"Montant de la taxe","total":"Total"},"range_constructor_requires_trie_parameter":"Le constructeur de plage n\u00e9cessite un param\u00e8tre Trie","register":"S'inscrire","requires_string_parameter":"rangeWithString n\u00e9cessite un param\u00e8tre de cha\u00eene","resend_email_verification":"Renvoyer la v\u00e9rification par e-mail","review":{"add_review":"Ajouter un commentaire","edit_review":"Modifier la r\u00e9vision","no_doctors_available_to_give_rating":"Aucun m\u00e9decin disponible pour donner une note.","review":"Revoir","write_a_review":"\u00c9crire une critique"},"reviews":"Commentaires","role":{"add_role":"Ajouter un r\u00f4le","edit_role":"Modifier le r\u00f4le","permissions":"Autorisations","role":"R\u00f4le","role_permissions":"Autorisations de r\u00f4le","select_all_permissions":"S\u00e9lectionner toutes les autorisations"},"roles":"R\u00f4les","service":{"add_service":"Ajouter un service","category":"Cat\u00e9gorie","charges":"Frais","edit_service":"Modifier le service","short_description":"Description courte"},"service_categories":"Cat\u00e9gories de services","service_category":{"add_category":"Ajouter une cat\u00e9gorie de service","edit_category":"Modifier la cat\u00e9gorie de service","service_category":"Cat\u00e9gorie de services"},"services":"Prestations","setting":{"address":"Adresse","change_app_logo":"Changer le logo de l'application","change_favicon":"Changer de favicon","clinic_name":"Nom de la Clinique","connect_google_calendar":"Connecter Google Agenda","connect_your_google_calendar":"Connectez votre agenda Google","contact_information":"Coordonn\u00e9es","currency":"Monnaie","currency_settings":"Param\u00e8tres de devise","default_country_code":"Code pays par d\u00e9faut","default_language_suggest":"En mettant \u00e0 jour cette fonctionnalit\u00e9, la langue enti\u00e8re de l'application changera au niveau des connexions du m\u00e9decin, des patients ainsi que sur la face avant.","disconnect_your_google_calendar":"D\u00e9connectez votre Google Agenda","do_not_allow_to_login_without_email_verification":"Ne pas autoriser la connexion sans v\u00e9rification par e-mail","favicon":"Favicon","general":"G\u00e9n\u00e9ral","general_details":"D\u00e9tails g\u00e9n\u00e9raux","logo":"Logo","postal_code":"Code Postal","prefix":"Pr\u00e9fixe","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"S\u00e9lectionnez vos agendas (depuis Google Calendar) dans lesquels vous souhaitez cr\u00e9er les rendez-vous","setting":"Param\u00e8tre","specialities":"Sp\u00e9cialit\u00e9s","sync_your_google_calendar":"Synchronisez votre agenda Google","when_checkbox_disable":"Lorsque la case \u00e0 cocher est d\u00e9sactiv\u00e9e, la v\u00e9rification des e-mails ne fonctionne pas pour les nouveaux utilisateurs.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Lorsque le patient prend rendez-vous avec vous, un nouveau rendez-vous sera cr\u00e9\u00e9 sur les calendriers s\u00e9lectionn\u00e9s","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Lorsque vous r\u00e9servez un rendez-vous, un nouveau rendez-vous sera cr\u00e9\u00e9 sur les calendriers s\u00e9lectionn\u00e9s"},"settings":"Param\u00e8tres","slider":{"add_slider":"Ajouter un curseur","edit_slider":"Modifier le curseur","image":"Image","short_description":"Description courte","title":"Titre"},"sliders":"Sliders","smart_patient_card":{"add_smart_card":"Ajouter une carte intelligente","add_smart_card_templates":"Ajouter des mod\u00e8les de carte intelligente","address_show":"Afficher l'adresse","blood_group_show":"Afficher le groupe sanguin","dob_show":"Afficher la date de naissance","edit_patient_card":"Modifier la carte intelligente","email_show":"Afficher l'e-mail","enter_template_name":"Saisissez le nom du mod\u00e8le","for_all_patient":"Pour tous les patients","generate_patient_card":"G\u00e9n\u00e9rer une carte de patient","generate_patient_smart_cards":"G\u00e9n\u00e9rer des cartes de patient intelligentes","header_color":"Couleur de l'en-t\u00eate","only_one_patient":"Uniquement un patient","patient":"Patient","patient_smart_card_created":"Carte de patient intelligente cr\u00e9\u00e9e avec succ\u00e8s.","patient_smart_card_deleted":"Carte de patient intelligente supprim\u00e9e avec succ\u00e8s.","phone_show":"Afficher le t\u00e9l\u00e9phone","please_selest_patient":"Veuillez s\u00e9lectionner un patient","remaning_patients":"Patients restants","select_patient":"S\u00e9lectionner un patient","select_template":"S\u00e9lectionner un mod\u00e8le","smart_patient_card_templates":"Mod\u00e8les de carte de patient intelligent","smart_patient_cards":"Cartes de patient intelligentes","templat_name":"Nom du mod\u00e8le","template":"Mod\u00e8le","template_created":"Mod\u00e8le cr\u00e9\u00e9 avec succ\u00e8s.","template_deleted":"Mod\u00e8le supprim\u00e9 avec succ\u00e8s.","template_update":"Mise \u00e0 jour du mod\u00e8le r\u00e9ussie.","type":"Type","unique_id_show":"Afficher l'identifiant unique"},"specialization":{"add_specialization":"Ajouter une sp\u00e9cialisation","edit_specialization":"Modifier la sp\u00e9cialisation","retrieved_successfully":"Sp\u00e9cialisation r\u00e9cup\u00e9r\u00e9e avec succ\u00e8s."},"specializations":"Sp\u00e9cialisations","staff":{"add_staff":"Ajouter du personnel","confirm_password":"Confirmer le mot de passe","contact_no":"N\u00b0 de contact","edit_staff":"Modifier la port\u00e9e","email":"Courriel","female":"Femme","first_name":"Pr\u00e9nom","gender":"Genre","last_name":"Nom","male":"Homme","password":"Mot de passe","role":"R\u00f4le","select_role":"S\u00e9lectionnez un r\u00f4le","staff":"personnel","staff_details":"D\u00e9tails du personnel"},"staffs":"Personnel","start_time_invalid":"l'heure de d\u00e9but de la journ\u00e9e n'est pas valide","state":{"add_state":"Ajouter un \u00e9tat","country":"Pays","edit_state":"Modifier l'\u00e9tat","state":"Etat","states":"\u00e9tats"},"states":"Etats","subscribers":"Abonn\u00e9s","terms_conditions":"Termes & Conditions","too_long":"Demasiado largo","too_short":"Demasiado corto","transaction":{"paid":"Pay\u00e9","payment_accepted_by":"Paiement accept\u00e9 par","payment_status":"Statut de paiement","pending":"En attente","transaction_detail":"D\u00e9tail de la transaction","transaction_id":"Identifiant de transaction"},"transactions":"proc\u00e9dure","used_medicine":{"used_at":"Utilis\u00e9 \u00e0","used_medicine":"M\u00e9dicament utilis\u00e9","used_medicines":"M\u00e9dicaments usag\u00e9s","used_quantity":"Quantit\u00e9 utilis\u00e9e"},"user":{"account":"Compte","account_setting":"Param\u00e8tres du compte","avatar":"Avatar","change_language":"Changer de langue","change_password":"Changer le mot de passe","confirm_password":"Confirmer le mot de passe","contact_number":"Num\u00e9ro de contact","current_password":"Mot de passe actuel","edit_profile":"Modifier le profil","email":"Courriel","email_notification":"notification par e-mail","full_name":"Nom complet","gender":"Genre","language":"Langue","new_password":"Nouveau mot de passe","profile_details":"D\u00e9tails du profil","return_to_admin":"Revenir \u00e0 ladministrateur","save_changes":"Enregistrer les modifications","select_time_zone":"S\u00e9lectionnez le fuseau horaire","setting":"Param\u00e8tre","sign_out":"D\u00e9connexion","staff_details":"D\u00e9tails du personnel","time_zone":"Fuseau horaire"},"users":"Utilisateurs","valid_expiration_date":"Entrez une date d'expiration valide.","valid_number":"N\u00famero v\u00e1lido","visit":{"add_visit":"Ajouter une visite","description":"Description","doctor":"Docteur","edit_visit":"Modifier la visite","enter_note":"Saisir une remarque","enter_observation":"Entrer l'observation","enter_problem":"Entrez le probl\u00e8me","notes":"Notes","observations":"Observations","patient":"Patient","prescriptions":"Prescriptions","problems":"Probl\u00e8mes","title":"Titre","visit_date":"Date de visite","visit_detail":"D\u00e9tail de la visite","visit_details":"D\u00e9tails de la visite"},"visits":"Visites","web":{"Meet_best_doctors":"Rencontrez les meilleurs docteurs","about_experience":"\u00c0 propos de l'exp\u00e9rience","about_short_description":"\u00c0 propos de la description courte","about_title":"\u00c0 propos du titre","about_us":"\u00c0 propos","all_rights_reserved":"Tous les droits sont r\u00e9serv\u00e9s","all_services":"Tous les Services","already_have_an_account":"Avoir d\u00e9j\u00e0 un compte","already_have_patient_account":"Avoir d\u00e9j\u00e0 un compte patient","appointment":"Rendez-vous","appointment_now":"Rendez-vous maintenant","best_professionals":"Meilleurs professionnels","book_an_appointment":"Prendre rendez-vous","book_appointment":"Prendre rendez-vous","call_us":"Appelez-nous","closed":"Ferm\u00e9","confirm_booking":"Confirmer la r\u00e9servation","contact":"Contact","contact_us":"contact","contact_us_for_any_information":"Contactez-nous pour toute information","create_an_account":"Cr\u00e9er un compte","created_at":"Cr\u00e9\u00e9 \u00e0","doctors":"M\u00e9decins","doctors_can_interact___":"Les m\u00e9decins peuvent interagir avec les patients et effectuer des traitements associ\u00e9s.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Formulez dynamiquement des r\u00e9sultats sans erreur avant les r\u00e9sultats int\u00e9gr\u00e9s. Incuber de mani\u00e8re spectaculaire les ressources int\u00e9gr\u00e9es sans rentabilit\u00e9 en dehors du.","email":"Courriel","email_address":"Adresse e-mail","emergency_help":"Aide d'urgence","enquiry":"Demande","enquiry_details":"D\u00e9tails de la demande","enter_your_email":"Entrer votre Email","enter_your_email_to_subscribe_to_our_newsletter":"Entrez votre Email pour vous abonner \u00e0 notre Newsletter","faqs":"FAQ","forgot_password":"Mot de passe oubli\u00e9","home":"Accueil","how_we_works":"Comment on travaille","i_agree":"Je suis d'accord","location":"emplacement","login":"Connexion","make_appointment":"Prendre un rendez-vous","medical":"M\u00e9dical","medical_about_us":"M\u00e9decine \u00c0 Propos","medical_appointment":"Rendez-vous M\u00e9dical","medical_contact":"Contact M\u00e9dical","medical_doctors":"M\u00e9decins","medical_services":"Services M\u00e9dicaux","medical_treatment":"Traitement m\u00e9dical","meet_our_team_of_specialists":"Rencontrez notre \u00e9quipe de sp\u00e9cialistes","message":"Message","name":"Nom","new_here":"Nouveau ici","no_services_available":"Aucun service disponible","opening_hours":"Heures d'ouverture","our_doctor":"Notre Docteur","our_team":"Notre \u00e9quipe","patient_can_book_an_appointment___":"Le patient peut prendre rendez-vous avec un m\u00e9decin \u00e0 partir de la page de destination ou de son panneau de connexion.","patient_can_do_registration___":"Le patient peut s'inscrire \u00e0 partir d'ici avec des informations de base.","patient_name":"Nom du patient","patient_registration":"Enregistrement des patients","phone":"T\u00e9l\u00e9phone","qualified_doctors":"M\u00e9decins qualifi\u00e9s","questions_before_booking":"Questions avant de r\u00e9server","quick_links":"Liens rapides","reason":"Raison","registration":"Inscription","remember_me":"Se souvenir de moi","satisfied_patient":"Patient Satisfait","saying_about_us":"Dire \u00e0 propos de nous","see_what_are_the_patients":"Voir quels sont les patients","send_an_email":"Envoyer un e-mail","send_message":"Envoyer un message","send_us_an_email":"Envoyez-nous un Email","services":"Prestations","sign_in":"Connexion","sign_in_here":"Connectez-vous ici","sign_up":"S'inscrire","status":"Statut","subject":"Sujet","subscribe":"S'inscrire","take_treatment":"Prendre un traitement","terms_and_conditions":"Termes et conditions","testimonial":"T\u00e9moignage","timings":"Calendrier","total_doctors":"Total des m\u00e9decins","total_registered_patient":"Total des patients enregistr\u00e9s","total_services":"Total des Prestations","total_specializations":"Total des sp\u00e9cialisations","view_more":"Voir plus","we_cover_a_big___":"Nous couvrons une grande vari\u00e9t\u00e9 de services m\u00e9dicaux","we_make_sure_that_your_life_are_in_good_hands":"Nous veillons \u00e0 ce que votre vie soit entre de bonnes mains","we_provide_the_special_tips___":"Nous fournissons des conseils et des conseils sp\u00e9ciaux sur les soins de sant\u00e9 et le meilleur niveau.","working_process":"Proc\u00e9d\u00e9 de travail","year_experience":"Ann\u00e9e Exp\u00e9rience"},"weekdays":{"fri":"VEN","mon":"LUN","sat":"Assis","sun":"SOLEIL","thu":"JEU","tue":"MAR","wed":"\u00c9POUSER"}},"fr.pagination":{"next":"Prochain","previous":"pr\u00e9c\u00e9dent"},"fr.passwords":{"reset":"Votre mot de passe a \u00e9t\u00e9 r\u00e9initialis\u00e9 !","sent":"Nous avons envoy\u00e9 votre lien de r\u00e9initialisation de mot de passe par e-mail !","throttled":"Veuillez patienter avant de r\u00e9essayer.","token":"Ce jeton de r\u00e9initialisation de mot de passe n'est pas valide.","user":"Nous ne trouvons pas d'utilisateur avec cette adresse e-mail."},"fr.validation":{"accepted":"L'attribut: doit \u00eatre accept\u00e9.","active_url":"L'attribut: n'est pas une URL valide.","after":"L'attribut: doit \u00eatre une date post\u00e9rieure \u00e0: date.","after_or_equal":"L'attribut: doit \u00eatre une date post\u00e9rieure ou \u00e9gale \u00e0: date.","alpha":"L'attribut: ne peut contenir que des lettres.","alpha_dash":"L'attribut: ne peut contenir que des lettres, des chiffres, des tirets et des traits de soulignement.","alpha_num":"L'attribut: ne peut contenir que des lettres et des chiffres.","array":"L'attribut: doit \u00eatre un tableau.","attributes":[],"before":"L'attribut: doit \u00eatre une date ant\u00e9rieure \u00e0: date.","before_or_equal":"L'attribut: doit \u00eatre une date ant\u00e9rieure ou \u00e9gale \u00e0: date.","between":{"array":"L'attribut: doit avoir entre: min et: max \u00e9l\u00e9ments.","file":"L'attribut: doit \u00eatre compris entre: min et: max kilo-octets.","numeric":"L'attribut: doit \u00eatre compris entre: min et: max.","string":"L'attribut: doit \u00eatre compris entre: min et: max caract\u00e8res."},"boolean":"Le champ: attribut doit \u00eatre vrai ou faux.","confirmed":"La confirmation d'attribut: ne correspond pas.","current_password":"Le mot de passe est incorrect.","custom":{"attribute-name":{"rule-name":"message personnalis\u00e9"}},"date":"L'attribut: n'est pas une date valide.","date_equals":"L'attribut: doit \u00eatre une date \u00e9gale \u00e0: date.","date_format":"L'attribut: ne correspond pas au format: format.","different":"Les: attribut et: autre doivent \u00eatre diff\u00e9rents.","digits":"L'attribut: doit \u00eatre: chiffres chiffres.","digits_between":"L'attribut: doit \u00eatre compris entre: min et: max chiffres.","dimensions":"L'attribut: a des dimensions d'image non valides.","distinct":"Le champ: attribut a une valeur en double.","email":"L'attribut: doit \u00eatre une adresse e-mail valide.","ends_with":"Le :attribute doit se terminer par l'un des \u00e9l\u00e9ments suivants : :values.","exists":"L'attribut selected: n'est pas valide.","file":"L'attribut: doit \u00eatre un fichier.","filled":"Le champ: attribut doit avoir une valeur.","gt":{"array":"L'attribut: doit avoir plus de: \u00e9l\u00e9ments de valeur.","file":"L'attribut: doit \u00eatre sup\u00e9rieur \u00e0: valeur kilo-octets.","numeric":"L'attribut: doit \u00eatre sup\u00e9rieur \u00e0: value.","string":"L'attribut: doit \u00eatre sup\u00e9rieur \u00e0: valeur caract\u00e8res."},"gte":{"array":"L'attribut: doit avoir: \u00e9l\u00e9ments de valeur ou plus.","file":"L'attribut: doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0: value kilo-octets.","numeric":"L'attribut: doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0: value.","string":"L'attribut: doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0: valeur caract\u00e8res."},"image":"L'attribut: doit \u00eatre une image.","in":"L'attribut selected: n'est pas valide.","in_array":"L\\e champ: attribut n'existe pas dans: autre.","integer":"L'attribut: doit \u00eatre un entier.","ip":"L'attribut: doit \u00eatre une adresse IP valide.","ipv4":"L'attribut: doit \u00eatre une adresse IPv4 valide.","ipv6":"L'attribut: doit \u00eatre une adresse IPv6 valide.","json":"L'attribut: doit \u00eatre une cha\u00eene JSON valide.","lt":{"array":"L'attribut: doit avoir moins de: \u00e9l\u00e9ments de valeur.","file":"L'attribut: doit \u00eatre inf\u00e9rieur \u00e0: valeur kilo-octets.","numeric":"L'attribut: doit \u00eatre inf\u00e9rieur \u00e0: value.","string":"L'attribut: doit \u00eatre inf\u00e9rieur \u00e0: valeur caract\u00e8res."},"lte":{"array":"L'attribut: ne doit pas avoir plus de: \u00e9l\u00e9ments de valeur.","file":"L'attribut: doit \u00eatre inf\u00e9rieur ou \u00e9gal \u00e0: value kilo-octets.","numeric":"L'attribut: doit \u00eatre inf\u00e9rieur ou \u00e9gal \u00e0: value.","string":"L'attribut: doit \u00eatre inf\u00e9rieur ou \u00e9gal \u00e0: valeur caract\u00e8res."},"max":{"array":"L'attribut: ne peut pas avoir plus de: max \u00e9l\u00e9ments.","file":"L'attribut: ne peut pas \u00eatre sup\u00e9rieur \u00e0: max kilo-octets.","numeric":"L'attribut: ne doit pas \u00eatre sup\u00e9rieur \u00e0: max.","string":"L'attribut: ne peut pas \u00eatre sup\u00e9rieur \u00e0: max caract\u00e8res."},"mimes":"L'attribut: doit \u00eatre un fichier de type:: valeurs.","mimetypes":"L'attribut: doit \u00eatre un fichier de type:: valeurs.","min":{"array":"L'attribut: doit avoir au moins: \u00e9l\u00e9ments min.","file":"L'attribut: doit \u00eatre d'au moins: min kilo-octets.","numeric":"L'attribut: doit \u00eatre au moins: min.","string":"L'attribut: doit contenir au moins: min caract\u00e8res."},"multiple_of":"Le :attribute doit \u00eatre un multiple de :value.","not_in":"L'attribut selected: n'est pas valide.","not_regex":"Le format d'attribut: n'est pas valide.","numeric":"L'attribut: doit \u00eatre un nombre.","password":"Le mot de passe est incorrect.","present":"Le champ: attribut doit \u00eatre pr\u00e9sent.","prohibited":"Le champ :attribute est interdit.","prohibited_if":"Le champ :attribute est interdit lorsque :other vaut :value.","prohibited_unless":"Le champ :attribute est interdit sauf si :other est dans :values.","regex":"Le format d'attribut: n'est pas valide.","required":"Le champ: attribut est obligatoire.","required_if":"Le champ: attribut est obligatoire lorsque: autre est: valeur.","required_unless":"Le champ: attribut est obligatoire sauf si: autre est dans: valeurs.","required_with":"Le champ: attribute est obligatoire lorsque: values est pr\u00e9sent.","required_with_all":"Le champ: attribute est obligatoire lorsque: des valeurs sont pr\u00e9sentes.","required_without":"Le champ: attribute est obligatoire lorsque: values n'est pas pr\u00e9sent.","required_without_all":"Le champ: attribute est obligatoire lorsqu'aucune des valeurs: n'est pr\u00e9sente.","same":"Les attributs: et: other doivent correspondre.","size":{"array":"L'attribut: doit contenir des \u00e9l\u00e9ments: size.","file":"L'attribut: doit \u00eatre: size kilo-octets.","numeric":"L'attribut: doit \u00eatre: size.","string":"L'attribut: doit \u00eatre: size caract\u00e8res."},"starts_with":"L'attribut: doit commencer par l'un des \u00e9l\u00e9ments suivants:: valeurs","string":"L'attribut: doit \u00eatre une cha\u00eene.","timezone":"L'attribut: doit \u00eatre une zone valide.","unique":"L'attribut: a d\u00e9j\u00e0 \u00e9t\u00e9 pris.","uploaded":"L'attribut: n'a pas pu \u00eatre t\u00e9l\u00e9charg\u00e9.","url":"L\\e format d'attribut: n'est pas valide.","uuid":"L'attribut: doit \u00eatre un UUID valide."},"id.livewire-tables::strings":{"All":"Semua","Applied Filters":"Filter Diterapkan","Applied Sorting":"Penyortiran Diterapkan","Bulk Actions":"Aksi","Clear":"Bersihkan","Columns":"Kolom","Done Reordering":"Selesai Mengurutkan Ulang","Filters":"Filter","No items found. Try to broaden your search.":"Tidak ada data yang ditemukan. Cobalah untuk memperluas pencarian Anda.","Remove filter option":"Hapus opsi filter","Remove sort option":"Hapus opsi pengurutan","Reorder":"Urutkan ulang","Search":"Cari","Select All":"Pilih Semua","Showing":"Menampilkan","Unselect All":"Batalkan Semua Pilihan","You are currently selecting all":"Anda sedang memilih semua","You are not connected to the internet.":"Anda sedang tidak terhubung ke internet.","You have selected":"Anda telah memilih","of":"dari","results":"hasil","rows":"baris","rows, do you want to select all":"baris, apakah Anda ingin memilih semua?","to":"ke"},"it.auth":{"app":{"create":"Creare","export":"Esportare","lock_account":"Blocca account","member_since":"Membro da","messages":"Messaggi","online":"In linea","print":"Stampa","profile":"Profilo","reload":"Ricaricare","reset":"Ripristina","search":"Ricerca","settings":"Impostazioni"},"confirm_password":"Conferma password","email":"E-mail","emails":{"password":{"reset_link":"Clicca qui per reimpostare la password"}},"failed":"Queste credenziali non corrispondono ai nostri record.","forgot_password":{"send_pwd_reset":"Invia link per reimpostare la password","title":"Inserisci l'e-mail per reimpostare la password"},"full_name":"Nome e cognome","login":{"forgot_password":"Ho dimenticato la mia password","register_membership":"Registrare un nuovo abbonamento","title":"Accedi per iniziare la tua sessione"},"password":"Parola d'ordine","register":"Registrati","registration":{"have_membership":"Ho gi\u00e0 un abbonamento","i_agree":"Acconsento","terms":"i termini","title":"Registrare un nuovo abbonamento"},"remember_me":"Ricordati di me","reset_password":{"reset_pwd_btn":"Resetta la password","title":"Reimposta la tua password"},"sign_in":"Registrazione","sign_out":"Disconnessione","throttle":"Troppi tentativi di accesso. Riprova tra :secondi secondi."},"it.livewire-tables::strings":{"All":"Tutti","Applied Filters":"Filtri Applicati","Applied Sorting":"Ordinamento Applicato","Bulk Actions":"Azioni di Gruppo","Clear":"Pulisci","Columns":"Colonne","Done Reordering":"Ordinamento Terminato","Filters":"Filtri","No items found. Try to broaden your search.":"Nessun risultato trovato. Prova ad ampliare la tua ricerca.","Remove filter option":"Rimuovi filtro","Remove sort option":"Rimuovi ordinamento","Reorder":"Riordina","Search":"Cerca","Select All":"Seleziona Tutto","Showing":"Visualizzati","Unselect All":"Deseleziona tutto","You are currently selecting all":"Stai selezionando tutto","You are not connected to the internet.":"Non sei connesso a internet","You have selected":"Hai selezionato","of":"di","results":"risultati","rows":"righe","rows, do you want to select all":"righe, vuoi selezionarle tutte","to":"a"},"it.messages":{"admin_dashboard":{"dashboard":"Pannello di controllo","day":"Giorno","earnings_from_appointments":"Guadagno da appuntamenti","filter_options":"Opzioni filtro","month":"Mese","name":"Nome","patient_id":"ID univoco paziente","recent_patients_registration":"Registrazione pazienti recenti","registered":"Registrato","today_appointments":"Appuntamenti di oggi","today_registered_patients":"Pazienti registrati oggi","total_doctor":"Medici totali","total_patients":"Pazienti totali","week":"Settimana"},"all_rights_reserved":"Tutti i diritti riservati","appointment":{"Select_payment_method":"Scegli il metodo di pagamento","add_new_appointment":"Aggiungi appuntamento","appointment_at":"Appuntamento a","appointment_date":"Data dell'appuntamento","appointment_details":"Dettagli appuntamento","appointment_status":"Stato dell'appuntamento","appointment_unique_id":"ID appuntamento","appointments":"Appuntamenti","appointments_schedule":"Programma degli appuntamenti","authorize_session_created_successfully":"Autorizza la sessione creata con successo.","available":"A disposizione","available_slot":"Slot disponibili","booked":"Prenotato","calendar":"Calendario","cancel_appointment":"Annulla appuntamento","cancelled":"Annullato","charge":"Caricare","check_in":"Registrare","check_out":"Guardare","date":"Data","description":"Descrizione","edit_appointment":"Modifica appuntamento","ends":"Fine","extra_fees":"Costi aggiuntivi","no_slot_found":"Nessuna fascia oraria trovata.","patient":"Paziente","patient_id":"ID paziente","patient_name_retrieved":"Nome del paziente recuperato correttamente","payable_amount":"Importo da pagare","payment":"Pagamento","payment_method":"Metodo di pagamento","payment_status":"Stato del pagamento","service":"Servizio","service_charge":"Costo del servizio","session_created_successfully":"sessione creata con successo","session_id_required":"l'ID sessione \u00e8 obbligatorio","starts":"Inizia","status":"Stato","switch_to_calendar":"Passa al calendario","time":"Volta","total_payable_amount":"Importo totale pagabile","upcoming_meetings":"prossimi incontri"},"appointments":"Appuntamenti","apps":"App","card_number_invalid..":"Il numero della carta non \u00e8 valido.","card_type":"Tipo di carta di credito","cities":"Citt\u00e0","city":{"add_city":"Aggiungi citt\u00e0","city":"Citt\u00e0","edit_city":"Modifica citt\u00e0","state":"Stato"},"clinic_schedules":"Orari Clinica","cms":{"Terms_Conditions_required":"Termini e condizioni sono obbligatori","about_image":"A proposito di immagine","cms":"CMS","description_no_white_space":"Il campo Informazioni sulla breve descrizione non contiene solo spazi bianchi","experience_required":"Il campo Informazioni sull'esperienza \u00e8 obbligatorio.","privacy_policy":"Politica sulla riservatezza","privacy_policy_required.":"L'informativa sulla privacy \u00e8 obbligatoria.","terms_conditions":"Termini & Condizioni","title_no_white_space":"Il campo del titolo non contiene solo spazi bianchi"},"common":{"Attempt_read_property_access_token_null":"Tentativo di leggere la propriet\u00e0 \\\"access_token\\\" su null","Forgot_password_lable":"Hai dimenticato la tua password? Nessun problema. Comunicaci semplicemente il tuo indirizzo email e ti invieremo un collegamento per reimpostare la password che ti consentir\u00e0 di sceglierne una nuova.","action":"Azione","active":"Attivo","add":"Aggiungere","add_credential":"Aggiungi le credenziali di zoom","age":"Et\u00e0","any_one_permission":"Seleziona un'autorizzazione qualsiasi.","apply":"Applicare","appointment_date_required":"Il campo della data dell'appuntamento \u00e8 obbligatorio.","are_you_sure":"Sei sicuro di voler eliminare questo","are_you_sure_cancel":"Sei sicuro di voler annullare questo","back":"Indietro","booked":"Prenotato","brand_required":"Il campo del marchio \u00e8 obbligatorio.","cancel":"Annulla","cancelled":"Annullato","cancelled_appointment":"Appuntamento annullato!","category_required":"Il campo della categoria \u00e8 obbligatorio.","change_image":"Cambia immagine","check in":"Registrare","check out":"Guardare","city":"Citt\u00e0","confirm":"Confermare","connected_zoom":"Connesso con zoom correttamente.","contact_number":"Il numero di contatto \u00e8","country":"Nazione","custom":"Costume","de_active":"Disattivare","default_language":"Lingua di default","delete":"Elimina","deleted":"Eliminato!","details":"Particolari","discard":"Scartare","doctor_required":"Il campo Dottore \u00e8 obbligatorio.","download":"Scaricamento","edit":"Modificare","email_already_exist":"L'e-mail \u00e8 gi\u00e0 iscritta.","email_max":"La dimensione massima dell'e-mail \u00e8 255.","email_not_register":"L'e-mail non \u00e8 registrata.","email_regex":"Il campo e-mail deve essere in un formato valido.","email_required":"Il campo e-mail \u00e8 obbligatorio.","email_verified":"Email verificata","error":"errore","filter":"Filtro","filter_option":"Opzione filtro","first_name_required":"Il campo del nome \u00e8 obbligatorio.","forgot_your_password":"Hai dimenticato la password","from":"Da","google_captcha_required":"Il campo captcha di Google \u00e8 obbligatorio.","has_been":"\u00e8 stato cancellato.","has_cancel":" \u00e8 stato cancellato.","hour":"Ora","icon":"Icona","impersonate":"Impersonare","instagram_url":"URL di Instagram","last_name_required":"Il campo Cognome \u00e8 obbligatorio.","linkedin_url":"URL Linkedin","logout":"Disconnettersi","maximum_55":"Sono consentiti al massimo 55 caratteri.","message_required":"Il campo del messaggio \u00e8 obbligatorio.","minutes":"Minuti","n\/a":"N \/ A","name":"Nome","name_already_taken":"Il nome \u00e8 gi\u00e0 stato preso","name_required":"Il campo Nome \u00e8 obbligatorio","no":"No, Annulla","no_data_available":"Nessun dato disponibile","no_data_available_in_table":"Nessun dato disponibile nella tabella","no_records_found":"Nessun record trovato.","not_allow__assess_record":"Sembra che non ti sia consentito accedere a questo record.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Nota: stiamo prendendo il fuso orario dei tuoi medici durante la creazione dell'appuntamento nel calendario. Se il medico non ha impostato il fuso orario, verr\u00e0 utilizzato il fuso orario UTC predefinito.","note_white_space":"Il campo Nota non contiene solo spazi bianchi","observation_white_space":"Il campo di osservazione non contiene solo spazi bianchi","of":"Di","overview":"Panoramica","payment_type_required":"Il campo Metodo di pagamento \u00e8 obbligatorio.","please_wait":"Attendere prego...","prescription_report":"Rapporto sulla prescrizione","problem_white_space":"Il campo problematico non contiene solo spazi bianchi","processing":"In lavorazione..","purchase_price":"Prezzo d'acquisto","read":"Leggi","remember_me":"Ricordati di me","resend_verification_email":"Invia nuovamente email di verifica","reset":"Ripristina","reset_password":"Resetta la password","results":"risultati","save":"Salva","search":"Ricerca","select_brand":"Seleziona Marca","select_category":"Seleziona categoria","select_city":"Seleziona citt\u00e0","select_country":"Seleziona il paese","select_doctor":"Seleziona dottore","select_service":"Seleziona servizio","select_state":"Seleziona stato","service":"Servizio","service_required":"Il campo Servizi \u00e8 obbligatorio.","show":"Mostrare","showing":"Mostrando","state":"Stato","status":"Stato","subject_required":"Il campo dell'oggetto \u00e8 obbligatorio.","submit":"Invia","to":"A","twitter_url":"URL Twitter","unread":"Non letto","verify_lable1":"Grazie per esserti iscritto! Prima di iniziare, potresti verificare il tuo indirizzo email facendo clic sul collegamento che ti abbiamo appena inviato via email? Se non hai ricevuto l'e-mail, te ne invieremo volentieri un'altra.","verify_lable2":"Un nuovo collegamento di verifica \u00e8 stato inviato all'indirizzo email fornito durante la registrazione.","view":"Visualizza","years":"Anni","yes":"S\u00ec, Elimina!","yes_update":"S\u00ec, Aggiorna!","zoom_credentials":"Aggiungi le credenziali di zoom."},"contact_us":"Contattaci","countries":"Paesi","country":{"add_country":"Aggiungi Paese","country":"Nazione","short_code":"Codice corto"},"currencies":"Valute","currency":{"add_currency":"Aggiungi valuta","add_currency_code_as_per_three_letter_iso_code":"Aggiungi codice valuta secondo il codice ISO di tre lettere","currency_code":"Codice valuta","currency_icon":"Icona valuta","currency_name":"Nome valuta","edit_currency":"Modifica valuta","name":"Nome","note":"Nota","you_can_find_out_here":"puoi scoprirlo qui"},"cvv_invalid.":"Il CVV non \u00e8 valido.","cvv_number_required.":"I campi del numero CVV sono obbligatori.","dashboard":"Pannello di controllo","datepicker":{"custom":"Gamma personalizzata","last_30_days":"Ultimi 30 giorni","last_month":"Lo scorso mese","last_week":"la settimana scorsa","this_month":"Questo mese","this_week":"Questa settimana","today":"Oggi","yesterday":"Ieri"},"doctor":{"add":"Aggiungi dottore","add_qualification":"Aggiungi qualifica","address1":"Indirizzo 1","address2":"Indirizzo 2","address_information":"Informazioni sull'indirizzo","allowed_img":"Tipi di file consentiti: png, jpg, jpeg.","city":"Citt\u00e0","collage_university":"COLLAGE\/UNIVERSIT\u00c0","country":"Nazione","created_at":"Creato a","degree":"Livello","dob":"DOB","doctor":"Medico","doctor_detail":"Dettagli medico","edit":"Modifica dottore","experience":"Esperienza nell'anno","female":"Femmina","first_name":"Nome di battesimo","instagram":"Instagram","last_name":"Cognome","linkedin":"Linkedin","male":"Maschio","passout_year":"Anno svenuto","postal_code":"Codice Postale","profile":"Profilo","qualification":"Qualificazione","qualification_information":"Informazioni sulla qualifica","select_blood_group":"Seleziona Gruppo sanguigno","select_date":"Seleziona Data","select_doctors":"doktorlar\u0131 se\u00e7","select_gender":"Selezionare genere","select_year":"Seleziona Anno","specialization":"Specializzazione","sr_no":"SR NO","state":"Stato","status":"Stato","twitter":"Twitter","university":"Universit\u00e0","updated_at":"Aggiornato a","year":"Anno"},"doctor_appointment":{"amount":"Quantit\u00e0","from_time":"Dal momento","patient":"Paziente","service":"Servizio","to_time":"Al tempo"},"doctor_appointments":"Appuntamenti dal dottore","doctor_dashboard":{"recent_appointments":"Appuntamenti recenti","total_appointments":"Appuntamenti totali"},"doctor_session":{"add":"Aggiungi programma medico","all":"Tutto","copy":"Copia","doctor":"Medico","doctor_session":"Programma medico","doctor_session_details":"Dettagli programma medico","edit":"Modifica orario medico","evening_session":"Programma serale","friday":"Venerd\u00ec","gap_between_appointment":"Gap tra l'appuntamento","monday":"Lunedi","morning_session":"Programma mattutino","my_schedule":"Il mio programma","saturday":"Sabato","select_meeting_time":"Seleziona l'ora della riunione","select_session_gap":"Seleziona intervallo di pianificazione","session":"Sessione","session_gap":"Schedule Gap","session_meeting_time":"Programma l'ora della riunione","session_time_in_minutes":"Programma l'ora della riunione","sunday":"Domenica","thursday":"Gioved\u00ec","tuesday":"Marted\u00ec","unavailable":"Non disponibile","wednesday":"Mercoled\u00ec","week_days":"Giorni della settimana"},"doctor_sessions":"Programmi medici","doctors":"Medici","doctors_scheduled_time_ended_for_today__":"L'orario programmato del medico \u00e8 terminato per oggi, selezionare un medico o una data diversi","email_password_reset_link":"Collegamento per reimpostare la password dell'e-mail","enquiries":"Indagini","expiration_month_required":"I campi relativi al mese di scadenza sono obbligatori.","expiration_year_required":"I campi relativi all'anno di scadenza sono obbligatori.","faq":{"add_faq":"Aggiungi FAQ","answer":"Risposta","edit_faq":"Modifica FAQ","question":"Domanda"},"faqs":"Domande frequenti","filter":{"active":"Attivo","all":"Tutto","awaited":"Atteso","booked":"Prenotato","cancelled":"Annullato","check in":"Registrare","check out":"Guardare","deactive":"Disattivare","finished":"Finito","paid":"Pagato","pending":"In attesa di","read":"Leggi","unread":"Non letto"},"filter_success":"filtrare il successo","flash":{"about_image_validation_message":"L'immagine About deve essere un file del seguente tipo: jpg, jpeg, png.","about_us_create":"Chi siamo salvati con successo.","all_notification_read":"Tutte le notifiche sono state lette correttamente.","appointment_booked":"Appuntamento prenotato con successo","appointment_cancel":"Appuntamento annullato.","appointment_create":"Appuntamento creato con successo.","appointment_created_payment_complete":"Appuntamento creato con successo e pagamento completato.","appointment_created_payment_not_complete":"Appuntamento creato con successo e pagamento non completato.","appointment_delete":"Appuntamento cancellato con successo.","appointment_not_found":"Appuntamento non trovato","appointment_retrieve":"Dati del calendario degli appuntamenti recuperati con successo.","calender_added":"Calendario aggiunto con successo.","cat_retrieve":"Categoria recuperata con successo.","cities_retrieve":"Citt\u00e0 recuperate con successo","city_create":"Citt\u00e0 creata con successo.","city_delete":"Citt\u00e0 eliminata con successo.","city_retrieved":"Citt\u00e0 recuperata con successo.","city_update":"Citt\u00e0 aggiornata con successo.","city_used":"Citt\u00e0 usata da qualche altra parte.","clinic_delete":"ClinicSchedule eliminato con successo.","clinic_save":"Pianificazione clinica salvata con successo.","cms_update":"CMS aggiornato correttamente.","country_create":"Paese creato con successo.","country_delete":"Paese eliminato con successo.","country_update":"Paese aggiornato correttamente.","country_used":"Paese utilizzato da qualche altra parte.","create_blog":"Blog VCard creato con successo.","create_front_testimonial":"Testimonianza creata con successo.","currency_create":"Valuta creata con successo.","currency_delete":"Valuta eliminata con successo.","currency_update":"Valuta aggiornata correttamente.","currency_used":"Valuta usata da qualche altra parte.","current_invalid":"La password attuale non \u00e8 valida.","data_retrieve":"Dati recuperati con successo.","default_role_not_delete":"Il ruolo predefinito non viene eliminato.","degree_required":"Il campo di laurea \u00e8 obbligatorio.","doctor_appointment":"Dati del calendario dell'appuntamento medico recuperati con successo.","doctor_create":"Il dottore \u00e8 stato creato con successo.","doctor_delete":"Dottore eliminato con successo.","doctor_holiday":"Il dottor Holiday \u00e8 stato creato con successo","doctor_not_available":"Medico non disponibile","doctor_session_not_found":"Sessione medico non trovata.","doctor_update":"Medico aggiornato con successo.","doctor_use":"Il dottore ha usato con successo.","email_notification":"Notifica e-mail aggiornata correttamente.","email_send":"Invio email riuscito.","enquire_deleted":"Richiesta eliminata con successo.","enquire_sent":"Richiesta inviata con successo","faq_creat":"FAQ create correttamente.","faq_delete":"Domande frequenti eliminate con successo.","faq_update":"Domande frequenti aggiornate correttamente.","faq_use":"Questa FAQ \u00e8 stata usata da qualche altra parte.","favicon_validation_message":"La favicon deve essere un file di tipo: jpg, jpeg, png.","feature_update":"Funzione aggiornata correttamente.","google_calendar_connect":"Il tuo Google Calendar \u00e8 ora connesso.","google_calendar_disconnect":"Google Calendar disconnesso con successo.","google_calendar_update":"Il tuo Google Calendar \u00e8 stato aggiornato correttamente.","holiday_already_is_exist":"La vacanza esiste gi\u00e0 per questa data","icon_validation_message":"L'icona deve essere un file del seguente tipo: jpg, jpeg, png, svg.","language_change":"Lingua cambiata con successo","language_update":"Lingua aggiornata correttamente.","live_consultation_delete":"Consultazione in tempo reale eliminata con successo.","live_consultation_retrieved":"Consultazione in tempo reale recuperata con successo.","live_consultation_save":"Consultazione in tempo reale salvata con successo.","live_consultation_update":"Consultazione in tempo reale aggiornata con successo.","logo_validation_message":"Il logo dell'applicazione deve essere un file del tipo: jpg, jpeg, png.","maximum_char":"Massimo 60 caratteri consentiti.","messages_sent":"Messaggio inviato correttamente","no_available_slots":"Non ci sono slot disponibili in una data specifica.","note_added":"Nota aggiunta con successo.","note_delete":"Nota eliminata con successo.","notification_read":"Notifica letta correttamente.","notification_send":"Notifica di verifica e-mail inviata correttamente.","observation_added":"Osservazione aggiunta con successo.","observation_delete":"Eliminazione osservazione riuscita.","operation_performed_success":"Operazione eseguita con successo","order_create":"Ordine creato con successo.","password_update":"Password aggiornata correttamente.","patient_appointment":"Dati del calendario degli appuntamenti del paziente recuperati con successo.","patient_create":"Paziente creato con successo.","patient_delete":"Paziente eliminato con successo.","patient_not_found":"Paziente non trovato.","patient_update":"Paziente aggiornato correttamente.","patient_used":"Paziente usato da qualche altra parte.","patients_retrieve":"Pazienti recuperati con successo.","payment_status_updated":"Stato del pagamento aggiornato correttamente.","paystack_token_expired":"Il gettone di pagamento \u00e8 scaduto. Perfavore ricarica la pagina e riprova.","plan_default":"Il piano predefinito \u00e8 cambiato con successo.","plan_status":"Stato del piano aggiornato con successo","plan_update":"Piano aggiornato con successo.","prescription_delete":"Prescrizione eliminata con successo.","prescription_retrieved":"Prescrizione recuperata con successo.","problem_added":"Problema aggiunto con successo.","problem_delete":"Eliminazione del problema riuscita.","profile_validation_message":"Il profilo deve essere un file del tipo: jpg, jpeg, png.","qualification_create":"Qualificazione creata con successo.","reactive_account":"Riattiva il tuo account dalla posta.","retrieve":"Recuperato con successo.","review_add":"Aggiungi revisione con successo.","review_edit":"Revisione modificata con successo.","review_retrieved":"Revisione recuperata con successo.","role_create":"Ruolo aggiornato correttamente..","role_delete":"Ruolo eliminato con successo.","role_update":"Ruolo aggiornato correttamente.","schedule_crete":"Programma creato con successo.","schedule_delete":"Programma eliminato con successo.","schedule_not_found":"Programma non trovato.","schedule_update":"Programma aggiornato correttamente.","select_calendar.":"Seleziona un calendario.","select_payment":"Seleziona un qualsiasi metodo di pagamento","service_cat_create":"Categoria di servizio creata con successo.","service_cat_delete":"Categoria di servizio eliminata con successo.","service_cat_update":"Categoria di servizio aggiornata correttamente.","service_cat_use":"Categoria di servizio usata altrove.","service_create":"Servizio creato con successo.","service_delete":"Eliminazione del servizio riuscita.","service_update":"Servizio aggiornato correttamente.","service_use":"Servizio utilizzato altrove.","session_retrieve":"Sessione recuperata con successo.","setting_update":"Impostazioni aggiornate correttamente.","slider_update":"Slider aggiornato con successo","some_doctors":"Alcuni medici hanno programmato i loro giorni in giorni non controllati, quindi sei sicuro di voler eseguire questa operazione?","something_went_wrong":"Qualcosa \u00e8 andato storto","specialization_create":"Specializzazione creata con successo.","specialization_delete":"Specializzazione eliminata con successo.","specialization_update":"Specializzazione aggiornata con successo.","specialization_use":"Specializzazione utilizzata con successo.","staff_create":"Personale creato con successo.","staff_delete":"Eliminazione del personale riuscita.","staff_update":"Staff aggiornato con successo.","staff_use":"Personale utilizzato con successo.","state_create":"Stato creato correttamente.","state_delete":"Stato aggiornato correttamente.","state_update":"Stato eliminato con successo.","state_use":"Stato utilizzato da qualche altra parte.","states_retrieve":"Stati recuperati con successo.","status_change":"Stato cambiato con successo.","status_update":"Stato aggiornato correttamente.","subscriber_creat":"Abbonato creato con successo.","subscriber_delete":"Abbonato eliminato con successo.","testimonial_creat":"Testimonianza del paziente anteriore creata con successo.","testimonial_delete":"Eliminazione riuscita della testimonianza del paziente anteriore.","testimonial_update":"Aggiornamento della testimonianza del paziente anteriore riuscito.","testimonial_use":"Testimonianza del paziente anteriore utilizzata con successo.","theme_change":"Tema cambiato con successo.","there_were":"Ci \u200b\u200bsono stati dei problemi con il pagamento. Per favore riprova pi\u00f9 tardi.","university_required":"L'universit\u00e0 \u00e8 richiesta.","update_blog":"Blog VCard aggiornato correttamente.","update_front_testimonial":"Testimonianza aggiornata con successo.","user_8_or":"Usa 6 o pi\u00f9 caratteri con un mix di lettere, numeri e simboli.","user_already_verified":"L'utente ha gi\u00e0 verificato l'email.","user_profile":"Profilo utente aggiornato correttamente.","user_profile_update":"Profilo utente aggiornato correttamente.","user_role_not_delete":"Non \u00e8 stato possibile eliminare questo ruolo utente perch\u00e9 \u00e8 assegnato a un utente.","user_status":"Stato utente aggiornato con successo","user_update":"Utente aggiornato correttamente.","user_zoom_credential_saved":"Credenziali Ingrandisci utente salvate correttamente.","valid_instagram":"Inserisci un URL Instagram valido","valid_linkedin":"Inserisci un URL Linkedin valido","valid_twitter":"Inserisci un URL Twitter valido","verified_email":"E-mail verificata con successo.","visit_create":"Visita creata con successo.","visit_delete":"Eliminazione visita riuscita.","visit_prescription_added":"Visita Prescrizione aggiunta con successo.","visit_prescription_update":"Prescrizione visita aggiornata con successo.","visit_update":"Visita aggiornata con successo.","year_required":"L'anno \u00e8 richiesto.","your_reg_success":"La tua registrazione \u00e8 riuscita. Verifica il tuo account dall'e-mail."},"front_cms":"CMS anteriore","front_faqs":"Domande frequenti","front_medical_service":{"add_front_medical_service":"Aggiungi servizio medico frontale","edit_front_medical_service":"Modifica servizio medico anteriore","short_description":"Breve descrizione","title":"Titolo"},"front_medical_services":"Servizi medici frontali","front_patient_testimonial":{"add_front_patient_testimonial":"Aggiungi testimonianza del paziente anteriore","designation":"Designazione","edit_front_patient_testimonial":"Modifica testimonianza del paziente anteriore","more_patient_feedbacks":"Altri feedback dei pazienti...","name":"Nome","patient_testimonials":"Testimonianze dei pazienti","profile":"Profilo","short_description":"Breve descrizione"},"front_patient_testimonials":"Testimonianze del paziente anteriore","front_service":{"add_front_service":"Aggiungi servizio front","edit_front_service":"Modifica Front Service","icon":"Icona","short_description":"Breve descrizione","title":"Titolo"},"front_services":"Servizi frontali","google_calendar":"Google Calendar","holder_name_invalid":"Il nome del titolare della carta non \u00e8 valido.","holder_name_required":"I campi relativi al nome del titolare della carta sono obbligatori.","holder_number_invalid":"I campi relativi al numero della carta sono obbligatori.","holiday":{"add_holiday":"Aggiungi vacanza","doctor_holiday":"Dottor Vacanze","holiday":"Vacanza","holiday_date":"Data festiva","service_category":"Categoria di servizio"},"how_we_care":"Come ci preoccupiamo","how_we_cares":{"add_how_we_care":"Aggiungi come ci preoccupiamo","edit_how_we_care":"Modifica come ci preoccupiamo","icon":"Icona","short_description":"Breve descrizione","status":"Stato","title":"Titolo"},"icon_size":"La dimensione dell'icona deve essere inferiore a 2 MB","id":"ID","image_file_type":"L'immagine deve essere un file di tipo: jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invalid_range":"Intervallo non valido","live_consultation":{"add_credential":"Aggiungi credenziali","add_live_consultation":"Aggiungi consultazione dal vivo","awaited":"Attesa","client_video":"Video del cliente","consultation_date":"Data di consultazione","consultation_duration_minutes":"Minuti della durata della consultazione","consultation_minutes":"Verbale di consultazione","consultation_title":"Titolo della consultazione","created_by":"Creato da","created_for":"Creato per","description":"Descrizione","disabled":"Disabilitato","duration":"Durata (in minuti)","edit_live_consultation":"Modifica consultazione dal vivo","edit_live_meeting":"Modifica riunione dal vivo","enable":"Abilitare","finished":"Finito","host_video":"Ospita video","join_now":"Iscriviti adesso","live_consultation_details":"Dettagli della consultazione dal vivo","new_live_consultation":"Nuova consultazione dal vivo","new_live_meeting":"Nuovo incontro dal vivo","select_consultation_date":"Seleziona data di consultazione","select_doctor_name":"Seleziona il nome del dottore","select_patient_name":"Seleziona il nome del paziente","staff_list":"Elenco del personale","start_now":"Parti ora","type":"Tipo","type_number":"Numero tipo","zoom_api_key":"Zoom chiave API","zoom_api_secret":"Segreto dell'API Zoom"},"live_consultations":"Consultazioni dal vivo","live_status_retrieved_successfully.":"Stato in tempo reale recuperato correttamente.","login":"Login","medicine":{"available_quantity":"quantit\u00e0 disponibile","brand":"Marca","brand_name":"Marchio","buying_price":"Prezzo d'acquisto","cant_be_deleted":"non pu\u00f2 essere cancellato","category":"Categoria","category_id":"ID categoria","category_retrieved_successfully":"Categoria Medicina recuperata correttamente.","deleted_successfully":"eliminato con successo","description":"Descrizione","dosage":"Dosaggio","dose_interval":"Selezionare l'intervallo di dose","duration":"Durata","edit_medicine":"Modifica Medicina","edit_medicine_brand":"Modifica il marchio della medicina","edit_medicine_category":"Modifica categoria medicina","filter_options":"Opzioni filtro","medicine":"Medicinale","medicine_brands":"Marchi di medicina","medicine_brands_details":"Dettagli sul marchio della medicina","medicine_category":"Categoria Medicina","medicine_category_details":"Dettagli sulla categoria della medicina","medicine_details":"Dettagli della medicina","medicine_name":"Nome della medicina","medicine_retrieved_successfully":"Medicina recuperata con successo","medicines":"Medicinali","name":"Nome","new_brand":"Nuova marca","new_medicine":"Nuova Medicina","new_medicine_brand":"Nuovo marchio di medicina","new_medicine_category":"Categoria Nuova Medicina","no_use":"Non in uso","quantity":"Quantit\u00e0","salt_composition":"Composizione di sale","saved_successfully":"Salvato con successo","select_duration":"Seleziona Durata","selling_price":"Prezzo di vendita","side_effects":"Effetti collaterali","status_updated_successfully":"Stato aggiornato con successo.","updated_successfully":"aggiornato con successo"},"medicine_bills":{"add_medicine_bill":"Aggiungi la fattura della medicina","available_quantity":"La quantit\u00e0 disponibile di","avl_qty":"Qt\u00e0 media","bill_date":"Data fattura","bill_id":"ID fattura","bill_number":"Numero di fattura","cell_no":"Cella n","dose_interval":"Intervallo di dose","duplicate_medicine":"Impossibile aggiungere medicinali duplicati.","edit_medicine_bill":"Modifica disegno di legge medicina","enter_lot_number":"Inserisci il numero di lotto.","enter_puchase_price":"Inserisci il prezzo di acquisto","enter_sale_price":"Inserisci il prezzo di vendita.","is":"\u00c8","item_name":"Nome dell'elemento","medicine_bill":"Progetto di legge sulla medicina","medicine_bill_details":"Dettagli della legge sulla medicina","medicine_bills":"Bollette di medicina","medicine_not_selected":"Seleziona almeno un medicinale.","medicine_required":"Il campo Medicina \u00e8 obbligatorio.","net_amount_cant":"L\"importo netto non pu\u00f2 essere vuoto.","net_amount_cant_zero":"L'importo netto non pu\u00f2 essere zero.","net_amount_not_empty":"L'importo netto non pu\u00f2 essere vuoto.","net_amount_not_zero":"L'importo netto non pu\u00f2 essere zero.","new_medicine_bill":"Nuovo disegno di legge sulla medicina","payment_status":"Stato del pagamento","payment_type":"Modalit\u00e0 di pagamento","prescription_not_found":"Prescrizione non trovata","price":"Prezzo","print_bill":"Stampa fattura","quantity_should":"La quantit\u00e0 deve essere maggiore di 0.","sale_price":"Prezzo di vendita","select_medicine":"Seleziona Medicina","select_patient":"Seleziona Paziente","select_payment_type":"Seleziona il tipo di pagamento","tax_amt":"L'importo dell'imposta non pu\u00f2 essere zero o vuoto.","tax_cannot_be_zero_empty":"L'importo dell'imposta non pu\u00f2 essere zero o vuoto.","tax_should_be":"Le tasse dovrebbero essere inferiori al 100%.","the_discount_shoul":"Lo sconto dovrebbe essere inferiore all'importo totale","the_medicine_already_in_use":"Questo medicinale \u00e8 gi\u00e0 utilizzato nelle fatture dei medicinali. Vuoi eliminarlo?","update_quantity":"La quantit\u00e0 di aggiornamento deve essere inferiore alla quantit\u00e0 precedente."},"medicine_brands":"Marchi di medicina","medicine_categories":"Categorie di medicina","medicines":"Medicinali","mobile_no":"cellulare n","months":{"apr":"Apr","aug":"Ago","dec":"Dic","feb":"Feb","jan":"Gen","jul":"Lug","jun":"Giu","mar":"Mar","may":"Mag","nov":"Nov","oct":"Ott","sep":"Set"},"no_matching_records_found":"Nessuna corrispondenza trovata","no_response":"Nessuna risposta restituita","not_supported":"non supportato","note":"Nota: devi impostare il tuo fuso orario prima di integrare Google Calendar.","notification":{"mark_all_as_read":"Segna tutti come letti","notification":"Notifiche","you_don`t_have_any_new_notification":"Non hai nessuna nuova notifica"},"our_team":"Squadra","patient":{"add":"Aggiungi paziente","address1":"Indirizzo 1","address2":"Indirizzo 2","address_information":"Informazioni sull'indirizzo","blood_group":"Gruppo sanguigno","city":"Citt\u00e0","confirm_password":"Conferma password","contact_no":"Contatto n.","country":"Nazione","details":"Dettagli paziente","dob":"DOB","edit":"Modifica paziente","email":"E-mail","emailverified":"email verificata","enter_email":"Inserisci l'email","enter_password":"Inserire la password","female":"Femmina","filter":"filtro","first_name":"Nome di battesimo","gender":"Genere","last_name":"Cognome","last_updated":"Ultimo aggiornamento","male":"Maschio","name":"Nome","password":"Parola d'ordine","patient_unique_id":"ID univoco paziente","postal_code":"Codice Postale","profile":"Profilo","registered_on":"Registrato il","save_changes":"Salvare le modifiche","state":"Stato","today":"Oggi"},"patient_dashboard":{"completed_appointments":"Appuntamenti completati","next_appointment":"Prossimi appuntamenti","today_appointments":"Appuntamenti di oggi","upcoming_appointments":"Prossimi appuntamenti"},"patients":"Pazienti","payment_detail":"Dettagli di pagamento","payment_for_booking_appointment_with_doctor":"Pagamento per prenotazione appuntamento con il medico","payment_method":{"authorize":"Autorizzare","paypal":"Paypal","paystack":"Pagaia","paytm":"Paga","razorpay":"Razorpay","stripe":"Banda"},"paytm":"Paga","prescription":{"accident":"Incidente","advice":"consiglio","appointment_slot":"Spazi per appuntamenti","available_quantity_of":"La quantit\u00e0 disponibile di ","breast_feeding":"Allattamento al seno","comment":"commento","connect_with_zoom":" Connettiti con Ingrandisci","current_medication":"Farmaci attuali","diabetic":"diabetico","doctor":"Medico","dosage":"dosaggio","duration":"Periodo di tempo","edit_prescription":"Modifica ricetta","female_pregnancy":"Gravidanza femminile","food_allergies":"Allergie alimentari","frequency":"Frequenza","health_insurance":"Assicurazione sanitaria","heart_disease":"cardiopatia","high_blood_pressure":"ipertensione","is":"\u00c8","low_income":"Reddito basso","medical_history":"Storia medica","medicine_name":"Nome della medicina","name":"Nome","new_medicine":"nuova medicina","new_prescription":"Nuova ricetta","next_visit":"prossima visita","not_add_duplicate_medicines":"Impossibile aggiungere medicinali duplicati.","ok":"OK","others":"Altro","patient":"Paziente","physical_information":"informazioni fisiche","plus_rate":"Tariffa d'impulso","prescription":"Ricetta","prescription_details":"Dettagli della ricetta","prescription_saved":"Ricetta salvata con successo.","prescription_updated":"Ricetta aggiornata con successo.","prescriptions":"Ricette","problem":"problema","problem_description":"Descrizione del problema","reference":"riferimento","rx":"Ricezione","selectMedicine":"Seleziona la medicina","surgery":"chirurgia","temperature":"temperatura","tendency_bleed":"tendenza a sanguinare","test":"Test","time":"Tempo","total_quantity":"Quantit\u00e0 totale"},"privacy_policy":"Politica sulla riservatezza","purchase_medicine":{"actions":"Azioni","amount":"Quantit\u00e0","discount":"Sconto","dose_duration":"Durata della dose","expiry_date":"Data di scadenza","export_to_excel":"esportare in Excel","lot_no":"Lotto n.","net_amount":"Importo netto","note":"Nota","other_details":"Altri dettagli","payment_mode":"Metodo di pagamento","payment_note":"Nota di pagamento","purchase_medicine":"Acquista Medicina","purchase_medicine_details":"Acquista i dettagli della medicina","purchase_medicine_overview":"Acquista panoramica della medicina","purchase_medicines":"Acquista medicinali","purchase_number":"Numero di acquisto","purchased_medicine_success":"Medicina acquistata con successo","quantity":"Quantit\u00e0","tax":"Imposta","tax_amount":"Ammontare della tassa","total":"Totale"},"range_constructor_requires_trie_parameter":"Il costruttore dell'intervallo richiede un parametro Trie","register":"Registrati","requires_string_parameter":"rangeWithString richiede un parametro stringa","resend_email_verification":"Invia nuovamente la verifica dell'e-mail","review":{"add_review":"Aggiungi recensione","edit_review":"Modifica recensione","no_doctors_available_to_give_rating":"Nessun medico disponibile per dare una valutazione.","review":"Revisione","write_a_review":"Scrivere una recensione"},"reviews":"Recensioni","role":{"add_role":"Aggiungi ruolo","edit_role":"Modifica ruolo","permissions":"Autorizzazioni","role":"Ruolo","role_permissions":"Autorizzazioni di ruolo","select_all_permissions":"Seleziona tutte le autorizzazioni"},"roles":"Ruoli","satisfied_patient":"Paziente soddisfatto","service":{"add_service":"Aggiungi servizio","category":"Categoria","charges":"Addebiti","edit_service":"Modifica servizio","short_description":"Breve descrizione","status":"Stato"},"service_categories":"Categorie di servizio","service_category":{"add_category":"Aggiungi categoria di servizio","edit_category":"Modifica categoria di servizio","service_category":"Categoria di servizio"},"services":"Servizi","setting":{"address":"Indirizzo","change_app_logo":"Cambia il logo dell'app","change_favicon":"Cambia favicon","clinic_name":"Nome clinica","connect_google_calendar":"Collega Google Calendar","connect_your_google_calendar":"Collega il tuo Google Calendar","contact_information":"Informazioni sui contatti","currency":"Moneta","currency_settings":"Impostazioni valuta","default_country_code":"Codice Paese predefinito","default_language_suggest":"Aggiornandolo, l'intera lingua dell'app cambier\u00e0 agli accessi del medico, del paziente e al lato anteriore.","disconnect_your_google_calendar":"Scollega il tuo Google Calendar","do_not_allow_to_login_without_email_verification":"Non consentire l'accesso senza la verifica e-mail","favicon":"Favicon","general":"Generale","general_details":"Dettagli generali","logo":"Logo","postal_code":"Codice Postale","prefix":"Prefisso","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"Seleziona i tuoi calendari (da Google Calendar) in cui desideri creare gli appuntamenti","setting":"Collocamento","specialities":"Specialit\u00e0","sync_your_google_calendar":"Sincronizza il tuo Google Calendar","when_checkbox_disable":"Quando la casella di controllo \u00e8 disabilitata, la verifica e-mail non funziona per i nuovi utenti.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Quando il paziente prenota un appuntamento con te, verr\u00e0 creato un nuovo appuntamento sui calendari selezionati","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Quando prenoti un appuntamento, verr\u00e0 creato un nuovo appuntamento sui calendari selezionati"},"settings":"Impostazioni","sign_up":"Iscriviti","slider":{"add_slider":"Aggiungi dispositivo di scorrimento","edit_slider":"Modifica dispositivo di scorrimento","image":"Immagine","short_description":"Breve descrizione","title":"Titolo"},"sliders":"Cursori","smart_patient_card":{"add_smart_card":"Aggiungi Carta Intelligente","add_smart_card_templates":"Aggiungi Modelli di Carte Intelligenti","address_show":"Mostra Indirizzo","blood_group_show":"Mostra Gruppo Sanguigno","dob_show":"Mostra Data di Nascita","edit_patient_card":"Modifica Carta Intelligente","email_show":"Mostra Email","enter_template_name":"Inserisci il Nome del Modello","for_all_patient":"Per Tutti i Pazienti","generate_patient_card":"Genera Carta Paziente","generate_patient_smart_cards":"Genera Carte Paziente Intelligenti","header_color":"Colore Intestazione","only_one_patient":"Solo Un Paziente","patient":"Paziente","patient_smart_card_created":"Carta intelligente del paziente creata con successo.","patient_smart_card_deleted":"Carta intelligente del paziente eliminata con successo.","phone_show":"Mostra Telefono","please_selest_patient":"Selezionare il paziente","remaning_patients":"Pazienti Rimanenti","select_patient":"Seleziona Paziente","select_template":"Seleziona Modello","smart_patient_card_templates":"Modelli di Carte Paziente Intelligenti","smart_patient_cards":"Carte Paziente Intelligenti","templat_name":"Nome Modello","template":"Modello","template_created":"Modello creato con successo.","template_deleted":"Modello eliminato con successo.","template_update":"Aggiornamento del modello riuscito.","type":"Tipo","unique_id_show":"Mostra ID Unico"},"specialization":{"add_specialization":"Aggiungi specializzazione","edit_specialization":"Modifica specializzazione","retrieved_successfully":"Specializzazione recuperata con successo."},"specializations":"Specializzazioni","staff":{"add_staff":"Aggiungi personale","confirm_password":"Conferma password","contact_no":"Contatto n.","edit_staff":"Modifica personale","email":"E-mail","female":"Femmina","first_name":"Nome di battesimo","gender":"Genere","last_name":"Cognome","male":"Maschio","password":"Parola d'ordine","role":"Ruolo","select_role":"Seleziona Ruolo","staff":"personale","staff_details":"Dettagli del personale"},"staffs":"Personale","start_time_invalid":"l'ora di inizio del giorno non \u00e8 valida","state":{"add_state":"Aggiungi stato","country":"Nazione","edit_state":"Modifica stato","state":"Stato","states":"stati"},"states":"Stati","subscribers":"Iscritti","terms_conditions":"Termini & Condizioni","this_is_an_alert":"Questo \u00e8 un avviso","too_long":"Demasiado largo","too_short":"Demasiado corto","transaction":{"paid":"Pagato","payment_accepted_by":"Pagamento accettato da","payment_status":"Stato del pagamento","pending":"Ask\u0131da olmas\u0131","transaction_detail":"Dettaglio transazione","transaction_id":"ID transazione"},"transactions":"Transazioni","used_medicine":{"used_at":"Usato a","used_medicine":"Medicina usata","used_medicines":"Medicinali usati","used_quantity":"Quantit\u00e0 usata"},"user":{"account":"Account","account_setting":"Impostazioni dell 'account","avatar":"Avatar","change_language":"Cambia lingua","change_password":"Cambiare la password","confirm_password":"Conferma password","contact_number":"Numero di contatto","current_password":"Password attuale","edit_profile":"Modifica Profilo","email":"E-mail","email_notification":"Notifica per email","full_name":"Nome e cognome","gender":"Genere","language":"Lingua","new_password":"Nuova password","profile_details":"Dettagli del profilo","return_to_admin":"Ritorna all'amministratore","save_changes":"Salvare le modifiche","select_time_zone":"Seleziona Fuso orario","setting":"Collocamento","sign_out":"Disconnessione","staff_details":"Dettagli del personale","time_zone":"Fuso orario"},"users":"Utenti","valid_expiration_date":"Inserisci una data di scadenza valida.","valid_number":"N\u00famero v\u00e1lido","visit":{"add_visit":"Aggiungi visita","description":"Descrizione","doctor":"Medico","edit_visit":"Modifica visita","enter_note":"Inserisci nota","enter_observation":"Entra in osservazione","enter_problem":"Inserisci problema","notes":"Appunti","observations":"Osservazioni","patient":"Paziente","prescriptions":"Prescrizioni","problems":"I problemi","title":"Titolo","visit_date":"Data di visita","visit_detail":"Dettaglio visita","visit_details":"Dettagli visita"},"visits":"Visite","web":{"Meet_best_doctors":"Incontra i migliori dottori","about_experience":"Informazioni sull'esperienza","about_short_description":"Informazioni sulla descrizione breve","about_title":"Informazioni sul titolo","about_us":"Chi siamo","all_rights_reserved":"Tutti i diritti riservati","all_services":"Tutti i servizi","already_have_an_account":"Hai gi\u00e0 un account","already_have_patient_account":"Avere gi\u00e0 un account paziente","appointment":"Appuntamento","appointment_now":"Appuntamento ora","best_professionals":"I migliori professionisti","book_an_appointment":"Prenotare un appuntamento","book_appointment":"Prenota appuntamento","call_us":"Chiamaci","closed":"Chiuso","confirm_booking":"Conferma prenotazione","contact":"Contatto","contact_us":"Contattaci","contact_us_for_any_information":"Contattaci per qualsiasi informazione","create_an_account":"Creare un account","created_at":"Creato a","doctors":"Medici","doctors_can_interact___":"I medici possono interagire con i pazienti e fare il relativo trattamento.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Formulare dinamicamente risultati privi di errori prima di risultati integrati. Incubare drammaticamente risorse integrate senza costi contenuti al di fuori del.","email":"E-mail","email_address":"Indirizzo email","emergency_help":"Aiuto di emergenza","enquiry":"Inchiesta","enquiry_details":"Dettagli della richiesta","enter_your_email":"Inserisci il tuo indirizzo email","enter_your_email_to_subscribe_to_our_newsletter":"Inserisci la tua email per iscriverti alla nostra newsletter","faqs":"Domande frequenti","forgot_password":"Ha dimenticato la password","home":"Casa","how_we_works":"Come lavoriamo","i_agree":"Concordo","location":"Posizione","login":"Login","make_appointment":"Prendere appuntamento","medical":"Casa","medical_about_us":"Chi siamo","medical_appointment":"Appuntamenti","medical_contact":"Contatto","medical_doctors":"Medici","medical_services":"Servizi","medical_treatment":"Trattamento medico","meet_our_team_of_specialists":"Incontra il nostro team di specialisti","message":"Messaggio","name":"Nome","new_here":"Nuovo qui","no_services_available":"Nessun servizio disponibile","opening_hours":"Orari di apertura","our_doctor":"Il nostro dottore","our_services":"Nostro servizio","our_team":"Squadra","patient_can_book_an_appointment___":"Il paziente pu\u00f2 prenotare un appuntamento con il medico dalla pagina di destinazione o dal suo pannello di accesso.","patient_can_do_registration___":"Il paziente pu\u00f2 effettuare la registrazione da qui con le informazioni di base.","patient_name":"Nome paziente","patient_registration":"Registrazione paziente","phone":"Telefono","qualified_doctors":"Medici qualificati","questions_before_booking":"Domande prima della prenotazione","quick_links":"Link veloci","reason":"Motivo","registration":"Registrazione","remember_me":"Ricordati di me","satisfied_patient":"Paziente","saying_about_us":"Parlando di noi","see_what_are_the_patients":"Vedi quali sono i pazienti","send_an_email":"Invia un'e-mail","send_message":"Invia messaggio","send_us_an_email":"Mandaci un email","services":"Servizi","sign_in":"Registrazione","sign_in_here":"Accedi qui","sign_up":"Iscriviti","status":"Stato","subject":"Materia","subscribe":"Sottoscrivi","take_treatment":"Prendi il trattamento","terms_and_conditions":"Termini e Condizioni","testimonial":"Testimonianza","timings":"Tempi","total_doctors":"Medici totali","total_registered_patient":"Totale pazienti registrati","total_services":"Servizi totali","total_specializations":"Specializzazioni totali","view_more":"Visualizza altro","we_cover_a_big___":"Copriamo una grande variet\u00e0 di servizi medici","we_make_sure_that_your_life_are_in_good_hands":"Ci assicuriamo che la tua vita sia in buone mani","we_provide_the_special_tips___":"Forniamo i suggerimenti e i consigli speciali per il trattamento sanitario e l'alto livello del meglio.","working_process":"Processo lavorativo","year_experience":"Esperienza annuale"},"weekdays":{"fri":"Ven","mon":"Lun","sat":"Sab","sun":"Dom","thu":"Gio","tue":"Mar","wed":"Mer"}},"it.pagination":{"next":"Il prossimo","previous":"Precedente"},"it.passwords":{"reset":"La tua password \u00e8 stata resettata!","sent":"Abbiamo inviato via e-mail il link per la reimpostazione della password!","throttled":"Attendere prima di riprovare.","token":"Questo token di reimpostazione della password non \u00e8 valido.","user":"Non riusciamo a trovare un utente con quell'indirizzo email."},"it.validation":{"accepted":"L'attributo :deve essere accettato.","active_url":"L'attributo :non \u00e8 un URL valido.","after":"L'attributo :deve essere una data successiva a :date.","after_or_equal":"L'attributo :deve essere una data successiva o uguale a :data.","alpha":"L'attributo : deve contenere solo lettere.","alpha_dash":"L'attributo : deve contenere solo lettere, numeri, trattini e trattini bassi.","alpha_num":"L'attributo : deve contenere solo lettere e numeri.","array":"L'attributo : deve essere un array.","attributes":[],"before":"L'attributo :deve essere una data precedente a :date.","before_or_equal":"L'attributo :deve essere una data precedente o uguale a :date.","between":{"array":"L'attributo :deve avere elementi compresi tra :min e :max.","file":"L'attributo :deve essere compreso tra :min e :max kilobyte.","numeric":"L'attributo :deve essere compreso tra :min e :max.","string":"L'attributo :deve essere compreso tra :min e :max caratteri."},"boolean":"Il campo :attributo deve essere vero o falso.","confirmed":"La conferma :attributo non corrisponde.","current_password":"La password non \u00e8 corretta.","custom":{"attribute-name":{"rule-name":"messaggio personalizzato"}},"date":"L'attributo :non \u00e8 una data valida.","date_equals":"L'attributo :deve essere una data uguale a :data.","date_format":"L'attributo :non corrisponde al formato :format.","different":"L'attributo :attributo e :altro devono essere diversi.","digits":"L'attributo :deve essere :cifre cifre.","digits_between":"L'attributo :deve essere compreso tra :min e :max cifre.","dimensions":"L'attributo :ha dimensioni dell'immagine non valide.","distinct":"Il campo :attributo ha un valore duplicato.","email":"L'attributo :deve essere un indirizzo email valido.","ends_with":"L'attributo :deve terminare con uno dei seguenti: :valori.","exists":"L'attributo :selezionato non \u00e8 valido.","file":"L'attributo :deve essere un file.","filled":"Il campo :attributo deve avere un valore.","gt":{"array":"L'attributo :deve avere pi\u00f9 di :elementi di valore.","file":"L'attributo :deve essere maggiore di :valore kilobyte.","numeric":"L'attributo :deve essere maggiore di :valore.","string":"L'attributo :deve essere maggiore di :caratteri di valore."},"gte":{"array":"L'attributo :deve avere :elementi di valore o pi\u00f9.","file":"L'attributo :deve essere maggiore o uguale a :valore kilobyte.","numeric":"L'attributo :deve essere maggiore o uguale a :valore.","string":"L'attributo :deve essere maggiore o uguale a :caratteri di valore."},"image":"L'attributo :deve essere un'immagine.","in":"L'attributo :selezionato non \u00e8 valido.","in_array":"Il campo :attributo non esiste in :altro.","integer":"L'attributo :deve essere un numero intero.","ip":"L'attributo : deve essere un indirizzo IP valido.","ipv4":"L'attributo : deve essere un indirizzo IPv4 valido.","ipv6":"L'attributo : deve essere un indirizzo IPv6 valido.","json":"L'attributo : deve essere una stringa JSON valida.","lt":{"array":"L'attributo :deve avere meno di :elementi di valore.","file":"L'attributo :deve essere inferiore a :value kilobytes.","numeric":"L'attributo :deve essere minore di :valore.","string":"L'attributo :deve essere inferiore a :caratteri di valore."},"lte":{"array":"L'attributo :non deve contenere pi\u00f9 di :elementi di valore.","file":"L'attributo :deve essere minore o uguale a :valore kilobyte.","numeric":"L'attributo :deve essere minore o uguale a :valore.","string":"L'attributo :deve essere minore o uguale a :caratteri di valore."},"max":{"array":"L'attributo :non deve contenere pi\u00f9 di :max elementi.","file":"L'attributo :non deve essere maggiore di :max kilobyte.","numeric":"L'attributo :non deve essere maggiore di :max.","string":"L'attributo :non deve essere maggiore di :max caratteri."},"mimes":"L'attributo :deve essere un file di tipo: :valori.","mimetypes":"L'attributo :deve essere un file di tipo: :valori.","min":{"array":"L'attributo :deve avere almeno :min elementi.","file":"L'attributo :deve essere almeno :min kilobyte.","numeric":"L'attributo :deve essere almeno :min.","string":"L'attributo :deve contenere almeno :min caratteri."},"multiple_of":"L'attributo :deve essere un multiplo di :valore.","not_in":"L'attributo :selezionato non \u00e8 valido.","not_regex":"Il formato :attributo non \u00e8 valido.","numeric":"L'attributo :deve essere un numero.","password":"La password non \u00e8 corretta.","present":"Il campo :attributo deve essere presente.","prohibited":"Il campo :attributo \u00e8 vietato.","prohibited_if":"Il campo :attributo \u00e8 proibito quando :altro \u00e8 :valore.","prohibited_unless":"Il campo :attributo \u00e8 proibito a meno che :other sia in :values.","regex":"Il formato :attributo non \u00e8 valido.","required":"Il campo :attributo \u00e8 obbligatorio.","required_if":"Il campo :attributo \u00e8 obbligatorio quando :altro \u00e8 :valore.","required_unless":"Il campo :attributo \u00e8 obbligatorio a meno che :other non sia in :valori.","required_with":"Il campo :attributo \u00e8 obbligatorio quando :valori \u00e8 presente.","required_with_all":"Il campo :attributo \u00e8 obbligatorio quando sono presenti :valori.","required_without":"Il campo :attributo \u00e8 obbligatorio quando :valori non \u00e8 presente.","required_without_all":"Il campo :attributo \u00e8 obbligatorio quando nessuno dei :valori \u00e8 presente.","same":"L'attributo :attributo e :altro devono corrispondere.","size":{"array":"L'attributo :deve contenere :dimensioni articoli.","file":"L'attributo :deve essere :dimensione kilobyte.","numeric":"L'attributo :deve essere :dimensione.","string":"L'attributo :deve essere :caratteri di dimensione."},"starts_with":"L'attributo :deve iniziare con uno dei seguenti: :valori.","string":"L'attributo :deve essere una stringa.","timezone":"L'attributo : deve essere un fuso orario valido.","unique":"L'attributo :\u00e8 gi\u00e0 stato preso.","uploaded":"Impossibile caricare :attributo.","url":"L'attributo : deve essere un URL valido.","uuid":"L'attributo : deve essere un UUID valido."},"pt.auth":{"app":{"create":"Criar","export":"Exportar","lock_account":"Bloquear conta","member_since":"Membro desde","messages":"Mensagens","online":"Online","print":"Imprimir","profile":"Perfil","reload":"Recarregar","reset":"Reiniciar","search":"Pesquisar","settings":"Configura\u00e7\u00f5es"},"confirm_password":"Confirmar senha","email":"Email","emails":{"password":{"reset_link":"Clique aqui para redefinir sua senha"}},"failed":"Estas credenciais n\u00e3o correspondem aos nossos registros.","forgot_password":{"send_pwd_reset":"Enviar link de redefini\u00e7\u00e3o de senha","title":"Digite o e-mail para redefinir a senha"},"full_name":"Nome Completo","login":{"forgot_password":"Esqueci minha senha","register_membership":"Registrar uma nova associa\u00e7\u00e3o","title":"Fa\u00e7a login para iniciar sua sess\u00e3o"},"password":"Senha","register":"Registrar","registration":{"have_membership":"J\u00e1 sou membro","i_agree":"Eu concordo com","terms":"os termos","title":"Registrar uma nova associa\u00e7\u00e3o"},"remember_me":"Lembre-se de mim","reset_password":{"reset_pwd_btn":"Redefinir senha","title":"Redefinir sua senha"},"sign_in":"Entrar","sign_out":"Sair","throttle":"Muitas tentativas de login. Por favor, tente novamente em: segundos segundos. "},"pt.livewire-tables::strings":{"All":"Tudo","Applied Filters":"Filtros Aplicados","Applied Sorting":"Ordena\u00e7\u00e3o Aplicada","Bulk Actions":"A\u00e7\u00f5es Massivas","Clear":"Limpar","Columns":"Colunas","Done Reordering":"Ordeana\u00e7\u00e3o finalizada","Filters":"Filtros","No items found. Try to broaden your search.":"Nenhum resultado encontrado. Tente ampliar a sua pesquisa.","Remove filter option":"Remover op\u00e7\u00e3o de filtro","Remove sort option":"Remover op\u00e7\u00e3o de ordena\u00e7\u00e3o","Reorder":"Reordenar","Search":"Pesquisar","Select All":"Seleccionar Tudo","Showing":"A mostrar","Unselect All":"Desmarcar Tudo","You are currently selecting all":"Atualmente est\u00e1 a selecionar tudo","You are not connected to the internet.":"N\u00e3o est\u00e1 ligado \u00e0 internet.","You have selected":"Selecionou","of":"de","results":"resultados","row":"linha","rows":"linhas","rows, do you want to select all":"linhas, pretende selecionar tudo","to":"a"},"pt.messages":{"admin_dashboard":{"dashboard":"Painel","day":"Dia","earnings_from_appointments":"Ganhos de nomea\u00e7\u00f5es","filter_options":"Op\u00e7\u00f5es de filtro","month":"M\u00eas","name":"Nome","patient_id":"Id \u00danico do Paciente","recent_patients_registration":"Registro de Pacientes Recentes","registered":"Registrado","today_appointments":"Compromissos de hoje","today_registered_patients":"Pacientes registrados hoje","total_doctor":"Total de m\u00e9dicos","total_patients":"Total de pacientes","week":"Semana"},"appointment":{"Select_payment_method":"Selecione o m\u00e9todo de pagamento","add_new_appointment":"Adicionar Compromisso","appointment_at":"Compromisso em","appointment_date":"Data de Compromisso","appointment_details":"Detalhes do Compromisso","appointment_status":"Status do compromisso","appointment_unique_id":"ID de Compromisso","appointments":"Compromissos","appointments_schedule":"Agendamento de compromissos","authorize_session_created_successfully":"Autorizar sess\u00e3o criada com sucesso.","available":"Dispon\u00edvel","available_slot":"Slots dispon\u00edveis","booked":"Reservado","calendar":"Calend\u00e1rio","cancel_appointment":"Cancela o agendamento","cancelled":"Cancelado","charge":"Carregar","check_in":"Fazer check-in","check_out":"Check Out","date":"Data","description":"Descri\u00e7\u00e3o","edit_appointment":"Editar Compromisso","ends":"Termina","extra_fees":"Taxas extras","no_slot_found":"Nenhum intervalo de tempo encontrado.","patient":"Paciente","patient_id":"Id do paciente","patient_name_retrieved":"Nome do paciente recuperado com sucesso","payable_amount":"Valor a pagar","payment":"Pagamento","payment_method":"Forma de pagamento","payment_status":"Status do pagamento","service":"Servi\u00e7o","service_charge":"Taxa de servi\u00e7o","session_created_successfully":"sess\u00e3o criada com sucesso","session_id_required":"o ID da sess\u00e3o \u00e9 obrigat\u00f3rio","starts":"Come\u00e7a","status":"Status","switch_to_calendar":"Mudar para calend\u00e1rio","time":"Tempo","total_payable_amount":"Valor total a pagar","upcoming_meetings":"pr\u00f3ximas reuni\u00f5es"},"appointments":"Compromissos","apps":"Aplicativos","card_number_invalid..":"O n\u00famero do cart\u00e3o \u00e9 inv\u00e1lido.","card_type":"Tipo de cart\u00e3o de cr\u00e9dito","cities":"Cidades","city":{"add_city":"Adicionar cidade","city":"Cidade","edit_city":"Editar cidade","state":"Estado"},"clinic_schedules":"Hor\u00e1rios Cl\u00ednicos","cms":{"Terms_Conditions_required":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios","about_image":"Sobre a imagem","cms":"CMS","description_no_white_space":"Sobre o campo Descri\u00e7\u00e3o resumida n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","experience_required":"O campo Sobre Experi\u00eancia \u00e9 obrigat\u00f3rio.","privacy_policy":"Pol\u00edtica de privacidade","privacy_policy_required.":"A Pol\u00edtica de Privacidade \u00e9 obrigat\u00f3ria.","terms_conditions":"Termos e Condi\u00e7\u00f5es","title_no_white_space":"Sobre o campo T\u00edtulo n\u00e3o cont\u00e9m apenas espa\u00e7os em branco"},"common":{"Attempt_read_property_access_token_null":"Tentativa de ler a propriedade \\\"access_token\\\" em null","Forgot_password_lable":"Voc\u00ea esqueceu sua senha? Sem problemas. Basta nos informar seu endere\u00e7o de e-mail e enviaremos um link de redefini\u00e7\u00e3o de senha que permitir\u00e1 que voc\u00ea escolha uma nova.","action":"A\u00e7\u00e3o","active":"Ativo","add":"Adicionar","add_credential":"Adicione credenciais de zoom","age":"Idade","any_one_permission":"Selecione qualquer permiss\u00e3o.","apply":"Aplicar","appointment_date_required":"O campo data do agendamento \u00e9 obrigat\u00f3rio.","are_you_sure":"Tem certeza que deseja excluir isso","are_you_sure_cancel":"Tem certeza que deseja cancelar isso ","back":"Voltar","booked":"Reservado","brand_required":"O campo marca \u00e9 obrigat\u00f3rio.","cancel":"Cancelar","cancelled":"Cancelado","cancelled_appointment":"Marca\u00e7\u00e3o cancelada!","category_required":"O campo categoria \u00e9 obrigat\u00f3rio.","change_image":"Alterar imagem","check in":"Check-in","check out":"Verifica\u00e7\u00e3o de sa\u00edda","city":"Cidade","confirm":"confirme","connected_zoom":"Conectado com zoom com sucesso.","contact_number":"O n\u00famero de contato \u00e9","country":"Pa\u00eds","custom":"Personalizado","de_active":"Desativar","default_language":"Idioma padr\u00e3o","delete":"Excluir","deleted":"Exclu\u00eddo!","details":"Detalhes","discard":"Descartar","doctor_required":"O campo m\u00e9dico \u00e9 obrigat\u00f3rio.","download":"Download","edit":"Editar","email_already_exist":"O e-mail j\u00e1 foi inscrito.","email_max":"O tamanho m\u00e1ximo do e-mail \u00e9 255.","email_not_register":"O e-mail n\u00e3o est\u00e1 cadastrado.","email_regex":"O campo de e-mail deve ter um formato v\u00e1lido.","email_required":"O campo e-mail \u00e9 obrigat\u00f3rio.","email_verified":"email verificadod","error":"erro","filter":"Filtro","filter_option":"Op\u00e7\u00e3o de filtro","first_name_required":"O campo do nome \u00e9 obrigat\u00f3rio.","forgot_your_password":"Esqueceu sua senha","from":"A partir de","google_captcha_required":"O campo captcha do Google \u00e9 obrigat\u00f3rio.","has_been":"foi deletado.","has_cancel":" foi cancelado.","hour":"Hora","impersonate":"personificar","instagram_url":"URL do Instagram","last_name_required":"O campo do sobrenome \u00e9 obrigat\u00f3rio.","linkedin_url":"URL do Linkedin","logout":"Sair","maximum_55":"M\u00e1ximo de 55 caracteres permitidos.","message_required":"O campo mensagem \u00e9 de preenchimento obrigat\u00f3rio.","minutes":"Minutos","n\/a":"N\/A","name":"Nome","name_already_taken":"O nome j\u00e1 foi escolhido","name_required":"O campo Nome \u00e9 obrigat\u00f3rio","no":"N\u00e3o, Cancelar","no_data_available":"N\u00e3o h\u00e1 dados dispon\u00edveis","no_data_available_in_table":"Sem dados dispon\u00edveis na tabela","no_records_found":"Nenhum registro encontrado.","not_allow__assess_record":"Parece que voc\u00ea n\u00e3o tem permiss\u00e3o para acessar este registro.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435. \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0441\u0442\u0440\u0435\u0447\u0438 \u0432 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0435 \u043c\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u0432\u0430\u0448\u0438\u0445 \u0432\u0440\u0430\u0447\u0435\u0439. \u0415\u0441\u043b\u0438 \u0414\u043e\u043a\u0442\u043e\u0440 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441, \u043e\u043d \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 UTC \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.","note_white_space":"O campo de observa\u00e7\u00e3o n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","observation_white_space":"O campo de observa\u00e7\u00e3o n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","of":"de","overview":"Vis\u00e3o geral","payment_type_required":"O campo Forma de Pagamento \u00e9 obrigat\u00f3rio.","please_wait":"Por favor, aguarde ...","prescription_report":"Relat\u00f3rio de prescri\u00e7\u00e3o","problem_white_space":"O campo do problema n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","processing":"Em processamento..","purchase_price":"Pre\u00e7o de compra","read":"Ler","remember_me":"Lembre de mim","resend_verification_email":"Reenviar email de verifica\u00e7\u00e3o","reset":"Reiniciar","reset_password":"Redefinir senha","results":"resultados","save":"Salvar","search":"Procurar","select_brand":"Selecione a marca","select_category":"Selecione a Categoria","select_city":"Selecione a cidade","select_country":"Selecione o pais","select_doctor":"Selecionar m\u00e9dico","select_service":"Selecionar servi\u00e7o","select_state":"Selecionar Estado","service":"Servi\u00e7o","service_required":"O campo Servi\u00e7os \u00e9 obrigat\u00f3rio.","show":"mostrar","showing":"Mostrando","state":"Estado","subject_required":"O campo assunto \u00e9 obrigat\u00f3rio.","submit":"Enviar","to":"para","twitter_url":"URL do Twitter","unread":"N\u00e3o lida","verify_lable1":"Obrigado por inscrever-se! Antes de come\u00e7ar, voc\u00ea poderia verificar seu endere\u00e7o de e-mail clicando no link que acabamos de enviar para voc\u00ea? Se voc\u00ea n\u00e3o recebeu o e-mail, teremos prazer em lhe enviar outro.","verify_lable2":"Um novo link de verifica\u00e7\u00e3o foi enviado para o endere\u00e7o de e-mail que voc\u00ea forneceu durante o registro.","view":"\u0412\u0438\u0434","years":"Anos","yes":"Sim, Excluir!","yes_update":"Sim, atualiza\u00e7\u00e3o!","zoom_credentials":"Adicione credenciais de zoom."},"countries":"Pa\u00edses","country":{"add_country":"Adicionar pa\u00eds","country":"Pa\u00eds","short_code":"C\u00f3digo Curto"},"currencies":"Moedas","currency":{"add_currency":"Adicionar moeda","add_currency_code_as_per_three_letter_iso_code":"Adicione o c\u00f3digo da moeda de acordo com o c\u00f3digo ISO de tr\u00eas letras","currency_code":"C\u00f3digo da moeda","currency_icon":"\u00cdcone de moeda","currency_name":"Nome da moeda","edit_currency":"Editar moeda","name":"Nome","you_can_find_out_here":"Voc\u00ea pode descobrir aqui"},"cvv_invalid.":"CVV \u00e9 inv\u00e1lido.","cvv_number_required.":"Os campos de n\u00famero CVV s\u00e3o obrigat\u00f3rios.","dashboard":"Painel","datepicker":{"last_30_days":"\u00daltimos 30 dias","last_month":"M\u00eas passado","last_week":"Semana passada","this_month":"Este m\u00eas","this_week":"Essa semana","today":"Hoje","yesterday":"Ontem"},"doctor":{"add":"Adicionar M\u00e9dico","add_qualification":"Adicionar qualifica\u00e7\u00e3o","address1":"Endere\u00e7o 1","address2":"Endere\u00e7o 2","address_information":"Informa\u00e7\u00f5es de endere\u00e7o","allowed_img":"Tipos de arquivo permitidos: png, jpg, jpeg.","city":"Cidade","collage_university":"COLAGEM \/ UNIVERSIDADE","country":"Pa\u00eds","created_at":"Criado em","degree":"Grau","dob":"DOB","doctor":"Doutor","doctor_detail":"Detalhes do m\u00e9dico","edit":"Editar Doutor","experience":"Experi\u00eancia no ano","female":"Feminino","first_name":"Nome","instagram":"Instagram","last_name":"Sobrenome","linkedin":"Linkedin","male":"Masculino","passout_year":"Ano da P\u00e1scoa","postal_code":"C\u00f3digo Postal","profile":"Perfil","qualification":"Qualifica\u00e7\u00e3o","qualification_information":"Informa\u00e7\u00f5es de qualifica\u00e7\u00e3o","select_blood_group":"Selecionar grupo sangu\u00edneo","select_date":"Selecione a data","select_doctors":"selecionar m\u00e9dicos","select_gender":"Selecionar Sexo","select_year":"Selecione o ano","specialization":"Especializa\u00e7\u00e3o","sr_no":"SR NO","state":"Estado","status":"Status","twitter":"Twitter","university":"Universidade","updated_at":"Atualizado em","year":"Ano"},"doctor_appointment":{"amount":"Quantidade","from_time":"Desde o Tempo","patient":"Paciente","service":"Servi\u00e7o","to_time":"To Time"},"doctor_appointments":"Consultas m\u00e9dicas","doctor_dashboard":{"recent_appointments":"Compromissos recentes","total_appointments":"Total de Compromissos"},"doctor_session":{"add":"Adicionar Agendamento M\u00e9dico","all":"Tudo","copy":"C\u00f3pia de","doctor":"Doutor","doctor_session":"Hor\u00e1rio M\u00e9dico","doctor_session_details":"Detalhes da agenda do m\u00e9dico","edit":"Editar Hor\u00e1rio M\u00e9dico","evening_session":"Programa\u00e7\u00e3o noturna","friday":"Sexta-feira","gap_between_appointment":"Espa\u00e7o entre compromissos","monday":"Segunda-feira","morning_session":"Programa\u00e7\u00e3o matinal","my_schedule":"Minha programa\u00e7\u00e3o","saturday":"S\u00e1bado","select_meeting_time":"Selecione o hor\u00e1rio da reuni\u00e3o","select_session_gap":"Selecionar intervalo de programa\u00e7\u00e3o","session":"Sess\u00e3o","session_gap":"Programa\u00e7\u00e3o Gap","session_meeting_time":"Agendar hora da reuni\u00e3o","session_time_in_minutes":"Agendar hora da reuni\u00e3o","sunday":"Domingo","thursday":"Quinta-feira","tuesday":"Ter\u00e7a-feira","unavailable":"Indispon\u00edvel","wednesday":"Quarta-feira","week_days":"Dias da semana"},"doctor_sessions":"Programa\u00e7\u00f5es m\u00e9dicas","doctors":"M\u00e9dicos","doctors_scheduled_time_ended_for_today__":"O hor\u00e1rio agendado do m\u00e9dico terminou para hoje, selecione um m\u00e9dico ou data diferente","email_password_reset_link":"Link para redefinir a senha do e-mail","enquiries":"Consultas","expiration_month_required":"Os campos do m\u00eas de expira\u00e7\u00e3o s\u00e3o obrigat\u00f3rios.","expiration_year_required":"Os campos do ano de expira\u00e7\u00e3o s\u00e3o obrigat\u00f3rios.","faq":{"add_faq":"Adicionar FAQ","answer":"Resposta","edit_faq":"Editar FAQ","question":"Pergunta"},"faqs":"FAQs","filter":{"active":"Ativo","all":"Tudo","awaited":"Aguardado","booked":"Reservado","cancelled":"Cancelado","check in":"Check-in","check out":"Verifica\u00e7\u00e3o de sa\u00edda","deactive":"Desativar","finished":"Finalizado","paid":"Pago","pending":"Pendente","read":"Ler","unread":"N\u00e3o lida"},"filter_success":"sucesso do filtro","flash":{"about_image_validation_message":"A imagem Sobre deve ser um arquivo do seguinte tipo: jpg, jpeg, png.","about_us_create":"Sobre n\u00f3s salvo com sucesso.","all_notification_read":"Todas as notifica\u00e7\u00f5es foram lidas com sucesso.","appointment_booked":"Atendimento agendado com sucesso","appointment_cancel":"Agendamento cancelado.","appointment_create":"Atendimento criado com sucesso.","appointment_created_payment_complete":"Atendimento criado com sucesso e pagamento conclu\u00eddo.","appointment_created_payment_not_complete":"Atendimento criado com sucesso e pagamento n\u00e3o conclu\u00eddo.","appointment_delete":"Compromisso exclu\u00eddo com sucesso.","appointment_not_found":"Atendimento n\u00e3o encontrado","appointment_retrieve":"Dados do calend\u00e1rio de compromissos recuperados com sucesso.","calender_added":"Calend\u00e1rio adicionado com sucesso.","cat_retrieve":"Categoria recuperada com sucesso.","cities_retrieve":"Cidades recuperadas com sucesso","city_create":"Cidade criada com sucesso.","city_delete":"Cidade exclu\u00edda com sucesso.","city_retrieved":"Cidade recuperada com sucesso.","city_update":"Cidade atualizada com sucesso.","city_used":"Cidade usada em outro lugar.","clinic_delete":"ClinicSchedule exclu\u00eddo com sucesso.","clinic_save":"Agenda cl\u00ednica salva com sucesso.","cms_update":"CMS atualizado com sucesso.","country_create":"Pa\u00eds criado com sucesso.","country_delete":"Pa\u00eds exclu\u00eddo com sucesso.","country_update":"Pa\u00eds atualizado com sucesso.","country_used":"Pa\u00eds usado em outro lugar.","create_blog":"Blog do VCard criado com sucesso.","create_front_testimonial":"Depoimento criado com sucesso.","currency_create":"Moeda criada com sucesso.","currency_delete":"Moeda exclu\u00edda com sucesso.","currency_update":"Moeda atualizada com sucesso.","currency_used":"Moeda usada em outro lugar.","current_invalid":"A senha atual \u00e9 inv\u00e1lida.","data_retrieve":"Dados recuperados com sucesso.","default_role_not_delete":"A fun\u00e7\u00e3o padr\u00e3o n\u00e3o \u00e9 exclu\u00edda.","degree_required":"O campo de gradua\u00e7\u00e3o \u00e9 obrigat\u00f3rio.","doctor_appointment":"Dados do calend\u00e1rio de consulta m\u00e9dica recuperados com sucesso.","doctor_create":"M\u00e9dico criado com sucesso.","doctor_delete":"M\u00e9dico exclu\u00eddo com sucesso.","doctor_holiday":"Doutor Holiday criado com sucesso","doctor_not_available":"M\u00e9dico n\u00e3o dispon\u00edvel","doctor_session_not_found":"Sess\u00e3o do m\u00e9dico n\u00e3o encontrada.","doctor_update":"M\u00e9dico atualizado com sucesso.","doctor_use":"M\u00e9dico usado com sucesso.","email_notification":"Notifica\u00e7\u00e3o por e-mail atualizada com sucesso.","email_send":"E-mail enviado com sucesso.","enquire_deleted":"Consulta exclu\u00edda com sucesso.","enquire_sent":"Pedido Enviado com Sucesso","faq_creat":"Perguntas frequentes criadas com sucesso.","faq_delete":"Perguntas frequentes exclu\u00eddas com sucesso.","faq_update":"Perguntas frequentes atualizadas com sucesso.","faq_use":"Esta FAQ usada em outro lugar.","favicon_validation_message":"O favicon deve ser um arquivo do tipo: jpg, jpeg, png.","feature_update":"Recurso atualizado com sucesso.","google_calendar_connect":"Seu Google Agenda agora est\u00e1 conectado.","google_calendar_disconnect":"Google Agenda desconectado com sucesso.","google_calendar_update":"Seu Google Agenda foi atualizado com sucesso.","holiday_already_is_exist":"J\u00e1 existe feriado para esta data","icon_validation_message":"O \u00edcone deve ser um arquivo do seguinte tipo: jpg, jpeg, png, svg.","language_change":"Idioma alterado com sucesso","language_update":"Idioma atualizado com sucesso.","live_consultation_delete":"Consulta ao vivo exclu\u00edda com sucesso.","live_consultation_retrieved":"Consulta ao vivo recuperada com sucesso.","live_consultation_save":"Consulta ao vivo salva com sucesso.","live_consultation_update":"Consulta ao vivo atualizada com sucesso.","logo_validation_message":"O logotipo do aplicativo deve ser um arquivo do tipo: jpg, jpeg, png.","maximum_char":"M\u00e1ximo de 60 caracteres permitidos.","messages_sent":"Mensagem enviada com sucesso","no_available_slots":"N\u00e3o h\u00e1 slots dispon\u00edveis em determinada data.","note_added":"Nota adicionada com sucesso.","note_delete":"Nota exclu\u00edda com sucesso.","notification_read":"Notifica\u00e7\u00e3o lida com sucesso.","notification_send":"Notifica\u00e7\u00e3o de verifica\u00e7\u00e3o de e-mail enviada com sucesso.","observation_added":"Observa\u00e7\u00e3o adicionada com sucesso.","observation_delete":"Observa\u00e7\u00e3o exclu\u00edda com sucesso.","operation_performed_success":"Opera\u00e7\u00e3o realizada com sucesso","order_create":"Pedido criado com sucesso.","password_update":"Senha atualizada com sucesso.","patient_appointment":"Dados do calend\u00e1rio de consultas do paciente recuperados com sucesso.","patient_create":"Paciente criado com sucesso.","patient_delete":"Paciente exclu\u00eddo com sucesso.","patient_not_found":"Paciente n\u00e3o encontrado.","patient_update":"Paciente atualizado com sucesso.","patient_used":"Paciente usado em outro lugar.","patients_retrieve":"Pacientes recuperados com sucesso.","payment_status_updated":"Status do pagamento atualizado com sucesso.","paystack_token_expired":"O token de paystack expirou. Atualize a p\u00e1gina e tente novamente.","plan_default":"Plano padr\u00e3o alterado com sucesso.","plan_status":"Status do plano atualizado com sucesso","plan_update":"Plano atualizado com sucesso.","prescription_delete":"Prescri\u00e7\u00e3o exclu\u00edda com sucesso.","prescription_retrieved":"Prescri\u00e7\u00e3o recuperada com sucesso.","problem_added":"Problema adicionado com sucesso.","problem_delete":"Problema ao excluir com sucesso.","profile_validation_message":"O perfil deve ser um arquivo do tipo: jpg, jpeg, png.","qualification_create":"Qualifica\u00e7\u00e3o criada com sucesso.","reactive_account":"Reative sua conta do e-mail.","retrieve":"Recuperado com sucesso.","review_add":"Revisar adi\u00e7\u00e3o com sucesso.","review_edit":"Avalia\u00e7\u00e3o editada com sucesso.","review_retrieved":"Revis\u00e3o recuperada com sucesso.","role_create":"Fun\u00e7\u00e3o criada com sucesso.","role_delete":"Fun\u00e7\u00e3o exclu\u00edda com sucesso.","role_update":"Fun\u00e7\u00e3o atualizada com sucesso.","schedule_crete":"Agendamento criado com sucesso.","schedule_delete":"Programa\u00e7\u00e3o exclu\u00edda com sucesso.","schedule_not_found":"Programa\u00e7\u00e3o n\u00e3o encontrada.","schedule_update":"Agendamento atualizado com sucesso.","select_calendar.":"Selecione um calend\u00e1rio.","select_payment":"Por favor, selecione qualquer m\u00e9todo de pagamento","service_cat_create":"Categoria de servi\u00e7o criada com sucesso.","service_cat_delete":"Categoria de servi\u00e7o exclu\u00edda com sucesso.","service_cat_update":"Categoria de servi\u00e7o atualizada com sucesso.","service_cat_use":"Categoria de servi\u00e7o usada em outro lugar.","service_create":"Servi\u00e7o criado com sucesso.","service_delete":"Servi\u00e7o exclu\u00eddo com sucesso.","service_update":"Servi\u00e7o atualizado com sucesso.","service_use":"Servi\u00e7o usado em outro lugar.","session_retrieve":"Sess\u00e3o recuperada com sucesso.","setting_update":"Configura\u00e7\u00f5es atualizadas com sucesso.","slider_update":"Slider atualizado com sucesso","some_doctors":"Alguns m\u00e9dicos agendaram seus dias em dias n\u00e3o verificados, ent\u00e3o voc\u00ea tem certeza de que deseja realizar esta opera\u00e7\u00e3o?","something_went_wrong":"Algo deu errado","specialization_create":"Especializa\u00e7\u00e3o criada com sucesso.","specialization_delete":"Especializa\u00e7\u00e3o exclu\u00edda com sucesso.","specialization_update":"Especializa\u00e7\u00e3o atualizada com sucesso.","specialization_use":"Especializa\u00e7\u00e3o usada com sucesso.","staff_create":"Funcion\u00e1rio criado com sucesso.","staff_delete":"Equipe exclu\u00edda com sucesso.","staff_update":"Equipe atualizada com sucesso.","staff_use":"Pessoal usado com sucesso.","state_create":"Estado criado com sucesso.","state_delete":"Estado atualizado com sucesso.","state_update":"Estado exclu\u00eddo com sucesso.","state_use":"Estado usado em outro lugar.","states_retrieve":"Estados recuperados com sucesso.","status_change":"Status alterado com sucesso.","status_update":"Status atualizado com sucesso.","subscriber_creat":"Assinante criado com sucesso.","subscriber_delete":"Assinante exclu\u00eddo com sucesso.","testimonial_creat":"Depoimento do Paciente Frontal criado com sucesso.","testimonial_delete":"Depoimento do paciente frontal exclu\u00eddo com sucesso.","testimonial_update":"Atualiza\u00e7\u00e3o do depoimento do paciente frontal com sucesso.","testimonial_use":"Depoimento do paciente frontal usado com sucesso.","theme_change":"Tema alterado com sucesso.","there_were":"Houve algum problema com o pagamento. Por favor, tente novamente mais tarde.","university_required":"A universidade \u00e9 necess\u00e1ria.","update_blog":"Blog do VCard atualizado com sucesso.","update_front_testimonial":"Depoimento atualizado com sucesso.","user_8_or":"Use 6 ou mais caracteres com uma mistura de letras, n\u00fameros e s\u00edmbolos.","user_already_verified":"O usu\u00e1rio j\u00e1 possui um e-mail verificado.","user_profile":"Perfil de usu\u00e1rio atualizado com sucesso.","user_profile_update":"Perfil de usu\u00e1rio atualizado com sucesso.","user_role_not_delete":"Esta fun\u00e7\u00e3o de usu\u00e1rio n\u00e3o p\u00f4de ser exclu\u00edda porque est\u00e1 atribu\u00edda a um usu\u00e1rio.","user_status":"Status do usu\u00e1rio atualizado com sucesso","user_update":"Usu\u00e1rio atualizado com sucesso.","user_zoom_credential_saved":"Credencial de zoom do usu\u00e1rio salva com sucesso.\n        Amplia\u00e7\u00e3o","valid_instagram":"Por favor, insira um URL v\u00e1lido do Instagram","valid_linkedin":"Por favor, insira um URL v\u00e1lido do Linkedin","valid_twitter":"Por favor, insira um URL v\u00e1lido do Twitter","verified_email":"E-mail verificado com sucesso.","visit_create":"Visita criada com sucesso.","visit_delete":"Visite excluir com sucesso.","visit_prescription_added":"Prescri\u00e7\u00e3o de visita adicionada com sucesso.","visit_prescription_update":"Prescri\u00e7\u00e3o da visita atualizada com sucesso.","visit_update":"Visita atualizada com sucesso.","year_required":"O ano \u00e9 obrigat\u00f3rio.","your_reg_success":"Seu registro foi realizado com sucesso. Por favor, verifique sua conta pelo e-mail."},"front_cms":"Front CMS","front_medical_service":{"add_front_medical_service":"Adicionar servi\u00e7o m\u00e9dico frontal","edit_front_medical_service":"Editar Front Medical Service","short_description":"Descri\u00e7\u00e3o curta","title":"T\u00edtulo"},"front_medical_services":"Front Medical Services","front_patient_testimonial":{"add_front_patient_testimonial":"Adicionar depoimento do paciente frontal","designation":"Designa\u00e7\u00e3o","edit_front_patient_testimonial":"Editar depoimento do paciente frontal","more_patient_feedbacks":"Mais coment\u00e1rios do paciente ...","name":"Nome","patient_testimonials":"Testemunhos de pacientes","profile":"Perfil","short_description":"Descri\u00e7\u00e3o curta"},"front_patient_testimonials":"Testemunhos do paciente frontal","front_service":{"add_front_service":"Adicionar servi\u00e7o frontal","edit_front_service":"Editar servi\u00e7o frontal","icon":"\u00cdcone","short_description":"Descri\u00e7\u00e3o curta","title":"T\u00edtulo"},"front_services":"Front Services","holder_name_invalid":"O nome do titular do cart\u00e3o \u00e9 inv\u00e1lido.","holder_name_required":"Os campos do nome do titular do cart\u00e3o s\u00e3o obrigat\u00f3rios.","holder_number_invalid":"Os campos do n\u00famero do cart\u00e3o s\u00e3o obrigat\u00f3rios.","holiday":{"add_holiday":"Adicionar feriado","doctor_holiday":"F\u00e9rias do m\u00e9dico","holiday":"Feriado","holiday_date":"Data do feriado","service_category":"Categoria de servi\u00e7o"},"icon_size":"Icon size should be less than 2 MBO tamanho do \u00edcone deve ser inferior a 2 MB","id":"EU IA","image_file_type":"A imagem deve ser um arquivo do tipo: jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invalid_range":"Intervalo inv\u00e1lido","live_consultation":{"add_credential":"Adicionar credencial","add_live_consultation":"Adicionar consulta ao vivo","awaited":"Aguardada","client_video":"V\u00eddeo do cliente","consultation_date":"Data da Consulta","consultation_duration_minutes":"Atas de Dura\u00e7\u00e3o da Consulta","consultation_minutes":"Atas de Consulta","consultation_title":"T\u00edtulo da consulta","created_by":"Criado por","created_for":"Criado para","description":"Descri\u00e7\u00e3o","disabled":"Desativado","duration":"Dura\u00e7\u00e3o (em minutos)","edit_live_consultation":"Editar consulta ao vivo","edit_live_meeting":"Editar reuni\u00e3o ao vivo","enable":"Habilitar","finished":"Finalizada","host_video":"Hospede de v\u00eddeo","join_now":"Entrar","live_consultation_details":"Detalhes da consulta ao vivo","new_live_consultation":"Nova consulta ao vivo","new_live_meeting":"Nova reuni\u00e3o ao vivo","select_consultation_date":"Selecione a data da consulta","select_doctor_name":"Selecione o nome do m\u00e9dico","select_patient_name":"Selecione o nome do paciente","staff_list":"Lista de trabalhadores","start_now":"Comece agora","type":"Modelo","type_number":"N\u00famero do tipo","zoom_api_key":"Chave da API de zoom","zoom_api_secret":"Segredo da API de zoom"},"live_consultations":"Consultas ao vivo","live_status_retrieved_successfully.":"Status ativo recuperado com sucesso.","login":"Login","medicine":{"available_quantity":"Quantidade dispon\u00edvel","brand":"Marca","brand_name":"Marca","buying_price":"Pre\u00e7o de compra","cant_be_deleted":"n\u00e3o pode ser exclu\u00eddo","category":"Categoria","category_id":"Categoria ID","category_retrieved_successfully":"Categoria de medicamento recuperada com sucesso.","deleted_successfully":"Apagado com sucesso","description":"Descri\u00e7\u00e3o","dosage":"Dosagem","dose_interval":"Selecione o intervalo de dose","duration":"Dura\u00e7\u00e3o","edit_medicine":"Editar rem\u00e9dio","edit_medicine_brand":"Editar marca de medicamento","edit_medicine_category":"Editar categoria de medicamento","filter_options":"Op\u00e7\u00f5es de filtro","medicine":"Medicamento","medicine_brands":"Marcas de medicamentos","medicine_brands_details":"Detalhes da Marca do Medicamento","medicine_category":"Categoria de medicamento","medicine_category_details":"Detalhes da Categoria do Medicamento","medicine_details":"Detalhes do medicamento","medicine_name":"Nome do medicamento","medicine_retrieved_successfully":"Medicamento recuperado com sucesso","medicines":"Medica\u00e7\u00e3o","name":"Nome","new_brand":"Nova marca","new_medicine":"Novo medicamento","new_medicine_brand":"Nova marca de medicamento","new_medicine_category":"Nova categoria de medicamento","no_use":"Fora de uso","quantity":"Quantidade","salt_composition":"Composi\u00e7\u00e3o do Sal","saved_successfully":"Salvo com sucesso","select_duration":"Selecione Dura\u00e7\u00e3o","selling_price":"Pre\u00e7o de venda","side_effects":"Efeitos colaterais","status_updated_successfully":"Estado atualizado com sucesso.","updated_successfully":"Atualizado com sucesso"},"medicine_bills":{"add_medicine_bill":"Adicionar Conta de Medicamentos","available_quantity":"A quantidade dispon\u00edvel de","avl_qty":"Quantidade Avl","bill_date":"Data da conta","bill_id":"Id da conta","bill_number":"N\u00famero da conta","cell_no":"N\u00famero da c\u00e9lula","dose_interval":"intervalo de dose","duplicate_medicine":"N\u00e3o \u00e9 poss\u00edvel adicionar medicamentos duplicados.","edit_medicine_bill":"Editar Conta de Medicamentos","enter_lot_number":"Insira o n\u00famero do lote..","enter_puchase_price":"Insira o pre\u00e7o de compra","enter_sale_price":"Insira o pre\u00e7o de venda..","is":"\u00e9","item_name":"Nome do item","medicine_bill":"Conta de Medicamentos","medicine_bill_details":"Detalhes da Conta de Medicamentos","medicine_bills":"Contas de Medicamentos","medicine_not_selected":"Selecione pelo menos um medicamento.","medicine_required":"A \u00e1rea de medicina \u00e9 obrigat\u00f3ria.","net_amount_cant":"O valor l\u00edquido n\u00e3o pode estar vazio.","net_amount_cant_zero":"O valor l\u00edquido n\u00e3o pode ser zero.","net_amount_not_empty":"O valor l\u00edquido n\u00e3o pode ficar vazio.","net_amount_not_zero":"O valor l\u00edquido n\u00e3o pode ser zero.","new_medicine_bill":"Nova Lei de Medicamentos","payment_status":"Status do pagamento","payment_type":"Tipo de pagamento","prescription_not_found":"Receita n\u00e3o encontrada","price":"Pre\u00e7o","print_bill":"Imprimir Fatura","quantity_should":"A quantidade deve ser maior que 0.","sale_price":"Pre\u00e7o de venda","select_medicine":"Selecione Medicamento","select_patient":"Selecionar paciente","select_payment_type":"Selecione o tipo de pagamento","tax_amt":"O valor do imposto n\u00e3o pode ser zero ou vazio..","tax_cannot_be_zero_empty":"Insira o n\u00famero do lote.","tax_should_be":"Os impostos devem ser inferiores a 100%.","the_discount_shoul":"O desconto deve ser menor que o valor total","the_medicine_already_in_use":"Este medicamento j\u00e1 \u00e9 utilizado nas faturas de medicamentos. Tem certeza de que deseja exclu\u00ed-lo?","update_quantity":"A quantidade atualizada deve ser menor que a quantidade anterior."},"medicine_brands":"Marcas de medicamentos","medicine_categories":"Categorias de medicamentos","medicines":"Medica\u00e7\u00e3o","mobile_no":"Celular n\u00e3o","months":{"apr":"abril","aug":"agosto","dec":"dezembro","feb":"fevereiro","jan":"janeiro","jul":"julho","jun":"junho","mar":"mar\u00e7o","may":"Poderia","nov":"novembro","oct":"Outubro","sep":"setembro"},"no_response":"Nenhuma resposta foi retornada","not_supported":"n\u00e3o suportado","note":"Observa\u00e7\u00e3o: voc\u00ea precisa definir seu fuso hor\u00e1rio antes de integrar o Google Agenda.","notification":{"mark_all_as_read":"Marcar tudo como lido","notification":"Notifica\u00e7\u00f5es","you_don`t_have_any_new_notification":"Voc\u00ea n\u00e3o tem nenhuma nova notifica\u00e7\u00e3o"},"patient":{"add":"Adicionar paciente","address1":"Endere\u00e7o 1","address2":"Endere\u00e7o 2","address_information":"Informa\u00e7\u00f5es de endere\u00e7o","blood_group":"Grupo Sangu\u00edneo","city":"Cidade","confirm_password":"Confirmar senha","contact_no":"Contato n\u00e3o","country":"Pa\u00eds","details":"Detalhes do paciente","dob":"DOB","edit":"Editar Paciente","email":"Email","emailverified":"email verificado","enter_email":"Digite o e-mail","enter_password":"Digite a senha","female":"Feminino","filter":"filtro","first_name":"Nome","gender":"Sexo","last_name":"Sobrenome","last_updated":"\u00daltima atualiza\u00e7\u00e3o","male":"Masculino","name":"Nome","password":"Senha","patient_unique_id":"ID \u00danica do Paciente","postal_code":"C\u00f3digo Postal","profile":"Perfil","registered_on":"Registrado em","save_changes":"Salvar altera\u00e7\u00f5es","state":"Estado","today":"Hoje"},"patient_dashboard":{"completed_appointments":"Compromissos conclu\u00eddos","next_appointment":"Pr\u00f3ximas nomea\u00e7\u00f5es","today_appointments":"Compromissos de hoje","upcoming_appointments":"Pr\u00f3ximas reuni\u00f5es"},"patients":"Pacientes","payment_detail":"Detalhes de pagamento","payment_for_booking_appointment_with_doctor":"Pagamento para marca\u00e7\u00e3o de consulta com m\u00e9dico","payment_method":{"authorize":"Autorizar","paypal":"Paypal","paystack":"Pagamento","paytm":"Paytm","razorpay":"Razorpay","stripe":"Listra"},"paytm":"Pagamento","prescription":{"Rx":"Rx","accident":"Acidente","advice":"adendo","after meal":"depois da refei\u00e7\u00e3o","appointment_slot":"Hor\u00e1rios dispon\u00edveis","available_quantity_of":"A quantidade dispon\u00edvel de ","before meal":"antes da refei\u00e7\u00e3o","breast_feeding":"Amamenta\u00e7\u00e3o","comment":"Comente","connect_with_zoom":" Conecte-se com Amplia\u00e7\u00e3o","current_medication":"Medica\u00e7\u00e3o atual","days":"dias","diabetic":"Diab\u00e9tica","doctor":"M\u00e9dico","dosage":"Dosagem","duration":"Dura\u00e7\u00e3o","edit_prescription":"Editar Prescri\u00e7\u00e3o","female_pregnancy":"Gravidez Feminina","food_allergies":"Alergias a comida","frequency":"Freq\u00fc\u00eancia","health_insurance":"Plano de sa\u00fade","heart_disease":"Doen\u00e7a card\u00edaca","high_blood_pressure":"Press\u00e3o alta","is":"\u00e9","low_income":"Baixa renda","medical_history":"Hist\u00f3rico m\u00e9dico","medicine_name":"nome_medicina","name":"Nome","new_medicine":"novo medicamento","new_prescription":"Nova prescri\u00e7\u00e3o","next_visit":"pr\u00f3xima visita","not_add_duplicate_medicines":"N\u00e3o \u00e9 poss\u00edvel adicionar medicamentos duplicados.","ok":"OK","others":"Outras","patient":"Paciente","physical_information":"informa\u00e7\u00e3o f\u00edsica","plus_rate":"pulso taxa","prescription":"Prescri\u00e7\u00e3o","prescription_details":"Detalhes da prescri\u00e7\u00e3o","prescription_saved":"Prescri\u00e7\u00e3o salva com sucesso.","prescription_updated":"Prescri\u00e7\u00e3o atualizada com sucesso.","prescriptions":"Prescri\u00e7\u00f5es","problem":"problema","problem_description":"Descri\u00e7\u00e3o do Problema","reference":"Refer\u00eancia","selectMedicine":"Selecione o medicamento","surgery":"Cirurgia","temperature":"temperatura","tendency_bleed":"Sangramento por tend\u00eancia","test":"teste","time":"Tempo","total_quantity":"Quantidade total"},"privacy_policy":"Pol\u00edtica de privacidade","purchase_medicine":{"actions":"A\u00e7\u00f5es","amount":"Quantia","discount":"Desconto","dose_duration":"Dura\u00e7\u00e3o da Dose","expiry_date":"Data de validade","export_to_excel":"Exportar para Excel","lot_no":"N\u00e3o muito.","net_amount":"Valor l\u00edquido","note":"Observa\u00e7\u00e3o","other_details":"Outros detalhes","payment_mode":"Modo de pagamento","payment_note":"Nota de pagamento","purchase_medicine":"Comprar rem\u00e9dio","purchase_medicine_details":"Comprar Detalhes do Medicamento","purchase_medicine_overview":"Vis\u00e3o Geral da Compra de Medicamentos","purchase_medicines":"comprar medicamentos","purchase_number":"N\u00famero de Compra","purchased_medicine_success":"Medicamento comprado com sucesso","quantity":"Quantidade","tax":"Imposto","tax_amount":"Valor do imposto","total":"Total"},"range_constructor_requires_trie_parameter":"O construtor Range requer um par\u00e2metro Trie","register":"Registrar","requires_string_parameter":"rangeWithString requer um par\u00e2metro de string","resend_email_verification":"Reenviar verifica\u00e7\u00e3o de e-mail","review":{"add_review":"Adicione uma avalia\u00e7\u00e3o","edit_review":"Editar avalia\u00e7\u00e3o","no_doctors_available_to_give_rating":"Nenhum m\u00e9dico dispon\u00edvel para dar classifica\u00e7\u00e3o.","review":"An\u00e1lise","write_a_review":"Escreva uma cr\u00edtica"},"reviews":"avalia\u00e7\u00f5es","role":{"add_role":"Adicionar fun\u00e7\u00e3o","edit_role":"Editar fun\u00e7\u00e3o","permissions":"Permiss\u00f5es","role":"Fun\u00e7\u00e3o","role_permissions":"Permiss\u00f5es de fun\u00e7\u00e3o","select_all_permissions":"Selecionar todas as permiss\u00f5es"},"roles":"Fun\u00e7\u00f5es","service":{"add_service":"Adicionar servi\u00e7o","category":"Categoria","charges":"Cobran\u00e7as","edit_service":"Editar servi\u00e7o","short_description":"Descri\u00e7\u00e3o curta"},"service_categories":"Categorias de servi\u00e7o","service_category":{"add_category":"Adicionar categoria de servi\u00e7o","edit_category":"Editar categoria de servi\u00e7o","service_category":"Categoria de servi\u00e7o"},"services":"Servi\u00e7os","setting":{"address":"Endere\u00e7o","change_app_logo":"Alterar logotipo do aplicativo","change_favicon":"Alterar favicon","clinic_name":"Nome da cl\u00ednica","connect_google_calendar":"Conecte o Google Agenda","connect_your_google_calendar":"Conecte seu Google Agenda","contact_information":"Informa\u00e7\u00f5es de contato","currency":"Moeda","currency_settings":"Configura\u00e7\u00f5es de moeda","default_country_code":"C\u00f3digo de pa\u00eds padr\u00e3o","default_language_suggest":"Ao atualizar isso, todo o idioma do aplicativo mudar\u00e1 nos logins do m\u00e9dico, do paciente e tamb\u00e9m na parte frontal.","disconnect_your_google_calendar":"Desconecte seu Google Agenda","do_not_allow_to_login_without_email_verification":"N\u00e3o permitir o login sem verifica\u00e7\u00e3o de e-mail","favicon":"Favicon","general":"Geral","general_details":"Detalhes Gerais","logo":"Logo","postal_code":"C\u00f3digo Postal","prefix":"Prefixo","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"Selecione seus calend\u00e1rios (do Google Agenda) nos quais deseja criar os compromissos","setting":"Configura\u00e7\u00e3o","specialities":"Especialidades","sync_your_google_calendar":"Sincronize seu Google Agenda","when_checkbox_disable":"Quando a caixa de sele\u00e7\u00e3o est\u00e1 desativada, a verifica\u00e7\u00e3o de e-mail n\u00e3o funciona para novos usu\u00e1rios.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Quando o paciente marcar uma consulta com voc\u00ea, um novo compromisso ser\u00e1 criado nos calend\u00e1rios selecionados","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Quando voc\u00ea marca um compromisso, um novo compromisso \u00e9 criado nos calend\u00e1rios selecionados"},"settings":"Configura\u00e7\u00f5es","slider":{"add_slider":"Adicionar controle deslizante","edit_slider":"Editar controle deslizante","image":"Imagem","short_description":"Descri\u00e7\u00e3o curta","title":"T\u00edtulo"},"sliders":"Sliders","smart_patient_card":{"add_smart_card":"Adicionar Cart\u00e3o Inteligente","add_smart_card_templates":"Adicionar Modelos de Cart\u00e3o Inteligente","address_show":"Mostrar Endere\u00e7o","blood_group_show":"Mostrar Grupo Sangu\u00edneo","dob_show":"Mostrar Data de Nascimento","edit_patient_card":"Editar Cart\u00e3o Inteligente","email_show":"Mostrar Email","enter_template_name":"Inserir Nome do Modelo","for_all_patient":"Para Todos os Pacientes","generate_patient_card":"Gerar Cart\u00e3o de Paciente","generate_patient_smart_cards":"Gerar Cart\u00f5es de Pacientes Inteligentes","header_color":"Cor do Cabe\u00e7alho","only_one_patient":"Apenas Um Paciente","patient":"Paciente","patient_smart_card_created":"Cart\u00e3o inteligente do paciente criado com sucesso.","patient_smart_card_deleted":"Cart\u00e3o inteligente do paciente exclu\u00eddo com sucesso.","phone_show":"Mostrar Telefone","please_selest_patient":"Selecione o paciente","remaning_patients":"Pacientes Restantes","select_patient":"Selecionar Paciente","select_template":"Selecionar Modelo","smart_patient_card_templates":"Modelos de Cart\u00e3o de Paciente Inteligente","smart_patient_cards":"Cart\u00f5es de Pacientes Inteligentes","templat_name":"Nome do Modelo","template":"Modelo","template_created":"Modelo criado com sucesso.","template_deleted":"Modelo exclu\u00eddo com sucesso.","template_update":"Atualiza\u00e7\u00e3o do modelo bem-sucedida.","type":"Tipo","unique_id_show":"Mostrar Identifica\u00e7\u00e3o \u00danica"},"specialization":{"add_specialization":"Adicionar especializa\u00e7\u00e3o","edit_specialization":"Editar especializa\u00e7\u00e3o","retrieved_successfully":"Especializa\u00e7\u00e3o recuperada com sucesso."},"specializations":"Especializa\u00e7\u00f5es","staff":{"add_staff":"Adicionar equipe","confirm_password":"Confirmar senha","contact_no":"Contato n\u00e3o","edit_staff":"Editar equipe","email":"Email","female":"Feminino","first_name":"Nome","gender":"Sexo","last_name":"Sobrenome","male":"Masculino","password":"Senha","role":"Fun\u00e7\u00e3o","select_role":"Selecionar fun\u00e7\u00e3o","staff":"equipe","staff_details":"Detalhes da equipe"},"staffs":"Staffs","start_time_invalid":"o hor\u00e1rio de in\u00edcio do dia \u00e9 inv\u00e1lido","state":{"add_state":"Adicionar estado","country":"Pa\u00eds","edit_state":"Editar estado","state":"Estado","states":"estados"},"states":"Estados","subscribers":"Assinantes","terms_conditions":"Termos e Condi\u00e7\u00f5es","too_long":"Demasiado largo","too_short":"Demasiado corto","transaction":{"paid":"Pago","payment_accepted_by":"Pagamento aceito por","payment_status":"Status do pagamento","pending":"Pendente","transaction_detail":"Detalhe da transa\u00e7\u00e3o","transaction_id":"ID da transa\u00e7\u00e3o"},"transactions":"transa\u00e7\u00f5es","used_medicine":{"used_at":"Usado em","used_medicine":"Rem\u00e9dio Usado","used_medicines":"Medicamentos Usados","used_quantity":"Quantidade usada"},"user":{"account":"Conta","account_setting":"Configura\u00e7\u00f5es da conta","avatar":"Avatar","change_language":"Mudar idioma","change_password":"Alterar senha","confirm_password":"Confirmar senha","contact_number":"N\u00famero de contato","current_password":"Senha atual","edit_profile":"Editar Perfil","email":"Email","email_notification":"Notifica\u00e7\u00e3o de Email","full_name":"Nome Completo","gender":"Sexo","language":"Idioma","new_password":"Nova senha","profile_details":"Detalhes do perfil","return_to_admin":"Retornar ao Admin","save_changes":"Salvar altera\u00e7\u00f5es","select_time_zone":"Selecionar fuso hor\u00e1rio","setting":"Configura\u00e7\u00e3o","sign_out":"Sair","staff_details":"Detalhes da equipe","time_zone":"Fuso hor\u00e1rio"},"users":"Usu\u00e1rios","valid_expiration_date":"Insira uma data de validade v\u00e1lida.","valid_number":"N\u00famero v\u00e1lido","visit":{"add_visit":"Adicionar visita","description":"Descri\u00e7\u00e3o","doctor":"Doutor","edit_visit":"Editar visita","enter_note":"Digite a nota","enter_observation":"Digite a observa\u00e7\u00e3o","enter_problem":"Digite o problema","notes":"Notas","observations":"Observa\u00e7\u00f5es","patient":"Paciente","prescriptions":"Prescri\u00e7\u00f5es","problems":"Problemas","title":"T\u00edtulo","visit_date":"Data da Visita","visit_detail":"Detalhe da visita","visit_details":"Detalhes da visita"},"visits":"Visitas","web":{"Meet_best_doctors":"Conhe\u00e7a os melhores m\u00e9dicos","about_experience":"Sobre a experi\u00eancia","about_short_description":"Sobre a breve descri\u00e7\u00e3o","about_title":"Sobre o T\u00edtulo","about_us":"Sobre n\u00f3s","all_rights_reserved":"Todos os direitos reservados","all_services":"Todos os servi\u00e7os","already_have_an_account":"J\u00e1 tenho uma conta","already_have_patient_account":"J\u00e1 tenho conta de paciente","appointment":"Compromisso","appointment_now":"Compromisso Agora","best_professionals":"Melhores Profissionais","book_an_appointment":"Agendar um compromisso","book_appointment":"Anota\u00e7\u00e3o de livro","call_us":"Ligue para n\u00f3s","closed":"Fechado","confirm_booking":"Confirmar reserva","contact":"Contato","contact_us":"contato","contact_us_for_any_information":"Contate-nos para qualquer informa\u00e7\u00e3o","create_an_account":"Criar uma conta","created_at":"Criado em","doctors":"M\u00e9dicos","doctors_can_interact___":"Os m\u00e9dicos podem interagir com os pacientes e fazer o tratamento relacionado.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Formule resultados sem erros de forma din\u00e2mica antes dos resultados integrados. Incube drasticamente os recursos integrados sem custo-benef\u00edcio fora do.","email":"Email","email_address":"Endere\u00e7o de e-mail","emergency_help":"Ajuda de Emerg\u00eancia","enquiry":"Investiga\u00e7\u00e3o","enquiry_details":"Detalhes do inqu\u00e9rito","enter_your_email":"Digite seu e-mail","enter_your_email_to_subscribe_to_our_newsletter":"Digite seu e-mail para assinar nosso boletim informativo","faqs":"FAQs","forgot_password":"Esqueci minha senha","home":"Casa","how_we_works":"Como trabalhamos","i_agree":"Eu concordo","location":"localiza\u00e7\u00e3o","login":"Login","make_appointment":"Marcar consulta","medical":"M\u00e9dico","medical_about_us":"M\u00e9dico sobre n\u00f3s","medical_appointment":"Consulta M\u00e9dica","medical_contact":"Contato M\u00e9dico","medical_doctors":"M\u00e9dicos","medical_services":"Servi\u00e7os m\u00e9dicos","medical_treatment":"Tratamento m\u00e9dico","meet_our_team_of_specialists":"Conhe\u00e7a nossa equipe de especialistas","message":"Mensagem","name":"Nome","new_here":"Novo aqui","no_services_available":"Nenhum servi\u00e7o dispon\u00edvel","opening_hours":"Hor\u00e1rio de Funcionamento","our_doctor":"Nosso Doutor","our_team":"Nosso time","patient_can_book_an_appointment___":"O paciente pode marcar uma consulta com o m\u00e9dico na p\u00e1gina de destino ou no painel de login.","patient_can_do_registration___":"O paciente pode fazer o registro a partir daqui com informa\u00e7\u00f5es b\u00e1sicas.","patient_name":"Nome do paciente","patient_registration":"Registro do Paciente","phone":"Telefone","qualified_doctors":"M\u00e9dicos Qualificados","questions_before_booking":"Perguntas antes da reserva","quick_links":"Links R\u00e1pidos","reason":"Raz\u00e3o","registration":"Cadastro","remember_me":"Lembre-se de mim","satisfied_patient":"Paciente Satisfeito","saying_about_us":"Dizendo sobre n\u00f3s","see_what_are_the_patients":"Veja quais s\u00e3o os pacientes","send_an_email":"Enviar um e-mail","send_message":"Enviar mensagem","send_us_an_email":"Envie-nos um e-mail","services":"Servi\u00e7os","sign_in":"Entrar","sign_in_here":"Fa\u00e7a login aqui","sign_up":"Inscrever-se","status":"Status","subject":"Assunto","subscribe":"Inscrever-se","take_treatment":"Fa\u00e7a tratamento","terms_and_conditions":"Termos e condi\u00e7\u00f5es","testimonial":"Testemunho","timings":"Timings","total_doctors":"Total de m\u00e9dicos","total_registered_patient":"Total de pacientes registrados","total_services":"Servi\u00e7os totais","total_specializations":"Total de especializa\u00e7\u00f5es","view_more":"Veja mais","we_cover_a_big___":"Cobrimos uma grande variedade de servi\u00e7os m\u00e9dicos","we_make_sure_that_your_life_are_in_good_hands":"N\u00f3s garantimos que sua vida esteja em boas m\u00e3os","we_provide_the_special_tips___":"N\u00f3s fornecemos dicas e conselhos especiais sobre tratamento de sa\u00fade e alto n\u00edvel dos melhores.","working_process":"Processo de trabalho","year_experience":"Experi\u00eancia de Ano"},"weekdays":{"fri":"SEX","mon":"SEG","sat":"Sentado","sun":"SOL","thu":"QUI","tue":"TER","wed":"QUA"}},"pt.pagination":{"next":"Pr\u00f3ximo","previous":"Anterior"},"pt.passwords":{"reset":"Sua senha foi redefinida!","sent":"Enviamos seu link de redefini\u00e7\u00e3o de senha por e-mail!","throttled":"Aguarde antes de tentar novamente.","token":"Este token de redefini\u00e7\u00e3o de senha \u00e9 inv\u00e1lido.","user":"N\u00e3o conseguimos encontrar um usu\u00e1rio com esse endere\u00e7o de e-mail."},"pt.validation":{"accepted":"O: attribute deve ser aceito.","active_url":"O atributo: n\u00e3o \u00e9 um URL v\u00e1lido.","after":"O: attribute deve ser uma data ap\u00f3s: date.","after_or_equal":"O: attribute deve ser uma data posterior ou igual a: date.","alpha":"O: attribute s\u00f3 pode conter letras.","alpha_dash":"O: attribute s\u00f3 pode conter letras, n\u00fameros, travess\u00f5es e sublinhados.","alpha_num":"O: attribute s\u00f3 pode conter letras e n\u00fameros.","array":"O: attribute deve ser uma matriz.","attributes":[],"before":"O: attribute deve ser uma data anterior a: date.","before_or_equal":"O: attribute deve ser uma data anterior ou igual a: date.","between":{"array":"O atributo: deve ter entre: min e: max itens.","file":"O: attribute deve estar entre: min e: max kilobytes.","numeric":"O: attribute deve estar entre: min e: max.","string":"O: attribute deve ter entre: min e: max caracteres."},"boolean":"O campo: attribute deve ser verdadeiro ou falso.","confirmed":"A confirma\u00e7\u00e3o de: attribute n\u00e3o corresponde.","current_password":"A senha est\u00e1 incorreta.","custom":{"attribute-name":{"rule-name":"mensagem personalizada"}},"date":"O atributo: n\u00e3o \u00e9 uma data v\u00e1lida.","date_equals":"O: attribute deve ser uma data igual a: date.","date_format":"O: attribute n\u00e3o corresponde ao formato: format.","different":"O: attribute e: other devem ser diferentes.","digits":"O: attribute deve ser: d\u00edgitos d\u00edgitos.","digits_between":"O: attribute deve ter entre: min e: max d\u00edgitos.","dimensions":"O: attribute tem dimens\u00f5es de imagem inv\u00e1lidas.","distinct":"O campo: attribute tem um valor duplicado.","email":"O: attribute deve ser um endere\u00e7o de e-mail v\u00e1lido.","ends_with":"O: attribute deve terminar com um dos seguintes:: valores.","exists":"O atributo selecionado: \u00e9 inv\u00e1lido.","file":"O atributo: deve ser um arquivo.","filled":"O campo: attribute deve ter um valor.","gt":{"array":"O: attribute deve ter mais de: itens de valor.","file":"O: attribute deve ser maior que: value kilobytes.","numeric":"O: attribute deve ser maior que: value.","string":"O atributo: deve ser maior que: caracteres de valor."},"gte":{"array":"O: attribute deve ter: itens de valor ou mais.","file":"O: attribute deve ser maior ou igual: value kilobytes.","numeric":"O: attribute deve ser maior ou igual: value.","string":"O: attribute deve ser maior ou igual a caracteres de valor."},"image":"O: attribute deve ser uma imagem.","in":"O atributo selecionado: \u00e9 inv\u00e1lido.","in_array":"O campo: attribute n\u00e3o existe em: other.","integer":"O: attribute deve ser um n\u00famero inteiro.","ip":"O: attribute deve ser um endere\u00e7o IP v\u00e1lido.","ipv4":"O: attribute deve ser um endere\u00e7o IPv4 v\u00e1lido.","ipv6":"O atributo: deve ser um endere\u00e7o IPv6 v\u00e1lido.","json":"O: attribute deve ser uma string JSON v\u00e1lida.","lt":{"array":"O: attribute deve ter menos que: itens de valor.","file":"O: attribute deve ser menor que: value kilobytes.","numeric":"O: attribute deve ser menor que: value.","string":"O: attribute deve ter menos que: caracteres de valor."},"lte":{"array":"O: attribute n\u00e3o deve ter mais do que: itens de valor.","file":"O atributo: deve ser menor ou igual a: kilobytes de valor.","numeric":"O: attribute deve ser menor ou igual: value.","string":"O atributo: deve ser menor ou igual a: caracteres de valor."},"max":{"array":"O: attribute n\u00e3o pode ter mais do que: max itens.","file":"O: attribute n\u00e3o pode ser maior que: max kilobytes.","numeric":"O atributo: n\u00e3o pode ser maior que: m\u00e1x.","string":"O: attribute n\u00e3o pode ser maior que: max caracteres."},"mimes":"O: attribute deve ser um arquivo do tipo:: values.","mimetypes":"O atributo: deve ser um arquivo do tipo:: values.","min":{"array":"O: attribute deve ter pelo menos: min itens.","file":"O: attribute deve ter pelo menos: min kilobytes.","numeric":"O: attribute deve ser pelo menos: min.","string":"O: attribute deve ter pelo menos: min caracteres."},"multiple_of":"O: attribute deve ser um m\u00faltiplo de: value.","not_in":"O atributo selecionado: \u00e9 inv\u00e1lido.","not_regex":"O formato do atributo \u00e9 inv\u00e1lido.","numeric":"O atributo: deve ser um n\u00famero.","password":"A senha est\u00e1 incorreta.","present":"O campo: attribute deve estar presente.","prohibited":"O campo: attribute \u00e9 proibido.","prohibited_if":"O campo: attribute \u00e9 proibido quando: other for: value.","prohibited_unless":"O campo: attribute \u00e9 proibido, a menos que: other esteja em: values.","regex":"O formato do atributo \u00e9 inv\u00e1lido.","required":"O campo: attribute \u00e9 obrigat\u00f3rio.","required_if":"O campo: attribute \u00e9 obrigat\u00f3rio quando: other for: value.","required_unless":"O campo: attribute \u00e9 obrigat\u00f3rio, a menos que: other esteja em: values.","required_with":"O campo: attribute \u00e9 obrigat\u00f3rio quando: values estiver presente.","required_with_all":"O campo: attribute \u00e9 obrigat\u00f3rio quando: valores est\u00e3o presentes.","required_without":"O campo: attribute \u00e9 obrigat\u00f3rio quando: values n\u00e3o estiver presente.","required_without_all":"O campo: attribute \u00e9 obrigat\u00f3rio quando nenhum dos valores: est\u00e1 presente.","same":"O: attribute e: other devem corresponder.","size":{"array":"O: attribute deve conter: itens de tamanho.","file":"O: attribute deve ter: size kilobytes.","numeric":"O atributo: deve ser: size.","string":"O: attribute deve ter: caracteres de tamanho."},"starts_with":"O atributo: deve come\u00e7ar com um dos seguintes:: values","string":"O: attribute deve ser uma string.","timezone":"O atributo: deve ser uma zona v\u00e1lida.","unique":"O atributo: j\u00e1 foi utilizado.","uploaded":"O: attribute falhou ao carregar.","url":"O formato do atributo \u00e9 inv\u00e1lido.","uuid":"O: attribute deve ser um UUID v\u00e1lido."},"ru.auth":{"app":{"create":"\u0421\u043e\u0437\u0434\u0430\u0442\u044c","export":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442","lock_account":"\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c","member_since":"\u0427\u043b\u0435\u043d \u0441","messages":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f","online":"\u041e\u043d\u043b\u0430\u0439\u043d","print":"\u041f\u0435\u0447\u0430\u0442\u044c","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","reload":"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c","reset":"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c","search":"\u041f\u043e\u0438\u0441\u043a","settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438"},"confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","emails":{"password":{"reset_link":"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044c, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"}},"failed":"\u042d\u0442\u0438 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043d\u0430\u0448\u0438\u043c \u0437\u0430\u043f\u0438\u0441\u044f\u043c.","forgot_password":{"send_pwd_reset":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f","title":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u0447\u0442\u043e\u0431\u044b \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"},"full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","login":{"forgot_password":"\u042f \u0437\u0430\u0431\u044b\u043b \u043c\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","register_membership":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e","title":"\u0412\u043e\u0439\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0447\u0430\u0442\u044c \u0441\u0435\u0430\u043d\u0441"},"password":"\u041f\u0430\u0440\u043e\u043b\u044c","register":"\u0440\u0435\u0433\u0438\u0441\u0442\u0440","registration":{"have_membership":"\u0423 \u043c\u0435\u043d\u044f \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e","i_agree":"\u042f \u0441\u043e\u0433\u043b\u0430\u0441\u0435\u043d \u0441","terms":"\u0443\u0441\u043b\u043e\u0432\u0438\u044f","title":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0447\u043b\u0435\u043d\u0441\u0442\u0432\u043e"},"remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044f","reset_password":{"reset_pwd_btn":"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c","title":"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c"},"sign_in":"\u0412\u043e\u0439\u0442\u0438","sign_out":"\u0432\u044b\u0445\u043e\u0434","throttle":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u0445\u043e\u0434\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0447\u0435\u0440\u0435\u0437: \u0441\u0435\u043a\u0443\u043d\u0434\u044b \u0441\u0435\u043a\u0443\u043d\u0434\u044b."},"ru.livewire-tables::strings":{"All":"\u0412\u0441\u0435","Applied Filters":"\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u044b","Applied Sorting":"\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043d\u0430\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430","Bulk Actions":"\u041c\u0430\u0441\u0441\u043e\u0432\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f","Clear":"\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c","Columns":"\u0421\u0442\u043e\u043b\u0431\u0446\u044b","Done Reordering":"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430","Filters":"\u0424\u0438\u043b\u044c\u0442\u0440\u044b","No items found. Try to broaden your search.":"\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a.","Remove filter option":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440","Remove sort option":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438","Reorder":"\u041f\u0435\u0440\u0435\u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0438\u0442\u044c","Search":"\u041f\u043e\u0438\u0441\u043a","Select All":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435","Showing":"\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u043e \u0441","Unselect All":"\u0421\u043d\u044f\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435","You are currently selecting all":"\u0412\u044b \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442\u0435 \u0432\u0441\u0435","You are not connected to the internet.":"\u0412\u044b \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u044b \u043a \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443","You have selected":"\u0412\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438","of":"\u0438\u0437","results":"\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432","rows":"\u0440\u044f\u0434\u044b","rows, do you want to select all":"\u0440\u044f\u0434\u044b, \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435","to":"\u043f\u043e"},"ru.messages":{"admin_dashboard":{"dashboard":"\u0429\u0438\u0442\u043e\u043a \u043f\u0440\u0438\u0431\u043e\u0440\u043e\u0432","day":"\u0414\u0435\u043d\u044c","earnings_from_appointments":"\u0414\u043e\u0445\u043e\u0434 \u043e\u0442 \u0432\u0441\u0442\u0440\u0435\u0447","filter_options":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0438\u043b\u044c\u0442\u0440\u0430","month":"\u041c\u0435\u0441\u044f\u0446","name":"\u0418\u043c\u044f","patient_id":"\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 ","recent_patients_registration":"\u041d\u0435\u0434\u0430\u0432\u043d\u044f\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 ","registered":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e ","today_appointments":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\u0448\u043d\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438","today_registered_patients":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u044b","total_doctor":"\u0412\u0441\u0435\u0433\u043e \u0432\u0440\u0430\u0447\u0435\u0439","total_patients":"\u0412\u0441\u0435\u0433\u043e \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","week":"\u041d\u0435\u0434\u0435\u043b\u044f"},"appointment":{"Select_payment_method":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","add_new_appointment":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0443 ","appointment_at":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 ","appointment_date":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430","appointment_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0432\u0441\u0442\u0440\u0435\u0447\u0435 ","appointment_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u0441\u0442\u0440\u0435\u0447\u0438","appointment_unique_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u0441\u0442\u0440\u0435\u0447\u0438 ","appointments":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f","appointments_schedule":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447 ","authorize_session_created_successfully":"\u0421\u0435\u0430\u043d\u0441 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","available":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0439","available_slot":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0441\u043b\u043e\u0442\u044b ","booked":"\u0417\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e ","calendar":"\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c","cancel_appointment":"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0443","cancelled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","charge":"\u041f\u043b\u0430\u0442\u0430","check_in":"\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c\u0441\u044f","check_out":"\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c","date":"\u0414\u0430\u0442\u0430","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","edit_appointment":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0443 ","ends":"\u041a\u043e\u043d\u0446\u044b ","extra_fees":"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0431\u043e\u0440\u044b","no_slot_found":"\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. ","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","patient_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 ","patient_name_retrieved":"\u0421\u0435\u0430\u043d\u0441 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","payable_amount":"\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435 ","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","payment_method":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","payment_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","service":"\u0423\u0441\u043b\u0443\u0433\u0430","service_charge":"\u041f\u043b\u0430\u0442\u0430 \u0437\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435","session_created_successfully":"\u0441\u0435\u0430\u043d\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","session_id_required":"\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0435\u0430\u043d\u0441\u0430","starts":"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f ","status":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","switch_to_calendar":"\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c ","time":"\u0412\u0440\u0435\u043c\u044f","total_payable_amount":"\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435 ","upcoming_meetings":"\u043f\u0440\u0435\u0434\u0441\u0442\u043e\u044f\u0449\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438"},"appointments":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f","apps":"\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b","card_number_invalid..":"\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","card_type":"\u0422\u0438\u043f \u043a\u0440\u0435\u0434\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b","cities":"\u0413\u043e\u0440\u043e\u0434\u0430","city":{"add_city":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434 ","city":"\u0413\u043e\u0440\u043e\u0434","edit_city":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0433\u043e\u0440\u043e\u0434 ","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435"},"clinic_schedules":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043b\u0438\u043d\u0438\u043a ","cms":{"Terms_Conditions_required":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.","about_image":"\u041e\u0431 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438","cms":"CMS ","description_no_white_space":"\u041f\u043e\u043b\u0435 \u00ab\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u00bb \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","experience_required":"\u041f\u043e\u043b\u0435 \u00ab\u041e\u0431 \u043e\u043f\u044b\u0442\u0435 \u0440\u0430\u0431\u043e\u0442\u044b\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","privacy_policy_required.":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u0430.","terms_conditions":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f ","title_no_white_space":"\u041e \u043f\u043e\u043b\u0435 \u00ab\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a\u00bb \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432"},"common":{"Attempt_read_property_access_token_null":"\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u00abaccess_token\u00bb \u043f\u0440\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0438.","Forgot_password_lable":"\u0412\u044b \u0437\u0430\u0431\u044b\u043b\u0438 \u0441\u0432\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c? \u0411\u0435\u0437 \u043f\u0440\u043e\u0431\u043b\u0435\u043c. \u041f\u0440\u043e\u0441\u0442\u043e \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043d\u0430\u043c \u0441\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u0438 \u043c\u044b \u0432\u044b\u0448\u043b\u0435\u043c \u0432\u0430\u043c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043f\u043e\u0437\u0432\u043e\u043b\u0438\u0442 \u0432\u0430\u043c \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439.","action":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435","active":"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439 ","add":"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c","add_credential":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 Zoom","age":"\u0412\u043e\u0437\u0440\u0430\u0441\u0442","any_one_permission":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435.","apply":"\u041f\u043e\u0434\u0430\u0442\u044c \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u0435","appointment_date_required":"\u041f\u043e\u043b\u0435 \u0434\u0430\u0442\u044b \u0432\u0441\u0442\u0440\u0435\u0447\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","are_you_sure_cancel":"\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e","back":"\u041d\u0430\u0437\u0430\u0434","booked":"\u0417\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e","brand_required":"\u041f\u043e\u043b\u0435 \u0431\u0440\u0435\u043d\u0434\u0430 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e..","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","cancelled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","cancelled_appointment":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430!","category_required":"\u041f\u043e\u043b\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","change_image":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","check in":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f","check out":"\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c","city":"\u0413\u043e\u0440\u043e\u0434","confirm":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u0442\u044c","connected_zoom":"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0437\u0443\u043c\u043e\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","contact_number":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","country":"\u0421\u0442\u0440\u0430\u043d\u0430","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","de_active":"\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c ","default_language":"\u042f\u0437\u044b\u043a \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e!","details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438","discard":"\u041e\u0442\u043a\u0430\u0437\u0430\u0442\u044c\u0441\u044f","doctor_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0435 \u0432\u0440\u0430\u0447\u0430.","download":"\u0421\u043a\u0430\u0447\u0430\u0442\u044c","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","email_already_exist":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0443\u0436\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0430.","email_max":"\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0438\u0441\u044c\u043c\u0430 \u2014 255.","email_not_register":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430.","email_regex":"\u041f\u043e\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0438\u043c\u0435\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.","email_required":"\u041f\u043e\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","email_verified":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430","error":"\u043e\u0448\u0438\u0431\u043a\u0430","filter":"\u0424\u0438\u043b\u044c\u0442\u0440","filter_option":"\u0412\u0430\u0440\u0438\u0430\u043d\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u0430 ","first_name_required":"\u041f\u043e\u043b\u0435 \u0438\u043c\u0435\u043d\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","forgot_your_password":"\u0417\u0430\u0431\u044b\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c","from":"\u0418\u0437","google_captcha_required":"\u041f\u043e\u043b\u0435 Google Captcha \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","has_been":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","has_cancel":" \u0431\u044b\u043b\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.","hour":"\u0427\u0430\u0441","impersonate":"\u043e\u043b\u0438\u0446\u0435\u0442\u0432\u043e\u0440\u044f\u0442\u044c","instagram_url":"URL-\u0430\u0434\u0440\u0435\u0441 \u0438\u043d\u0441\u0442\u0430\u0433\u0440\u0430\u043c\u0430","last_name_required":"\u041f\u043e\u043b\u0435 \u0424\u0430\u043c\u0438\u043b\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","linkedin_url":"URL-\u0430\u0434\u0440\u0435\u0441 Linkedin","logout":"\u0412\u044b\u0439\u0442\u0438","maximum_55":"\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 55 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","message_required":"\u041f\u043e\u043b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","minutes":"\u041c\u0438\u043d\u0443\u0442\u044b","n\/a":"N\/A ","name":"\u0418\u043c\u044f","name_already_taken":"\u0418\u043c\u044f \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442\u043e","name_required":"\u041f\u043e\u043b\u0435 \u0438\u043c\u0435\u043d\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","no":"\u041d\u0435\u0442, \u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","no_data_available":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b","no_data_available_in_table":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435","no_records_found":"\u0417\u0430\u043f\u0438\u0441\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. ","not_allow__assess_record":"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u044d\u0442\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435. \u041f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0441\u0442\u0440\u0435\u0447\u0438 \u0432 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0435 \u043c\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u0432\u0430\u0448\u0438\u0445 \u0432\u0440\u0430\u0447\u0435\u0439. \u0415\u0441\u043b\u0438 \u0414\u043e\u043a\u0442\u043e\u0440 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441, \u043e\u043d \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 UTC \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.","note_white_space":"\u041f\u043e\u043b\u0435 \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","observation_white_space":"\u041f\u043e\u043b\u0435 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","of":"\u0438\u0437","overview":"\u041e\u0431\u0437\u043e\u0440 ","payment_type_required":"\u041f\u043e\u043b\u0435 \u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","please_wait":"\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430...","prescription_report":"\u041e\u0442\u0447\u0435\u0442 \u043e \u0440\u0435\u0446\u0435\u043f\u0442\u0430\u0445","problem_white_space":"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","processing":"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430..","purchase_price":"\u0426\u0435\u043d\u0430","read":"\u0427\u0438\u0442\u0430\u0442\u044c","remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044f","resend_verification_email":"\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f","reset":"\u0421\u0431\u0440\u043e\u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a","reset_password":"\u0421\u0431\u0440\u043e\u0441 \u043f\u0430\u0440\u043e\u043b\u044f","results":"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b","save":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c","search":"\u041f\u043e\u0438\u0441\u043a","select_brand":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0431\u0440\u0435\u043d\u0434","select_category":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e","select_city":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u043e\u0440\u043e\u0434","select_country":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443","select_doctor":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u043e\u043a\u0442\u043e\u0440\u0430","select_service":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443","select_state":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","service":"\u0423\u0441\u043b\u0443\u0433\u0430","service_required":"\u041f\u043e\u043b\u0435 \u00ab\u0423\u0441\u043b\u0443\u0433\u0438\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c","showing":"\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","subject_required":"\u041f\u043e\u043b\u0435 \u00ab\u0422\u0435\u043c\u0430\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","submit":"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0430 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u0435","to":"\u043a","twitter_url":"URL-\u0430\u0434\u0440\u0435\u0441 \u0422\u0432\u0438\u0442\u0442\u0435\u0440\u0430","unread":"\u041d\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e","verify_lable1":"\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e! \u041f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u043d\u0430\u0447\u0430\u0442\u044c, \u043d\u0435 \u043c\u043e\u0433\u043b\u0438 \u0431\u044b \u0432\u044b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0441\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u043d\u0430\u0436\u0430\u0432 \u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0443, \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u043c\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0432\u0430\u043c \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435? \u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043f\u0438\u0441\u044c\u043c\u043e, \u043c\u044b \u0441 \u0440\u0430\u0434\u043e\u0441\u0442\u044c\u044e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043c \u0432\u0430\u043c \u0434\u0440\u0443\u0433\u043e\u0435.","verify_lable2":"\u041d\u043e\u0432\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0431\u044b\u043b\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430 \u200b\u200b\u043d\u0430 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u044b \u0443\u043a\u0430\u0437\u0430\u043b\u0438 \u043f\u0440\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438.","view":"\u0412\u0438\u0434","years":"\u0413\u043e\u0434\u044b","yes":"\u0414\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","yes_update":"\u0414\u0430, \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435!","zoom_credentials":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 Zoom."},"countries":"\u0421\u0442\u0440\u0430\u043d\u044b ","country":{"add_country":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0443","country":"\u0421\u0442\u0440\u0430\u043d\u0430","short_code":"\u0421\u043e\u043a\u0440\u0430\u0449\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u0434"},"currencies":"\u0412\u0430\u043b\u044e\u0442\u044b","currency":{"add_currency":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 ","add_currency_code_as_per_three_letter_iso_code":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0442\u0440\u0435\u0445\u0431\u0443\u043a\u0432\u0435\u043d\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c ISO","currency_code":"\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b","currency_icon":"\u0417\u043d\u0430\u0447\u043e\u043a \u0432\u0430\u043b\u044e\u0442\u044b ","currency_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b ","edit_currency":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0430\u043b\u044e\u0442\u0443 ","name":"\u0418\u043c\u044f","you_can_find_out_here":"\u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0437\u043d\u0430\u0442\u044c \u0437\u0434\u0435\u0441\u044c"},"cvv_invalid.":"CVV \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","cvv_number_required.":"\u041f\u043e\u043b\u044f \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c CVV \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b.","dashboard":"\u0429\u0438\u0442\u043e\u043a \u043f\u0440\u0438\u0431\u043e\u0440\u043e\u0432","datepicker":{"last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","last_week":"\u041f\u0440\u043e\u0448\u043b\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","yesterday":"\u0412\u0447\u0435\u0440\u0430\u0448\u043d\u0438\u0439 \u0434\u0435\u043d\u044c"},"doctor":{"add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u043e\u043a\u0442\u043e\u0440\u0430 ","add_qualification":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0432\u0430\u043b\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044e ","address1":"\u0410\u0434\u0440\u0435\u0441 1","address2":"\u0410\u0434\u0440\u0435\u0441 2","address_information":"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0430\u0434\u0440\u0435\u0441\u0435","allowed_img":"\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg. ","city":"\u0413\u043e\u0440\u043e\u0434","collage_university":"\u041a\u041e\u041b\u041b\u0410\u0416 \/ \u0423\u041d\u0418\u0412\u0415\u0420\u0421\u0418\u0422\u0415\u0422","country":"\u0421\u0442\u0440\u0430\u043d\u0430","created_at":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0432","degree":"\u0421\u0442\u0435\u043f\u0435\u043d\u044c","dob":"\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: ","doctor":"\u0414\u043e\u043a\u0442\u043e\u0440","doctor_detail":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0434\u043e\u043a\u0442\u043e\u0440\u0430 ","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043e\u043a\u0442\u043e\u0440\u0430 ","experience":"\u041e\u043f\u044b\u0442 \u0440\u0430\u0431\u043e\u0442\u044b \u0432 \u0433\u043e\u0434\u0443","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","first_name":"\u0418\u043c\u044f","instagram":"\u0418\u043d\u0441\u0442\u0430\u0433\u0440\u0430\u043c","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","linkedin":"\u041b\u0438\u043d\u043a\u0435\u0434\u0438\u043d","male":"\u041c\u0443\u0436\u0447\u0438\u043d\u0430","passout_year":"Passout Year ","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u041a\u043e\u0434","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","qualification":"\u041a\u0432\u0430\u043b\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f","qualification_information":"\u041a\u0432\u0430\u043b\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","select_blood_group":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443 \u043a\u0440\u043e\u0432\u0438","select_date":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443","select_doctors":"\u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0440\u0430\u0447\u0435\u0439","select_gender":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b","select_year":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u043e\u0434","specialization":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f","sr_no":"\u0421\u0420 \u041d\u0415\u0422 ","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","status":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","twitter":"\u0422\u0432\u0438\u0442\u0442\u0435\u0440","university":"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0438\u0442\u0435\u0442","updated_at":"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0432 ","year":"\u0413\u043e\u0434"},"doctor_appointment":{"amount":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","from_time":"\u041e\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","service":"\u0423\u0441\u043b\u0443\u0433\u0430","to_time":"\u041a\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438"},"doctor_appointments":"\u0417\u0430\u043f\u0438\u0441\u044c \u043a \u0432\u0440\u0430\u0447\u0443 ","doctor_dashboard":{"recent_appointments":"\u041d\u0435\u0434\u0430\u0432\u043d\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438 ","total_appointments":"\u0412\u0441\u0435\u0433\u043e \u0432\u0441\u0442\u0440\u0435\u0447 "},"doctor_session":{"add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0430 ","all":"\u0412\u0441\u0435","copy":"\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c","doctor":"\u0414\u043e\u043a\u0442\u043e\u0440 ","doctor_session":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0430 ","doctor_session_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u0432\u0440\u0430\u0447\u0430 ","edit":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0430 ","evening_session":"\u0412\u0435\u0447\u0435\u0440\u043d\u0435\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 ","friday":"\u041f\u044f\u0442\u043d\u0438\u0446\u0430","gap_between_appointment":"\u0420\u0430\u0437\u0440\u044b\u0432 \u043c\u0435\u0436\u0434\u0443 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f\u043c\u0438","monday":"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a","morning_session":"\u0423\u0442\u0440\u0435\u043d\u043d\u0435\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 ","my_schedule":"\u041c\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 ","saturday":"\u0421\u0443\u0431\u0431\u043e\u0442\u0430","select_meeting_time":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0438","select_session_gap":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438","session":"\u0421\u0435\u0441\u0441\u0438\u044f ","session_gap":"\u0413\u0440\u0430\u0444\u0438\u043a \u0440\u0430\u0437\u0440\u044b\u0432\u0430","session_meeting_time":"\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0438 ","session_time_in_minutes":"\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0438 ","sunday":"\u0412\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435","thursday":"\u0427\u0435\u0442\u0432\u0435\u0440\u0433","tuesday":"\u0412\u0442\u043e\u0440\u043d\u0438\u043a","unavailable":"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d","wednesday":"\u0421\u0440\u0435\u0434\u0430","week_days":"\u0411\u0443\u0434\u043d\u0438"},"doctor_sessions":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0435\u0439 ","doctors":"\u0412\u0440\u0430\u0447\u0435\u0439","doctors_scheduled_time_ended_for_today__":"\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0432\u0440\u0430\u0447\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u043e\u0441\u044c \u043d\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0432\u0440\u0430\u0447\u0430 \u0438\u043b\u0438 \u0434\u0430\u0442\u0443","email_password_reset_link":"\u0421\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enquiries":"\u0417\u0430\u043f\u0440\u043e\u0441\u044b ","expiration_month_required":"\u041f\u043e\u043b\u044f \u043c\u0435\u0441\u044f\u0446\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.","expiration_year_required":"\u041f\u043e\u043b\u044f \u0433\u043e\u0434\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.","faq":{"add_faq":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c FAQ ","answer":"\u041e\u0442\u0432\u0435\u0447\u0430\u0442\u044c","edit_faq":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c FAQ ","question":"\u0412\u043e\u043f\u0440\u043e\u0441"},"faqs":"FAQs ","filter":{"active":"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439","all":"\u0412\u0441\u0435","awaited":"\u0416\u0434\u0443","booked":"\u0417\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043e","cancelled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","check in":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f","check out":"\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c","deactive":"\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c","finished":"\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043d\u044b\u0439","paid":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0439","pending":"\u0412 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0438","read":"\u0427\u0438\u0442\u0430\u0442\u044c","unread":"\u041d\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e"},"filter_success":"\u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0441\u043f\u0435\u0445","flash":{"about_image_validation_message":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u00ab\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435\u00bb \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0442\u0438\u043f\u0430: jpg, jpeg, png.","about_us_create":"\u041e \u043d\u0430\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e.","all_notification_read":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b.","appointment_booked":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430","appointment_cancel":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430","appointment_create":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e.","appointment_created_payment_complete":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e, \u043f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d.","appointment_created_payment_not_complete":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e, \u0438 \u043e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430.","appointment_delete":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","appointment_not_found":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e","appointment_retrieve":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f \u0432\u0441\u0442\u0440\u0435\u0447 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.","calender_added":"\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.","cat_retrieve":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","cities_retrieve":"\u0413\u043e\u0440\u043e\u0434\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b","city_create":"\u0413\u043e\u0440\u043e\u0434 \u0441\u043e\u0437\u0434\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","city_delete":"\u0413\u043e\u0440\u043e\u0434 \u0443\u0434\u0430\u043b\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","city_retrieved":"\u0413\u043e\u0440\u043e\u0434 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d.","city_update":"\u0413\u043e\u0440\u043e\u0434 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","city_used":"\u0413\u043e\u0440\u043e\u0434 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","clinic_delete":"ClinicSchedule \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","clinic_save":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u043d\u0438\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e.","cms_update":"\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","country_create":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","country_delete":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","country_update":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","country_used":"\u0421\u0442\u0440\u0430\u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","create_blog":"\u0411\u043b\u043e\u0433 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","create_front_testimonial":"\u041e\u0442\u0437\u044b\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","currency_create":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","currency_delete":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","currency_update":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","currency_used":"\u0412\u0430\u043b\u044e\u0442\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","current_invalid":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","data_retrieve":"\u0414\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.","default_role_not_delete":"\u0420\u043e\u043b\u044c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043d\u0435 \u0443\u0434\u0430\u043b\u044f\u0442\u044c.","degree_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u043f\u043e\u043b\u0435 \u0441\u0442\u0435\u043f\u0435\u043d\u0438.","doctor_appointment":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f \u043f\u0440\u0438\u0435\u043c\u0430 \u0443 \u0432\u0440\u0430\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.","doctor_create":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0441\u043e\u0437\u0434\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","doctor_delete":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","doctor_holiday":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0425\u043e\u043b\u0438\u0434\u0435\u0439 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d","doctor_not_available":"\u0412\u0440\u0430\u0447 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d","doctor_session_not_found":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0421\u0435\u0441\u0441\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.","doctor_update":"\u0414\u043e\u043a\u0442\u043e\u0440 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","doctor_use":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","email_notification":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","email_send":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430.","enquire_deleted":"\u0417\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","enquire_sent":"\u0417\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d","faq_creat":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u044b.","faq_delete":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u044b.","faq_update":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b.","faq_use":"\u042d\u0442\u043e\u0442 FAQ \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","favicon_validation_message":"\u0424\u0430\u0432\u0438\u043a\u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpg, jpeg, png.","feature_update":"\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","google_calendar_connect":"\u0412\u0430\u0448 \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google \u0442\u0435\u043f\u0435\u0440\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.","google_calendar_disconnect":"\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.","google_calendar_update":"\u0412\u0430\u0448 \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","holiday_already_is_exist":"\u041f\u0440\u0430\u0437\u0434\u043d\u0438\u043a \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430 \u044d\u0442\u0443 \u0434\u0430\u0442\u0443","icon_validation_message":"\u0418\u043a\u043e\u043d\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0442\u0438\u043f\u0430: jpg, jpeg, png, svg.","language_change":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d","language_update":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","live_consultation_delete":"\u041f\u0440\u044f\u043c\u0430\u044f \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","live_consultation_retrieved":"\u041a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044f \u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.","live_consultation_save":"\u041f\u0440\u044f\u043c\u0430\u044f \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430.","live_consultation_update":"\u041f\u0440\u044f\u043c\u0430\u044f \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","logo_validation_message":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpg, jpeg, png.","maximum_char":"\u0414\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 60 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","messages_sent":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e","no_available_slots":"\u041d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0441\u043b\u043e\u0442\u043e\u0432.","note_added":"\u0417\u0430\u043c\u0435\u0442\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430.","note_delete":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","notification_read":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e.","notification_send":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043ely.","observation_added":"\u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e.","observation_delete":"\u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","operation_performed_success":"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e","order_create":"\u0417\u0430\u043a\u0430\u0437 \u0441\u043e\u0437\u0434\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","password_update":"\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","patient_appointment":"\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f \u043f\u0440\u0438\u0435\u043c\u0430 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b.","patient_create":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","patient_delete":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","patient_not_found":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.","patient_update":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","patient_used":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u0440\u0443\u0433\u043e\u043c \u043c\u0435\u0441\u0442\u0435.","patients_retrieve":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u044b.","payment_status_updated":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","paystack_token_expired":"\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u043e\u043a\u0435\u043d\u0430 \u0441\u0442\u0435\u043a\u0430 \u0432\u044b\u043f\u043b\u0430\u0442 \u0438\u0441\u0442\u0435\u043a. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443.","plan_default":"\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d.","plan_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","plan_update":"\u041f\u043b\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","prescription_delete":"\u0420\u0435\u0446\u0435\u043f\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","prescription_retrieved":"\u0420\u0435\u0446\u0435\u043f\u0442 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","problem_added":"\u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430.","problem_delete":"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","profile_validation_message":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpg, jpeg, png.","qualification_create":"\u041a\u0432\u0430\u043b\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","reactive_account":"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u044e \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0438\u0437 \u043f\u043e\u0447\u0442\u044b.","retrieve":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e.","review_add":"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430.","review_edit":"\u041e\u0442\u0437\u044b\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","review_retrieved":"\u041e\u0442\u0437\u044b\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d.","role_create":"\u0420\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","role_delete":"\u0420\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","role_update":"\u0420\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","schedule_crete":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e.","schedule_delete":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","schedule_not_found":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.","schedule_update":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","select_calendar.":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c.","select_payment":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u044e\u0431\u043e\u0439 \u0441\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","service_cat_create":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","service_cat_delete":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","service_cat_update":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","service_cat_use":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","service_create":"\u0421\u0435\u0440\u0432\u0438\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","service_delete":"\u0421\u043b\u0443\u0436\u0431\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","service_update":"\u0421\u043b\u0443\u0436\u0431\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","service_use":"\u0421\u0435\u0440\u0432\u0438\u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","session_retrieve":"\u0421\u0435\u0430\u043d\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d.","setting_update":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b.","slider_update":"\u0421\u043b\u0430\u0439\u0434\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","some_doctors":"\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0432\u0440\u0430\u0447\u0438 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0438 \u0441\u0432\u043e\u0438 \u0434\u043d\u0438 \u0432 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0435 \u0434\u043d\u0438, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0432\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u044d\u0442\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e?","something_went_wrong":"\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a","specialization_create":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","specialization_delete":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","specialization_update":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430.","specialization_use":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0430.","staff_create":"\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","staff_delete":"\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","staff_update":"\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","staff_use":"\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d.","state_create":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e.","state_delete":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","state_update":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","state_use":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0433\u0434\u0435-\u0442\u043e \u0435\u0449\u0435.","states_retrieve":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","status_change":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d.","status_update":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","subscriber_creat":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","subscriber_delete":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","testimonial_creat":"\u041e\u0442\u0437\u044b\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","testimonial_delete":"\u041e\u0442\u0437\u044b\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d.","testimonial_update":"\u041e\u0442\u0437\u044b\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","testimonial_use":"\u041e\u0442\u0437\u044b\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d.","theme_change":"\u0422\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430.","there_were":"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u043e\u043f\u043b\u0430\u0442\u043e\u0439. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0436\u0435.","university_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u043d\u0438\u0432\u0435\u0440\u0441\u0438\u0442\u0435\u0442.","update_blog":"\u0411\u043b\u043e\u0433 VCard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","update_front_testimonial":"\u041e\u0442\u0437\u044b\u0432 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_8_or":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 6 \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432, \u0441\u043e\u0447\u0435\u0442\u0430\u044f \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b \u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u044b.","user_already_verified":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0436\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435.","user_profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_profile_update":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_role_not_delete":"\u042d\u0442\u0430 \u0440\u043e\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e.","user_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","user_update":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","user_zoom_credential_saved":"\u0423\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f Zoom \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.","valid_instagram":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Instagram","valid_linkedin":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Linkedin","valid_twitter":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Twitter","verified_email":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430.","visit_create":"\u041f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e.","visit_delete":"\u041f\u043e\u0441\u0435\u0442\u0438\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","visit_prescription_added":"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e.","visit_prescription_update":"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e.","visit_update":"\u0412\u0438\u0437\u0438\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","year_required":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0433\u043e\u0434.","your_reg_success":"\u0412\u0430\u0448\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e. \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u044e \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435."},"front_cms":"Front CMS ","front_medical_service":{"add_front_medical_service":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u0434\u043d\u044e\u044e \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0443\u044e \u0441\u043b\u0443\u0436\u0431\u0443 ","edit_front_medical_service":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0434\u043d\u044e\u044e \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0443\u044e \u0441\u043b\u0443\u0436\u0431\u0443","short_description":"\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"front_medical_services":"Front Medical Services","front_patient_testimonial":{"add_front_patient_testimonial":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u0442\u0437\u044b\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u043f\u0435\u0440\u0435\u0434\u043d\u0435\u0433\u043e \u043f\u043b\u0430\u043d\u0430 ","designation":"\u041e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 ","edit_front_patient_testimonial":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0434\u043d\u044e\u044e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0443 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","more_patient_feedbacks":"\u0411\u043e\u043b\u044c\u0448\u0435 \u043e\u0442\u0437\u044b\u0432\u043e\u0432 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 ... ","name":"\u0418\u043c\u044f","patient_testimonials":"\u041e\u0442\u0437\u044b\u0432\u044b \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 ","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","short_description":"\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"},"front_patient_testimonials":"\u0424\u0440\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u043e\u0442\u0437\u044b\u0432\u044b \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 ","front_service":{"add_front_service":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c Front Service ","edit_front_service":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u0434\u043d\u044e\u044e \u0441\u043b\u0443\u0436\u0431\u0443 ","icon":"\u0417\u043d\u0430\u0447\u043e\u043a","short_description":"\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"front_services":"\u0424\u0430\u0441\u0430\u0434\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438","holder_name_invalid":"\u0418\u043c\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0440\u0442\u044b \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e.","holder_name_required":"\u041f\u043e\u043b\u044f \u0438\u043c\u0435\u043d\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043a\u0430\u0440\u0442\u044b \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.","holder_number_invalid":"\u041f\u043e\u043b\u044f \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u043a\u0430\u0440\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b.","holiday":{"add_holiday":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a","doctor_holiday":"\u0414\u043e\u043a\u0442\u043e\u0440 \u0425\u043e\u043b\u0438\u0434\u0435\u0439\u0441","holiday":"\u041f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c","holiday_date":"\u0414\u0430\u0442\u0430 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a\u0430","service_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438"},"icon_size":"\u0420\u0430\u0437\u043c\u0435\u0440 \u0437\u043d\u0430\u0447\u043a\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 2\u00a0\u041c\u0411.","id":"\u0418\u0414\u0415\u041d\u0422\u0418\u0424\u0418\u041a\u0410\u0422\u041e\u0420","image_file_type":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpeg, jpg, png..","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","invalid_range":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d","live_consultation":{"add_credential":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435","add_live_consultation":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u043d\u043b\u0430\u0439\u043d-\u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044e","awaited":"\u041e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0439","client_video":"\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0435 \u0432\u0438\u0434\u0435\u043e","consultation_date":"\u0414\u0430\u0442\u0430 \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","consultation_duration_minutes":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438 \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445","consultation_minutes":"\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","consultation_title":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","created_by":"\u0421\u043e\u0437\u0434\u0430\u043d","created_for":"\u041f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","disabled":"\u041d\u0435\u043f\u043e\u043b\u043d\u043e\u0446\u0435\u043d\u043d\u044b\u0439","duration":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445)","edit_live_consultation":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043d\u043b\u0430\u0439\u043d-\u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044e","edit_live_meeting":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0436\u0438\u0432\u0443\u044e \u0432\u0441\u0442\u0440\u0435\u0447\u0443","enable":"\u0414\u0430\u0432\u0430\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c","finished":"\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043d\u044b\u0439","host_video":"\u0412\u0438\u0434\u0435\u043e \u0445\u043e\u0441\u0442\u0430","join_now":"\u041f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u044f\u0439\u0441\u044f \u0441\u0435\u0439\u0447\u0430\u0441","live_consultation_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043e\u043d\u043b\u0430\u0439\u043d-\u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","new_live_consultation":"\u041d\u043e\u0432\u0430\u044f \u0436\u0438\u0432\u0430\u044f \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044f","new_live_meeting":"\u041d\u043e\u0432\u0430\u044f \u0436\u0438\u0432\u0430\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0430","select_consultation_date":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","select_doctor_name":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043c\u044f \u0432\u0440\u0430\u0447\u0430","select_patient_name":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043c\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","staff_list":"\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432","start_now":"\u041d\u0430\u0447\u0438\u043d\u0430\u0439 \u0441\u0435\u0439\u0447\u0430\u0441","type":"\u0422\u0438\u043f","type_number":"\u041d\u043e\u043c\u0435\u0440 \u0442\u0438\u043f\u0430","zoom_api_key":"\u041a\u043b\u044e\u0447 API \u043c\u0430\u0441\u0448\u0442\u0430\u0431\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f","zoom_api_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 Zoom API"},"live_consultations":"\u0416\u0438\u0432\u044b\u0435 \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","live_status_retrieved_successfully.":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d.","login":"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f","medicine":{"available_quantity":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","brand":"\u0411\u0440\u0435\u043d\u0434","brand_name":"\u0418\u043c\u044f \u0431\u0440\u0435\u043d\u0434\u0430","buying_price":"\u0426\u0435\u043d\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0438","cant_be_deleted":"\u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","category_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438","category_retrieved_successfully":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u00ab\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0430\u00bb \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430.","deleted_successfully":"\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","dosage":"\u0414\u043e\u0437\u0438\u0440\u043e\u0432\u043a\u0430","dose_interval":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0434\u043e\u0437\u044b","duration":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","edit_medicine":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0430","edit_medicine_brand":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u0430\u0440\u043a\u0443 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","edit_medicine_category":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432","filter_options":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0438\u043b\u044c\u0442\u0440\u0430","medicine":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","medicine_brands":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u044b","medicine_brands_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0442\u043e\u0440\u0433\u043e\u0432\u043e\u0439 \u043c\u0430\u0440\u043a\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","medicine_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u044b","medicine_category_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432","medicine_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u044b","medicine_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","medicine_retrieved_successfully":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e","medicines":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","name":"\u0418\u043c\u044f","new_brand":"\u041d\u043e\u0432\u044b\u0439 \u0431\u0440\u0435\u043d\u0434","new_medicine":"\u041d\u043e\u0432\u0430\u044f \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0430","new_medicine_brand":"\u041d\u043e\u0432\u044b\u0439 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0439 \u0431\u0440\u0435\u043d\u0434","new_medicine_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u00ab\u041d\u043e\u0432\u0430\u044f \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0430\u00bb","no_use":"\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f","quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","salt_composition":"\u0421\u043e\u043b\u0435\u0432\u043e\u0439 \u0441\u043e\u0441\u0442\u0430\u0432","saved_successfully":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e","select_duration":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","selling_price":"\u0426\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438","side_effects":"\u041f\u043e\u0431\u043e\u0447\u043d\u044b\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u044b","status_updated_successfully":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","updated_successfully":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e"},"medicine_bills":{"add_medicine_bill":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","available_quantity":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","avl_qty":"Avl \u041a\u043e\u043b-\u0432\u043e","bill_date":"\u0414\u0430\u0442\u0430 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430","bill_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0447\u0435\u0442\u0430","bill_number":"\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430","cell_no":"\u041d\u043e\u043c\u0435\u0440 \u044f\u0447\u0435\u0439\u043a\u0438","dose_interval":"\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0434\u043e\u0437\u044b","duplicate_medicine":"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430.","edit_medicine_bill":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","enter_lot_number":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043b\u043e\u0442\u0430.","enter_puchase_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u043e\u043a\u0443\u043f\u043a\u0438","enter_sale_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0438.","is":"\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f","item_name":"\u0418\u043c\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430","medicine_bill":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442","medicine_bill_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0441\u0447\u0435\u0442\u0435 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","medicine_bills":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0441\u0447\u0435\u0442\u0430","medicine_not_selected":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u043e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e.","medicine_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0430\".","net_amount_cant":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.","net_amount_cant_zero":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439.","net_amount_not_empty":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0447\u0438\u0441\u0442\u0443\u044e \u0441\u0443\u043c\u043c\u0443.","net_amount_not_zero":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u0430 \u043d\u0443\u043b\u044e.","new_medicine_bill":"\u0411\u0438\u043b\u043b\u044c \u043e \u043d\u043e\u0432\u043e\u0439 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0435","payment_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_type":"\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b","prescription_not_found":"\u0420\u0435\u0446\u0435\u043f\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d","price":"\u0426\u0435\u043d\u0430","print_bill":"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0441\u0447\u0435\u0442","quantity_should":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 0.","sale_price":"\u0426\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438","select_medicine":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0430","select_patient":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","select_payment_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430","tax_amt":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u043e\u0439.","tax_cannot_be_zero_empty":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u043e\u0439.","tax_should_be":"\u041d\u0430\u043b\u043e\u0433\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 100%.","the_discount_shoul":"\u0421\u043a\u0438\u0434\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043e\u0431\u0449\u0435\u0439 \u0441\u0443\u043c\u043c\u044b.","the_medicine_already_in_use":"\u042d\u0442\u043e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0441\u0447\u0435\u0442\u0430\u0445 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c?","update_quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435, \u0447\u0435\u043c \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e."},"medicine_brands":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u044b","medicine_categories":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u044b","medicines":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","mobile_no":"\u041d\u043e\u043c\u0435\u0440 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0433\u043e","months":{"apr":"\u0430\u043f\u0440","aug":"\u0430\u0432\u0433","dec":"\u0434\u0435\u043a\u0430\u0431\u0440\u044c","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","jan":"\u042f\u043d","jul":"\u0438\u044e\u043b\u044c","jun":"\u0438\u044e\u043d\u044c","mar":"\u043c\u0430\u0440\u0442","may":"\u041c\u0430\u0439","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u043e\u043a\u0442\u044f\u0431\u0440\u044c","sep":"\u0441\u0435\u043d"},"no_response":"\u041e\u0442\u0432\u0435\u0442 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d","not_supported":"\u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435. \u041f\u0435\u0440\u0435\u0434 \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u0435\u0439 \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f Google \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441.","notification":{"mark_all_as_read":"\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u0430\u043a \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043d\u043e\u0435","notification":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f","you_don`t_have_any_new_notification":"\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439"},"patient":{"add":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","address1":"\u0410\u0434\u0440\u0435\u0441 1","address2":"\u0410\u0434\u0440\u0435\u0441 2","address_information":"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0430\u0434\u0440\u0435\u0441\u0435","blood_group":"\u0413\u0440\u0443\u043f\u043f\u0430 \u043a\u0440\u043e\u0432\u0438","city":"\u0413\u043e\u0440\u043e\u0434","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_no":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 ","country":"\u0421\u0442\u0440\u0430\u043d\u0430","details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0435 ","dob":"\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f:","edit":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","emailverified":"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u0430","enter_email":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enter_password":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","filter":"\u0444\u0438\u043b\u044c\u0442\u0440","first_name":"\u0418\u043c\u044f","gender":"\u041f\u043e\u043b","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","last_updated":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435","male":"\u041c\u0443\u0436\u0447\u0438\u043d\u0430","name":"\u0418\u043c\u044f","password":"\u041f\u0430\u0440\u043e\u043b\u044c","patient_unique_id":"\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 ","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u041a\u043e\u0434","profile":"\u041f\u0440\u043e\u0444\u0438\u043b\u044c","registered_on":"\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e ","save_changes":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f"},"patient_dashboard":{"completed_appointments":"\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438","next_appointment":"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438 ","today_appointments":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\u0448\u043d\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438","upcoming_appointments":"\u041f\u0440\u0435\u0434\u0441\u0442\u043e\u044f\u0449\u0438\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0438"},"patients":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442\u044b","payment_detail":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","payment_for_booking_appointment_with_doctor":"\u041e\u043f\u043b\u0430\u0442\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0430 \u043f\u0440\u0438\u0435\u043c \u043a \u0432\u0440\u0430\u0447\u0443","payment_method":{"authorize":"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u0442\u044c","paypal":"Paypal","paystack":"\u0421\u0442\u043e\u043f\u043a\u0430","paytm":"\u041f\u044d\u0439\u0442\u043c","razorpay":"\u0420\u0430\u0437\u043e\u0440\u043f\u0430\u0439","stripe":"\u041f\u043e\u043b\u043e\u0441\u0430"},"paytm":"\u041f\u044d\u0439\u0442\u043c","prescription":{"available_quantity_of":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e ","duration":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","frequency":"\u0427\u0430\u0441\u0442\u043e\u0442\u0430","is":"\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f","name":"\u0418\u043c\u044f","not_add_duplicate_medicines":"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u0443\u0431\u043b\u0438\u043a\u0430\u0442\u044b \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432.","selectMedicine":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","total_quantity":"\u041e\u0431\u0449\u0430\u044f \u0447\u0438\u0441\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u044c"},"privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","purchase_medicine":{"actions":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f","amount":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","discount":"\u0421\u043a\u0438\u0434\u043a\u0430","dose_duration":"\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0437\u044b","expiry_date":"\u0414\u0430\u0442\u0430 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f","export_to_excel":"\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 Excel","lot_no":"\u041c\u043d\u043e\u0433\u043e \u043d\u0435.","net_amount":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430","note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435","other_details":"\u0414\u0440\u0443\u0433\u0438\u0435 \u0434\u0435\u0442\u0430\u043b\u0438","payment_mode":"\u0420\u0435\u0436\u0438\u043c \u043e\u043f\u043b\u0430\u0442\u044b","payment_note":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435 \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435","purchase_medicine":"\u041a\u0443\u043f\u0438\u0442\u044c \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","purchase_medicine_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u043e\u043a\u0443\u043f\u043a\u0438 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","purchase_medicine_overview":"\u041a\u0443\u043f\u0438\u0442\u044c \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u041e\u0431\u0437\u043e\u0440","purchase_medicines":"\u041a\u0443\u043f\u0438\u0442\u044c \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","purchase_number":"\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u043a\u0443\u043f\u043a\u0438","purchased_medicine_success":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u0438\u043e\u0431\u0440\u0435\u0442\u0435\u043d\u043e","quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","tax":"\u043d\u0430\u043b\u043e\u0433","tax_amount":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430","total":"\u041e\u0431\u0449\u0438\u0439"},"range_constructor_requires_trie_parameter":"\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0443 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Trie","register":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440","requires_string_parameter":"rangeWithString \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0441\u0442\u0440\u043e\u043a\u043e\u0432\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430","resend_email_verification":"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435","review":{"add_review":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u0442\u0437\u044b\u0432","edit_review":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0437\u044b\u0432","no_doctors_available_to_give_rating":"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0432\u0440\u0430\u0447\u0435\u0439, \u0447\u0442\u043e\u0431\u044b \u0434\u0430\u0442\u044c \u043e\u0446\u0435\u043d\u043a\u0443.","review":"\u0420\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u0435","write_a_review":"\u041d\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0440\u0435\u0446\u0435\u043d\u0437\u0438\u044e"},"reviews":"\u043e\u0442\u0437\u044b\u0432\u044b","role":{"add_role":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u043e\u043b\u044c ","edit_role":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u043e\u043b\u044c ","permissions":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f ","role":"\u0420\u043e\u043b\u044c","role_permissions":"\u0420\u043e\u043b\u0435\u0432\u044b\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f ","select_all_permissions":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f "},"roles":"\u0420\u043e\u043b\u0438","service":{"add_service":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443 ","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f ","charges":"\u0421\u0431\u043e\u0440\u044b ","edit_service":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043b\u0443\u0436\u0431\u0443 ","short_description":"\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"},"service_categories":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0443\u0441\u043b\u0443\u0433","service_category":{"add_category":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0443\u0441\u043b\u0443\u0433","edit_category":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0443\u0441\u043b\u0443\u0433\u0438","service_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438"},"services":"\u0423\u0441\u043b\u0443\u0433\u0438","setting":{"address":"\u0410\u0434\u0440\u0435\u0441","change_app_logo":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","change_favicon":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u043e\u043a","clinic_name":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u043d\u0438\u043a\u0438","connect_google_calendar":"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google","connect_your_google_calendar":"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0441\u0432\u043e\u0439 Google \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c","contact_information":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","currency_settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u0430\u043b\u044e\u0442\u044b","default_country_code":"\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\u00bb","default_language_suggest":"\u041f\u043e\u0441\u043b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u0435\u0441\u044c \u044f\u0437\u044b\u043a \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u0441\u044f \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0432\u0440\u0430\u0447\u0430, \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u043d\u0430 \u043b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0442\u043e\u0440\u043e\u043d\u0435.","disconnect_your_google_calendar":"\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google","do_not_allow_to_login_without_email_verification":"\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0442\u044c \u0432\u0445\u043e\u0434 \u0431\u0435\u0437 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","favicon":"\u0424\u0430\u0432\u0438\u043a\u043e\u043d","general":"\u041e\u0431\u0449\u0438\u0439","general_details":"\u041e\u0431\u0449\u0438\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f","logo":"\u041b\u043e\u0433\u043e\u0442\u0438\u043f","postal_code":"\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u041a\u043e\u0434","prefix":"\u041f\u0440\u0438\u0441\u0442\u0430\u0432\u043a\u0430","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0432\u043e\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438 (\u0438\u0437 Google Calendar), \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0438.","setting":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440","specialities":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","sync_your_google_calendar":"\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google","when_checkbox_disable":"\u041a\u043e\u0433\u0434\u0430 \u0444\u043b\u0430\u0436\u043e\u043a \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0434\u043b\u044f \u043d\u043e\u0432\u044b\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"\u041a\u043e\u0433\u0434\u0430 \u043f\u0430\u0446\u0438\u0435\u043d\u0442 \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c \u043a \u0432\u0430\u043c, \u043d\u043e\u0432\u0430\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f\u0445.","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"\u041a\u043e\u0433\u0434\u0430 \u0432\u044b \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0443, \u043d\u043e\u0432\u0430\u044f \u0432\u0441\u0442\u0440\u0435\u0447\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f\u0445"},"settings":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438","slider":{"Rx":"Rx","accident":"\u041d\u0435\u0441\u0447\u0430\u0441\u0442\u043d\u044b\u0439 \u0441\u043b\u0443\u0447\u0430\u0439","add_slider":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u0430\u0439\u0434\u0435\u0440 ","advice":"\u0441\u043e\u0432\u0435\u0442","after meal":"\u043f\u043e\u0441\u043b\u0435 \u0435\u0434\u044b","appointment_slot":"\u0421\u043b\u043e\u0442\u044b \u0432\u0441\u0442\u0440\u0435\u0447","before meal":"\u043f\u0435\u0440\u0435\u0434 \u0435\u0434\u043e\u0439","breast_feeding":"\u0413\u0440\u0443\u0434\u043d\u043e\u0435 \u0432\u0441\u043a\u0430\u0440\u043c\u043b\u0438\u0432\u0430\u043d\u0438\u0435","comment":"\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439","connect_with_zoom":" \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u0441\u044c \u043a \u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c","current_medication":"\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u043b\u0435\u0447\u0435\u043d\u0438\u0435","days":"\u0434\u043d\u0438","diabetic":"\u0434\u0438\u0430\u0431\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439","dosage":"\u0414\u043e\u0437\u0438\u0440\u043e\u0432\u043a\u0430","duration":"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","edit_prescription":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0446\u0435\u043f\u0442","edit_slider":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043b\u0430\u0439\u0434\u0435\u0440 ","female_pregnancy":"\u0416\u0435\u043d\u0441\u043a\u0430\u044f \u0431\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u044c","food_allergies":"\u041f\u0438\u0449\u0435\u0432\u044b\u0435 \u0430\u043b\u043b\u0435\u0440\u0433\u0438\u0438","health_insurance":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430","heart_disease":"\u0411\u043e\u043b\u0435\u0437\u043d\u044c \u0441\u0435\u0440\u0434\u0446\u0430","high_blood_pressure":"\u0412\u044b\u0441\u043e\u043a\u043e\u0435 \u043a\u0440\u043e\u0432\u044f\u043d\u043e\u0435 \u0434\u0430\u0432\u043b\u0435\u043d\u0438\u0435","image":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435","low_income":"\u041d\u0438\u0437\u043a\u0438\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u043e\u0445\u043e\u0434\u0430","medical_history":"\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0431\u043e\u043b\u0435\u0437\u043d\u0438","medicine_name":"\u0438\u043c\u044f_\u043c\u0435\u0434\u0438\u0446\u0438\u043d\u044b","new_medicine":"\u043d\u043e\u0432\u043e\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","new_prescription":"\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0446\u0435\u043f\u0442","next_visit":"\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0432\u0438\u0437\u0438\u0442","ok":"\u0425\u043e\u0440\u043e\u0448\u043e","others":"\u0434\u0440\u0443\u0433\u0438\u0435","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","physical_information":"\u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f","plus_rate":"\u043f\u0443\u043b\u044c\u0441 \u0441\u0442\u0430\u0432\u043a\u0430","prescription":"\u0434\u0430\u0432\u043d\u043e\u0441\u0442\u044c","prescription_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0440\u0435\u0446\u0435\u043f\u0442\u0430","prescription_saved":"\u0420\u0435\u0446\u0435\u043f\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.","prescription_updated":"\u0420\u0435\u0446\u0435\u043f\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","prescriptions":"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f","problem":"\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430","problem_description":"\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b","reference":"\u0421\u0441\u044b\u043b\u043a\u0430","short_description":"\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","surgery":"\u0425\u0438\u0440\u0443\u0440\u0433\u0438\u044f","temperature":"\u0442\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0430","tendency_bleed":"\u0422\u0435\u043d\u0434\u0435\u043d\u0446\u0438\u044f \u041a\u0440\u043e\u0432\u043e\u0442\u0435\u0447\u0435\u043d\u0438\u0435","test":"\u0442\u0435\u0441\u0442","time":"\u0432\u0440\u0435\u043c\u044f","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a"},"sliders":"\u0421\u043b\u0430\u0439\u0434\u0435\u0440\u044b ","smart_patient_card":{"add_smart_card":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u043c\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u0443","add_smart_card_templates":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d\u044b \u0443\u043c\u043d\u044b\u0445 \u043a\u0430\u0440\u0442","address_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0430\u0434\u0440\u0435\u0441","blood_group_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u043a\u0440\u043e\u0432\u0438","dob_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0434\u0430\u0442\u0443 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f","edit_patient_card":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u043c\u043d\u0443\u044e \u043a\u0430\u0440\u0442\u0443","email_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0443\u044e \u043f\u043e\u0447\u0442\u0443","enter_template_name":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430","for_all_patient":"\u0414\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","generate_patient_card":"\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0441\u043a\u0443\u044e \u043a\u0430\u0440\u0442\u0443","generate_patient_smart_cards":"\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u043c\u043d\u044b\u0435 \u043a\u0430\u0440\u0442\u044b \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","header_color":"\u0426\u0432\u0435\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430","only_one_patient":"\u0422\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u043f\u0430\u0446\u0438\u0435\u043d\u0442","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","patient_smart_card_created":"\u0423\u043c\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430.","patient_smart_card_deleted":"\u0423\u043c\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430.","phone_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u0435\u043b\u0435\u0444\u043e\u043d","please_selest_patient":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","remaning_patients":"\u041e\u0441\u0442\u0430\u0432\u0448\u0438\u0435\u0441\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u044b","select_patient":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","select_template":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d","smart_patient_card_templates":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0443\u043c\u043d\u044b\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0445 \u043a\u0430\u0440\u0442","smart_patient_cards":"\u0423\u043c\u043d\u044b\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0435 \u043a\u0430\u0440\u0442\u044b","templat_name":"\u0418\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430","template":"\u0428\u0430\u0431\u043b\u043e\u043d","template_created":"\u0428\u0430\u0431\u043b\u043e\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","template_deleted":"\u0428\u0430\u0431\u043b\u043e\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0451\u043d.","template_update":"\u0428\u0430\u0431\u043b\u043e\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d.","type":"\u0422\u0438\u043f","unique_id_show":"\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440"},"specialization":{"add_specialization":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e ","edit_specialization":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e ","retrieved_successfully":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e."},"specializations":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438","staff":{"add_staff":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b ","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_no":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 ","edit_staff":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","female":"\u0416\u0435\u043d\u0441\u043a\u0438\u0439","first_name":"\u0418\u043c\u044f","gender":"\u041f\u043e\u043b","last_name":"\u0424\u0430\u043c\u0438\u043b\u0438\u044f","male":"\u041c\u0443\u0436\u0447\u0438\u043d\u0430","password":"\u041f\u0430\u0440\u043e\u043b\u044c","role":"\u0420\u043e\u043b\u044c","select_role":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u043b\u044c","staff":"\u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0438","staff_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0435 "},"staffs":"\u0428\u0442\u0430\u0431\u044b","start_time_invalid":"\u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043d\u044f \u043d\u0435\u0432\u0435\u0440\u043d\u043e","state":{"add_state":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","country":"\u0421\u0442\u0440\u0430\u043d\u0430","edit_state":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","state":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435","states":"\u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f"},"states":"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f","subscribers":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","terms_conditions":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u044f ","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","transaction":{"paid":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0439","payment_accepted_by":"\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u0440\u0438\u043d\u044f\u0442\u0430","payment_status":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430","pending":"\u0412 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0438","transaction_detail":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438","transaction_id":"ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"},"transactions":"\u0441\u0434\u0435\u043b\u043a\u0438","used_medicine":{"used_at":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432","used_medicine":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u0430\u044f \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0430","used_medicines":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","used_quantity":"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e"},"user":{"account":"\u0421\u0447\u0435\u0442","account_setting":"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430","avatar":"\u0410\u0432\u0430\u0442\u0430\u0440 ","change_language":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044f\u0437\u044b\u043a","change_password":"\u0418\u0437\u043c\u0435\u043d\u0438 \u043f\u0430\u0440\u043e\u043b\u044c","confirm_password":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c","contact_number":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d","current_password":"\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","edit_profile":"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","email_notification":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435","full_name":"\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f","gender":"\u041f\u043e\u043b","language":"\u042f\u0437\u044b\u043a","new_password":"\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c","profile_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044f ","return_to_admin":"\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443","save_changes":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f","select_time_zone":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441","setting":"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440","sign_out":"\u0412\u044b\u0439\u0442\u0438","staff_details":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u0435 ","time_zone":"\u0427\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441"},"users":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438","valid_expiration_date":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.","valid_number":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","visit":{"add_visit":"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u0435 ","description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","doctor":"\u0414\u043e\u043a\u0442\u043e\u0440","edit_visit":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u0435 ","enter_note":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435","enter_observation":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435","enter_problem":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443","notes":"\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f","observations":"\u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","prescriptions":"\u0420\u0435\u0446\u0435\u043f\u0442\u044b","problems":"\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b","title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a","visit_date":"\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u044f ","visit_detail":"\u041f\u043e\u0441\u0435\u0442\u0438\u0442\u0435 \u0434\u0435\u0442\u0430\u043b\u044c ","visit_details":"\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u043e \u043f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u0438"},"visits":"\u041f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u044f ","web":{"Meet_best_doctors":"\u041f\u043e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u043b\u0443\u0447\u0448\u0438\u043c\u0438 \u0432\u0440\u0430\u0447\u0430\u043c\u0438","about_experience":"\u041e\u0431 \u043e\u043f\u044b\u0442\u0435","about_short_description":"\u041e \u043a\u0440\u0430\u0442\u043a\u043e\u043c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0438 ","about_title":"\u041e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0438 ","about_us":"\u041e \u043d\u0430\u0441","all_rights_reserved":"\u0412\u0441\u0435 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u0449\u0438\u0449\u0435\u043d\u044b","all_services":"\u0412\u0441\u0435 \u0443\u0441\u043b\u0443\u0433\u0438","already_have_an_account":"\u0423\u0436\u0435 \u0435\u0441\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442","already_have_patient_account":"\u0423 \u0432\u0430\u0441 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","appointment":"\u0414\u0435\u043b\u043e\u0432\u043e\u0435 \u0441\u0432\u0438\u0434\u0430\u043d\u0438\u0435, \u0432\u0441\u0442\u0440\u0435\u0447\u0430","appointment_now":"\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0439\u0447\u0430\u0441","best_professionals":"\u041b\u0443\u0447\u0448\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u043e\u043d\u0430\u043b\u044b","book_an_appointment":"\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","book_appointment":"\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","call_us":"\u041f\u043e\u0437\u0432\u043e\u043d\u0438\u0442\u0435 \u043d\u0430\u043c","closed":"\u0417\u0430\u043a\u0440\u044b\u0442\u043e","confirm_booking":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435","contact":"\u041a\u043e\u043d\u0442\u0430\u043a\u0442","contact_us":"\u043a\u043e\u043d\u0442\u0430\u043a\u0442","contact_us_for_any_information":"\u0421\u0432\u044f\u0436\u0438\u0442\u0435\u0441\u044c \u0441 \u043d\u0430\u043c\u0438 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043b\u044e\u0431\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438","create_an_account":"\u0417\u0430\u0432\u0435\u0441\u0442\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442","created_at":"\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0432","doctors":"\u0412\u0440\u0430\u0447\u0435\u0439","doctors_can_interact___":"\u0412\u0440\u0430\u0447\u0438 \u043c\u043e\u0433\u0443\u0442 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0441 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430\u043c\u0438 \u0438 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0438\u0432\u0430\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 \u043b\u0435\u0447\u0435\u043d\u0438\u0435","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438 \u0444\u043e\u0440\u043c\u0443\u043b\u0438\u0440\u0443\u0439\u0442\u0435 \u0431\u0435\u0437\u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0434\u043e \u0438\u043d\u0442\u0435\u0433\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432. \u0417\u043d\u0430\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0438\u043d\u043a\u0443\u0431\u0438\u0440\u0443\u0439\u0442\u0435 \u0438\u043d\u0442\u0435\u0433\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b \u0431\u0435\u0437 \u0440\u0435\u043d\u0442\u0430\u0431\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438.","email":"\u042d\u043b. \u0430\u0434\u0440\u0435\u0441","email_address":"\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","emergency_help":"\u0421\u043a\u043e\u0440\u0430\u044f \u043f\u043e\u043c\u043e\u0449\u044c","enquiry":"\u0420\u0430\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435","enquiry_details":"\u0414\u0435\u0442\u0430\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 ","enter_your_email":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b","enter_your_email_to_subscribe_to_our_newsletter":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043d\u0430\u0448\u0443 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u043e\u0432\u043e\u0441\u0442\u0435\u0439","faqs":"\u0427\u0410\u0421\u0422\u041e \u0417\u0410\u0414\u0410\u0412\u0410\u0415\u041c\u042b\u0415 \u0412\u041e\u041f\u0420\u041e\u0421\u042b","forgot_password":"\u0417\u0430\u0431\u044b\u043b \u043f\u0430\u0440\u043e\u043b\u044c","home":"\u0414\u043e\u043c","how_we_works":"\u041a\u0430\u043a \u043c\u044b \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u043c","i_agree":"\u042f \u0441\u043e\u0433\u043b\u0430\u0441\u0435\u043d","location":"\u043c\u0435\u0441\u0442\u043e \u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f","login":"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f","make_appointment":"\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0432\u0441\u0442\u0440\u0435\u0447\u0443","medical":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0439 ","medical_about_us":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u043e \u043d\u0430\u0441 ","medical_appointment":"\u0417\u0430\u043f\u0438\u0441\u044c \u043a \u0432\u0440\u0430\u0447\u0443 ","medical_contact":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0442\u0430\u043a\u0442","medical_doctors":"\u0412\u0440\u0430\u0447\u0438","medical_services":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438","medical_treatment":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u043e\u0435 \u043b\u0435\u0447\u0435\u043d\u0438\u0435","meet_our_team_of_specialists":"\u041f\u043e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u043d\u0430\u0448\u0435\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0441\u0442\u043e\u0432","message":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","name":"\u0418\u043c\u044f","new_here":"\u041d\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u0439 \u0442\u0443\u0442","no_services_available":"\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433","opening_hours":"\u0427\u0430\u0441\u044b \u0440\u0430\u0431\u043e\u0442\u044b","our_doctor":"\u041d\u0430\u0448 \u0434\u043e\u043a\u0442\u043e\u0440","our_team":"\u041d\u0430\u0448\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430","patient_can_book_an_appointment___":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u0440\u0438\u0435\u043c \u043a \u0432\u0440\u0430\u0447\u0443 \u0441 \u0446\u0435\u043b\u0435\u0432\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u0438\u043b\u0438 \u0441\u043e \u0441\u0432\u043e\u0435\u0439 \u043f\u0430\u043d\u0435\u043b\u0438 \u0432\u0445\u043e\u0434\u0430","patient_can_do_registration___":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0437\u0434\u0435\u0441\u044c, \u0443\u043a\u0430\u0437\u0430\u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e.","patient_name":"\u0418\u043c\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","patient_registration":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","phone":"\u0422\u0435\u043b\u0435\u0444\u043e\u043d","qualified_doctors":"\u041a\u0432\u0430\u043b\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0432\u0440\u0430\u0447\u0438","questions_before_booking":"\u0412\u043e\u043f\u0440\u043e\u0441\u044b \u043f\u0435\u0440\u0435\u0434 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c","quick_links":"\u0411\u044b\u0441\u0442\u0440\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438","reason":"\u041f\u0440\u0438\u0447\u0438\u043d\u0430","registration":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f","remember_me":"\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u043c\u0435\u043d\u044f","satisfied_patient":"\u0414\u043e\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0446\u0438\u0435\u043d\u0442","saying_about_us":"\u0413\u043e\u0432\u043e\u0440\u044f \u043e \u043d\u0430\u0441","see_what_are_the_patients":"\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435, \u0447\u0442\u043e \u0442\u0430\u043a\u043e\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u044b","send_an_email":"\u041f\u043e\u0441\u043b\u0430\u0442\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e","send_message":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435","send_us_an_email":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430\u043c \u043f\u0438\u0441\u044c\u043c\u043e","services":"\u0423\u0441\u043b\u0443\u0433\u0438","sign_in":"\u0412\u043e\u0439\u0442\u0438","sign_in_here":"\u0412\u043e\u0439\u0434\u0438\u0442\u0435 \u0437\u0434\u0435\u0441\u044c ","sign_up":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440","status":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","subject":"\u0422\u0435\u043c\u0430","subscribe":"\u041f\u043e\u0434\u043f\u0438\u0441\u044b\u0432\u0430\u0439\u0441\u044f","take_treatment":"\u0412\u044b\u043b\u0435\u0447\u0438\u0442\u0435\u0441\u044c","terms_and_conditions":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438 \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f","testimonial":"\u0420\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u0435","timings":"\u0421\u0440\u043e\u043a\u0438 ","total_doctors":"\u0412\u0441\u0435\u0433\u043e \u0432\u0440\u0430\u0447\u0435\u0439","total_registered_patient":"\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432 ","total_services":"\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u043b\u0443\u0433","total_specializations":"\u0412\u0441\u0435\u0433\u043e \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439","view_more":"\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0435\u0449\u0435","we_cover_a_big___":"\u041c\u044b \u043f\u043e\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0448\u0438\u0440\u043e\u043a\u0438\u0439 \u0441\u043f\u0435\u043a\u0442\u0440 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0445 \u0443\u0441\u043b\u0443\u0433","we_make_sure_that_your_life_are_in_good_hands":"\u041c\u044b \u0437\u0430\u0431\u043e\u0442\u0438\u043c\u0441\u044f \u043e \u0442\u043e\u043c, \u0447\u0442\u043e\u0431\u044b \u0432\u0430\u0448\u0430 \u0436\u0438\u0437\u043d\u044c \u0431\u044b\u043b\u0430 \u0432 \u043d\u0430\u0434\u0435\u0436\u043d\u044b\u0445 \u0440\u0443\u043a\u0430\u0445","we_provide_the_special_tips___":"\u0414\u0430\u0435\u043c \u043e\u0441\u043e\u0431\u044b\u0435 \u0441\u043e\u0432\u0435\u0442\u044b \u0438 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438 \u043f\u043e \u0443\u0445\u043e\u0434\u0443 \u0437\u0430 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u0435\u043c \u0438 \u043d\u0430 \u0432\u044b\u0441\u0448\u0435\u043c \u0443\u0440\u043e\u0432\u043d\u0435","working_process":"\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441","year_experience":"\u0413\u043e\u0434\u044b \u043e\u043f\u044b\u0442\u0430"},"weekdays":{"fri":"\u041f\u0422","mon":"\u041f\u041d","sat":"\u0421\u0438\u0434\u0435\u043b","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","thu":"\u0427\u0422","tue":"\u0412\u0422","wed":"\u041c\u042b \u0411"}},"ru.pagination":{"next":"\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439","previous":"\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439"},"ru.passwords":{"reset":"\u0412\u0430\u0448 \u043f\u0430\u0440\u043e\u043b\u044c \u0431\u044b\u043b \u0441\u0431\u0440\u043e\u0448\u0435\u043d!","sent":"\u041c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0432\u0430\u043c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043f\u043e \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u0435!","throttled":"\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435, \u043f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043f\u043e\u043f\u044b\u0442\u043a\u0443.","token":"\u042d\u0442\u043e\u0442 \u0442\u043e\u043a\u0435\u043d \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","user":"\u041c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b."},"ru.validation":{"accepted":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u043d\u044f\u0442.","active_url":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u043c URL.","after":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0441\u043b\u0435: date.","after_or_equal":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0441\u043b\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e\u0439 \u0434\u0430\u0442\u0435.","alpha":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b.","alpha_dash":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b, \u0442\u0438\u0440\u0435 \u0438 \u043f\u043e\u0434\u0447\u0435\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f.","alpha_num":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b \u0438 \u0446\u0438\u0444\u0440\u044b.","array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c.","attributes":[],"before":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u043f\u0435\u0440\u0435\u0434: date.","before_or_equal":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439 \u0434\u043e \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e\u0439 \u0434\u0430\u0442\u0435.","between":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442: min \u0434\u043e: max \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442: min \u0434\u043e: max \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442: min \u0434\u043e: max.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b\u044b: min \u0438: max."},"boolean":"\u041f\u043e\u043b\u0435: attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0438\u0441\u0442\u0438\u043d\u043d\u044b\u043c \u0438\u043b\u0438 \u043b\u043e\u0436\u043d\u044b\u043c.","confirmed":"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435: attribute \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442.","current_password":"\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","custom":{"attribute-name":{"rule-name":"\u043d\u0430 \u0437\u0430\u043a\u0430\u0437 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"}},"date":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439 \u0434\u0430\u0442\u043e\u0439.","date_equals":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0430\u0442\u043e\u0439, \u0440\u0430\u0432\u043d\u043e\u0439: date.","date_format":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443: \u0444\u043e\u0440\u043c\u0430\u0442.","different":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0438: \u0434\u0440\u0443\u0433\u043e\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043d\u044b\u043c\u0438.","digits":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c: \u0446\u0438\u0444\u0440\u044b \u0446\u0438\u0444\u0440\u044b.","digits_between":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443: min \u0438: max \u0446\u0438\u0444\u0440\u0430\u043c\u0438.","dimensions":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f.","distinct":"\u041f\u043e\u043b\u0435: attribute \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0435\u0435\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.","email":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","ends_with":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0442\u044c\u0441\u044f \u043e\u0434\u043d\u0438\u043c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445:: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439.","exists":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442 selected: \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c.","filled":"\u041f\u043e\u043b\u0435: attribute \u0434\u043e\u043b\u0436\u043d\u043e \u0438\u043c\u0435\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.","gt":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435: value \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"gte":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b: value \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d: value.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d \u0441\u0438\u043c\u0432\u043e\u043b\u0443: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435."},"image":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c.","in":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442 selected: \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","in_array":"\u041f\u043e\u043b\u0435: attribute \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432: other.","integer":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c.","ip":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c IP-\u0430\u0434\u0440\u0435\u0441\u043e\u043c.","ipv4":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c IPv4-\u0430\u0434\u0440\u0435\u0441\u043e\u043c.","ipv6":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c IPv6.","json":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 JSON.","lt":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435: value \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: value."},"lte":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d: value.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u0435\u043d \u0441\u0438\u043c\u0432\u043e\u043b\u0443: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435."},"max":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435: max \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435: max \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c: \u043c\u0430\u043a\u0441.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: max."},"mimes":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430:: values.","mimetypes":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430:: values.","min":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c: min \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u044c\u0448\u0435: min \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u044c\u0448\u0435: \u043c\u0438\u043d.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435: min \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432."},"multiple_of":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043a\u0440\u0430\u0442\u043d\u044b\u043c: value.","not_in":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442 selected: \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","not_regex":"\u0424\u043e\u0440\u043c\u0430\u0442: attribute \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c.","password":"\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","present":"\u041f\u043e\u043b\u0435: attribute \u0434\u043e\u043b\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c.","prohibited":"\u041f\u043e\u043b\u0435: attribute \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. ","prohibited_if":"\u041f\u043e\u043b\u0435: attribute \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u043a\u043e\u0433\u0434\u0430: other \u0440\u0430\u0432\u043d\u043e: value. ","prohibited_unless":"\u041f\u043e\u043b\u0435: attribute \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u0435\u0441\u043b\u0438: other \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432: values. ","regex":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430: \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","required":"\u041f\u043e\u043b\u0435: attribute \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","required_if":"\u041f\u043e\u043b\u0435: attribute \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u043a\u043e\u0433\u0434\u0430: other: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.","required_unless":"\u041f\u043e\u043b\u0435: \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c, \u0435\u0441\u043b\u0438: other \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432: values.","required_with":"\u041f\u043e\u043b\u0435: attribute \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f, \u0435\u0441\u043b\u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442: values.","required_with_all":"\u041f\u043e\u043b\u0435: attribute \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u043a\u043e\u0433\u0434\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f.","required_without":"\u041f\u043e\u043b\u0435: attribute \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c, \u0435\u0441\u043b\u0438: values \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.","required_without_all":"\u041f\u043e\u043b\u0435: attribute \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c, \u0435\u0441\u043b\u0438 \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437: \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439.","same":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0438: \u0434\u0440\u0443\u0433\u043e\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c.","size":{"array":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b: size.","file":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.","numeric":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c: size.","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b\u044b: size."},"starts_with":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439::","string":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u043e\u0439.","timezone":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0439 \u0437\u043e\u043d\u043e\u0439.","unique":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0443\u0436\u0435 \u0431\u044b\u043b \u0437\u0430\u043d\u044f\u0442.","uploaded":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c.","url":"\u0424\u043e\u0440\u043c\u0430\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430: \u043d\u0435\u0432\u0435\u0440\u0435\u043d.","uuid":"\u0410\u0442\u0440\u0438\u0431\u0443\u0442: \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c UUID."},"th.livewire-tables::strings":{"All":"\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Applied Filters":"\u0e01\u0e23\u0e2d\u0e07\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e15\u0e32\u0e21","Applied Sorting":"\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e15\u0e32\u0e21","Bulk Actions":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e01\u0e32\u0e23\u0e01\u0e23\u0e30\u0e17\u0e33","Clear":"\u0e25\u0e49\u0e32\u0e07\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Columns":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e04\u0e2d\u0e25\u0e31\u0e21\u0e19\u0e4c","Done Reordering":"\u0e08\u0e31\u0e14\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e41\u0e25\u0e49\u0e27","Filters":"\u0e15\u0e31\u0e27\u0e01\u0e23\u0e2d\u0e07","No items found. Try to broaden your search.":"\u0e44\u0e21\u0e48\u0e1e\u0e1a\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e04\u0e49\u0e19\u0e2b\u0e32","Remove filter option":"\u0e40\u0e2d\u0e32\u0e15\u0e31\u0e27\u0e01\u0e23\u0e2d\u0e07\u0e2d\u0e2d\u0e01","Remove sort option":"\u0e40\u0e2d\u0e32\u0e01\u0e32\u0e23\u0e40\u0e23\u0e35\u0e22\u0e07\u0e25\u0e33\u0e14\u0e31\u0e1a\u0e2d\u0e2d\u0e01","Reorder":"\u0e08\u0e31\u0e14\u0e25\u0e33\u0e14\u0e31\u0e1a","Search":"\u0e04\u0e49\u0e19\u0e2b\u0e32...","Select All":"\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","Showing":"\u0e41\u0e2a\u0e14\u0e07","Unselect All":"\u0e44\u0e21\u0e48\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","You are currently selecting all":"\u0e02\u0e13\u0e30\u0e19\u0e35\u0e49\u0e04\u0e38\u0e13\u0e44\u0e14\u0e49\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e38\u0e01\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","You are not connected to the internet.":"\u0e02\u0e13\u0e30\u0e19\u0e35\u0e49\u0e04\u0e38\u0e13\u0e44\u0e21\u0e48\u0e44\u0e14\u0e49\u0e40\u0e0a\u0e37\u0e48\u0e2d\u0e21\u0e15\u0e48\u0e2d\u0e01\u0e31\u0e1a\u0e2d\u0e34\u0e19\u0e40\u0e17\u0e2d\u0e23\u0e4c\u0e40\u0e19\u0e47\u0e15","You have selected":"\u0e04\u0e38\u0e13\u0e40\u0e25\u0e37\u0e2d\u0e01","of":"\u0e08\u0e32\u0e01","results":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","row":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","rows":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23","rows, do you want to select all":"\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23, \u0e04\u0e38\u0e13\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e31\u0e49\u0e07\u0e2b\u0e21\u0e14","to":"-"},"tk.livewire-tables::strings":{"All":"Hemmesi","Applied Filters":"Ulanyl\u00fdan S\u00fczg\u00fc\u00e7ler","Applied Sorting":"Ulanyl\u00fdan Tertiple\u015fdirme","Bulk Actions":"K\u00f6p\u00e7\u00fclikle\u00fdin Hereketler","Clear":"Arassala","Columns":"S\u00fct\u00fcnler","Done Reordering":"T\u00e4zeden Tertiplendi","Filters":"S\u00fczg\u00fc\u00e7ler","No items found. Try to broaden your search.":"Hi\u00e7 zat tapylmady. G\u00f6zlegi\u0148izi gi\u0148eltm\u00e4ge synany\u015fy\u0148.","Remove filter option":"S\u00fczg\u00fc\u00e7 g\u00f6rn\u00fc\u015fini a\u00fdyry\u0148","Remove sort option":"Tertiplemek g\u00f6rn\u00fc\u015fini a\u00fdyry\u0148","Reorder":"Tertibe salmak","Search":"G\u00f6zlemek","Select All":"Hemmesini Sa\u00fdla","Showing":"G\u00f6rkezmek","Unselect All":"Hemmesini A\u00fdyr","You are currently selecting all":"H\u00e4zirki wagtda hemmesini sa\u00fdlap al\u00fdarsy\u0148yz","You are not connected to the internet.":"Siz internete birikmediksi\u0148iz.","You have selected":"Sa\u00fdlady\u0148yz","of":"aralygy","results":"netijeler","rows":"hatarlar","rows, do you want to select all":"hatarlar, hemmesini sa\u00fdlamak isle\u00fd\u00e4rsi\u0148izmi?","to":"-"},"tr.auth":{"app":{"create":"Olu\u015ftur","export":"D\u0131\u015fa Aktar","lock_account":"Hesab\u0131 Kilitle","member_since":"\u00dcyelikten beri","messages":"Mesajlar","online":"\u00c7evrimi\u00e7i","print":"Yazd\u0131r","profile":"Profil","reload":"Yeniden Y\u00fckle","reset":"S\u0131f\u0131rla","search":"Ara","settings":"Ayarlar"},"confirm_password":"\u015eifreyi Onayla","email":"E-posta","emails":{"password":{"reset_link":"\u015eifrenizi s\u0131f\u0131rlamak i\u00e7in buraya t\u0131klay\u0131n"}},"failed":"Bu kimlik bilgileri kay\u0131tlar\u0131m\u0131zla e\u015fle\u015fmiyor.","forgot_password":{"send_pwd_reset":"\u015eifre S\u0131f\u0131rlama Ba\u011flant\u0131s\u0131 G\u00f6nder","title":"\u015eifreyi s\u0131f\u0131rlamak i\u00e7in E-posta girin"},"full_name":"Tam Ad","login":{"forgot_password":"\u015eifremi unuttum","register_membership":"Yeni \u00fcyelik olu\u015ftur","title":"Oturumunuzu ba\u015flatmak i\u00e7in oturum a\u00e7\u0131n"},"password":"\u015eifre","register":"Kaydol","registration":{"have_membership":"Zaten \u00fcyeli\u011fim var","i_agree":"Kabul ediyorum","terms":"\u015fartlar","title":"Yeni \u00fcyelik olu\u015ftur"},"remember_me":"Beni Hat\u0131rla","reset_password":{"reset_pwd_btn":"\u015eifreyi S\u0131f\u0131rla","title":"\u015eifrenizi s\u0131f\u0131rlay\u0131n"},"sign_in":"Oturum A\u00e7","sign_out":"\u00c7\u0131k\u0131\u015f","throttle":"\u00c7ok fazla giri\u015f denemesi. L\u00fctfen :saniye saniye i\u00e7inde tekrar deneyin."},"tr.messages":{"admin_dashboard":{"dashboard":"G\u00f6sterge Tablosu","day":"G\u00fcn","earnings_from_appointments":"Randevulardan Kazan\u00e7","filter_options":"Filtre se\u00e7enekleri","month":"Ay","name":"Ad","patient_id":"Hastaya \u00d6zel Kimli\u011fi","recent_patients_registration":"Son Hasta Kayd\u0131","registered":"Kay\u0131tl\u0131","today_appointments":"Bug\u00fcn Randevular\u0131","today_registered_patients":"Bug\u00fcn Kay\u0131tl\u0131 Hastalar","total_doctor":"Toplam Doktorlar","total_patients":"Toplam Hasta","week":"Hafta"},"appointment":{"Select_payment_method":"\u00d6deme t\u00fcr\u00fcn\u00fc se\u00e7in","add_new_appointment":"Randevu Ekle","appointment_at":"Randevuda","appointment_date":"Randevu Tarihi","appointment_details":"Randevu Detaylar\u0131","appointment_status":"Randevu Durumu","appointment_unique_id":"Randevu Kimli\u011fi","appointments":"Randevular","appointments_schedule":"Randevu takvimi","authorize_session_created_successfully":"Yetkilendirme oturumu ba\u015far\u0131yla olu\u015fturuldu.","available":"Mevcut","available_slot":"Mevcut Yuvalar","booked":"Rezerve edildi","calendar":"Takvim","cancel_appointment":"Randevu iptal","cancelled":"\u0130ptal edildi","charge":"\u00dccret","check_in":"Giri\u015f","check_out":"Kontrol Et","date":"Tarih","description":"A\u00e7\u0131klama","edit_appointment":"Randevu D\u00fczenle","ends":"Bitir","extra_fees":"Ek \u00dccretler","no_slot_found":"Zaman aral\u0131\u011f\u0131 bulunamad\u0131.","patient":"Hasta","patient_id":"Hasta Kimli\u011fi","patient_name_retrieved":"Hasta ad\u0131 ba\u015far\u0131yla al\u0131nd\u0131","payable_amount":"\u00d6denecek Tutar","payment":"\u00d6deme","payment_method":"\u00d6deme y\u00f6ntemi","payment_status":"\u00d6deme Durumu","service":"Hizmet","service_charge":"Hizmet \u00dccreti","session_created_successfully":"oturum ba\u015far\u0131yla olu\u015fturuldu","session_id_required":"oturum kimli\u011fi gerekli","starts":"Ba\u015flar","status":"Durum","switch_to_calendar":"Takvime Ge\u00e7","time":"Zaman","total_payable_amount":"Toplam \u00d6denecek Tutar","upcoming_meetings":"yakla\u015fan toplant\u0131lar"},"appointments":"Randevular","apps":"Uygulamalar","card_number_invalid..":"Kart numaras\u0131 ge\u00e7ersiz.","card_type":"Kredi kart tipi","cities":"\u015eehirler","city":{"add_city":"\u015eehir Ekle","city":"\u015eehir","edit_city":"\u015eehri D\u00fczenle","state":"Devlet"},"clinic_schedules":"Klinik Programlar\u0131","cms":{"Terms_Conditions_required":"\u015eartlar ve Ko\u015fullar gerekli","about_image":"Resim Hakk\u0131nda","cms":"\u0130YS","description_no_white_space":"Hakk\u0131nda K\u0131sa A\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermez","experience_required":"Hakk\u0131nda Tecr\u00fcbe alan\u0131 zorunludur.","privacy_policy":"Gizlilik Politikas\u0131","privacy_policy_required.":"Gizlilik Politikas\u0131 gereklidir.","terms_conditions":"\u015eartlar ve Ko\u015fullar","title_no_white_space":"Ba\u015fl\u0131k Hakk\u0131nda alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor"},"common":{"Attempt_read_property_access_token_null":"Bo\u015f de\u011ferde \\\"access_token\\\" \u00f6zelli\u011fi okunmaya \u00e7al\u0131\u015f\u0131ld\u0131","Forgot_password_lable":"\u015eifreni mi unuttun? Sorun de\u011fil. Bize e-posta adresinizi bildirmeniz yeterlidir; size yeni bir \u015fifre se\u00e7menizi sa\u011flayacak bir \u015fifre s\u0131f\u0131rlama ba\u011flant\u0131s\u0131 g\u00f6nderece\u011fiz.","action":"Eylem","active":"Etkin","add":"Ekle","add_credential":"L\u00fctfen yak\u0131nla\u015ft\u0131rma kimlik bilgilerini ekleyin","age":"Ya\u015f","any_one_permission":"L\u00fctfen herhangi bir izin se\u00e7in.","apply":"Uygula","appointment_date_required":"Randevu tarihi alan\u0131 zorunludur.","are_you_sure":"Bunu silmek istedi\u011finizden emin misiniz?","are_you_sure_cancel":"Bunu iptal etmek istedi\u011finizden emin misiniz","back":"Geri","booked":"Rezerve edildi","brand_required":"Marka alan\u0131 zorunludur.","cancel":"\u0130ptal","cancelled":"\u0130ptal edildi","cancelled_appointment":"\u0130ptal Randevu !","category_required":"Kategori alan\u0131 zorunludur.","change_image":"Resmi de\u011fi\u015ftir","check in":"Giri\u015f","check out":"\u00d6deme","city":"\u015eehir","confirm":"Onaylamak","connected_zoom":"Zoom'a ba\u015far\u0131yla ba\u011flan\u0131ld\u0131.","contact_number":"\u0130leti\u015fim numaras\u0131:","country":"\u00dclke","custom":"Gelenek","de_active":"Devre D\u0131\u015f\u0131 B\u0131rak","default_language":"Varsay\u0131lan dil","delete":"Silmek","deleted":"Silindi!","details":"Ayr\u0131nt\u0131lar","discard":"At","doctor_required":"Doktor alan\u0131 zorunludur.","download":"\u0130ndirmek","edit":"D\u00fczenle","email_already_exist":"E-posta zaten abone oldu.","email_max":"Maksimum e-posta boyutu 255'tir.","email_not_register":"E-posta kay\u0131tl\u0131 de\u011fil.","email_regex":"E-posta alan\u0131 ge\u00e7erli bir bi\u00e7imde olmal\u0131d\u0131r.","email_required":"E-posta alan\u0131 gereklidir.","email_verified":"E-posta Do\u011fruland\u0131","error":"hata","filter":"Filtre","filter_option":"Filtre Se\u00e7ene\u011fi","first_name_required":"Ad alan\u0131 zorunludur.","forgot_your_password":"Parolan\u0131z\u0131 m\u0131 unuttunuz","from":"\u0130tibaren","google_captcha_required":"Google captcha alan\u0131 gereklidir.","has_been":"silindi.","has_cancel":" iptal edildi.","hour":"Saat","impersonate":"kimli\u011fine b\u00fcr\u00fcnmek","instagram_url":"Instagram URL'si","last_name_required":"Soyad\u0131 alan\u0131 zorunludur.","linkedin_url":"Linkedin URL'si","logout":"\u00c7\u0131k\u0131\u015f Yap","maximum_55":"Maksimum 55 karaktere izin verilir.","message_required":"Mesaj alan\u0131 zorunludur.","minutes":"dakika","n\/a":"N\/A","name":"Ad","name_already_taken":"\u0130sim zaten al\u0131nm\u0131\u015f","name_required":"Ad alan\u0131 zorunludur","no":"Hay\u0131r, \u0130ptal","no_data_available":"Veri Yok","no_data_available_in_table":"Tabloda veri yok","no_records_found":"Kay\u0131t bulunamad\u0131.","not_allow__assess_record":"G\u00f6r\u00fcn\u00fc\u015fe g\u00f6re bu kayda eri\u015fmenize izin verilmiyor.","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"Not: Takvimde randevu olu\u015ftururken doktorlar\u0131n\u0131z\u0131n saat dilimini al\u0131yoruz. Doktor saat dilimini ayarlamad\u0131ysa, varsay\u0131lan UTC saat dilimini alacakt\u0131r.","note_white_space":"Not alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","observation_white_space":"G\u00f6zlem alan\u0131 yaln\u0131zca beyaz bo\u015fluk i\u00e7ermiyor","of":"ile ilgili","overview":"Genel Bak\u0131\u015f","payment_type_required":"\u00d6deme Y\u00f6ntemi alan\u0131 zorunludur.","please_wait":"L\u00fctfen bekleyin...","prescription_report":"Re\u00e7ete Raporu","problem_white_space":"Sorun alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","processing":"\u0130\u015fleme..","purchase_price":"Al\u0131\u015f fiyat\u0131","read":"Okumak","remember_me":"Beni Hat\u0131rla","resend_verification_email":"Do\u011frulama e-postas\u0131n\u0131 tekrar g\u00f6nder","reset":"S\u0131f\u0131rla","reset_password":"\u015eifreyi yenile","results":"sonu\u00e7lar","save":"Kaydet","search":"Arama","select_brand":"Marka Se\u00e7iniz","select_category":"Kategori se\u00e7","select_city":"\u015eehir se\u00e7","select_country":"\u00dclke Se\u00e7","select_doctor":"Doktor Se\u00e7","select_service":"Hizmet Se\u00e7","select_state":"Devlet Se\u00e7","service":"Hizmet","service_required":"Hizmetler alan\u0131 zorunludur.","show":"G\u00f6stermek","showing":"G\u00f6sterilen","state":"Devlet","subject_required":"Konu alan\u0131 zorunludur.","submit":"G\u00f6nder","to":"ile","twitter_url":"Twitter URL'si","unread":"Okunmam\u0131\u015f","verify_lable1":"\u00dcye oldu\u011funuz i\u00e7in te\u015fekk\u00fcrler! Ba\u015flamadan \u00f6nce, size az \u00f6nce e-postayla g\u00f6nderdi\u011fimiz ba\u011flant\u0131ya t\u0131klayarak e-posta adresinizi do\u011frulayabilir misiniz? E-postay\u0131 almad\u0131ysan\u0131z, size memnuniyetle ba\u015fka bir e-posta g\u00f6ndeririz.","verify_lable2":"Kay\u0131t s\u0131ras\u0131nda verdi\u011finiz e-posta adresine yeni bir do\u011frulama ba\u011flant\u0131s\u0131 g\u00f6nderildi.","view":"g\u00f6r\u00fc\u015f","years":"Y\u0131llar","yes":"Evet, Sil!","yes_update":"Evet, G\u00fcncelle!","zoom_credentials":"L\u00fctfen yak\u0131nla\u015ft\u0131rma kimlik bilgilerini ekleyin."},"countries":"\u00dclkeler","country":{"add_country":"\u00dclke Ekle","country":"\u00dclke","short_code":"K\u0131sa Kod"},"currencies":"Para birimleri","currency":{"add_currency":"Para Birimi Ekle","add_currency_code_as_per_three_letter_iso_code":"\u00dc\u00e7 harfli ISO koduna g\u00f6re para birimi kodu ekleyin","currency_code":"Para Birimi Kodu","currency_icon":"Para Birimi Simgesi","currency_name":"Para Birimi Ad\u0131","edit_currency":"Para Birimi D\u00fczenle","name":"Ad","you_can_find_out_here":"buradan \u00f6\u011frenebilirsin"},"cvv_invalid.":"CVV ge\u00e7ersiz.","cvv_number_required.":"CVV numaras\u0131 alanlar\u0131n\u0131n doldurulmas\u0131 zorunludur.","dashboard":"G\u00f6sterge Tablosu","datepicker":{"last_30_days":"Son 30 g\u00fcn","last_month":"Ge\u00e7en ay","last_week":"Ge\u00e7en hafta","this_month":"Bu ay","this_week":"Bu hafta","today":"Bug\u00fcn","yesterday":"D\u00fcn"},"doctor":{"add":"Doktor Ekle","add_qualification":"Kalifikasyon Ekle","address1":"Adres 1","address2":"Adres 2","address_information":"Adres Bilgileri","allowed_img":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","city":"\u015eehir","collage_university":"KOLAJ\/\u00dcN\u0130VERS\u0130TE","country":"\u00dclke","created_at":"Olu\u015fturma Tarihi","degree":"Derece","dob":"DOB","doctor":"Doktor","doctor_detail":"Doktor Ayr\u0131nt\u0131lar\u0131","edit":"Doktoru D\u00fczenle","experience":"Y\u0131l \u0130\u00e7inde Tecr\u00fcbe","female":"Kad\u0131n","first_name":"Ad","instagram":"Instagram","last_name":"Soyad\u0131","linkedin":"Linkedin","male":"Erkek","passout_year":"Passout Y\u0131l\u0131","postal_code":"Posta Kodu","profile":"Profil","qualification":"Vas\u0131f","qualification_information":"Yeterlilik Bilgileri","select_blood_group":"Kan Grubu Se\u00e7in","select_date":"Tarih se\u00e7","select_doctors":"Doktorlar\u0131 Se\u00e7in","select_gender":"Cinsiyet Se\u00e7","select_year":"Y\u0131l Se\u00e7","specialization":"Uzmanl\u0131k","sr_no":"SR HAYIR","state":"Devlet","status":"Durum","twitter":"Twitter","university":"\u00dcniversite","updated_at":"G\u00fcncelleme Tarihi","year":"Y\u0131l"},"doctor_appointment":{"amount":"Miktar","from_time":"Zamandan","patient":"Hasta","service":"Hizmet","to_time":"Zamana Kadar"},"doctor_appointments":"Doktor Randevular\u0131","doctor_dashboard":{"recent_appointments":"Son Randevular","total_appointments":"Toplam Randevu"},"doctor_session":{"add":"Doktor Takvimi Ekle","all":"T\u00fcm\u00fc","copy":"Kopyala","doctor":"Doktor","doctor_session":"Doktor Program\u0131","doctor_session_details":"Doktor Program\u0131 Detaylar\u0131","edit":"Doktor Program\u0131n\u0131 D\u00fczenle","evening_session":"Ak\u015fam Program\u0131","friday":"Cuma","gap_between_appointment":"Randevu Aras\u0131ndaki Bo\u015fluk","monday":"Pazartesi","morning_session":"Sabah Program\u0131","my_schedule":"Program\u0131m","saturday":"Cumartesi","select_meeting_time":"Toplant\u0131 saatini se\u00e7in","select_session_gap":"Program bo\u015flu\u011funu se\u00e7in","session":"Oturum","session_gap":"Zamanlama Bo\u015flu\u011fu","session_meeting_time":"Toplant\u0131 Zaman\u0131n\u0131 Planla","session_time_in_minutes":"Toplant\u0131 Zaman\u0131n\u0131 Planla","sunday":"Pazar","thursday":"Per\u015fembe","tuesday":"Sal\u0131","unavailable":"Kullan\u0131m d\u0131\u015f\u0131","wednesday":"\u00c7ar\u015famba","week_days":"Hafta G\u00fcnleri"},"doctor_sessions":"Doktor Programlar\u0131","doctors":"Doktorlar","doctors_scheduled_time_ended_for_today__":"Doktorun planlanan saati bug\u00fcn bitti, l\u00fctfen farkl\u0131 bir doktor veya tarih se\u00e7in","email_password_reset_link":"E-posta \u015fifresini s\u0131f\u0131rlama ba\u011flant\u0131s\u0131","enquiries":"Sorgular","expiration_month_required":"Son kullanma ay\u0131 alanlar\u0131 zorunludur.","expiration_year_required":"Son kullanma y\u0131l\u0131 alanlar\u0131 zorunludur.","faq":{"add_faq":"SSS Ekle","answer":"Cevap","edit_faq":"SSS'yi D\u00fczenle","question":"Soru"},"faqs":"SSS","filter":{"active":"Aktif","all":"Her\u015fey","awaited":"Beklenen","booked":"Rezerve edildi","cancelled":"\u0130ptal edildi","check in":"Giri\u015f","check out":"\u00d6deme","deactive":"Devre d\u0131\u015f\u0131 b\u0131rakmak","finished":"Bitti","paid":"Paral\u0131","pending":"Ask\u0131da olmas\u0131","read":"Okumak","unread":"Okunmam\u0131\u015f"},"filter_success":"filtre ba\u015far\u0131s\u0131","flash":{"about_image_validation_message":"Hakk\u0131nda resmi \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","about_us_create":"Hakk\u0131m\u0131zda ba\u015far\u0131yla kaydedildi.","all_notification_read":"T\u00fcm Bildirimler ba\u015far\u0131yla okundu.","appointment_booked":"Randevu ba\u015far\u0131yla al\u0131nd\u0131","appointment_cancel":"Randevu \u0130ptal Edildi.","appointment_create":"Randevu ba\u015far\u0131yla olu\u015fturuldu.","appointment_created_payment_complete":"Randevu ba\u015far\u0131yla olu\u015fturuldu ve \u00d6deme tamamland\u0131.","appointment_created_payment_not_complete":"Randevu ba\u015far\u0131yla olu\u015fturuldu ve \u00d6deme tamamlanmad\u0131.","appointment_delete":"Randevu ba\u015far\u0131yla silindi.","appointment_not_found":"Randevu bulunamad\u0131","appointment_retrieve":"Randevu takvimi verileri ba\u015far\u0131yla al\u0131nd\u0131.","calender_added":"Takvim Ba\u015far\u0131yla Eklendi.","cat_retrieve":"Kategori ba\u015far\u0131yla al\u0131nd\u0131.","cities_retrieve":"\u015eehirler ba\u015far\u0131yla al\u0131nd\u0131","city_create":"\u015eehir ba\u015far\u0131yla olu\u015fturuldu.","city_delete":"\u015eehir ba\u015far\u0131yla silindi.","city_retrieved":"\u015eehir ba\u015far\u0131yla al\u0131nd\u0131.","city_update":"\u015eehir ba\u015far\u0131yla g\u00fcncellendi.","city_used":"\u015eehir ba\u015fka bir yerde kullan\u0131l\u0131yor.","clinic_delete":"ClinicSchedule ba\u015far\u0131yla silindi.","clinic_save":"Klinik Program\u0131 ba\u015far\u0131yla kaydedildi.","cms_update":"CMS ba\u015far\u0131yla g\u00fcncellendi.","country_create":"\u00dclke ba\u015far\u0131yla olu\u015fturuldu.","country_delete":"\u00dclke ba\u015far\u0131yla silindi.","country_update":"\u00dclke ba\u015far\u0131yla g\u00fcncellendi.","country_used":"\u00dclke ba\u015fka bir yerde kullan\u0131ld\u0131.","create_blog":"VCard blogu ba\u015far\u0131yla olu\u015fturuldu.","create_front_testimonial":"G\u00f6r\u00fc\u015f ba\u015far\u0131yla olu\u015fturuldu.","currency_create":"Para birimi ba\u015far\u0131yla olu\u015fturuldu.","currency_delete":"Para birimi ba\u015far\u0131yla silindi.","currency_update":"Para birimi ba\u015far\u0131yla g\u00fcncellendi.","currency_used":"Para birimi ba\u015fka bir yerde kullan\u0131l\u0131yor.","current_invalid":"Mevcut \u015fifre ge\u00e7ersiz.","data_retrieve":"Veriler Ba\u015far\u0131yla Al\u0131nd\u0131.","default_role_not_delete":"Varsay\u0131lan rol silinmez.","degree_required":"Derece alan\u0131 zorunludur.","doctor_appointment":"Doktor Randevu takvimi verileri ba\u015far\u0131yla al\u0131nd\u0131.","doctor_create":"Doktor ba\u015far\u0131yla olu\u015fturuldu.","doctor_delete":"Doktor ba\u015far\u0131yla silindi.","doctor_holiday":"Doktor Tatili ba\u015far\u0131yla olu\u015fturuldu","doctor_not_available":"Doktor m\u00fcsait de\u011fil","doctor_session_not_found":"Doktor Oturumu bulunamad\u0131.","doctor_update":"Doktor ba\u015far\u0131yla g\u00fcncellendi.","doctor_use":"Doktor ba\u015far\u0131yla kullan\u0131ld\u0131.","email_notification":"E-posta bildirimi ba\u015far\u0131yla g\u00fcncellendi.","email_send":"E-posta ba\u015far\u0131yla g\u00f6nderildi.","enquire_deleted":"Sorgu ba\u015far\u0131yla silindi.","enquire_sent":"Soru\u015fturma Ba\u015far\u0131yla G\u00f6nderildi","faq_creat":"SSS ba\u015far\u0131yla olu\u015fturuldu.","faq_delete":"SSS ba\u015far\u0131yla silindi.","faq_update":"SSS ba\u015far\u0131yla g\u00fcncellendi.","faq_use":"Bu SSS ba\u015fka bir yerde kullan\u0131ld\u0131.","favicon_validation_message":"Site simgesi \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","feature_update":"\u00d6zellik ba\u015far\u0131yla g\u00fcncellendi.","google_calendar_connect":"Google Takviminiz \u015fimdi ba\u011fland\u0131.","google_calendar_disconnect":"Google Takvim ba\u011flant\u0131s\u0131 ba\u015far\u0131yla kesildi.","google_calendar_update":"Google Takviminiz ba\u015far\u0131yla g\u00fcncellendi.","holiday_already_is_exist":"Bu tarih i\u00e7in tatil zaten var","icon_validation_message":"Simge \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png, svg.","language_change":"Dil ba\u015far\u0131yla de\u011fi\u015ftirildi","language_update":"Dil ba\u015far\u0131yla g\u00fcncellendi.","live_consultation_delete":"Canl\u0131 Dan\u0131\u015fma ba\u015far\u0131yla silindi.","live_consultation_retrieved":"Canl\u0131 Dan\u0131\u015fma ba\u015far\u0131yla al\u0131nd\u0131.","live_consultation_save":"Canl\u0131 Dan\u0131\u015fma ba\u015far\u0131yla kaydedildi.","live_consultation_update":"Canl\u0131 Dan\u0131\u015fma ba\u015far\u0131yla g\u00fcncellendi.","logo_validation_message":"Uygulama logosu \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","maximum_char":"Maksimum 60 karaktere izin verilir.","messages_sent":"Mesaj ba\u015far\u0131yla g\u00f6nderildi","no_available_slots":"Belirtilen tarihte bo\u015f yer yok.","note_added":"Not ba\u015far\u0131yla eklendi.","note_delete":"Not ba\u015far\u0131yla silindi.","notification_read":"Bildirim ba\u015far\u0131yla okundu.","notification_send":"E-posta do\u011frulama bildirimi ba\u015far\u0131yla g\u00f6nderildi.","observation_added":"G\u00f6zlem ba\u015far\u0131yla eklendi.","observation_delete":"G\u00f6zlem ba\u015far\u0131yla silindi.","operation_performed_success":"\u0130\u015flem ba\u015far\u0131yla ger\u00e7ekle\u015ftirildi","order_create":"Sipari\u015f ba\u015far\u0131yla olu\u015fturuldu.","password_update":"\u015eifre ba\u015far\u0131yla g\u00fcncellendi.","patient_appointment":"Hasta Randevu takvimi verileri ba\u015far\u0131yla al\u0131nd\u0131.","patient_create":"Hasta ba\u015far\u0131yla olu\u015fturuldu.","patient_delete":"Hasta ba\u015far\u0131yla silindi.","patient_not_found":"Hasta bulunamad\u0131.","patient_update":"Hasta ba\u015far\u0131yla g\u00fcncellendi.","patient_used":"Hasta ba\u015fka bir yerde kulland\u0131.","patients_retrieve":"Hastalar ba\u015far\u0131yla al\u0131nd\u0131.","payment_status_updated":"\u00d6deme durumu ba\u015far\u0131yla g\u00fcncellendi.","paystack_token_expired":"\u00d6deme jetonunun s\u00fcresi doldu. L\u00fctfen sayfay\u0131 yenileyin ve tekrar deneyin.","plan_default":"Varsay\u0131lan plan ba\u015far\u0131yla de\u011fi\u015ftirildi.","plan_status":"Plan durumu ba\u015far\u0131yla g\u00fcncellendi","plan_update":"Plan ba\u015far\u0131yla g\u00fcncellendi.","prescription_delete":"Re\u00e7ete ba\u015far\u0131yla silindi.","prescription_retrieved":"Re\u00e7ete ba\u015far\u0131yla al\u0131nd\u0131.","problem_added":"Sorun ba\u015far\u0131yla eklendi.","problem_delete":"Sorun ba\u015far\u0131yla silindi.","profile_validation_message":"Profil \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","qualification_create":"Kalifikasyon ba\u015far\u0131yla olu\u015fturuldu.","reactive_account":"Hesab\u0131n\u0131z\u0131 postadan yeniden etkinle\u015ftirin.","retrieve":"Ba\u015far\u0131yla al\u0131nd\u0131.","review_add":"Eklemeyi ba\u015far\u0131yla g\u00f6zden ge\u00e7irin.","review_edit":"\u0130nceleme ba\u015far\u0131yla d\u00fczenlendi.","review_retrieved":"\u0130nceleme ba\u015far\u0131yla al\u0131nd\u0131.","role_create":"Rol ba\u015far\u0131yla olu\u015fturuldu.","role_delete":"Rol ba\u015far\u0131yla silindi.","role_update":"Rol ba\u015far\u0131yla g\u00fcncellendi.","schedule_crete":"Program ba\u015far\u0131yla olu\u015fturuldu.","schedule_delete":"Program ba\u015far\u0131yla silindi.","schedule_not_found":"Program bulunamad\u0131.","schedule_update":"Program ba\u015far\u0131yla g\u00fcncellendi.","select_calendar.":"L\u00fctfen bir takvim se\u00e7in.","select_payment":"L\u00fctfen herhangi bir \u00d6deme Y\u00f6ntemi se\u00e7in","service_cat_create":"Hizmet kategorisi ba\u015far\u0131yla olu\u015fturuldu.","service_cat_delete":"Hizmet kategorisi ba\u015far\u0131yla silindi.","service_cat_update":"Hizmet kategorisi ba\u015far\u0131yla g\u00fcncellendi.","service_cat_use":"Hizmet kategorisi ba\u015fka bir yerde kullan\u0131l\u0131yor.","service_create":"Hizmet ba\u015far\u0131yla olu\u015fturuldu.","service_delete":"Hizmet ba\u015far\u0131yla silindi.","service_update":"Hizmet ba\u015far\u0131yla g\u00fcncellendi.","service_use":"Hizmet ba\u015fka bir yerde kullan\u0131ld\u0131.","session_retrieve":"Oturum ba\u015far\u0131yla al\u0131nd\u0131.","setting_update":"Ayarlar ba\u015far\u0131yla g\u00fcncellendi.","slider_update":"Kayd\u0131r\u0131c\u0131 ba\u015far\u0131yla g\u00fcncellendi","some_doctors":"Baz\u0131 doktorlar g\u00fcnlerini kontrol edilmeyen g\u00fcnlere ayarlam\u0131\u015f, yani bu ameliyat\u0131 yapmak istedi\u011finizden emin misiniz?","something_went_wrong":"Bir \u015feyler yanl\u0131\u015f gitti","specialization_create":"Uzmanl\u0131k ba\u015far\u0131yla olu\u015fturuldu.","specialization_delete":"Uzmanl\u0131k ba\u015far\u0131yla silindi.","specialization_update":"Uzmanl\u0131k ba\u015far\u0131yla g\u00fcncellendi.","specialization_use":"Uzmanl\u0131k ba\u015far\u0131yla kullan\u0131ld\u0131.","staff_create":"Personel ba\u015far\u0131yla olu\u015fturuldu.","staff_delete":"Personel ba\u015far\u0131yla silindi.","staff_update":"Personel ba\u015far\u0131yla g\u00fcncellendi.","staff_use":"Personel ba\u015far\u0131yla kullan\u0131ld\u0131.","state_create":"Devlet ba\u015far\u0131yla olu\u015fturuldu.","state_delete":"Durum ba\u015far\u0131yla g\u00fcncellendi.","state_update":"Durum ba\u015far\u0131yla silindi.","state_use":"Devlet ba\u015fka bir yerde kullan\u0131ld\u0131.","states_retrieve":"Durumlar ba\u015far\u0131yla al\u0131nd\u0131.","status_change":"Durum ba\u015far\u0131yla de\u011fi\u015ftirildi.","status_update":"Durum ba\u015far\u0131yla g\u00fcncellendi.","subscriber_creat":"Abone ba\u015far\u0131yla olu\u015fturuldu.","subscriber_delete":"Abone ba\u015far\u0131yla silindi.","testimonial_creat":"\u00d6n Hasta G\u00f6r\u00fc\u015f\u00fc ba\u015far\u0131yla olu\u015fturuldu.","testimonial_delete":"\u00d6n Hasta G\u00f6r\u00fc\u015f\u00fc ba\u015far\u0131yla silindi.","testimonial_update":"\u00d6n Hasta G\u00f6r\u00fc\u015fleri ba\u015far\u0131yla g\u00fcncellendi.","testimonial_use":"\u00d6n Hasta G\u00f6r\u00fc\u015f\u00fc ba\u015far\u0131yla kullan\u0131ld\u0131.","theme_change":"Tema Ba\u015far\u0131yla De\u011fi\u015ftirildi.","there_were":"\u00d6deme ile ilgili baz\u0131 sorunlar vard\u0131. L\u00fctfen daha sonra tekrar deneyiniz.","university_required":"\u00dcniversite gerekli.","update_blog":"VCard blogu ba\u015far\u0131yla g\u00fcncellendi.","update_front_testimonial":"G\u00f6r\u00fc\u015f ba\u015far\u0131yla g\u00fcncellendi.","user_8_or":"Harf, say\u0131 ve simge kar\u0131\u015f\u0131m\u0131yla 6 veya daha fazla karakter kullan\u0131n.","user_already_verified":"Kullan\u0131c\u0131n\u0131n zaten Do\u011frulanm\u0131\u015f e-postas\u0131 var.","user_profile":"Kullan\u0131c\u0131 profili ba\u015far\u0131yla g\u00fcncellendi.","user_profile_update":"Kullan\u0131c\u0131 profili ba\u015far\u0131yla g\u00fcncellendi.","user_role_not_delete":"Bu kullan\u0131c\u0131 rol\u00fc, bir kullan\u0131c\u0131ya atand\u0131\u011f\u0131 i\u00e7in silinemedi.","user_status":"Kullan\u0131c\u0131 durumu ba\u015far\u0131yla g\u00fcncellendi","user_update":"Kullan\u0131c\u0131 ba\u015far\u0131yla g\u00fcncellendi.","user_zoom_credential_saved":"Kullan\u0131c\u0131 Yak\u0131nla\u015ft\u0131rma Kimlik Bilgileri ba\u015far\u0131yla kaydedildi.","valid_instagram":"L\u00fctfen ge\u00e7erli bir Instagram URL'si girin","valid_linkedin":"L\u00fctfen ge\u00e7erli bir Linkedin URL'si girin","valid_twitter":"L\u00fctfen ge\u00e7erli bir Twitter URL'si girin","verified_email":"E-posta ba\u015far\u0131yla do\u011fruland\u0131.","visit_create":"Ziyaret ba\u015far\u0131yla olu\u015fturuldu.","visit_delete":"Silme i\u015flemini ba\u015far\u0131yla ziyaret edin.","visit_prescription_added":"Ziyaret Re\u00e7etesi ba\u015far\u0131yla eklendi.","visit_prescription_update":"Ziyaret Re\u00e7etesi ba\u015far\u0131yla g\u00fcncellendi.","visit_update":"Ziyaret ba\u015far\u0131yla g\u00fcncellendi.","year_required":"Y\u0131l gerekli.","your_reg_success":"Kayd\u0131n\u0131z ba\u015far\u0131yla tamamland\u0131.L\u00fctfen hesab\u0131n\u0131z\u0131 e-postadan do\u011frulay\u0131n."},"front_cms":"\u00d6n CMS","front_medical_service":{"add_front_medical_service":"\u00d6n Sa\u011fl\u0131k Hizmeti Ekle","edit_front_medical_service":"\u00d6n Sa\u011fl\u0131k Hizmetini D\u00fczenle","short_description":"K\u0131sa A\u00e7\u0131klama","title":"Ba\u015fl\u0131k"},"front_medical_services":"\u00d6n Sa\u011fl\u0131k Hizmetleri","front_patient_testimonial":{"add_front_patient_testimonial":"\u00d6n Hasta G\u00f6r\u00fc\u015f\u00fc Ekle","designation":"Tan\u0131mlama","edit_front_patient_testimonial":"\u00d6n Hasta G\u00f6r\u00fc\u015flerini D\u00fczenle","more_patient_feedbacks":"Daha Fazla Hasta Geri Bildirimi...","name":"Ad","patient_testimonials":"Hasta G\u00f6r\u00fc\u015fleri","profile":"Profil","short_description":"K\u0131sa A\u00e7\u0131klama"},"front_patient_testimonials":"\u00d6n Hasta G\u00f6r\u00fc\u015fleri","front_service":{"add_front_service":"\u00d6n Hizmet Ekle","edit_front_service":"\u00d6n Hizmeti D\u00fczenle","icon":"Simge","short_description":"K\u0131sa A\u00e7\u0131klama","title":"Ba\u015fl\u0131k"},"front_services":"\u00d6n Hizmetler","holder_name_invalid":"Kart sahibinin ad\u0131 Ge\u00e7ersiz.","holder_name_required":"Kart sahibi ad\u0131 alanlar\u0131n\u0131n doldurulmas\u0131 zorunludur.","holder_number_invalid":"Kart numaras\u0131 alanlar\u0131n\u0131n doldurulmas\u0131 zorunludur.","holiday":{"add_holiday":"Tatil Ekle","doctor_holiday":"Doktor Tatilleri","holiday":"Tatil","holiday_date":"Tatil Tarihi","service_category":"Hizmet Kategorisi"},"icon_size":"Simge boyutu 2 MB'tan k\u00fc\u00e7\u00fck olmal\u0131d\u0131r","id":"\u0130D","image_file_type":"Resim \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpeg, jpg, png.","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz numara","invalid_range":"Ge\u00e7ersiz aral\u0131k","live_consultation":{"add_credential":"Kimlik Bilgisi Ekle","add_live_consultation":"Canl\u0131 Dan\u0131\u015fma Ekle","awaited":"Beklenen","client_video":"M\u00fc\u015fteri Videosu","consultation_date":"Dan\u0131\u015fma Tarihi","consultation_duration_minutes":"Dan\u0131\u015fma S\u00fcresi Dakikalar\u0131","consultation_minutes":"Dan\u0131\u015fma Tutanaklar\u0131","consultation_title":"Dan\u0131\u015fma Ba\u015fl\u0131\u011f\u0131","created_by":"Taraf\u0131ndan yarat\u0131ld\u0131","created_for":"\u0130\u00e7in Yarat\u0131ld\u0131","description":"Tan\u0131m","disabled":"Engelli","duration":"S\u00fcre (dakika olarak)","edit_live_consultation":"Canl\u0131 Dan\u0131\u015fmay\u0131 D\u00fczenle","edit_live_meeting":"Canl\u0131 Toplant\u0131y\u0131 D\u00fczenle","enable":"Olanak vermek","finished":"bitmi\u015f","host_video":"Videoyu Bar\u0131nd\u0131r","join_now":"\u015eimdi Kat\u0131l","live_consultation_details":"Canl\u0131 Dan\u0131\u015fma Detaylar\u0131","new_live_consultation":"Yeni Canl\u0131 Dan\u0131\u015fma","new_live_meeting":"Yeni Canl\u0131 Toplant\u0131","select_consultation_date":"Dan\u0131\u015fma Tarihi Se\u00e7","select_doctor_name":"Doktor Ad\u0131 Se\u00e7in","select_patient_name":"Hasta Ad\u0131n\u0131 Se\u00e7","staff_list":"Personel listesi","start_now":"\u015eimdi ba\u015fla","type":"Tip","type_number":"Numara giriniz","zoom_api_key":"Yak\u0131nla\u015ft\u0131rma API Anahtar\u0131","zoom_api_secret":"Yak\u0131nla\u015ft\u0131rma API S\u0131rr\u0131"},"live_consultations":"Canl\u0131 Kons\u00fcltasyonlar","live_status_retrieved_successfully.":"Canl\u0131 Durum ba\u015far\u0131yla al\u0131nd\u0131.","login":"Giri\u015f","medicine":{"available_quantity":"Mevcut Miktar\u0131","brand":"Marka","brand_name":"Marka ad\u0131","buying_price":"Al\u0131m fiyati","cant_be_deleted":"silinemez","category":"Kategori","category_id":"Kimlik kategorisi","category_retrieved_successfully":"\u0130la\u00e7 kategorisi ba\u015far\u0131yla al\u0131nd\u0131.","deleted_successfully":"ba\u015far\u0131yla silindi","description":"Tan\u0131m","dosage":"Dozaj","dose_interval":"Doz Aral\u0131\u011f\u0131n\u0131 Se\u00e7in","duration":"S\u00fcre","edit_medicine":"\u0130lac\u0131 D\u00fczenle","edit_medicine_brand":"\u0130la\u00e7 Markas\u0131n\u0131 D\u00fczenle","edit_medicine_category":"\u0130la\u00e7 Kategorisini D\u00fczenle","filter_options":"Filtre se\u00e7enekleri","medicine":"\u0130la\u00e7","medicine_brands":"\u0130la\u00e7 Markalar\u0131","medicine_brands_details":"\u0130la\u00e7 Markas\u0131 Ayr\u0131nt\u0131lar\u0131","medicine_category":"\u0130la\u00e7 Kategorisi","medicine_category_details":"\u0130la\u00e7 Kategorisi Ayr\u0131nt\u0131lar\u0131","medicine_details":"\u0130la\u00e7 Detaylar\u0131","medicine_name":"\u0130la\u00e7 Ad\u0131","medicine_retrieved_successfully":"\u0130la\u00e7 Ba\u015far\u0131yla Al\u0131nd\u0131","medicines":"\u0130la\u00e7lar","name":"\u0130sim","new_brand":"Yeni marka","new_medicine":"Yeni T\u0131p","new_medicine_brand":"Yeni \u0130la\u00e7 Markas\u0131","new_medicine_category":"Yeni \u0130la\u00e7 Kategorisi","no_use":"Kullan\u0131mda de\u011fil","quantity":"Miktar","salt_composition":"Tuz Bile\u015fimi","saved_successfully":"Ba\u015far\u0131yla kaydedildi","select_duration":"S\u00fcreyi Se\u00e7in","selling_price":"Sat\u0131\u015f fiyat\u0131","side_effects":"Yan etkiler","status_updated_successfully":"Durum ba\u015far\u0131yla g\u00fcncellendi.","updated_successfully":"ba\u015far\u0131yla g\u00fcncellendi"},"medicine_bills":{"add_medicine_bill":"\u0130la\u00e7 Faturas\u0131 Ekle","available_quantity":"Mevcut miktar","avl_qty":"Avl Adet","bill_date":"Fatura tarihi","bill_id":"fatura kimli\u011fi","bill_number":"Fatura numaras\u0131","cell_no":"Telefon numaras\u0131","dose_interval":"Doz Aral\u0131\u011f\u0131","duplicate_medicine":"Yinelenen ila\u00e7lar eklenemez.","edit_medicine_bill":"\u0130la\u00e7 Faturas\u0131n\u0131 D\u00fczenle","enter_lot_number":"Parti numaras\u0131n\u0131 girin.","enter_puchase_price":"Sat\u0131n alma fiyat\u0131n\u0131 girin","enter_sale_price":"Sat\u0131\u015f fiyat\u0131n\u0131 girin.","is":"d\u0131r-dir","item_name":"\u00d6\u011fe ad\u0131","medicine_bill":"\u0130la\u00e7 Faturas\u0131","medicine_bill_details":"\u0130la\u00e7 Faturas\u0131 ayr\u0131nt\u0131lar\u0131","medicine_bills":"\u0130la\u00e7 Faturalar\u0131","medicine_not_selected":"L\u00fctfen en az bir ila\u00e7 se\u00e7iniz.","medicine_required":"T\u0131p alan\u0131 zorunludur.","net_amount_cant":"Net tutar bo\u015f olamaz.","net_amount_cant_zero":"Net tutar s\u0131f\u0131r olamaz.","net_amount_not_empty":"Net tutar bo\u015f b\u0131rak\u0131lamaz.","net_amount_not_zero":"Net tutar s\u0131f\u0131r olamaz.","new_medicine_bill":"Yeni \u0130la\u00e7 Yasas\u0131","payment_status":"\u00d6deme Durumu","payment_type":"\u00d6deme t\u00fcr\u00fc","prescription_not_found":"re\u00e7ete bulunamad\u0131","price":"Fiyat","print_bill":"Faturay\u0131 Yazd\u0131r","quantity_should":"Mukdary 0-dan uly bolmaly.","sale_price":"Sat\u0131\u015f \u00fccreti","select_medicine":"T\u0131p Se\u00e7in","select_patient":"Hasta Se\u00e7","select_payment_type":"\u00d6deme T\u00fcr\u00fcn\u00fc Se\u00e7in","tax_amt":"Vergi tutar\u0131 s\u0131f\u0131r veya bo\u015f olamaz.","tax_cannot_be_zero_empty":"Vergi tutar\u0131 s\u0131f\u0131r veya bo\u015f olamaz.","tax_should_be":"Vergiler %100\"den az olmal\u0131d\u0131r..","the_discount_shoul":"\u0130ndirim toplam tutardan az olmal\u0131d\u0131r","the_medicine_already_in_use":"Bu ila\u00e7 zaten ila\u00e7 faturalar\u0131nda kullan\u0131l\u0131yor, silmek istedi\u011finizden emin misiniz?","update_quantity":"G\u00fcncelleme miktar\u0131 \u00f6nceki miktardan az olmal\u0131d\u0131r."},"medicine_brands":"\u0130la\u00e7 Markalar\u0131","medicine_categories":"\u0130la\u00e7 Kategorileri","medicines":"\u0130la\u00e7lar","mobile_no":"Telefon numaras\u0131","months":{"apr":"Nisan","aug":"a\u011fustos","dec":"Aral\u0131k","feb":"\u015eubat","jan":"Ocak","jul":"Temmuz","jun":"Haziran","mar":"Mart","may":"May\u0131s","nov":"kas\u0131m","oct":"Ekim","sep":"Eyl\u00fcl"},"no_response":"Yan\u0131t verilmedi","not_supported":"desteklenmiyor","note":"Not: Google Takvim'i entegre etmeden \u00f6nce saat diliminizi ayarlaman\u0131z gerekir.","notification":{"mark_all_as_read":"T\u00fcm\u00fcn\u00fc Okundu Olarak \u0130\u015faretle","notification":"Bildirimler","you_don`t_have_any_new_notification":"Yeni bir bildiriminiz yok"},"patient":{"add":"Hasta Ekle","address1":"Adres 1","address2":"Adres 2","address_information":"Adres Bilgileri","blood_group":"Kan Grubu","city":"\u015eehir","confirm_password":"\u015eifreyi Onayla","contact_no":"\u0130leti\u015fim No","country":"\u00dclke","details":"Hasta Detaylar\u0131","dob":"DOB","edit":"Hastay\u0131 D\u00fczenle","email":"E-posta","emailverified":"E-posta Do\u011fruland\u0131","enter_email":"E-posta Girin","enter_password":"Parolan\u0131 Gir","female":"Kad\u0131n","filter":"filtre","first_name":"Ad","gender":"Cinsiyet","last_name":"Soyad\u0131","last_updated":"Son g\u00fcncelleme","male":"Erkek","name":"Ad","password":"\u015eifre","patient_unique_id":"\u00d6zg\u00fcn Hasta Kimli\u011fi","postal_code":"Posta Kodu","profile":"Profil","registered_on":"Kay\u0131t Tarihi","save_changes":"De\u011fi\u015fiklikleri Kaydet","state":"Devlet","today":"Bug\u00fcn"},"patient_dashboard":{"completed_appointments":"Tamamlanan Randevular","next_appointment":"Sonraki Randevular","today_appointments":"Bug\u00fcn Randevular\u0131","upcoming_appointments":"Yakla\u015fan Randevular"},"patients":"Hastalar","payment_detail":"\u00d6deme detaylar\u0131","payment_for_booking_appointment_with_doctor":"Doktor randevusu i\u00e7in \u00f6deme","payment_method":{"authorize":"Yetki vermek","paypal":"Paypal","paystack":"Pay y\u0131\u011f\u0131n\u0131","paytm":"Payt","razorpay":"Razorpay","stripe":"\u015eerit"},"paytm":"\u00f6deme","prescription":{"Rx":"Rx","accident":"Kaza","advice":"tavsiye","after meal":"apr\u00e8s manger","appointment_slot":"Randevu Aral\u0131klar\u0131","available_quantity_of":"Mevcut miktar ","before meal":"yemekten \u00f6nce","breast_feeding":"Emzirme","comment":"yorum","connect_with_zoom":" Zoom'a ba\u011flan\u0131n","current_medication":"Mevcut \u0130la\u00e7lar","days":"g\u00fcnler","diabetic":"\u015eeker hastas\u0131","doctor":"Doktor","dosage":"Dozaj","duration":"S\u00fcre","edit_prescription":"Re\u00e7eteyi D\u00fczenle","female_pregnancy":"Kad\u0131n Hamileli\u011fi","food_allergies":"Yiyecek alerjisi","frequency":"S\u0131kl\u0131k","health_insurance":"Sa\u011fl\u0131k Sigortas\u0131","heart_disease":"Kalp hastal\u0131\u011f\u0131","high_blood_pressure":"Y\u00fcksek tansiyon","is":"d\u0131r-dir","low_income":"D\u00fc\u015f\u00fck Gelir","medical_history":"T\u0131bbi ge\u00e7mi\u015f","medicine_name":"t\u0131p_ad\u0131","name":"Ad","new_medicine":"yeni ila\u00e7","new_prescription":"Yeni Re\u00e7ete","next_visit":"Bir sonraki ziyaret","not_add_duplicate_medicines":"Yinelenen ila\u00e7lar eklenemez.","ok":"Tamam","others":"Di\u011ferleri","patient":"Hasta","physical_information":"fiziksel bilgi","plus_rate":"nab\u0131z oran","prescription":"re\u00e7ete","prescription_details":"Re\u00e7ete Detaylar\u0131","prescription_saved":"Re\u00e7ete ba\u015far\u0131yla kaydedildi.","prescription_updated":"Re\u00e7ete ba\u015far\u0131yla g\u00fcncellendi.","prescriptions":"re\u00e7eteler","problem":"sorun","problem_description":"Sorun A\u00e7\u0131klamas\u0131","reference":"Referans","selectMedicine":"\u0130la\u00e7 se\u00e7in","surgery":"cerrahl\u0131k","temperature":"s\u0131cakl\u0131k","tendency_bleed":"E\u011filim Kanamas\u0131","test":"\u00d6l\u00e7ek","time":"zaman","total_quantity":"Toplam miktar"},"privacy_policy":"Gizlilik Politikas\u0131","purchase_medicine":{"actions":"Hareketler","amount":"Miktar","discount":"\u0130ndirim","dose_duration":"Doz S\u00fcresi","expiry_date":"Son kullanma tarihi","export_to_excel":"Excel'e Aktar","lot_no":"\u00c7ok yok.","net_amount":"Net tutar","note":"Not","other_details":"Di\u011fer detaylar","payment_mode":"\u00d6deme \u015fekli","payment_note":"\u00d6deme Notu","purchase_medicine":"\u0130la\u00e7 sat\u0131n al","purchase_medicine_details":"\u0130la\u00e7 Ayr\u0131nt\u0131lar\u0131n\u0131 Sat\u0131n Al\u0131n","purchase_medicine_overview":"\u0130la\u00e7 Sat\u0131n Almaya Genel Bak\u0131\u015f","purchase_medicines":"\u0130la\u00e7 sat\u0131n al","purchase_number":"Sat\u0131n alma numaras\u0131","purchased_medicine_success":"\u0130la\u00e7 ba\u015far\u0131yla sat\u0131n al\u0131nd\u0131","quantity":"Miktar","tax":"Vergi","tax_amount":"Vergi miktar\u0131","total":"Toplam"},"range_constructor_requires_trie_parameter":"Aral\u0131k yap\u0131c\u0131s\u0131 bir Trie parametresi gerektirir","register":"Kaydol","requires_string_parameter":"rangeWithString bir dize parametresi gerektirir","resend_email_verification":"E-posta Do\u011frulamay\u0131 Yeniden G\u00f6nder","review":{"add_review":"\u0130nceleme ekle","edit_review":"\u0130ncelemeyi D\u00fczenle","no_doctors_available_to_give_rating":"De\u011fer verecek Doktor yok.","review":"G\u00f6zden ge\u00e7irmek","write_a_review":"Bir de\u011ferlendirme yaz\u0131n"},"reviews":"yorumlar","role":{"add_role":"Rol Ekle","edit_role":"Rol\u00fc D\u00fczenle","permissions":"\u0130zinler","role":"Rol","role_permissions":"Rol \u0130zinleri","select_all_permissions":"T\u00fcm \u0130zinleri Se\u00e7"},"roles":"Roller","service":{"add_service":"Hizmet Ekle","category":"Kategori","charges":"\u00dccretler","edit_service":"Hizmeti D\u00fczenle","short_description":"K\u0131sa A\u00e7\u0131klama"},"service_categories":"Hizmet Kategorileri","service_category":{"add_category":"Hizmet Kategorisi Ekle","edit_category":"Hizmet Kategorisini D\u00fczenle","service_category":"Hizmet Kategorisi"},"services":"Hizmetler","setting":{"address":"Adres","change_app_logo":"Uygulama logosunu de\u011fi\u015ftir","change_favicon":"Favicon'u de\u011fi\u015ftir","clinic_name":"Klinik Ad\u0131","connect_google_calendar":"Google Takvim'i Ba\u011fla","connect_your_google_calendar":"Google Takviminizi ba\u011flay\u0131n","contact_information":"\u0130leti\u015fim Bilgileri","currency":"Para Birimi","currency_settings":"Para Birimi Ayarlar\u0131","default_country_code":"Varsay\u0131lan \u00dclke Kodu","default_language_suggest":"Bunu g\u00fcncelledi\u011finizde t\u00fcm uygulama dili doktor, hasta oturum a\u00e7ma i\u015flemleri ve \u00f6n tarafta de\u011fi\u015fecektir.","disconnect_your_google_calendar":"Google Takviminizin ba\u011flant\u0131s\u0131n\u0131 kesin","do_not_allow_to_login_without_email_verification":"E-posta do\u011frulamas\u0131 olmadan giri\u015f yap\u0131lmas\u0131na izin verme","favicon":"Favicon","general":"Genel","general_details":"Genel Detaylar","logo":"Logo","postal_code":"Posta Kodu","prefix":"\u00d6nek","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"Randevular\u0131 olu\u015fturmak istedi\u011finiz takvimlerinizi (Google Takvim'den) se\u00e7in","setting":"Ayar","specialities":"\u00d6zellikler","sync_your_google_calendar":"Google Takviminizi senkronize edin","when_checkbox_disable":"Onay kutusu devre d\u0131\u015f\u0131 b\u0131rak\u0131ld\u0131\u011f\u0131nda e-posta do\u011frulamas\u0131 yeni kullan\u0131c\u0131lar i\u00e7in \u00e7al\u0131\u015fm\u0131yor.","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"Hasta sizinle randevu ald\u0131\u011f\u0131nda, se\u00e7ilen takvimlerde yeni randevu olu\u015fturulacakt\u0131r.","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"Randevu ald\u0131\u011f\u0131n\u0131zda, se\u00e7ilen takvimlerde yeni randevu olu\u015fturulacakt\u0131r."},"settings":"Ayarlar","slider":{"add_slider":"Kayd\u0131r\u0131c\u0131 Ekle","edit_slider":"Kayd\u0131r\u0131c\u0131y\u0131 D\u00fczenle","image":"G\u00f6r\u00fcnt\u00fc","short_description":"K\u0131sa A\u00e7\u0131klama","title":"Ba\u015fl\u0131k"},"sliders":"Kayd\u0131r\u0131c\u0131lar","smart_patient_card":{"add_smart_card":"Ak\u0131ll\u0131 Kart Ekle","add_smart_card_templates":"Ak\u0131ll\u0131 Kart \u015eablonu Ekle","address_show":"Adres G\u00f6ster","blood_group_show":"Kan Grubu G\u00f6ster","dob_show":"Do\u011fum Tarihi G\u00f6ster","edit_patient_card":"Ak\u0131ll\u0131 Kart\u0131 D\u00fczenle","email_show":"E-posta G\u00f6ster","enter_template_name":"\u015eablon Ad\u0131n\u0131 Girin","for_all_patient":"T\u00fcm Hasta \u0130\u00e7in","generate_patient_card":"Hasta Kart\u0131 Olu\u015ftur","generate_patient_smart_cards":"Hasta Ak\u0131ll\u0131 Kartlar\u0131 Olu\u015ftur","header_color":"Ba\u015fl\u0131k Rengi","only_one_patient":"Sadece Bir Hasta \u0130\u00e7in","patient":"Hasta","patient_smart_card_created":"Hasta ak\u0131ll\u0131 kart\u0131 ba\u015far\u0131yla olu\u015fturuldu.","patient_smart_card_deleted":"Hasta ak\u0131ll\u0131 kart\u0131 ba\u015far\u0131yla silindi.","phone_show":"Telefon G\u00f6ster","please_selest_patient":"L\u00fctfen Hasta Se\u00e7iniz","remaning_patients":"Kalan Hasta","select_patient":"Hasta Se\u00e7","select_template":"\u015eablon Se\u00e7","smart_patient_card_templates":"Ak\u0131ll\u0131 Hasta Kart \u015eablonlar\u0131","smart_patient_cards":"Ak\u0131ll\u0131 Hasta Kartlar\u0131","templat_name":"\u015eablon Ad\u0131","template":"\u015eablon","template_created":"\u015eablon ba\u015far\u0131yla olu\u015fturuldu.","template_deleted":"\u015eablon ba\u015far\u0131yla silindi.","template_update":"\u015eablon g\u00fcncellemesi ba\u015far\u0131l\u0131.","type":"T\u00fcr","unique_id_show":"Benzersiz Kimlik G\u00f6ster"},"specialization":{"add_specialization":"Uzmanl\u0131k Ekle","edit_specialization":"Uzmanl\u0131\u011f\u0131 D\u00fczenle","retrieved_successfully":"Uzmanl\u0131k ba\u015far\u0131yla al\u0131nd\u0131."},"specializations":"Uzmanl\u0131klar","staff":{"add_staff":"Personel Ekle","confirm_password":"\u015eifreyi Onayla","contact_no":"\u0130leti\u015fim No","edit_staff":"Personeli D\u00fczenle","email":"E-posta","female":"Kad\u0131n","first_name":"Ad","gender":"Cinsiyet","last_name":"Soyad\u0131","male":"Erkek","password":"\u015eifre","role":"Rol","select_role":"Rol Se\u00e7in","staff":"personel","staff_details":"Personel Detaylar\u0131"},"staffs":"Personel","start_time_invalid":"g\u00fcn\u00fcn ba\u015flang\u0131\u00e7 \u200b\u200bsaati ge\u00e7ersiz","state":{"add_state":"Devlet Ekle","country":"\u00dclke","edit_state":"Durumu D\u00fczenle","state":"Devlet","states":"durumlar"},"states":"Devletler","subscribers":"Aboneler","terms_conditions":"\u015eartlar ve Ko\u015fullar","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","transaction":{"paid":"paral\u0131","payment_accepted_by":"\u00d6demeyi Kabul Eden","payment_status":"\u00d6deme Durumu","pending":"Ask\u0131da olmas\u0131","transaction_detail":"\u0130\u015flem Detay\u0131","transaction_id":"\u0130\u015flem Kimli\u011fi"},"transactions":"i\u015flemler","used_medicine":{"used_at":"Kullan\u0131lan","used_medicine":"Kullan\u0131lm\u0131\u015f \u0130la\u00e7","used_medicines":"Kullan\u0131lm\u0131\u015f \u0130la\u00e7lar","used_quantity":"Kullan\u0131lan Miktar"},"user":{"account":"Hesap","account_setting":"Hesap Ayarlar\u0131","avatar":"Avatar","change_language":"Dili de\u011fi\u015ftir","change_password":"\u015eifreyi De\u011fi\u015ftir","confirm_password":"\u015eifreyi Onayla","contact_number":"\u0130leti\u015fim Numaras\u0131","current_password":"Ge\u00e7erli \u015eifre","edit_profile":"Profili D\u00fczenle","email":"E-posta","email_notification":"Eposta bildirimi","full_name":"Tam Ad","gender":"Cinsiyet","new_password":"Yeni \u015eifre","profile_details":"Profil Ayr\u0131nt\u0131lar\u0131","return_to_admin":"Y\u00f6neticiye D\u00f6n","save_changes":"De\u011fi\u015fiklikleri Kaydet","select_time_zone":"Saat Dilimi Se\u00e7","setting":"Ayarlar","staff_details":"Personel Detaylar\u0131","time_zone":"Saat dilimi"},"users":"Kullan\u0131c\u0131lar","valid_expiration_date":"Ge\u00e7erli son kullanma tarihini girin.","valid_number":"Ge\u00e7erli numara","visit":{"add_visit":"Ziyaret Ekle","description":"A\u00e7\u0131klama","doctor":"Doktor","edit_visit":"Ziyaret D\u00fczenle","enter_note":"Not girin","enter_observation":"Enter observation","enter_problem":"Sorunu girin","notes":"Notlar","observations":"G\u00f6zlemler","patient":"Hasta","prescriptions":"Re\u00e7eteler","problems":"Sorunlar","title":"Ba\u015fl\u0131k","visit_date":"Ziyaret Tarihi","visit_detail":"Ziyaret Detay\u0131","visit_details":"Ziyaret Detaylar\u0131"},"visits":"Ziyaretler","web":{"Meet_best_doctors":"En \u0130yi Doktorlarla Tan\u0131\u015f\u0131n","about_short_description":"K\u0131sa A\u00e7\u0131klama Hakk\u0131nda","about_title":"Ba\u015fl\u0131k Hakk\u0131nda","about_us":"Hakk\u0131m\u0131zda","all_rights_reserved":"Her hakk\u0131 sakl\u0131d\u0131r","all_services":"T\u00fcm Hizmetler","already_have_an_account":"Zaten bir hesab\u0131n\u0131z var","already_have_patient_account":"Hasta Hesab\u0131 Zaten Var","appointment":"Randevu","appointment_now":"\u015eimdi Randevu","best_professionals":"En \u0130yi Profesyoneller","book_an_appointment":"Randevu Al","book_appointment":"Kitap randevusu","call_us":"Bizi Aray\u0131n","closed":"Kapal\u0131","confirm_booking":"Rezervasyonu Onayla","contact":"\u0130leti\u015fim","contact_us":"\u0130leti\u015fim","contact_us_for_any_information":"Herhangi Bir Bilgi \u0130\u00e7in Bize Ula\u015f\u0131n","create_an_account":"Hesap Olu\u015ftur","created_at":"Olu\u015fturma Tarihi","doctors":"Doktorlar","doctors_can_interact___":"Doktorlar hastalarla etkile\u015fime girebilir ve ilgili tedaviyi yapabilir.","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"Entegre sonu\u00e7lardan \u00f6nce hatas\u0131z sonu\u00e7lar\u0131 dinamik olarak form\u00fcle edin. D\u0131\u015f\u0131nda maliyet etkin olmadan entegre kaynaklar\u0131 \u00f6nemli \u00f6l\u00e7\u00fcde kulu\u00e7kaya yat\u0131r\u0131n.","email":"E-posta","email_address":"e-posta","emergency_help":"Acil Yard\u0131m","enquiry":"Soru\u015fturma","enquiry_details":"Sorgu Ayr\u0131nt\u0131lar\u0131","enter_your_email":"E-postan\u0131z\u0131 giriniz","enter_your_email_to_subscribe_to_our_newsletter":"B\u00fcltenimize Abone Olmak \u0130\u00e7in E-postan\u0131z\u0131 Girin","faqs":"SSS","forgot_password":"\u015eifremi Unuttum","home":"Ev","how_we_works":"Nas\u0131l \u00e7al\u0131\u015f\u0131yoruz","i_agree":"Kabul Ediyorum","location":"yer","login":"Giri\u015f","make_appointment":"Randevu ayarlamak","medical":"T\u0131bbi","medical_about_us":"T\u0131bbi Hakk\u0131m\u0131zda","medical_appointment":"T\u0131bbi Randevu","medical_contact":"T\u0131bbi \u0130leti\u015fim","medical_doctors":"T\u0131p Doktorlar\u0131","medical_services":"T\u0131bbi Hizmetler","medical_treatment":"T\u0131bbi tedavi","meet_our_team_of_specialists":"Uzman Ekibimizle Tan\u0131\u015f\u0131n","message":"Mesaj","name":"Ad","new_here":"Yeni Burada","no_services_available":"Hizmet Mevcut De\u011fil","opening_hours":"A\u00e7\u0131l\u0131\u015f Saatleri","our_doctor":"Doktorumuz","our_team":"Bizim tak\u0131m","patient_can_book_an_appointment___":"Hasta giri\u015f sayfas\u0131ndan veya giri\u015f panelinden doktordan randevu alabilir.","patient_can_do_registration___":"Hasta buradan temel bilgilerle kay\u0131t yapabilir.","patient_name":"Hasta Ad\u0131","patient_registration":"Hasta Kayd\u0131","phone":"Telefon","qualified_doctors":"Nitelikli Doktorlar","questions_before_booking":"Rezervasyon \u00d6ncesi Sorular","quick_links":"H\u0131zl\u0131 Linkler","reason":"Sebep","registration":"Kay\u0131t","remember_me":"Beni hat\u0131rla","satisfied_patient":"Memnun Hasta","saying_about_us":"Bizi Anlatanlar","see_what_are_the_patients":"Hastalar\u0131n Ne Oldu\u011funu G\u00f6r","send_an_email":"E-posta G\u00f6nder","send_message":"Mesaj G\u00f6nder","send_us_an_email":"Bize E-posta G\u00f6nder","services":"Hizmetler","sign_in":"Oturum A\u00e7","sign_in_here":"Burada oturum a\u00e7\u0131n","sign_up":"\u00dcye olmak","status":"Durum","subject":"Konu","subscribe":"Abone ol","take_treatment":"Tedavi Yap","terms_and_conditions":"\u015eartlar ve ko\u015fullar","testimonial":"Tan\u0131t\u0131m","timings":"Zamanlamalar","total_doctors":"Toplam Doktorlar","total_registered_patient":"Toplam Kay\u0131tl\u0131 Hasta","total_services":"Toplam Hizmetler","total_specializations":"Toplam Uzmanl\u0131klar","view_more":"Daha fazla g\u00f6ster","we_cover_a_big___":"\u00c7ok \u00c7e\u015fitli T\u0131bbi Hizmetleri Kapsad\u0131k","we_make_sure_that_your_life_are_in_good_hands":"Hayat\u0131n\u0131z\u0131n Emin Ellerde Olmas\u0131n\u0131 Sa\u011fl\u0131yoruz","we_provide_the_special_tips___":"Sa\u011fl\u0131k tedavisi ve y\u00fcksek d\u00fczeyde en iyinin \u00f6zel ipu\u00e7lar\u0131n\u0131 ve tavsiyelerini sunuyoruz.","working_process":"\u00c7al\u0131\u015fma s\u00fcreci","year_experience":"Y\u0131ll\u0131k Tecr\u00fcbe"},"weekdays":{"fri":"Cuma","mon":"AY","sat":"Oturdu","sun":"G\u00dcNE\u015e","thu":"PHU","tue":"sal","wed":"EVLENMEK"}},"tr.pagination":{"next":"sonraki","previous":"\u00d6ncesi"},"tr.passwords":{"reset":"\u015eifreniz s\u0131f\u0131rland\u0131!","sent":"\u015eifre s\u0131f\u0131rlama ba\u011flant\u0131n\u0131z\u0131 e-posta ile g\u00f6nderdik!","throttled":"Yeniden denemeden \u00f6nce l\u00fctfen bekleyin.","token":"Bu parola s\u0131f\u0131rlama belirteci ge\u00e7ersiz.","user":"Bu e-posta adresine sahip bir kullan\u0131c\u0131 bulam\u0131yoruz."},"tr.validation":{"accepted":":attribute kabul edilmelidir.","active_url":":attribute ge\u00e7erli bir URL de\u011fil.","after":":attribute, :date tarihinden sonraki bir tarih olmal\u0131d\u0131r.","after_or_equal":":attribute, :date'den sonraki veya buna e\u015fit bir tarih olmal\u0131d\u0131r.","alpha":":attribute yaln\u0131zca harf i\u00e7ermelidir.","alpha_dash":":attribute yaln\u0131zca harf, say\u0131, tire ve alt \u00e7izgi i\u00e7ermelidir.","alpha_num":":attribute yaln\u0131zca harf ve rakamlardan olu\u015fmal\u0131d\u0131r.","array":":attribute bir dizi olmal\u0131d\u0131r.","attributes":[],"before":":attribute :date tarihinden \u00f6nceki bir tarih olmal\u0131d\u0131r.","before_or_equal":":attribute, :date'den \u00f6nce veya buna e\u015fit bir tarih olmal\u0131d\u0131r.","between":{"array":":attribute :min ve :max \u00f6\u011feleri aras\u0131nda olmal\u0131d\u0131r.","file":":attribute :min ile :max kilobayt aras\u0131nda olmal\u0131d\u0131r.","numeric":":attribute :min ve :max aras\u0131nda olmal\u0131d\u0131r.","string":":attribute :min ve :max karakter aras\u0131nda olmal\u0131d\u0131r."},"boolean":":attribute alan\u0131 do\u011fru veya yanl\u0131\u015f olmal\u0131d\u0131r.","confirmed":":attribute onay\u0131 e\u015fle\u015fmiyor.","current_password":"Parola yanl\u0131\u015f.","custom":{"attribute-name":{"rule-name":"\u00f6zel mesaj"}},"date":":attribute ge\u00e7erli bir tarih de\u011fil.","date_equals":":attribute, :date de\u011ferine e\u015fit bir tarih olmal\u0131d\u0131r.","date_format":":attribute, :format bi\u00e7imiyle e\u015fle\u015fmiyor.","different":":attribute ve :other farkl\u0131 olmal\u0131d\u0131r.","digits":":attribute :digits basamak olmal\u0131d\u0131r.","digits_between":":attribute :min ve :max basamaklar\u0131 aras\u0131nda olmal\u0131d\u0131r.","dimensions":":attribute ge\u00e7ersiz resim boyutlar\u0131na sahip.","distinct":":attribute alan\u0131 yinelenen bir de\u011fere sahip.","email":":attribute ge\u00e7erli bir e-posta adresi olmal\u0131d\u0131r.","ends_with":":attribute a\u015fa\u011f\u0131dakilerden biriyle bitmelidir: :values.","exists":"Se\u00e7ilen :attribute ge\u00e7ersiz.","file":":attribute bir dosya olmal\u0131d\u0131r.","filled":":attribute alan\u0131 bir de\u011fere sahip olmal\u0131d\u0131r.","gt":{"array":":attribute, :value \u00f6\u011felerinden daha fazlas\u0131na sahip olmal\u0131d\u0131r.","file":":attribute, :value kilobayttan b\u00fcy\u00fck olmal\u0131d\u0131r.","numeric":":attribute, :value de\u011ferinden b\u00fcy\u00fck olmal\u0131d\u0131r.","string":":attribute, :value karakterlerinden b\u00fcy\u00fck olmal\u0131d\u0131r."},"gte":{"array":":attribute :value \u00f6\u011felerine veya daha fazlas\u0131na sahip olmal\u0131d\u0131r.","file":":attribute :value kilobayttan b\u00fcy\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","numeric":":attribute :value de\u011ferinden b\u00fcy\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","string":":attribute, :value karakterlerinden b\u00fcy\u00fck veya ona e\u015fit olmal\u0131d\u0131r."},"image":":attribute bir resim olmal\u0131d\u0131r.","in":"Se\u00e7ilen :attribute ge\u00e7ersiz.","in_array":":attribute alan\u0131 :other i\u00e7inde mevcut de\u011fil.","integer":":attribute bir tamsay\u0131 olmal\u0131d\u0131r.","ip":":attribute ge\u00e7erli bir IP adresi olmal\u0131d\u0131r.","ipv4":":attribute ge\u00e7erli bir IPv4 adresi olmal\u0131d\u0131r.","ipv6":":attribute ge\u00e7erli bir IPv6 adresi olmal\u0131d\u0131r.","json":":attribute ge\u00e7erli bir JSON dizesi olmal\u0131d\u0131r.","lt":{"array":":attribute, :value \u00f6\u011felerinden daha az\u0131na sahip olmal\u0131d\u0131r.","file":":attribute, :value kilobayttan k\u00fc\u00e7\u00fck olmal\u0131d\u0131r.","numeric":":attribute, :value de\u011ferinden k\u00fc\u00e7\u00fck olmal\u0131d\u0131r.","string":":attribute, :value karakterlerinden daha az olmal\u0131d\u0131r."},"lte":{"array":":attribute, :value \u00f6\u011felerinden daha fazlas\u0131na sahip olmamal\u0131d\u0131r.","file":":attribute :value kilobayttan k\u00fc\u00e7\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","numeric":":attribute :value de\u011ferinden k\u00fc\u00e7\u00fck veya ona e\u015fit olmal\u0131d\u0131r.","string":":attribute, :value karakterlerinden k\u00fc\u00e7\u00fck veya ona e\u015fit olmal\u0131d\u0131r."},"max":{"array":":attribute, :max'tan fazla \u00f6\u011feye sahip olmamal\u0131d\u0131r.","file":":attribute :max kilobayttan b\u00fcy\u00fck olmamal\u0131d\u0131r.","numeric":":attribute :max'tan b\u00fcy\u00fck olmamal\u0131d\u0131r.","string":":attribute :max karakterden b\u00fcy\u00fck olmamal\u0131d\u0131r."},"mimes":":attribute, :values t\u00fcr\u00fcnde bir dosya olmal\u0131d\u0131r.","mimetypes":":attribute, :values t\u00fcr\u00fcnde bir dosya olmal\u0131d\u0131r.","min":{"array":":attribute en az :min \u00f6\u011feye sahip olmal\u0131d\u0131r.","file":":attribute en az :min kilobayt olmal\u0131d\u0131r.","numeric":":attribute en az :min olmal\u0131d\u0131r.","string":":attribute en az :min karakter olmal\u0131d\u0131r."},"multiple_of":":attribute, :value'nun kat\u0131 olmal\u0131d\u0131r.","not_in":"Se\u00e7ilen :attribute ge\u00e7ersiz.","not_regex":":attribute bi\u00e7imi ge\u00e7ersiz.","numeric":":attribute bir say\u0131 olmal\u0131d\u0131r.","password":"Parola yanl\u0131\u015f.","present":":attribute alan\u0131 mevcut olmal\u0131d\u0131r.","prohibited":":attribute alan\u0131 yasakt\u0131r.","prohibited_if":":attribute alan\u0131, :di\u011fer :de\u011fer oldu\u011funda yasakt\u0131r.","prohibited_unless":":attribute alan\u0131, :other :values i\u00e7inde olmad\u0131k\u00e7a yasakt\u0131r.","regex":":attribute bi\u00e7imi ge\u00e7ersiz.","required":":attribute alan\u0131 gereklidir.","required_if":":attribute alan\u0131, :di\u011fer :de\u011fer oldu\u011funda gereklidir.","required_unless":":attribute alan\u0131, :other :values i\u00e7inde olmad\u0131\u011f\u0131 s\u00fcrece gereklidir.","required_with":":attribute alan\u0131 :values mevcut oldu\u011funda gereklidir.","required_with_all":":attribute alan\u0131 :values mevcut oldu\u011funda gereklidir.","required_without":":attribute alan\u0131 :values olmad\u0131\u011f\u0131nda gereklidir.","required_without_all":":attribute alan\u0131, :de\u011ferlerden hi\u00e7biri mevcut olmad\u0131\u011f\u0131nda gereklidir.","same":":attribute ve :other e\u015fle\u015fmelidir.","size":{"array":":attribute :size \u00f6\u011feleri i\u00e7ermelidir.","file":":attribute :size kilobayt olmal\u0131d\u0131r.","numeric":":attribute :size olmal\u0131d\u0131r.","string":":attribute :size karakter olmal\u0131d\u0131r."},"starts_with":":attribute a\u015fa\u011f\u0131dakilerden biriyle ba\u015flamal\u0131d\u0131r: :values.","string":":attribute bir dize olmal\u0131d\u0131r.","timezone":":attribute ge\u00e7erli bir saat dilimi olmal\u0131d\u0131r.","unique":":attribute zaten al\u0131nm\u0131\u015f.","uploaded":":attribute y\u00fcklenemedi.","url":":attribute ge\u00e7erli bir URL olmal\u0131d\u0131r.","uuid":":attribute ge\u00e7erli bir UUID olmal\u0131d\u0131r."},"tw.livewire-tables::strings":{"All":"\u5168\u90e8","Applied Filters":"\u5df2\u5957\u7528\u7684\u904e\u6ffe\u898f\u5247","Applied Sorting":"\u5df2\u5957\u7528\u7684\u641c\u5c0b\u898f\u5247","Bulk Actions":"\u6279\u6b21\u64cd\u4f5c","Clear":"\u6e05\u9664","Columns":"\u6b04\u4f4d","Done Reordering":"\u6392\u5e8f\u5b8c\u6210","Filters":"\u904e\u6ffe\u898f\u5247","No items found. Try to broaden your search.":"\u7121\u8cc7\u6599\u5448\u73fe\u3002\u8acb\u5617\u8a66\u64f4\u5927\u641c\u5c0b\u7bc4\u570d\u3002","Remove filter option":"\u79fb\u9664\u904e\u6ffe\u898f\u5247","Remove sort option":"\u79fb\u9664\u6392\u5e8f\u898f\u5247","Reorder":"\u91cd\u65b0\u6392\u5e8f","Search":"\u641c\u5c0b","Select All":"\u641c\u5c0b\u5168\u90e8","Showing":"\u986f\u793a","Unselect All":"\u53d6\u6d88\u9078\u64c7","You are currently selecting all":"\u60a8\u76ee\u524d\u5df2\u9078\u64c7\u5168\u90e8\u8cc7\u6599","You are not connected to the internet.":"\u76ee\u524d\u70ba\u96e2\u7dda\u6a21\u5f0f","You have selected":"\u60a8\u5df2\u9078\u64c7","of":"\u7b46\u8cc7\u6599\uff0c\u5171","results":"\u7b46\u8cc7\u6599","rows":"\u7b46\u8cc7\u6599","rows, do you want to select all":"\u7b46\u8cc7\u6599\uff0c\u60a8\u662f\u5426\u8981\u5168\u9078","to":"\u81f3"},"zh.auth":{"app":{"create":"\u521b\u5efa","export":"\u51fa\u53e3","lock_account":"\u9501\u5b9a\u5e10\u6237","member_since":"\u4f1a\u5458\u81ea","messages":"\u6d88\u606f","online":"\u5728\u7ebf","print":"\u6253\u5370","profile":"\u4e2a\u4eba\u8d44\u6599","reload":"\u91cd\u65b0\u52a0\u8f7d","reset":"\u91cd\u7f6e","search":"\u641c\u7d22","settings":"\u8bbe\u7f6e"},"confirm_password":"\u786e\u8ba4\u5bc6\u7801","email":"\u7535\u5b50\u90ae\u4ef6","emails":{"password":{"reset_link":"\u70b9\u51fb\u8fd9\u91cc\u91cd\u7f6e\u60a8\u7684\u5bc6\u7801"}},"failed":"\u8fd9\u4e9b\u51ed\u636e\u4e0e\u6211\u4eec\u7684\u8bb0\u5f55\u4e0d\u5339\u914d\u3002","forgot_password":{"send_pwd_reset":"\u53d1\u9001\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5","title":"\u8f93\u5165\u90ae\u7bb1\u91cd\u7f6e\u5bc6\u7801"},"full_name":"\u5168\u540d","login":{"forgot_password":"\u6211\u5fd8\u8bb0\u4e86\u5bc6\u7801","register_membership":"\u6ce8\u518c\u65b0\u4f1a\u5458","title":"\u767b\u5f55\u4ee5\u5f00\u59cb\u60a8\u7684\u4f1a\u8bdd"},"password":"\u5bc6\u7801","register":"\u6ce8\u518c","registration":{"have_membership":"\u6211\u5df2\u7ecf\u6709\u4f1a\u5458","i_agree":"\u6211\u540c\u610f","terms":"\u6761\u6b3e","title":"\u6ce8\u518c\u65b0\u4f1a\u5458"},"remember_me":"\u8bb0\u4f4f\u6211","reset_password":{"reset_pwd_btn":"\u91cd\u7f6e\u5bc6\u7801","title":"\u91cd\u7f6e\u5bc6\u7801"},"sign_in":"\u767b\u5f55","sign_out":"\u9000\u51fa","throttle":"\u767b\u5f55\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a\u3002 \u8bf7\u5728 :seconds \u79d2\u540e\u91cd\u8bd5\u3002"},"zh.messages":{"admin_dashboard":{"dashboard":"\u4eea\u8868\u677f","day":"\u5929","earnings_from_appointments":"\u4efb\u547d\u6536\u5165","filter_options":"\u8fc7\u6ee4\u5668\u9009\u9879","month":"\u6708","name":"\u59d3\u540d","patient_id":"\u60a3\u8005\u552f\u4e00 ID","recent_patients_registration":"\u8fd1\u671f\u60a3\u8005\u767b\u8bb0","registered":"\u6ce8\u518c","today_appointments":"\u4eca\u65e5\u7ea6\u4f1a","today_registered_patients":"\u4eca\u5929\u6ce8\u518c\u7684\u60a3\u8005","total_doctor":"\u603b\u533b\u751f","total_patients":"\u603b\u60a3\u8005","week":"\u5468"},"appointment":{"PatientRequired":"\u9700\u8981\u60a3\u8005\u5b57\u6bb5\u3002","SelectAppointment":"\u8acb\u9078\u64c7\u9810\u7d04\u6642\u6bb5\u3002","Select_payment_method":"\u9009\u62e9\u4ed8\u6b3e\u65b9\u5f0f","ServiceRequired":"\u670d\u52d9\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805\u3002","add_new_appointment":"\u6dfb\u52a0\u7ea6\u4f1a","appointment_at":"\u9884\u7ea6\u65f6\u95f4","appointment_date":"\u9884\u7ea6\u65e5\u671f","appointment_details":"\u7ea6\u4f1a\u8be6\u60c5","appointment_status":"\u9884\u7ea6\u72b6\u6001","appointment_unique_id":"\u7ea6\u4f1aID","appointments":"\u7ea6\u4f1a","appointments_schedule":"\u7ea6\u4f1a\u65f6\u95f4\u8868","authorize_session_created_successfully":"\u6388\u6b0a\u6703\u8a71\u5275\u5efa\u6210\u529f\u3002","available":"\u53ef\u7528","available_slot":"\u53ef\u7528\u63d2\u69fd","booked":"\u9884\u8ba2","calendar":"\u65e5\u5386","cancel_appointment":"\u53d6\u6d88\u9884\u7ea6","cancelled":"\u53d6\u6d88","charge":"\u5145\u7535","check_in":"\u7b7e\u5230","check_out":"\u9000\u623f","date":"\u65e5\u671f","description":"\u8bf4\u660e","edit_appointment":"\u7f16\u8f91\u7ea6\u4f1a","ends":"\u7ed3\u675f","extra_fees":"\u989d\u5916\u8d39\u7528","no_slot_found":"\u6ca1\u6709\u627e\u5230\u65f6\u95f4\u6bb5\u3002","patient":"\u75c5\u4eba","patient_id":"\u60a3\u8005 ID","patient_name_retrieved":"\u60a3\u8005\u59d3\u540d\u6aa2\u7d22\u6210\u529f","payable_amount":"\u5e94\u4ed8\u91d1\u989d","payment":"\u652f\u4ed8","payment_method":"\u4ed8\u6b3e\u65b9\u6cd5","payment_status":"\u652f\u4ed8\u72c0\u614b","service":"\u670d\u52a1","service_charge":"\u670d\u52a1\u8d39","session_created_successfully":"\u4f1a\u8bdd\u521b\u5efa\u6210\u529f","session_id_required":"\u6703\u8a71 ID \u70ba\u5fc5\u586b\u9805","starts":"\u5f00\u59cb","status":"\u72b6\u6001","switch_to_calendar":"\u5207\u6362\u5230\u65e5\u5386","time":"\u65f6\u95f4","total_payable_amount":"\u603b\u5e94\u4ed8\u91d1\u989d","upcoming_meetings":"\u5373\u5c06\u53ec\u5f00\u7684\u4f1a\u8bae"},"appointments":"\u7ea6\u4f1a","apps":"\u5e94\u7528\u7a0b\u5e8f","card_number_invalid..":"\u5361\u865f\u7121\u6548\u3002","card_type":"\u4fe1\u7528\u5361\u985e\u578b","cities":"\u57ce\u5e02","city":{"add_city":"\u6dfb\u52a0\u57ce\u5e02","city":"\u57ce\u5e02","edit_city":"\u7f16\u8f91\u57ce\u5e02","state":"\u72b6\u6001"},"clinic_schedules":"\u8bca\u6240\u65f6\u95f4\u8868","cms":{"Terms_Conditions_required":"\u689d\u6b3e\u548c\u689d\u4ef6\u70ba\u5fc5\u586b\u9805","about_image":"\u5173\u4e8e\u5f62\u8c61","cms":"\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf","description_no_white_space":"\u95dc\u65bc\u7c21\u77ed\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","experience_required":"\u95dc\u65bc\u7d93\u9a57\u6b04\u4f4d\u662f\u5fc5\u8981\u7684\u3002","privacy_policy":"\u9690\u79c1\u653f\u7b56","privacy_policy_required.":"\u9700\u8981\u96b1\u79c1\u6b0a\u653f\u7b56\u3002","terms_conditions":"\u6761\u6b3e\u548c\u6761\u4ef6","title_no_white_space":"\u95dc\u65bc\u6a19\u984c\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c"},"common":{"Attempt_read_property_access_token_null":"\u5617\u8a66\u8b80\u53d6 null \u4e0a\u7684\u5c6c\u6027\u201caccess_token\u201d","Forgot_password_lable":"\u4f60\u5fd8\u8a18\u5bc6\u78bc\u4e86\u55ce\uff1f\u6c92\u554f\u984c\u3002\u53ea\u9700\u544a\u8a34\u6211\u5011\u60a8\u7684\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\uff0c\u6211\u5011\u5c07\u5411\u60a8\u767c\u9001\u4e00\u500b\u5bc6\u78bc\u91cd\u7f6e\u93c8\u63a5\uff0c\u60a8\u53ef\u4ee5\u900f\u904e\u8a72\u93c8\u63a5\u9078\u64c7\u4e00\u500b\u65b0\u5bc6\u78bc\u3002","action":"\u52a8\u4f5c","active":"\u6d3b\u52a8","add":"\u6dfb\u52a0","add_credential":"\u8bf7\u6dfb\u52a0\u7f29\u653e\u51ed\u636e","age":"\u5e74\u9f84","any_one_permission":"\u8bf7\u9009\u62e9\u4efb\u610f\u4e00\u9879\u6743\u9650\u3002","apply":"\u7533\u8bf7","appointment_date_required":"\u9884\u7ea6\u65e5\u671f\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","are_you_sure":"\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u4e2a","are_you_sure_cancel":"\u4f60\u786e\u5b9a\u8981\u53d6\u6d88\u5417","back":"\u8fd4\u56de","booked":"\u9884\u8ba2","brand_required":"\u54c1\u724c\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","cancel":"\u53d6\u6d88","cancelled":"\u53d6\u6d88","cancelled_appointment":"\u53d6\u6d88\u7ea6\u4f1a\uff01","category_required":"\u7c7b\u522b\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","change_image":"\u66f4\u6539\u56fe\u50cf","check in":"\u62a5\u5230","check out":"\u67e5\u770b","city":"\u57ce\u5e02","confirm":"\u78ba\u8a8d","connected_zoom":"\u4e0ezoom\u8fde\u63a5\u6210\u529f\u3002","contact_number":"\u8054\u7cfb\u7535\u8bdd\u662f","country":"\u56fd\u5bb6","custom":"\u98ce\u4fd7","de_active":"\u505c\u7528","default_language":"\u9810\u8a2d\u8a9e\u8a00","delete":"\u5220\u9664","deleted":"\u5df2\u5220\u9664\uff01","details":"\u8be6\u60c5","discard":"\u4e22\u5f03","doctor_required":"\u9700\u8981\u533b\u751f\u5b57\u6bb5\u3002","download":"\u4e0b\u8f7d","edit":"\u7f16\u8f91","email_already_exist":"\u8be5\u7535\u5b50\u90ae\u4ef6\u5df2\u8ba2\u9605\u3002","email_max":"\u7535\u5b50\u90ae\u4ef6\u7684\u6700\u5927\u5927\u5c0f\u4e3a 255.","email_not_register":"\u7535\u5b50\u90ae\u4ef6\u672a\u6ce8\u518c\u3002","email_regex":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u5fc5\u987b\u662f\u6709\u6548\u7684\u683c\u5f0f.","email_required":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","email_verified":"\u7535\u5b50\u90ae\u4ef6\u5df2\u9a8c\u8bc1","error":"\u9519\u8bef","filter":"\u8fc7\u6ee4","filter_option":"\u8fc7\u6ee4\u9009\u9879","first_name_required":"\u540d\u5b57\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","forgot_your_password":"\u5fd8\u8a18\u5bc6\u78bc\u4e86\u55ce","from":"\u4ece","google_captcha_required":"\u8c37\u6b4c\u9a8c\u8bc1\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","has_been":"\u5df2\u88ab\u5220\u9664\u3002","has_cancel":" \u5df2\u7ecf\u53d6\u6d88\u4e86\u3002","hour":"\u5c0f\u65f6","impersonate":"\u6a21\u4eff","instagram_url":"Instagram \u7f51\u5740","last_name_required":"\u59d3\u6c0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","linkedin_url":"\u9886\u82f1\u7f51\u5740","logout":"\u767b\u51fa","maximum_55":"\u6700\u591a\u5141\u8bb8 55 \u4e2a\u5b57\u7b26\u3002","message_required":"\u6d88\u606f\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879.","minutes":"\u5206\u949f","n\/a":"\u4e0d\u9002\u7528","name":"\u59d3\u540d","name_already_taken":"\u8be5\u540d\u5b57\u5df2\u88ab\u5360\u7528","name_required":"\u59d3\u540d\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","no":"\u4e0d\uff0c\u53d6\u6d88","no_data_available":"\u65e0\u53ef\u7528\u6570\u636e","no_data_available_in_table":"\u8868\u4e2d\u65e0\u53ef\u7528\u6570\u636e","no_records_found":"\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\u3002","not_allow__assess_record":"\u770b\u4f86\u60a8\u7121\u6b0a\u5b58\u53d6\u6b64\u8a18\u9304\u3002","note_we_are_taking_the_timezone_of_your_doctors_while_creating_appointment_in_calendar":"\u6ce8\u610f\uff1a\u6211\u4eec\u5728\u65e5\u5386\u4e2d\u521b\u5efa\u7ea6\u4f1a\u65f6\u4f1a\u91c7\u7528\u60a8\u533b\u751f\u7684\u65f6\u533a\u3002\u5982\u679c Doctor \u6ca1\u6709\u8bbe\u7f6e\u65f6\u533a\uff0c\u90a3\u4e48\u5b83\u5c06\u91c7\u7528\u9ed8\u8ba4\u7684 UTC \u65f6\u533a\u3002","note_white_space":"\u6ce8\u610f\u5b57\u6bb5\u4e0d\u4ec5\u4ec5\u5305\u542b\u7a7a\u683c","observation_white_space":"\u89c2\u5bdf\u5b57\u6bb5\u4e0d\u4ec5\u4ec5\u5305\u542b\u7a7a\u767d","of":"\u7684","overview":"\u6982\u8ff0","payment_type_required":"\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","please_wait":"\u8bf7\u7a0d\u5019...","prescription_report":"\u5904\u65b9\u62a5\u544a","problem_white_space":"\u95ee\u9898\u5b57\u6bb5\u4e0d\u4ec5\u4ec5\u5305\u542b\u7a7a\u683c","processing":"\u52a0\u5de5..","purchase_price":"\u8d2d\u4e70\u4ef7\u683c","read":"\u8bfb","remember_me":"\u8a18\u4f4f\u5e33\u865f","resend_verification_email":"\u91cd\u65b0\u767c\u9001\u9a57\u8b49\u90f5\u4ef6","reset":"\u91cd\u7f6e","reset_password":"\u91cd\u65b0\u8a2d\u5bc6\u78bc","results":"\u7ed3\u679c","save":"\u4fdd\u5b58","search":"\u641c\u7d22","select_brand":"\u9009\u62e9\u54c1\u724c","select_category":"\u9009\u62e9\u7c7b\u522b","select_city":"\u9009\u62e9\u57ce\u5e02","select_country":"\u9009\u62e9\u56fd\u5bb6","select_doctor":"\u9009\u62e9\u533b\u751f","select_service":"\u9009\u62e9\u670d\u52a1","select_state":"\u9009\u62e9\u72b6\u6001","service":"\u670d\u52a1","service_required":"\u670d\u52a1\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879\u3002","show":"\u8282\u76ee","showing":"\u663e\u793a\u4e2d","state":"\u72b6\u6001","subject_required":"\u4e3b\u9898\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879.","submit":"\u63d0\u4ea4","to":"\u5230","twitter_url":"\u63a8\u7279\u7f51\u5740","unread":"\u672a\u8bfb","verify_lable1":"\u611f\u8b1d\u60a8\u7684\u8a3b\u518a\uff01\u5728\u958b\u59cb\u4e4b\u524d\uff0c\u60a8\u53ef\u4ee5\u900f\u904e\u9ede\u64ca\u6211\u5011\u525b\u525b\u900f\u904e\u96fb\u5b50\u90f5\u4ef6\u767c\u9001\u7d66\u60a8\u7684\u9023\u7d50\u4f86\u9a57\u8b49\u60a8\u7684\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u55ce\uff1f\u5982\u679c\u60a8\u6c92\u6709\u6536\u5230\u96fb\u5b50\u90f5\u4ef6\uff0c\u6211\u5011\u5f88\u6a02\u610f\u5411\u60a8\u767c\u9001\u53e6\u4e00\u5c01\u96fb\u5b50\u90f5\u4ef6\u3002","verify_lable2":"\u65b0\u7684\u9a57\u8b49\u9023\u7d50\u5df2\u767c\u9001\u81f3\u60a8\u8a3b\u518a\u6642\u63d0\u4f9b\u7684\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u3002","view":"\u770b\u6cd5","years":"\u5e74","yes":"\u662f\u7684\uff0c\u5220\u9664\uff01","yes_update":"\u662f\u7684\uff0c\u66f4\u65b0\uff01","zoom_credentials":"\u8acb\u65b0\u589e\u7e2e\u653e\u6191\u8b49\u3002"},"countries":"\u56fd\u5bb6","country":{"add_country":"\u6dfb\u52a0\u56fd\u5bb6","country":"\u56fd\u5bb6","short_code":"\u77ed\u4ee3\u7801"},"currencies":"\u8d27\u5e01","currency":{"add_currency":"\u6dfb\u52a0\u8d27\u5e01","add_currency_code_as_per_three_letter_iso_code":"\u6839\u636e\u4e09\u5b57\u6bcd ISO \u4ee3\u7801\u6dfb\u52a0\u8d27\u5e01\u4ee3\u7801","currency_code":"\u8d27\u5e01\u4ee3\u7801","currency_icon":"\u8d27\u5e01\u56fe\u6807","currency_name":"\u8d27\u5e01\u540d\u79f0","edit_currency":"\u7f16\u8f91\u8d27\u5e01","name":"\u59d3\u540d","you_can_find_out_here":"\u4f60\u53ef\u4ee5\u5728\u8fd9\u91cc\u627e\u5230"},"cvv_invalid.":"CVV \u7121\u6548\u3002","cvv_number_required.":"CVV \u865f\u78bc\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805\u3002","dashboard":"\u4eea\u8868\u677f","datepicker":{"last_30_days":"\u8fc7\u53bb 30 \u5929","last_month":"\u4e0a\u4e2a\u6708","last_week":"\u4e0a\u5468","this_month":"\u8fd9\u4e2a\u6708","this_week":"\u672c\u661f\u671f","today":"\u4eca\u5929","yesterday":"\u6628\u5929"},"doctor":{"add":"\u6dfb\u52a0\u533b\u751f","add_qualification":"\u6dfb\u52a0\u8d44\u683c","address1":"\u5730\u5740 1","address2":"\u5730\u5740 2","address_information":"\u5730\u5740\u4fe1\u606f","allowed_img":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","city":"\u57ce\u5e02","collage_university":"\u62fc\u8d34\/\u5927\u5b66","country":"\u56fd\u5bb6","created_at":"\u521b\u5efa\u4e8e","degree":"\u5b66\u4f4d","dob":"\u51fa\u751f\u65e5\u671f","doctor":"\u533b\u751f","doctor_detail":"\u533b\u751f\u8be6\u60c5","edit":"\u7f16\u8f91\u533b\u751f","experience":"\u5e74\u5ea6\u7ecf\u9a8c","female":"\u5973","first_name":"\u540d\u5b57","instagram":"Instagram","last_name":"\u59d3\u6c0f","linkedin":"\u9886\u82f1","male":"\u7537","passout_year":"\u4f20\u9012\u5e74\u4efd","postal_code":"\u90ae\u653f\u7f16\u7801","profile":"\u4e2a\u4eba\u8d44\u6599","qualification":"\u8d44\u8d28","qualification_information":"\u8d44\u683c\u4fe1\u606f","select_blood_group":"\u9009\u62e9\u8840\u578b","select_date":"\u9009\u62e9\u65e5\u671f","select_doctors":"\u9009\u62e9\u533b\u751f","select_gender":"\u9009\u62e9\u6027\u522b","select_year":"\u9009\u62e9\u5e74\u4efd","specialization":"\u4e13\u4e1a\u5316","sr_no":"SR NO","state":"\u72b6\u6001","status":"\u72b6\u6001","twitter":"\u63a8\u7279","university":"\u5927\u5b66","updated_at":"\u66f4\u65b0\u65f6\u95f4","year":"\u5e74"},"doctor_appointment":{"amount":"\u91d1\u989d","from_time":"\u4ece\u65f6\u95f4","patient":"\u75c5\u4eba","service":"\u670d\u52a1","to_time":"\u65f6\u95f4"},"doctor_appointments":"\u533b\u751f\u9884\u7ea6","doctor_dashboard":{"recent_appointments":"\u6700\u8fd1\u7684\u7ea6\u4f1a","total_appointments":"\u603b\u7ea6\u4f1a"},"doctor_session":{"add":"\u6dfb\u52a0\u533b\u751f\u65f6\u95f4\u8868","all":"\u5168\u90e8","copy":"\u590d\u5236","doctor":"\u533b\u751f","doctor_session":"\u533b\u751f\u65f6\u95f4\u8868","doctor_session_details":"\u533b\u751f\u65e5\u7a0b\u8be6\u60c5","edit":"\u7f16\u8f91\u533b\u751f\u65f6\u95f4\u8868","evening_session":"\u665a\u95f4\u65f6\u95f4\u8868","friday":"\u661f\u671f\u4e94","gap_between_appointment":"\u7ea6\u4f1a\u95f4\u9694","monday":"\u5468\u4e00","morning_session":"\u65e9\u95f4\u65f6\u95f4\u8868","my_schedule":"\u6211\u7684\u65e5\u7a0b","saturday":"\u5468\u516d","select_meeting_time":"\u9009\u62e9\u4f1a\u8bae\u65f6\u95f4","select_session_gap":"\u9009\u62e9\u8fdb\u5ea6\u95f4\u9694","session":"\u4f1a\u8bdd","session_gap":"\u65f6\u95f4\u95f4\u9694","session_meeting_time":"\u5b89\u6392\u4f1a\u8bae\u65f6\u95f4","session_time_in_minutes":"\u5b89\u6392\u4f1a\u8bae\u65f6\u95f4","sunday":"\u661f\u671f\u65e5","thursday":"\u5468\u56db","tuesday":"\u5468\u4e8c","unavailable":"\u4e0d\u53ef\u7528","wednesday":"\u5468\u4e09","week_days":"\u5de5\u4f5c\u65e5"},"doctor_sessions":"\u533b\u751f\u65f6\u95f4\u8868","doctors":"\u533b\u751f","doctors_scheduled_time_ended_for_today__":"\u4eca\u5929\u533b\u751f\u9884\u7ea6\u65f6\u95f4\u7ed3\u675f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u533b\u751f\u6216\u65e5\u671f","email_password_reset_link":"\u91cd\u8a2d\u96fb\u5b50\u90f5\u4ef6\u5bc6\u78bc\u7684\u93c8\u63a5","enquiries":"\u67e5\u8be2","expiration_month_required":"\u5230\u671f\u6708\u4efd\u6b04\u4f4d\u662f\u5fc5\u9700\u7684\u3002","expiration_year_required":"\u5230\u671f\u5e74\u4efd\u6b04\u4f4d\u662f\u5fc5\u9700\u7684\u3002","faq":{"add_faq":"\u6dfb\u52a0\u5e38\u89c1\u95ee\u9898","answer":"\u7b54\u6848","edit_faq":"\u7f16\u8f91\u5e38\u89c1\u95ee\u9898","question":"\u95ee\u9898"},"faqs":"\u5e38\u89c1\u95ee\u9898","filter":{"active":"\u79ef\u6781\u7684","all":"\u5168\u90e8","awaited":"\u7b49\u5f85","booked":"\u9884\u8ba2","cancelled":"\u53d6\u6d88","check in":"\u62a5\u5230","check out":"\u67e5\u770b","deactive":"\u505c\u7528","finished":"\u5b8c\u6210\u7684","paid":"\u6709\u85aa\u916c\u7684","pending":"\u5f85\u529e\u7684","read":"\u8bfb","unread":"\u672a\u8bfb"},"filter_success":"\u904e\u6ffe\u6210\u529f","flash":{"about_image_validation_message":"\u5173\u4e8e\u56fe\u7247\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg\u3001jpeg\u3001png\u3002","about_us_create":"\u5173\u4e8e\u6211\u4eec\u5df2\u6210\u529f\u4fdd\u5b58\u3002","all_notification_read":"\u6240\u6709\u901a\u77e5\u8bfb\u53d6\u6210\u529f\u3002","appointment_booked":"\u9884\u7ea6\u6210\u529f","appointment_cancel":"\u9884\u7ea6\u53d6\u6d88\u3002","appointment_create":"\u7ea6\u4f1a\u521b\u5efa\u6210\u529f\u3002","appointment_created_payment_complete":"\u7ea6\u4f1a\u521b\u5efa\u6210\u529f\uff0c\u4ed8\u6b3e\u5b8c\u6210\u3002","appointment_created_payment_not_complete":"\u7ea6\u4f1a\u521b\u5efa\u6210\u529f\uff0c\u4ed8\u6b3e\u672a\u5b8c\u6210\u3002","appointment_delete":"\u7ea6\u4f1a\u5220\u9664\u6210\u529f\u3002","appointment_not_found":"\u672a\u627e\u5230\u7ea6\u4f1a","appointment_retrieve":"\u7ea6\u4f1a\u65e5\u5386\u6570\u636e\u68c0\u7d22\u6210\u529f\u3002","calender_added":"\u65e5\u5386\u6dfb\u52a0\u6210\u529f\u3002","cat_retrieve":"\u7c7b\u522b\u68c0\u7d22\u6210\u529f\u3002","cities_retrieve":"\u57ce\u5e02\u68c0\u7d22\u6210\u529f","city_create":"\u57ce\u5e02\u521b\u5efa\u6210\u529f\u3002","city_delete":"\u57ce\u5e02\u5220\u9664\u6210\u529f\u3002","city_retrieved":"\u57ce\u5e02\u68c0\u7d22\u6210\u529f\u3002","city_update":"\u57ce\u5e02\u66f4\u65b0\u6210\u529f\u3002","city_used":"\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u7684\u57ce\u5e02\u3002","clinic_delete":"ClinicSchedule \u5220\u9664\u6210\u529f\u3002","clinic_save":"\u8bca\u6240\u65f6\u95f4\u8868\u5df2\u6210\u529f\u4fdd\u5b58\u3002","cms_update":"CMS \u66f4\u65b0\u6210\u529f\u3002","country_create":"\u56fd\u5bb6\u521b\u5efa\u6210\u529f\u3002","country_delete":"\u56fd\u5bb6\u5220\u9664\u6210\u529f\u3002","country_update":"\u56fd\u5bb6\u66f4\u65b0\u6210\u529f\u3002","country_used":"\u56fd\u5bb6\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u3002","create_blog":"VCard \u535a\u5ba2\u521b\u5efa\u6210\u529f\u3002","create_front_testimonial":"\u8bc1\u660e\u521b\u5efa\u6210\u529f\u3002","currency_create":"\u8d27\u5e01\u521b\u5efa\u6210\u529f\u3002","currency_delete":"\u8d27\u5e01\u5220\u9664\u6210\u529f\u3002","currency_update":"\u8d27\u5e01\u66f4\u65b0\u6210\u529f\u3002","currency_used":"\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u7684\u8d27\u5e01\u3002","current_invalid":"\u5f53\u524d\u5bc6\u7801\u65e0\u6548\u3002","data_retrieve":"\u6570\u636e\u68c0\u7d22\u6210\u529f\u3002","default_role_not_delete":"\u4e0d\u5220\u9664\u9ed8\u8ba4\u89d2\u8272\u3002","degree_required":"\u5b66\u4f4d\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","doctor_appointment":"\u533b\u751f\u9884\u7ea6\u65e5\u5386\u6570\u636e\u68c0\u7d22\u6210\u529f\u3002","doctor_create":"\u533b\u751f\u521b\u5efa\u6210\u529f\u3002","doctor_delete":"\u533b\u751f\u5220\u9664\u6210\u529f\u3002","doctor_holiday":"\u533b\u751f\u5047\u671f\u521b\u5efa\u6210\u529f","doctor_not_available":"\u533b\u751f\u4e0d\u53ef\u7528","doctor_session_not_found":"\u672a\u627e\u5230\u533b\u751f\u4f1a\u8bae\u3002","doctor_update":"\u533b\u751f\u66f4\u65b0\u6210\u529f\u3002","doctor_use":"\u533b\u751f\u4f7f\u7528\u6210\u529f\u3002","email_notification":"\u90ae\u4ef6\u901a\u77e5\u66f4\u65b0\u6210\u529f\u3002","email_send":"\u90ae\u4ef6\u53d1\u9001\u6210\u529f\u3002","enquire_deleted":"\u67e5\u8be2\u5220\u9664\u6210\u529f\u3002","enquire_sent":"\u67e5\u8be2\u53d1\u9001\u6210\u529f","faq_creat":"FAQ \u521b\u5efa\u6210\u529f\u3002","faq_delete":"FAQ \u5220\u9664\u6210\u529f\u3002","faq_update":"\u5e38\u89c1\u95ee\u9898\u66f4\u65b0\u6210\u529f\u3002","faq_use":"\u6b64\u5e38\u89c1\u95ee\u9898\u89e3\u7b54\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u8fc7\u3002","favicon_validation_message":"\u56fe\u6807\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg\u3001jpeg\u3001png\u3002","feature_update":"\u529f\u80fd\u66f4\u65b0\u6210\u529f\u3002","google_calendar_connect":"\u60a8\u7684 Google \u65e5\u5386\u73b0\u5df2\u8fde\u63a5\u3002","google_calendar_disconnect":"Google \u65e5\u5386\u5df2\u6210\u529f\u65ad\u5f00\u8fde\u63a5\u3002","google_calendar_update":"\u60a8\u7684 Google \u65e5\u5386\u66f4\u65b0\u6210\u529f\u3002","holiday_already_is_exist":"\u8be5\u65e5\u671f\u5df2\u5b58\u5728\u5047\u671f","icon_validation_message":"\u56fe\u6807\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg\u3001jpeg\u3001png\u3001svg\u3002","language_change":"\u8bed\u8a00\u66f4\u6539\u6210\u529f","language_update":"\u8bed\u8a00\u66f4\u65b0\u6210\u529f\u3002","live_consultation_delete":"\u5b9e\u65f6\u54a8\u8be2\u5220\u9664\u6210\u529f\u3002","live_consultation_retrieved":"\u5df2\u6210\u529f\u68c0\u7d22\u5b9e\u65f6\u54a8\u8be2\u3002","live_consultation_save":"\u5b9e\u65f6\u54a8\u8be2\u4fdd\u5b58\u6210\u529f\u3002","live_consultation_update":"\u5b9e\u65f6\u54a8\u8be2\u66f4\u65b0\u6210\u529f\u3002","logo_validation_message":"\u5e94\u7528\u7a0b\u5e8f\u5fbd\u6807\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg\u3001jpeg\u3001png\u3002","maximum_char":"\u6700\u591a\u5141\u8bb8 60 \u4e2a\u5b57\u7b26\u3002","messages_sent":"\u6d88\u606f\u53d1\u9001\u6210\u529f","no_available_slots":"\u5728\u7ed9\u5b9a\u65e5\u671f\u6ca1\u6709\u53ef\u7528\u7684\u63d2\u69fd\u3002","note_added":"\u7b14\u8bb0\u6dfb\u52a0\u6210\u529f\u3002","note_delete":"\u7b14\u8bb0\u5220\u9664\u6210\u529f\u3002","notification_read":"\u901a\u77e5\u8bfb\u53d6\u6210\u529f\u3002","notification_send":"\u90ae\u4ef6\u9a8c\u8bc1\u901a\u77e5\u53d1\u9001\u6210\u529f\u3002","observation_added":"\u89c2\u5bdf\u6dfb\u52a0\u6210\u529f\u3002","observation_delete":"\u89c2\u5bdf\u5220\u9664\u6210\u529f\u3002","operation_performed_success":"\u64cd\u4f5c\u6210\u529f\u6267\u884c","order_create":"\u8ba2\u5355\u521b\u5efa\u6210\u529f\u3002","password_update":"\u5bc6\u7801\u66f4\u65b0\u6210\u529f\u3002","patient_appointment":"\u60a3\u8005\u9884\u7ea6\u65e5\u5386\u6570\u636e\u68c0\u7d22\u6210\u529f\u3002","patient_create":"\u60a3\u8005\u521b\u5efa\u6210\u529f\u3002","patient_delete":"\u60a3\u8005\u5220\u9664\u6210\u529f\u3002","patient_not_found":"\u672a\u627e\u5230\u60a3\u8005\u3002","patient_update":"\u60a3\u8005\u66f4\u65b0\u6210\u529f\u3002","patient_used":"\u60a3\u8005\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u8fc7\u3002","patients_retrieve":"\u60a3\u8005\u68c0\u7d22\u6210\u529f\u3002","payment_status_updated":"\u4ed8\u6b3e\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","paystack_token_expired":"paystack \u4ee4\u724c\u5df2\u8fc7\u671f\u3002\u8bf7\u5237\u65b0\u9875\u9762\u5e76\u91cd\u8bd5\u3002","plan_default":"\u9ed8\u8ba4\u8ba1\u5212\u66f4\u6539\u6210\u529f\u3002","plan_status":"\u8ba1\u5212\u72b6\u6001\u66f4\u65b0\u6210\u529f","plan_update":"\u8ba1\u5212\u66f4\u65b0\u6210\u529f\u3002","prescription_delete":"\u5904\u65b9\u5220\u9664\u6210\u529f\u3002","prescription_retrieved":"\u5904\u65b9\u68c0\u7d22\u6210\u529f\u3002","problem_added":"\u95ee\u9898\u6dfb\u52a0\u6210\u529f\u3002","problem_delete":"\u95ee\u9898\u5220\u9664\u6210\u529f\u3002","profile_validation_message":"\u914d\u7f6e\u6587\u4ef6\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg\u3001jpeg\u3001png\u3002","qualification_create":"\u8d44\u683c\u521b\u5efa\u6210\u529f\u3002","reactive_account":"\u901a\u8fc7\u90ae\u4ef6\u91cd\u65b0\u6fc0\u6d3b\u60a8\u7684\u5e10\u6237\u3002","retrieve":"\u68c0\u7d22\u6210\u529f\u3002","review_add":"\u5ba1\u6838\u6dfb\u52a0\u6210\u529f\u3002","review_edit":"\u8bc4\u8bba\u7f16\u8f91\u6210\u529f\u3002","review_retrieved":"\u8bc4\u8bba\u68c0\u7d22\u6210\u529f\u3002","role_create":"\u89d2\u8272\u521b\u5efa\u6210\u529f\u3002","role_delete":"\u89d2\u8272\u5220\u9664\u6210\u529f\u3002","role_update":"\u89d2\u8272\u66f4\u65b0\u6210\u529f\u3002","schedule_crete":"\u8ba1\u5212\u521b\u5efa\u6210\u529f\u3002","schedule_delete":"\u8ba1\u5212\u5220\u9664\u6210\u529f\u3002","schedule_not_found":"\u672a\u627e\u5230\u65f6\u95f4\u8868\u3002","schedule_update":"\u65e5\u7a0b\u66f4\u65b0\u6210\u529f\u3002","0":"\u533b\u751f\u4e0d\u53ef\u7528","select_calendar.":"Please select a calendar.","select_payment":"\u8bf7\u9009\u62e9\u4efb\u4f55\u4e00\u79cd\u4ed8\u6b3e\u65b9\u5f0f","service_cat_create":"\u670d\u52a1\u7c7b\u522b\u521b\u5efa\u6210\u529f\u3002","service_cat_delete":"\u670d\u52a1\u7c7b\u522b\u5220\u9664\u6210\u529f\u3002","service_cat_update":"\u670d\u52a1\u7c7b\u522b\u66f4\u65b0\u6210\u529f\u3002","service_cat_use":"\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u7684\u670d\u52a1\u7c7b\u522b\u3002","service_create":"\u670d\u52a1\u521b\u5efa\u6210\u529f\u3002","service_delete":"\u670d\u52a1\u5220\u9664\u6210\u529f\u3002","service_update":"\u670d\u52a1\u66f4\u65b0\u6210\u529f\u3002","service_use":"\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u7684\u670d\u52a1\u3002","session_retrieve":"\u4f1a\u8bdd\u68c0\u7d22\u6210\u529f\u3002","setting_update":"\u8bbe\u7f6e\u66f4\u65b0\u6210\u529f\u3002","slider_update":"\u6ed1\u5757\u66f4\u65b0\u6210\u529f","some_doctors":"\u6709\u4e9b\u533b\u751f\u628a\u4ed6\u4eec\u7684\u65e5\u5b50\u5b89\u6392\u5728\u7ed9\u5b9a\u7684\u672a\u7ecf\u68c0\u67e5\u7684\u65e5\u5b50\u91cc\uff0c\u6240\u4ee5\u4f60\u786e\u5b9a\u8981\u6267\u884c\u8fd9\u4e2a\u624b\u672f\u5417\uff1f","something_went_wrong":"\u51fa\u95ee\u9898\u4e86","specialization_create":"\u4e13\u4e1a\u5316\u521b\u5efa\u6210\u529f\u3002","specialization_delete":"\u4e13\u4e1a\u5316\u5220\u9664\u6210\u529f\u3002","specialization_update":"\u4e13\u4e1a\u66f4\u65b0\u6210\u529f\u3002","specialization_use":"\u4e13\u4e1a\u5316\u4f7f\u7528\u6210\u529f\u3002","staff_create":"\u5458\u5de5\u521b\u5efa\u6210\u529f\u3002","staff_delete":"\u5458\u5de5\u5220\u9664\u6210\u529f\u3002","staff_update":"\u5458\u5de5\u66f4\u65b0\u6210\u529f\u3002","staff_use":"\u5458\u5de5\u4f7f\u7528\u6210\u529f\u3002","state_create":"\u72b6\u6001\u521b\u5efa\u6210\u529f\u3002","state_delete":"\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","state_update":"\u72b6\u6001\u5220\u9664\u6210\u529f\u3002","state_use":"\u56fd\u5bb6\u5728\u5176\u4ed6\u5730\u65b9\u4f7f\u7528\u3002","states_retrieve":"\u72b6\u6001\u68c0\u7d22\u6210\u529f\u3002","status_change":"\u72b6\u6001\u66f4\u6539\u6210\u529f\u3002","status_update":"\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","subscriber_creat":"\u8ba2\u9605\u8005\u521b\u5efa\u6210\u529f\u3002","subscriber_delete":"\u8ba2\u9605\u8005\u5220\u9664\u6210\u529f\u3002","testimonial_creat":"\u524d\u9762\u7684\u60a3\u8005\u89c1\u8bc1\u521b\u5efa\u6210\u529f\u3002","testimonial_delete":"\u524d\u9762\u7684\u75c5\u4eba\u89c1\u8bc1\u5220\u9664\u6210\u529f\u3002","testimonial_update":"\u524d\u9762\u7684\u60a3\u8005\u89c1\u8bc1\u66f4\u65b0\u6210\u529f\u3002","testimonial_use":"\u524d\u9762\u7684\u60a3\u8005\u8bc1\u660e\u5df2\u6210\u529f\u4f7f\u7528\u3002","theme_change":"\u4e3b\u9898\u66f4\u6539\u6210\u529f\u3002","there_were":"\u4ed8\u6b3e\u6709\u95ee\u9898\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002","university_required":"\u5927\u5b66\u662f\u5fc5\u9700\u7684\u3002","update_blog":"VCard \u535a\u5ba2\u66f4\u65b0\u6210\u529f\u3002","update_front_testimonial":"\u8bc1\u660e\u66f4\u65b0\u6210\u529f\u3002","user_8_or":"\u4f7f\u7528 6 \u4e2a\u6216\u66f4\u591a\u5b57\u7b26\uff0c\u6df7\u5408\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7b26\u53f7\u3002","user_already_verified":"\u7528\u6237\u5df2\u7ecf\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u3002","user_profile":"\u7528\u6237\u8d44\u6599\u66f4\u65b0\u6210\u529f\u3002","user_profile_update":"\u7528\u6237\u8d44\u6599\u66f4\u65b0\u6210\u529f\u3002","user_role_not_delete":"\u65e0\u6cd5\u5220\u9664\u6b64\u7528\u6237\u89d2\u8272\uff0c\u56e0\u4e3a\u5b83\u5df2\u5206\u914d\u7ed9\u7528\u6237\u3002","user_status":"\u7528\u6237\u72b6\u6001\u66f4\u65b0\u6210\u529f","user_update":"\u7528\u6237\u66f4\u65b0\u6210\u529f\u3002","user_zoom_credential_saved":"\u7528\u6237 \u98de\u6da8 \u51ed\u8bc1\u4fdd\u5b58\u6210\u529f\u3002","valid_instagram":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Instagram \u7f51\u5740","valid_linkedin":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u9886\u82f1\u7f51\u5740","valid_twitter":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Twitter \u7f51\u5740","verified_email":"\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u6210\u529f\u3002","visit_create":"\u8bbf\u95ee\u521b\u5efa\u6210\u529f\u3002","visit_delete":"\u8bbf\u95ee\u5220\u9664\u6210\u529f\u3002","visit_prescription_added":"\u8bbf\u95ee\u5904\u65b9\u6dfb\u52a0\u6210\u529f\u3002","visit_prescription_update":"\u8bbf\u95ee\u5904\u65b9\u66f4\u65b0\u6210\u529f\u3002","visit_update":"\u8bbf\u95ee\u66f4\u65b0\u6210\u529f\u3002","year_required":"\u5e74\u4efd\u662f\u5fc5\u9700\u7684\u3002","your_reg_success":"\u60a8\u7684\u6ce8\u518c\u6210\u529f\u3002\u8bf7\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u60a8\u7684\u5e10\u6237\u3002"},"front_cms":"\u524d\u7aef CMS","front_medical_service":{"add_front_medical_service":"\u6dfb\u52a0\u524d\u7ebf\u533b\u7597\u670d\u52a1","edit_front_medical_service":"\u7f16\u8f91\u524d\u7ebf\u533b\u7597\u670d\u52a1","short_description":"\u7b80\u77ed\u8bf4\u660e","title":"\u6807\u9898"},"front_medical_services":"\u524d\u7ebf\u533b\u7597\u670d\u52a1","front_patient_testimonial":{"add_front_patient_testimonial":"\u6dfb\u52a0\u524d\u53f0\u60a3\u8005\u63a8\u8350","designation":"\u6307\u5b9a","edit_front_patient_testimonial":"\u7f16\u8f91\u524d\u53f0\u60a3\u8005\u63a8\u8350","more_patient_feedbacks":"\u66f4\u591a\u60a3\u8005\u53cd\u9988...","name":"\u59d3\u540d","patient_testimonials":"\u60a3\u8005\u611f\u8a00","profile":"\u4e2a\u4eba\u8d44\u6599","short_description":"\u7b80\u77ed\u8bf4\u660e"},"front_patient_testimonials":"\u524d\u53f0\u60a3\u8005\u63a8\u8350","front_service":{"add_front_service":"\u6dfb\u52a0\u524d\u53f0\u670d\u52a1","edit_front_service":"\u7f16\u8f91\u524d\u53f0\u670d\u52a1","icon":"\u56fe\u6807","short_description":"\u7b80\u77ed\u8bf4\u660e","title":"\u6807\u9898"},"front_services":"\u524d\u53f0\u670d\u52a1","holder_name_invalid":"\u6301\u5361\u4eba\u59d3\u540d\u7121\u6548\u3002","holder_name_required":"\u6301\u5361\u4eba\u59d3\u540d\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805\u3002","holder_number_invalid":"\u5361\u865f\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805\u3002","holiday":{"add_holiday":"\u6dfb\u52a0\u5047\u671f","doctor_holiday":"\u533b\u751f\u5047\u671f","holiday":"\u5047\u671f","holiday_date":"\u5047\u671f\u65e5\u671f","service_category":"\u670d\u52a1\u7c7b\u522b"},"icon_size":"\u5716\u793a\u5927\u5c0f\u61c9\u5c0f\u65bc 2 MB","id":"ID","image_file_type":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1ajpeg\u3001jpg\u3001png\u3002","invalid_country_code":"\u56fd\u5bb6\u4ee3\u7801\u65e0\u6548","invalid_number":"\u65e0\u6548\u53f7\u7801","invalid_range":"\u7121\u6548\u7bc4\u570d","live_consultation":{"add_credential":"\u6dfb\u52a0\u51ed\u636e","add_live_consultation":"\u6dfb\u52a0\u5b9e\u65f6\u54a8\u8be2","awaited":"\u7b49\u5f85\u4e2d","client_video":"\u5ba2\u6237\u89c6\u9891","consultation_date":"\u54a8\u8be2\u65e5\u671f","consultation_duration_minutes":"\u54a8\u8be2\u65f6\u95f4\u5206\u949f","consultation_minutes":"\u54a8\u8be2\u7eaa\u8981","consultation_title":"\u54a8\u8be2\u6807\u9898","created_by":"\u7531...\u5236\u4f5c","created_for":"\u521b\u9020","description":"\u63cf\u8ff0","disabled":"\u7981\u7528","duration":"\u6301\u7eed\u65f6\u95f4\uff08\u4ee5\u5206\u949f\u4e3a\u5355\u4f4d\uff09","edit_live_consultation":"\u7f16\u8f91\u5b9e\u65f6\u54a8\u8be2","edit_live_meeting":"\u7f16\u8f91\u5b9e\u65f6\u4f1a\u8bae","enable":"\u4f7f\u80fd\u591f","finished":"\u5b8c\u6210\u7684","host_video":"\u4e3b\u673a\u89c6\u9891","join_now":"\u73b0\u5728\u52a0\u5165","live_consultation_details":"\u73b0\u573a\u54a8\u8be2\u8be6\u60c5","new_live_consultation":"\u65b0\u7684\u73b0\u573a\u54a8\u8be2","new_live_meeting":"\u65b0\u7684\u5b9e\u65f6\u4f1a\u8bae","select_consultation_date":"\u9009\u62e9\u54a8\u8be2\u65e5\u671f","select_doctor_name":"\u9009\u62e9\u533b\u751f\u59d3\u540d","select_patient_name":"\u9009\u62e9\u60a3\u8005\u59d3\u540d","staff_list":"\u5458\u5de5\u540d\u5355","start_now":"\u73b0\u5728\u5f00\u59cb","type":"\u7c7b\u578b","type_number":"\u578b\u53f7","zoom_api_key":"\u7f29\u653e API \u952e","zoom_api_secret":"\u7f29\u653e API \u79d8\u5bc6"},"live_consultations":"\u73b0\u573a\u54a8\u8be2","live_status_retrieved_successfully.":"\u5373\u6642\u72c0\u614b\u5df2\u6210\u529f\u6aa2\u7d22\u3002","login":"\u767b\u5f55","medicine":{"available_quantity":"\u53ef\u7528\u6570\u91cf","brand":"\u54c1\u724c","brand_name":"\u54c1\u724c","buying_price":"\u4e70\u4ef7","cant_be_deleted":"\u65e0\u6cd5\u5220\u9664","category":"\u7c7b\u522b","category_id":"\u7c7b\u522b ID","category_retrieved_successfully":"\u85e5\u54c1\u985e\u5225\u6aa2\u7d22\u6210\u529f\u3002","deleted_successfully":"\u5220\u9664\u6210\u529f","description":"\u63cf\u8ff0","dosage":"\u5242\u91cf","dose_interval":"\u9078\u64c7\u5291\u91cf\u9593\u9694","duration":"\u671f\u95f4","edit_medicine":"\u7f16\u8f91\u533b\u5b66","edit_medicine_brand":"\u7f16\u8f91\u836f\u54c1\u54c1\u724c","edit_medicine_category":"\u7f16\u8f91\u836f\u54c1\u7c7b\u522b","filter_options":"\u8fc7\u6ee4\u5668\u9009\u9879","medicine":"\u836f\u54c1","medicine_brands":"\u836f\u54c1\u54c1\u724c","medicine_brands_details":"\u836f\u54c1\u54c1\u724c\u8be6\u60c5","medicine_category":"\u836f\u54c1\u7c7b\u522b","medicine_category_details":"\u836f\u54c1\u7c7b\u522b\u8be6\u60c5","medicine_details":"\u836f\u54c1\u8be6\u60c5","medicine_name":"\u836f\u54c1\u540d\u79f0","medicine_retrieved_successfully":"\u85e5\u7269\u6210\u529f\u53d6\u56de","medicines":"\u836f\u7269","name":"\u59d3\u540d","new_brand":"\u65b0\u54c1\u724c","new_medicine":"\u65b0\u836f","new_medicine_brand":"\u65b0\u533b\u836f\u54c1\u724c","new_medicine_category":"\u65b0\u836f\u7c7b\u522b","no_use":"\u672a\u4f7f\u7528","quantity":"\u6570\u91cf","salt_composition":"\u76d0\u6210\u5206","saved_successfully":"\u4fdd\u5b58\u6210\u529f","select_duration":"\u9078\u64c7\u6301\u7e8c\u6642\u9593","selling_price":"\u552e\u4ef7","side_effects":"\u526f\u4f5c\u7528","status_updated_successfully":"\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","updated_successfully":"\u66f4\u65b0\u6210\u529f"},"medicine_bills":{"add_medicine_bill":"\u6dfb\u52a0\u836f\u54c1\u8d26\u5355","available_quantity":"\u53ef\u7528\u6570\u91cf","avl_qty":"\u5e73\u5747\u6578\u91cf","bill_date":"\u8d26\u5355\u65e5\u671f","bill_id":"\u5e10\u5355\u7f16\u53f7","bill_number":"\u5e10\u5355\u53f7\u7801","cell_no":"\u5c0f\u533a\u7f16\u53f7","dose_interval":"\u5242\u91cf\u95f4\u9694","duplicate_medicine":"\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u836f\u7269\u3002","edit_medicine_bill":"\u7f16\u8f91\u836f\u54c1\u8d26\u5355","enter_lot_number":"\u8f93\u5165\u6279\u53f7\u3002","enter_puchase_price":"\u8f93\u5165\u8d2d\u4e70\u4ef7\u683c","enter_sale_price":"\u8f93\u5165\u9500\u552e\u4ef7\u683c\u3002","is":"\u662f","item_name":"\u9879\u76ee\u540d","medicine_bill":"\u533b\u836f\u6cd5\u6848","medicine_bill_details":"\u836f\u54c1\u8d26\u5355\u8be6\u60c5","medicine_bills":"\u533b\u836f\u8d39","medicine_not_selected":"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u836f\u7269\u3002","medicine_required":"\u9700\u8981\u533b\u5b66\u9886\u57df\u3002","net_amount_cant":"\u51c0\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002","net_amount_cant_zero":"\u51c0\u989d\u4e0d\u80fd\u4e3a\u96f6\u3002","net_amount_not_empty":"\u51c0\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002","net_amount_not_zero":"\u51c0\u989d\u4e0d\u80fd\u4e3a\u96f6\u3002","new_medicine_bill":"\u65b0\u533b\u836f\u6cd5\u6848","payment_status":"\u652f\u4ed8\u72b6\u6001","payment_type":"\u4ed8\u6b3e\u65b9\u5f0f","prescription_not_found":"\u672a\u627e\u5230\u5904\u65b9","price":"\u4ef7\u683c","print_bill":"\u6253\u5370\u8d26\u5355","quantity_should":"\u6570\u91cf\u5e94\u5927\u4e8e 0\u3002","sale_price":"\u9500\u552e\u4ef7\u683c","select_medicine":"\u9009\u62e9\u836f\u7269","select_patient":"\u9009\u62e9\u60a3\u8005","select_payment_type":"\u9009\u62e9\u4ed8\u6b3e\u65b9\u5f0f","tax_amt":"\u7a0e\u989d\u4e0d\u80fd\u4e3a\u96f6\u6216\u4e3a\u7a7a\u3002","tax_cannot_be_zero_empty":"\u7a0e\u989d\u4e0d\u80fd\u4e3a\u96f6\u6216\u4e3a\u7a7a\u3002","tax_should_be":"\u7a0e\u6536\u5e94\u4f4e\u4e8e 100%\u3002","the_discount_shoul":"\u6298\u6263\u91d1\u989d\u5e94\u5c0f\u4e8e\u603b\u91d1\u989d","the_medicine_already_in_use":"\u8be5\u836f\u5df2\u5728\u533b\u836f\u8d26\u5355\u4e2d\u4f7f\u7528\uff0c\u60a8\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f","update_quantity":"\u66f4\u65b0\u6570\u91cf\u5e94\u5c0f\u4e8e\u4e4b\u524d\u7684\u6570\u91cf\u3002"},"medicine_brands":"\u836f\u54c1\u54c1\u724c","medicine_categories":"\u533b\u836f\u7c7b\u522b","medicines":"\u836f\u7269","mobile_no":"\u624b\u673a\u53f7\u7801","months":{"apr":"\u56db\u6708","aug":"\u4e5d\u6708","dec":"\u592a\u9633","feb":"\u4e8c\u6708","jan":"\u7b80","jul":"\u516b\u6708","jun":"\u541b","mar":"\u4e09\u6708","may":"\u53ef\u80fd","nov":"\u5341\u4e8c\u6708","oct":"\u5341\u4e00\u6708","sep":"\u5341\u6708"},"no_response":"\u6c92\u6709\u56de\u8986","not_supported":"\u4e0d\u652f\u63f4","note":"\u6ce8\u610f\uff1a\u60a8\u5fc5\u987b\u5728\u96c6\u6210 Google \u65e5\u5386\u4e4b\u524d\u8bbe\u7f6e\u60a8\u7684\u65f6\u533a\u3002","notification":{"mark_all_as_read":"\u6807\u8bb0\u4e3a\u5df2\u8bfb","notification":"\u901a\u77e5","you_don`t_have_any_new_notification":"\u60a8\u6ca1\u6709\u4efb\u4f55\u65b0\u901a\u77e5"},"patient":{"add":"\u6dfb\u52a0\u60a3\u8005","address1":"\u5730\u5740 1","address2":"\u5730\u5740 2","address_information":"\u5730\u5740\u4fe1\u606f","blood_group":"\u8840\u578b","city":"\u57ce\u5e02","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_no":"\u8054\u7cfb\u53f7\u7801","country":"\u56fd\u5bb6","details":"\u60a3\u8005\u8be6\u7ec6\u4fe1\u606f","dob":"\u51fa\u751f\u65e5\u671f","edit":"\u7f16\u8f91\u60a3\u8005","email":"\u7535\u5b50\u90ae\u4ef6","emailverified":"\u96fb\u5b50\u90f5\u4ef6\u5df2\u9a57\u8b49","enter_email":"\u8f38\u5165\u96fb\u5b50\u90f5\u4ef6","enter_password":"\u8f38\u5165\u5bc6\u78bc","female":"\u5973","filter":"\u7be9\u9078","first_name":"\u540d\u5b57","gender":"\u6027\u522b","last_name":"\u59d3\u6c0f","last_updated":"\u6700\u540e\u66f4\u65b0","male":"\u7537","name":"\u59d3\u540d","password":"\u5bc6\u7801","patient_unique_id":"\u60a3\u8005\u552f\u4e00 ID","postal_code":"\u90ae\u653f\u7f16\u7801","profile":"\u4e2a\u4eba\u8d44\u6599","registered_on":"\u6ce8\u518c","save_changes":"\u4fdd\u5b58\u66f4\u6539","state":"\u72b6\u6001","today":"\u4eca\u5929"},"patient_dashboard":{"completed_appointments":"\u5df2\u5b8c\u6210\u7684\u7ea6\u4f1a","next_appointment":"\u4e0b\u6b21\u7ea6\u4f1a","today_appointments":"\u4eca\u65e5\u7ea6\u4f1a","upcoming_appointments":"\u5373\u5c06\u5230\u6765\u7684\u7ea6\u4f1a"},"patients":"\u75c5\u4eba","payment_detail":"\u4ed8\u6b3e\u660e\u7ec6","payment_for_booking_appointment_with_doctor":"\u4e0e\u533b\u751f\u9884\u7ea6\u7684\u8d39\u7528","payment_method":{"authorize":"\u6388\u6743","paypal":"\u8d1d\u5b9d","paystack":"\u652f\u4ed8\u5b9d","paytm":"\u652f\u4ed8\u5b9d","razorpay":"\u5243\u5200\u652f\u4ed8","stripe":"\u6761\u7eb9"},"paytm":"\u652f\u4ed8\u5b9d","prescription":{"Rx":"\u63a5\u6536","accident":"\u4e8b\u6545","advice":"\u5efa\u8bae","after meal":"\u5403\u996d\u540e","appointment_slot":"\u9884\u7ea6\u65f6\u6bb5","available_quantity_of":"\u53ef\u7528\u6578\u91cf ","before meal":"\u996d\u524d","breast_feeding":"\u6bcd\u4e73\u5582\u517b","comment":"\u8bc4\u8bba","connect_with_zoom":" \u4e0e \u98de\u6da8 \u8fde\u63a5","current_medication":"\u5f53\u524d\u836f\u7269","days":"\u5929","diabetic":"\u7cd6\u5c3f\u75c5\u7684","doctor":"\u533b\u751f","dosage":"\u5242\u91cf","duration":"\u671f\u95f4","edit_prescription":"\u7f16\u8f91\u5904\u65b9","female_pregnancy":"\u5973\u6027\u6000\u5b55","food_allergies":"\u98df\u7269\u8fc7\u654f","frequency":"\u9891\u7387","health_insurance":"\u5065\u5eb7\u4fdd\u9669","heart_disease":"\u5fc3\u810f\u75c5","high_blood_pressure":"\u9ad8\u8840\u538b","is":"\u662f","low_income":"\u4f4e\u6536\u5165","medical_history":"\u75c5\u53f2","medicine_name":"\u836f\u540d","name":"\u59d3\u540d","new_medicine":"\u65b0\u836f","new_prescription":"\u65b0\u5904\u65b9","next_visit":"\u4e0b\u6b21\u8bbf\u95ee","not_add_duplicate_medicines":"\u4e0d\u80fd\u91cd\u8907\u6dfb\u52a0\u85e5\u7269\u3002","ok":"\u597d\u7684","others":"\u5176\u4ed6","patient":"\u60a3\u8005","physical_information":"\u7269\u7406\u4fe1\u606f","plus_rate":"\u5fc3\u7387","prescription":"\u5904\u65b9","prescription_details":"\u5904\u65b9\u8be6\u60c5","prescription_saved":"\u5904\u65b9\u4fdd\u5b58\u6210\u529f\u3002","prescription_updated":"\u5904\u65b9\u66f4\u65b0\u6210\u529f\u3002","prescriptions":"\u5904\u65b9\u836f","problem":"\u95ee\u9898","problem_description":"\u95ee\u9898\u63cf\u8ff0","reference":"\u53c2\u8003","selectMedicine":"\u9078\u64c7\u85e5\u7269","surgery":"\u624b\u672f","temperature":"\u6e29\u5ea6","tendency_bleed":"\u503e\u5411\u6d41\u8840","test":"\u6d4b\u8bd5","time":"\u65f6\u95f4","total_quantity":"\u7e3d\u6578\uff08\u91cf"},"privacy_policy":"\u9690\u79c1\u653f\u7b56","purchase_medicine":{"actions":"\u884c\u52a8","amount":"\u6570\u91cf","discount":"\u6298\u6263","dose_duration":"\u5242\u91cf\u6301\u7eed\u65f6\u95f4","expiry_date":"\u5230\u671f\u65e5","export_to_excel":"\u5bfc\u51fa\u5230 Excel","lot_no":"\u6279\u53f7","net_amount":"\u51c0\u989d","note":"\u7b14\u8bb0","other_details":"\u5176\u4ed6\u8be6\u60c5","payment_mode":"\u4ed8\u6b3e\u65b9\u5f0f","payment_note":"\u4ed8\u6b3e\u5355","purchase_medicine":"\u8d2d\u4e70\u836f\u54c1","purchase_medicine_details":"\u8d2d\u4e70\u836f\u54c1\u8be6\u60c5","purchase_medicine_overview":"\u91c7\u8d2d\u836f\u54c1\u6982\u89c8","purchase_medicines":"\u8d2d\u4e70\u836f\u54c1","purchase_number":"\u8d2d\u4e70\u6570\u91cf","purchased_medicine_success":"\u836f\u54c1\u8d2d\u4e70\u6210\u529f","quantity":"\u6570\u91cf","tax":"\u7a0e","tax_amount":"\u7a0e\u989d","total":"\u5168\u90e8\u7684"},"range_constructor_requires_trie_parameter":"Range \u5efa\u69cb\u51fd\u5f0f\u9700\u8981 Trie \u53c3\u6578","register":"\u6ce8\u518c","requires_string_parameter":"rangeWithString \u9700\u8981\u4e00\u500b\u5b57\u4e32\u53c3\u6578","resend_email_verification":"\u91cd\u65b0\u53d1\u9001\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1","review":{"add_review":"\u6dfb\u52a0\u8bc4\u8bba","edit_review":"\u7f16\u8f91\u8bc4\u8bba","no_doctors_available_to_give_rating":"\u6ca1\u6709\u533b\u751f\u53ef\u63d0\u4f9b\u8bc4\u7ea7\u3002","review":"\u5ba1\u67e5","write_a_review":"\u5199\u8bc4\u8bba"},"reviews":"\u8bc4\u8bba","role":{"add_role":"\u6dfb\u52a0\u89d2\u8272","edit_role":"\u7f16\u8f91\u89d2\u8272","permissions":"\u6743\u9650","role":"\u89d2\u8272","role_permissions":"\u89d2\u8272\u6743\u9650","select_all_permissions":"\u9009\u62e9\u6240\u6709\u6743\u9650"},"roles":"\u89d2\u8272","service":{"add_service":"\u6dfb\u52a0\u670d\u52a1","category":"\u7c7b\u522b","charges":"\u6536\u8d39","edit_service":"\u7f16\u8f91\u670d\u52a1","short_description":"\u7b80\u77ed\u8bf4\u660e"},"service_categories":"\u670d\u52a1\u7c7b\u522b","service_category":{"add_category":"\u6dfb\u52a0\u670d\u52a1\u7c7b\u522b","edit_category":"\u7f16\u8f91\u670d\u52a1\u7c7b\u522b","service_category":"\u670d\u52a1\u7c7b\u522b"},"services":"\u670d\u52a1","setting":{"address":"\u5730\u5740","change_app_logo":"\u66f4\u6539\u5e94\u7528\u7a0b\u5e8f\u5fbd\u6807","change_favicon":"\u66f4\u6539\u7f51\u7ad9\u56fe\u6807","clinic_name":"\u8bca\u6240\u540d\u79f0","connect_google_calendar":"\u8fde\u63a5\u8c37\u6b4c\u65e5\u5386","connect_your_google_calendar":"\u8fde\u63a5\u4f60\u7684\u8c37\u6b4c\u65e5\u5386","contact_information":"\u8054\u7cfb\u65b9\u5f0f","currency":"\u8d27\u5e01","currency_settings":"\u8d27\u5e01\u8bbe\u7f6e","default_country_code":"\u9ed8\u8ba4\u56fd\u5bb6\u4ee3\u7801","default_language_suggest":"\u900f\u904e\u66f4\u65b0\uff0c\u6574\u500b\u61c9\u7528\u7a0b\u5f0f\u7684\u8a9e\u8a00\u5c07\u5728\u91ab\u751f\u3001\u60a3\u8005\u767b\u5165\u4ee5\u53ca\u524d\u7aef\u767c\u751f\u8b8a\u5316\u3002","disconnect_your_google_calendar":"\u65ad\u5f00\u60a8\u7684 Google \u65e5\u5386","do_not_allow_to_login_without_email_verification":"\u4e0d\u5141\u8bb8\u5728\u6ca1\u6709\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u7684\u60c5\u51b5\u4e0b\u767b\u5f55","favicon":"\u6536\u85cf\u5939","general":"\u4e00\u822c","general_details":"\u4e00\u822c\u8be6\u60c5","logo":"\u6807\u5fd7","postal_code":"\u90ae\u653f\u7f16\u7801","prefix":"\u524d\u7f00","select_your_calendars_from_google_calendar_in_which_you_want_to_create_the_appointments":"\u9009\u62e9\u60a8\u8981\u5728\u5176\u4e2d\u521b\u5efa\u7ea6\u4f1a\u7684\u65e5\u5386\uff08\u6765\u81ea Google \u65e5\u5386\uff09","setting":"\u73af\u5883","specialities":"\u4e13\u4e1a","sync_your_google_calendar":"\u540c\u6b65\u4f60\u7684\u8c37\u6b4c\u65e5\u5386","when_checkbox_disable":"\u5f53\u590d\u9009\u6846\u88ab\u7981\u7528\u65f6\uff0c\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1\u4e0d\u9002\u7528\u4e8e\u65b0\u7528\u6237\u3002","when_patient_book_an_appointment_with_you_new_appointment_will_created_on_selected_calendars":"\u5f53\u60a3\u8005\u4e0e\u60a8\u9884\u7ea6\u65f6\uff0c\u5c06\u5728\u9009\u5b9a\u7684\u65e5\u5386\u4e0a\u521b\u5efa\u65b0\u7684\u9884\u7ea6","when_you_book_an_appointment_new_appointment_will_created_on_selected_calendars":"\u5f53\u60a8\u9884\u8ba2\u7ea6\u4f1a\u65f6\uff0c\u5c06\u5728\u6240\u9009\u65e5\u5386\u4e0a\u521b\u5efa\u65b0\u7ea6\u4f1a"},"settings":"\u8bbe\u7f6e","slider":{"add_slider":"\u6dfb\u52a0\u6ed1\u5757","edit_slider":"\u7f16\u8f91\u6ed1\u5757","image":"\u56fe\u7247","short_description":"\u7b80\u77ed\u8bf4\u660e","title":"\u6807\u9898"},"sliders":"\u6ed1\u5757","smart_patient_card":{"add_smart_card":"\u6dfb\u52a0\u667a\u80fd\u5361","add_smart_card_templates":"\u6dfb\u52a0\u667a\u80fd\u5361\u6a21\u677f","address_show":"\u663e\u793a\u5730\u5740","blood_group_show":"\u663e\u793a\u8840\u578b","dob_show":"\u663e\u793a\u51fa\u751f\u65e5\u671f","edit_patient_card":"\u7f16\u8f91\u667a\u80fd\u5361","email_show":"\u663e\u793a\u7535\u5b50\u90ae\u4ef6","enter_template_name":"\u8f93\u5165\u6a21\u677f\u540d\u79f0","for_all_patient":"\u6240\u6709\u60a3\u8005","generate_patient_card":"\u751f\u6210\u60a3\u8005\u5361","generate_patient_smart_cards":"\u751f\u6210\u60a3\u8005\u667a\u80fd\u5361","header_color":"\u6807\u9898\u989c\u8272","only_one_patient":"\u4ec5\u4e00\u4e2a\u60a3\u8005","patient":"\u60a3\u8005","patient_smart_card_created":"\u6210\u529f\u521b\u5efa\u60a3\u8005\u667a\u80fd\u5361\u3002","patient_smart_card_deleted":"\u6210\u529f\u5220\u9664\u60a3\u8005\u667a\u80fd\u5361\u3002","phone_show":"\u663e\u793a\u7535\u8bdd","please_selest_patient":"\u8acb\u9078\u64c7\u60a3\u8005","remaning_patients":"\u5269\u4f59\u60a3\u8005","select_patient":"\u9009\u62e9\u60a3\u8005","select_template":"\u9009\u62e9\u6a21\u677f","smart_patient_card_templates":"\u667a\u80fd\u60a3\u8005\u5361\u6a21\u677f","smart_patient_cards":"\u667a\u80fd\u60a3\u8005\u5361","templat_name":"\u6a21\u677f\u540d\u79f0","template":"\u6a21\u677f","template_created":"\u6210\u529f\u521b\u5efa\u6a21\u677f\u3002","template_deleted":"\u6210\u529f\u5220\u9664\u6a21\u677f\u3002","template_update":"\u6210\u529f\u66f4\u65b0\u6a21\u677f\u3002","type":"\u7c7b\u578b","unique_id_show":"\u663e\u793a\u552f\u4e00\u6807\u8bc6"},"specialization":{"add_specialization":"\u6dfb\u52a0\u4e13\u4e1a\u5316","edit_specialization":"\u7f16\u8f91\u4e13\u4e1a\u5316","retrieved_successfully":"\u5c08\u696d\u5316\u5df2\u6210\u529f\u6aa2\u7d22\u3002"},"specializations":"\u4e13\u4e1a","staff":{"add_staff":"\u6dfb\u52a0\u5458\u5de5","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_no":"\u8054\u7cfb\u53f7\u7801","edit_staff":"\u7f16\u8f91\u4eba\u5458","email":"\u7535\u5b50\u90ae\u4ef6","female":"\u5973","first_name":"\u540d\u5b57","gender":"\u6027\u522b","last_name":"\u59d3\u6c0f","male":"\u7537","password":"\u5bc6\u7801","role":"\u89d2\u8272","select_role":"\u9009\u62e9\u89d2\u8272","staff":"\u5458\u5de5","staff_details":"\u5458\u5de5\u8be6\u60c5"},"staffs":"\u5458\u5de5","start_time_invalid":"\u7576\u5929\u7684\u958b\u59cb\u6642\u9593\u7121\u6548","state":{"add_state":"\u6dfb\u52a0\u72b6\u6001","country":"\u56fd\u5bb6","edit_state":"\u7f16\u8f91\u72b6\u6001","state":"\u72b6\u6001","states":"\u72b6\u6001"},"states":"\u56fd\u5bb6","subscribers":"\u8ba2\u9605\u8005","terms_conditions":"\u6761\u6b3e\u548c\u6761\u4ef6","too_long":"\u592a\u77ed","too_short":"\u5f88\u77ed","transaction":{"paid":"\u6709\u85aa\u916c\u7684","payment_accepted_by":"\u4ed8\u6b3e\u63a5\u53d7\u8005","payment_status":"\u652f\u4ed8\u72b6\u6001","pending":"\u5f85\u529e\u7684","transaction_detail":"\u4ea4\u6613\u8be6\u60c5","transaction_id":"\u4ea4\u6613\u7f16\u53f7"},"transactions":"\u4ea4\u6613","used_medicine":{"used_at":"\u4f7f\u7528\u4e8e","used_medicine":"\u7528\u8fc7\u7684\u836f\u54c1","used_medicines":"\u7528\u8fc7\u7684\u836f\u54c1","used_quantity":"\u4f7f\u7528\u6570\u91cf"},"user":{"account":"\u5e10\u6237","account_setting":"\u8d26\u6237\u8bbe\u7f6e","avatar":"\u5934\u50cf","change_language":"\u6539\u53d8\u8bed\u8a00","change_password":"\u66f4\u6539\u5bc6\u7801","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_number":"\u8054\u7cfb\u7535\u8bdd","current_password":"\u5f53\u524d\u5bc6\u7801","edit_profile":"\u7f16\u8f91\u4e2a\u4eba\u8d44\u6599","email":"\u7535\u5b50\u90ae\u4ef6","email_notification":"\u7535\u5b50\u90ae\u4ef6\u901a\u77e5","full_name":"\u5168\u540d","gender":"\u6027\u522b","language":"\u8bed\u8a00","new_password":"\u65b0\u5bc6\u7801","profile_details":"\u4e2a\u4eba\u8d44\u6599\u8be6\u60c5","return_to_admin":"\u8fd4\u56de\u7ba1\u7406\u5458","save_changes":"\u4fdd\u5b58\u66f4\u6539","select_time_zone":"\u9009\u62e9\u65f6\u533a","setting":"\u8bbe\u7f6e","sign_out":"\u9000\u51fa","staff_details":"\u5458\u5de5\u8be6\u60c5","time_zone":"\u65f6\u533a"},"users":"\u7528\u6237","valid_expiration_date":"\u8f38\u5165\u6709\u6548\u7684\u5230\u671f\u65e5\u3002","valid_number":"\u6709\u6548\u53f7\u7801","visit":{"add_visit":"\u6dfb\u52a0\u8bbf\u95ee","description":"\u8bf4\u660e","doctor":"\u533b\u751f","edit_visit":"\u7f16\u8f91\u8bbf\u95ee","enter_note":"\u8f93\u5165\u5907\u6ce8","enter_observation":"\u8fdb\u5165\u89c2\u5bdf","enter_problem":"\u8f93\u5165\u95ee\u9898","notes":"\u5907\u6ce8","observations":"\u89c2\u5bdf","patient":"\u75c5\u4eba","prescriptions":"\u5904\u65b9","problems":"\u95ee\u9898","title":"\u6807\u9898","visit_date":"\u8bbf\u95ee\u65e5\u671f","visit_detail":"\u53c2\u89c2\u8be6\u60c5","visit_details":"\u8bbf\u95ee\u8be6\u60c5"},"visits":"\u8bbf\u95ee","web":{"Meet_best_doctors":"\u9047\u89c1\u6700\u597d\u7684\u533b\u751f","about_experience":"\u5173\u4e8e\u4f53\u9a8c","about_short_description":"\u5173\u4e8e\u7b80\u77ed\u63cf\u8ff0","about_title":"\u5173\u4e8e\u6807\u9898","about_us":"\u5173\u4e8e\u6211\u4eec","all_rights_reserved":"\u7248\u6743\u6240\u6709","all_services":"\u6240\u6709\u670d\u52a1","already_have_an_account":"\u5df2\u7ecf\u6709\u4e00\u4e2a\u5e10\u6237","already_have_patient_account":"\u5df2\u6709\u60a3\u8005\u8d26\u6237","appointment":"\u7ea6\u4f1a","appointment_now":"\u7acb\u5373\u9884\u7ea6","best_professionals":"\u6700\u4f73\u4e13\u4e1a\u4eba\u58eb","book_an_appointment":"\u9884\u7ea6","book_appointment":"\u9884\u7ea6","call_us":"\u7ed9\u6211\u4eec\u6253\u7535\u8bdd","closed":"\u5173\u95ed","confirm_booking":"\u786e\u8ba4\u9884\u8ba2","contact":"\u8054\u7cfb\u65b9\u5f0f","contact_us":"\u8054\u7cfb\u6211\u4eec","contact_us_for_any_information":"\u8054\u7cfb\u6211\u4eec\u83b7\u53d6\u4efb\u4f55\u4fe1\u606f","create_an_account":"\u521b\u5efa\u4e00\u4e2a\u5e10\u6237","created_at":"\u521b\u5efa\u4e8e","doctors":"\u533b\u751f","doctors_can_interact___":"\u533b\u751f\u53ef\u4ee5\u4e0e\u60a3\u8005\u4e92\u52a8\u5e76\u8fdb\u884c\u76f8\u5173\u6cbb\u7597\u3002","dynamically_formulate_error_free_results_before_integrated_results_dramatically_incubate_integrated_resources_without_cost_effective_outside_the":"\u5728\u96c6\u6210\u7ed3\u679c\u4e4b\u524d\u52a8\u6001\u5730\u5236\u5b9a\u65e0\u9519\u8bef\u7684\u7ed3\u679c\u3002 \u5728\u6ca1\u6709\u6210\u672c\u6548\u76ca\u7684\u60c5\u51b5\u4e0b\u5927\u5e45\u5b75\u5316\u6574\u5408\u8d44\u6e90\u3002","email":"\u7535\u5b50\u90ae\u4ef6","email_address":"\u7535\u5b50\u90ae\u4ef6\u5730\u5740","emergency_help":"\u7d27\u6025\u5e2e\u52a9","enquiry":"\u8be2\u95ee","enquiry_details":"\u67e5\u8be2\u8be6\u60c5","enter_your_email":"\u8f93\u5165\u4f60\u7684\u7535\u5b50\u90ae\u7bb1","enter_your_email_to_subscribe_to_our_newsletter":"\u8f93\u5165\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u4ee5\u8ba2\u9605\u6211\u4eec\u7684\u65f6\u4e8b\u901a\u8baf","faqs":"\u5e38\u89c1\u95ee\u9898","forgot_password":"\u5fd8\u8bb0\u5bc6\u7801","home":"\u5bb6","how_we_works":"\u6211\u4eec\u5982\u4f55\u5de5\u4f5c","i_agree":"\u6211\u540c\u610f","location":"\u5730\u70b9","login":"\u767b\u5f55","make_appointment":"\u7ea6\u4e2a\u65f6\u95f4","medical":"\u533b\u7597","medical_about_us":"\u5173\u4e8e\u6211\u4eec\u7684\u533b\u7597","medical_appointment":"\u533b\u7597\u9884\u7ea6","medical_contact":"\u533b\u7597\u8054\u7cfb\u4eba","medical_doctors":"\u533b\u751f","medical_services":"\u533b\u7597\u670d\u52a1","medical_treatment":"\u836f\u7269\u6cbb\u7597","meet_our_team_of_specialists":"\u8ba4\u8bc6\u6211\u4eec\u7684\u4e13\u5bb6\u56e2\u961f","message":"\u6d88\u606f","name":"\u59d3\u540d","new_here":"\u65b0\u6765","no_services_available":"\u6ca1\u6709\u53ef\u7528\u7684\u670d\u52a1","opening_hours":"\u8425\u4e1a\u65f6\u95f4","our_doctor":"\u6211\u4eec\u7684\u533b\u751f","our_team":"\u6211\u4eec\u7684\u961f\u4f0d","patient_can_book_an_appointment___":"\u60a3\u8005\u53ef\u4ee5\u4ece\u767b\u9646\u9875\u9762\u6216\u4ed6\u7684\u767b\u5f55\u9762\u677f\u4e0e\u533b\u751f\u9884\u7ea6\u3002","patient_can_do_registration___":"\u60a3\u8005\u53ef\u4ee5\u4ece\u8fd9\u91cc\u6ce8\u518c\u57fa\u672c\u4fe1\u606f\u3002","patient_name":"\u60a3\u8005\u59d3\u540d","patient_registration":"\u75c5\u4eba\u767b\u8bb0","phone":"\u7535\u8bdd","qualified_doctors":"\u5408\u683c\u533b\u751f","questions_before_booking":"\u9884\u8ba2\u524d\u7684\u95ee\u9898","quick_links":"\u5feb\u901f\u94fe\u63a5","reason":"\u539f\u56e0","registration":"\u767b\u8bb0","remember_me":"\u8bb0\u4f4f\u6211","satisfied_patient":"\u6ee1\u610f\u7684\u75c5\u4eba","saying_about_us":"\u8bf4\u5230\u6211\u4eec","see_what_are_the_patients":"\u770b\u770b\u75c5\u4eba\u662f\u4ec0\u4e48","send_an_email":"\u53d1\u9001\u7535\u5b50\u90ae\u4ef6","send_message":"\u53d1\u9001\u6d88\u606f","send_us_an_email":"\u7ed9\u6211\u4eec\u53d1\u9001\u7535\u5b50\u90ae\u4ef6","services":"\u670d\u52a1","sign_in":"\u767b\u5f55","sign_in_here":"\u5728\u6b64\u5904\u767b\u5f55","sign_up":"\u62a5\u540d","status":"\u72b6\u6001","subject":"\u4e3b\u9898","subscribe":"\u8ba2\u9605","take_treatment":"\u63a5\u53d7\u6cbb\u7597","terms_and_conditions":"\u6761\u6b3e\u548c\u6761\u4ef6","testimonial":"\u63a8\u8350","timings":"\u65f6\u95f4","total_doctors":"\u603b\u533b\u751f","total_registered_patient":"\u603b\u6ce8\u518c\u60a3\u8005","total_services":"\u603b\u670d\u52a1","total_specializations":"\u603b\u4e13\u4e1a\u5316","view_more":"\u67e5\u770b\u66f4\u591a","we_cover_a_big___":"\u6211\u4eec\u6db5\u76d6\u5404\u79cd\u5404\u6837\u7684\u533b\u7597\u670d\u52a1","we_make_sure_that_your_life_are_in_good_hands":"\u6211\u4eec\u786e\u4fdd\u60a8\u7684\u751f\u6d3b\u5f97\u5230\u59a5\u5584\u5904\u7406","we_provide_the_special_tips___":"\u6211\u4eec\u63d0\u4f9b\u4fdd\u5065\u6cbb\u7597\u548c\u9ad8\u6c34\u5e73\u6700\u597d\u7684\u7279\u522b\u63d0\u793a\u548c\u5efa\u8bae\u3002","working_process":"\u5de5\u4f5c\u6d41\u7a0b","year_experience":"\u5e74\u7ecf\u9a8c"},"weekdays":{"fri":"\u5468\u4e94","mon":"\u661f\u671f\u4e00","sat":"\u661f\u671f\u516d","sun":"\u592a\u9633","thu":"\u5468\u56db","tue":"\u5468\u4e8c","wed":"\u661f\u671f\u4e09"}},"zh.pagination":{"next":"\u4e0b\u4e00\u4e2a","previous":"\u4ee5\u524d\u7684"},"zh.passwords":{"reset":"\u60a8\u7684\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\uff01","sent":"\u6211\u4eec\u5df2\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u53d1\u9001\u60a8\u7684\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5\uff01","throttled":"\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002","token":"\u6b64\u5bc6\u7801\u91cd\u7f6e\u4ee4\u724c\u65e0\u6548\u3002","user":"\u6211\u4eec\u627e\u4e0d\u5230\u4f7f\u7528\u8be5\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u7684\u7528\u6237\u3002"},"zh.validation":{"accepted":"\uff1aattribute\u5fc5\u9808\u88ab\u63a5\u53d7\u3002","active_url":"\uff1aattribute\u4e0d\u662f\u6709\u6548\u7684URL\u3002","after":"\uff1aattribute\u5fc5\u9808\u662f\uff1adate\u4e4b\u5f8c\u7684\u65e5\u671f\u3002","after_or_equal":"\uff1aattribute\u5fc5\u9808\u662f\u7b49\u65bc\u6216\u5c0f\u65bc\uff1adate\u7684\u65e5\u671f\u3002","alpha":"\uff1aattribute\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3002","alpha_dash":"\uff1aattribute\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\uff0c\u6578\u5b57\uff0c\u7834\u6298\u865f\u548c\u4e0b\u5283\u7dda\u3002","alpha_num":"\uff1aattribute\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u548c\u6578\u5b57\u3002","array":"\uff1aattribute\u5fc5\u9808\u662f\u4e00\u500b\u6578\u7d44\u3002","attributes":[],"before":"\uff1aattribute\u5fc5\u9808\u662f\uff1adate\u4e4b\u524d\u7684\u65e5\u671f\u3002","before_or_equal":"\uff1aattribute\u5fc5\u9808\u662f\u7b49\u65bc\u6216\u5c0f\u65bc\uff1adate\u7684\u65e5\u671f\u3002","between":{"array":"\uff1aattribute\u5fc5\u9808\u5728\uff1amin\u548c\uff1amax\u4e4b\u9593\u3002","file":"\uff1aattribute\u5fc5\u9808\u4ecb\u65bc\uff1amin\u548c\uff1amax\u5343\u5b57\u7bc0\u4e4b\u9593\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u4ecb\u65bc\uff1amin\u548c\uff1amax\u4e4b\u9593\u3002","string":"\uff1aattribute\u5fc5\u9808\u4ecb\u65bc\uff1amin\u548c\uff1amax\u4e4b\u9593\u3002"},"boolean":"\uff1aattribute\u5b57\u6bb5\u5fc5\u9808\u70batrue\u6216false\u3002","confirmed":"\uff1aattribute\u78ba\u8a8d\u4e0d\u5339\u914d\u3002","current_password":"\u5bc6\u7801\u4e0d\u6b63\u786e\u3002","custom":{"attribute-name":{"rule-name":"\u81ea\u5b9a\u7fa9\u6d88\u606f"}},"date":"\uff1aattribute\u4e0d\u662f\u6709\u6548\u65e5\u671f\u3002","date_equals":"\uff1aattribute\u5fc5\u9808\u662f\u7b49\u65bc\uff1adate\u7684\u65e5\u671f\u3002","date_format":"\uff1aattribute\u8207\u683c\u5f0f\uff1aformat\u4e0d\u5339\u914d\u3002","different":"\uff1aattribute\u548c\uff1aother\u5fc5\u9808\u4e0d\u540c\u3002","digits":"\uff1aattribute\u5fc5\u9808\u70ba\uff1adigits\u4f4d\u6578\u3002","digits_between":"\uff1aattribute\u5fc5\u9808\u4ecb\u65bc\uff1amin\u548c\uff1amax\u6578\u5b57\u4e4b\u9593\u3002","dimensions":"\uff1aattribute\u7684\u5716\u7247\u5c3a\u5bf8\u7121\u6548\u3002","distinct":"\uff1aattribute\u5b57\u6bb5\u5177\u6709\u91cd\u8907\u503c\u3002","email":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u3002","ends_with":"\uff1aattribute\u5fc5\u9808\u4ee5\u4e0b\u5217\u4e4b\u4e00\u7d50\u5c3e\uff1a\uff1avalues","exists":"\u6240\u9078\u7684\uff1aattribute\u7121\u6548\u3002","file":"\uff1aattribute\u5fc5\u9808\u662f\u4e00\u500b\u6587\u4ef6\u3002","filled":"\uff1aattribute\u5b57\u6bb5\u5fc5\u9808\u6709\u4e00\u500b\u503c\u3002","gt":{"array":"\uff1aattribute\u5fc5\u9808\u5305\u542b\u591a\u500b\uff1avalue\u9805\u76ee\u3002","file":"\uff1aattribute\u5fc5\u9808\u5927\u65bc\uff1avalue\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u5927\u65bc\uff1avalue\u3002","string":"\uff1aattribute\u5fc5\u9808\u5927\u65bc\uff1avalue\u5b57\u7b26\u3002"},"gte":{"array":"\uff1aattribute\u5fc5\u9808\u5177\u6709\uff1avalue\u9805\u6216\u66f4\u591a\u3002","file":"\uff1aattribute\u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc\uff1avalue\u5343\u5b57\u7bc0\u3002","numeric":"a\uff1aattribute\u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc\uff1avalue\u3002","string":"\uff1aattribute\u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc\uff1avalue\u5b57\u7b26\u3002"},"image":"\uff1aattribute\u5fc5\u9808\u662f\u5716\u50cf\u3002","in":"\u6240\u9078\u7684\uff1aattribute\u7121\u6548\u3002","in_array":"\uff1aattribute\u5b57\u6bb5\u5728\uff1aother\u4e2d\u4e0d\u5b58\u5728\u3002","integer":"\uff1aattribute\u5fc5\u9808\u70ba\u6574\u6578\u3002","ip":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684IP\u5730\u5740\u3002","ipv4":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684IPv4\u5730\u5740\u3002","ipv6":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684IPv6\u5730\u5740\u3002","json":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684JSON\u5b57\u7b26\u4e32\u3002","lt":{"array":"\uff1aattribute\u5fc5\u9808\u5c11\u65bc\uff1avalue\u500b\u9805\u76ee\u3002","file":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\uff1avalue\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\uff1avalue\u3002","string":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\uff1avalue\u5b57\u7b26\u3002"},"lte":{"array":"\uff1aattribute\u4e0d\u5f97\u8d85\u904e\uff1avalue\u500b\u9805\u76ee\u3002","file":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc\uff1avalue\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc\uff1avalue\u3002","string":"\uff1aattribute\u5fc5\u9808\u5c0f\u65bc\u6216\u7b49\u65bc\uff1avalue\u5b57\u7b26\u3002"},"max":{"array":"\uff1aattribute\u6700\u591a\u53ea\u80fd\u5305\u542b\uff1amax\u500b\u9805\u76ee\u3002","file":"\uff1aattribute\u4e0d\u5f97\u5927\u65bc\uff1amax\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u4e0d\u5f97\u5927\u65bc\uff1amax\u3002","string":"\uff1aattribute\u4e0d\u5f97\u5927\u65bc\uff1amax\u500b\u5b57\u7b26\u3002"},"mimes":"\uff1aattribute\u5fc5\u9808\u662f\u985e\u578b\uff1a\uff1avalues\u7684\u6587\u4ef6\u3002","mimetypes":"\uff1aattribute\u5fc5\u9808\u662f\u985e\u578b\uff1a\uff1avalues\u7684\u6587\u4ef6\u3002","min":{"array":"\uff1aattribute\u5fc5\u9808\u81f3\u5c11\u5305\u542b\uff1amin\u500b\u9805\u76ee\u3002","file":"\uff1aattribute\u5fc5\u9808\u81f3\u5c11\u70ba\uff1amin\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u81f3\u5c11\u70ba\uff1amin\u3002","string":"\uff1aattribute\u5fc5\u9808\u81f3\u5c11\u70ba\uff1amin\u500b\u5b57\u7b26\u3002"},"multiple_of":":attribute \u5fc5\u987b\u662f :value \u7684\u500d\u6570\u3002","not_in":"\u6240\u9078\u7684\uff1aattribute\u7121\u6548\u3002","not_regex":"\uff1aattribute\u683c\u5f0f\u7121\u6548\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u70ba\u6578\u5b57\u3002","password":"\u5bc6\u7801\u4e0d\u6b63\u786e\u3002","present":"\uff1aattribute\u5b57\u6bb5\u5fc5\u9808\u5b58\u5728\u3002","prohibited":"\u7981\u6b62 :attribute \u5b57\u6bb5\u3002","prohibited_if":"\u5f53 :other \u4e3a :value \u65f6\uff0c\u7981\u6b62 :attribute\u5b57\u6bb5\u3002","prohibited_unless":"\u7981\u6b62 :attribute\u5b57\u6bb5\uff0c\u9664\u975e :other \u5728 :values \u4e2d\u3002","regex":"\uff1aattribute\u683c\u5f0f\u7121\u6548\u3002","required":"\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","required_if":"\u7576\uff1aother\u662f\uff1avalue\u6642\uff0c\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","required_unless":"\u9664\u975e\uff1aother\u4f4d\u65bc\uff1avalues\u4e2d\uff0c\u5426\u5247\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u586b\u5b57\u6bb5\u3002","required_with":"\u5982\u679c\u5b58\u5728\uff1avalues\uff0c\u5247\uff1aattribute\u5b57\u6bb5\u70ba\u5fc5\u586b\u5b57\u6bb5\u3002","required_with_all":"\u5982\u679c\u5b58\u5728\uff1avalues\uff0c\u5247\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","required_without":"\u7576\uff1avalues\u4e0d\u5b58\u5728\u6642\uff0c\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","required_without_all":"\u7576\uff1avalues\u4e0d\u5b58\u5728\u6642\uff0c\uff1aattribute\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","same":"\uff1aattribute\u548c\uff1aother\u5fc5\u9808\u5339\u914d\u3002","size":{"array":"\uff1aattribute\u5fc5\u9808\u5305\u542b\uff1asize\u9805\u3002","file":"\uff1aattribute\u5fc5\u9808\u70ba\uff1asize\u5343\u5b57\u7bc0\u3002","numeric":"\uff1aattribute\u5fc5\u9808\u70ba\uff1asize\u3002","string":"\uff1aattribute\u5fc5\u9808\u70ba\uff1asize\u5b57\u7b26\u3002"},"starts_with":"\uff1aattribute\u5fc5\u9808\u4ee5\u4e0b\u5217\u4e4b\u4e00\u958b\u982d\uff1a\uff1avalues","string":"\uff1aattribute\u5fc5\u9808\u70ba\u5b57\u7b26\u4e32\u3002","timezone":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684\u5340\u57df\u3002","unique":"\uff1aattribute\u5df2\u7d93\u88ab\u4f7f\u7528\u3002","uploaded":"\uff1aattribute\u4e0a\u50b3\u5931\u6557\u3002","url":"\uff1aattribute\u683c\u5f0f\u7121\u6548\u3002","uuid":"\uff1aattribute\u5fc5\u9808\u662f\u6709\u6548\u7684UUID\u3002"}});
})();
